/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.Connection;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ParseConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="connectionDetail")
    private final Connection connectionDetail;
    @JsonProperty(value="connectionPayload")
    private final byte[] connectionPayload;
    @JsonProperty(value="walletSecretId")
    private final String walletSecretId;
    @JsonProperty(value="walletSecretName")
    private final String walletSecretName;

    @Deprecated
    @ConstructorProperties(value={"connectionDetail", "connectionPayload", "walletSecretId", "walletSecretName"})
    public ParseConnectionDetails(Connection connectionDetail, byte[] connectionPayload, String walletSecretId, String walletSecretName) {
        this.connectionDetail = connectionDetail;
        this.connectionPayload = connectionPayload;
        this.walletSecretId = walletSecretId;
        this.walletSecretName = walletSecretName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Connection getConnectionDetail() {
        return this.connectionDetail;
    }

    public byte[] getConnectionPayload() {
        return this.connectionPayload;
    }

    public String getWalletSecretId() {
        return this.walletSecretId;
    }

    public String getWalletSecretName() {
        return this.walletSecretName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParseConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("connectionDetail=").append(String.valueOf((Object)this.connectionDetail));
        sb.append(", connectionPayload=").append(includeByteArrayContents ? Arrays.toString(this.connectionPayload) : String.valueOf(this.connectionPayload) + (this.connectionPayload != null ? " (byte[" + this.connectionPayload.length + "])" : ""));
        sb.append(", walletSecretId=").append(String.valueOf(this.walletSecretId));
        sb.append(", walletSecretName=").append(String.valueOf(this.walletSecretName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParseConnectionDetails)) {
            return false;
        }
        ParseConnectionDetails other = (ParseConnectionDetails)((Object)o);
        return Objects.equals((Object)this.connectionDetail, (Object)other.connectionDetail) && Arrays.equals(this.connectionPayload, other.connectionPayload) && Objects.equals(this.walletSecretId, other.walletSecretId) && Objects.equals(this.walletSecretName, other.walletSecretName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.connectionDetail == null ? 43 : this.connectionDetail.hashCode());
        result = result * 59 + Arrays.hashCode(this.connectionPayload);
        result = result * 59 + (this.walletSecretId == null ? 43 : this.walletSecretId.hashCode());
        result = result * 59 + (this.walletSecretName == null ? 43 : this.walletSecretName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectionDetail")
        private Connection connectionDetail;
        @JsonProperty(value="connectionPayload")
        private byte[] connectionPayload;
        @JsonProperty(value="walletSecretId")
        private String walletSecretId;
        @JsonProperty(value="walletSecretName")
        private String walletSecretName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectionDetail(Connection connectionDetail) {
            this.connectionDetail = connectionDetail;
            this.__explicitlySet__.add("connectionDetail");
            return this;
        }

        public Builder connectionPayload(byte[] connectionPayload) {
            this.connectionPayload = connectionPayload;
            this.__explicitlySet__.add("connectionPayload");
            return this;
        }

        public Builder walletSecretId(String walletSecretId) {
            this.walletSecretId = walletSecretId;
            this.__explicitlySet__.add("walletSecretId");
            return this;
        }

        public Builder walletSecretName(String walletSecretName) {
            this.walletSecretName = walletSecretName;
            this.__explicitlySet__.add("walletSecretName");
            return this;
        }

        public ParseConnectionDetails build() {
            ParseConnectionDetails model = new ParseConnectionDetails(this.connectionDetail, this.connectionPayload, this.walletSecretId, this.walletSecretName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ParseConnectionDetails model) {
            if (model.wasPropertyExplicitlySet("connectionDetail")) {
                this.connectionDetail(model.getConnectionDetail());
            }
            if (model.wasPropertyExplicitlySet("connectionPayload")) {
                this.connectionPayload(model.getConnectionPayload());
            }
            if (model.wasPropertyExplicitlySet("walletSecretId")) {
                this.walletSecretId(model.getWalletSecretId());
            }
            if (model.wasPropertyExplicitlySet("walletSecretName")) {
                this.walletSecretName(model.getWalletSecretName());
            }
            return this;
        }
    }
}

