/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ObjectRelationship
extends ExplicitlySetBmcModel {
    @JsonProperty(value="relationshipType")
    private final String relationshipType;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="typeName")
    private final String typeName;
    @JsonProperty(value="typeKey")
    private final String typeKey;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="parentKey")
    private final String parentKey;
    @JsonProperty(value="parentPath")
    private final String parentPath;

    @Deprecated
    @ConstructorProperties(value={"relationshipType", "key", "name", "typeName", "typeKey", "timeCreated", "timeUpdated", "path", "parentKey", "parentPath"})
    public ObjectRelationship(String relationshipType, String key, String name, String typeName, String typeKey, Date timeCreated, Date timeUpdated, String path, String parentKey, String parentPath) {
        this.relationshipType = relationshipType;
        this.key = key;
        this.name = name;
        this.typeName = typeName;
        this.typeKey = typeKey;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.path = path;
        this.parentKey = parentKey;
        this.parentPath = parentPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getPath() {
        return this.path;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectRelationship(");
        sb.append("super=").append(super.toString());
        sb.append("relationshipType=").append(String.valueOf(this.relationshipType));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", typeName=").append(String.valueOf(this.typeName));
        sb.append(", typeKey=").append(String.valueOf(this.typeKey));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", parentKey=").append(String.valueOf(this.parentKey));
        sb.append(", parentPath=").append(String.valueOf(this.parentPath));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectRelationship)) {
            return false;
        }
        ObjectRelationship other = (ObjectRelationship)((Object)o);
        return Objects.equals(this.relationshipType, other.relationshipType) && Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.typeKey, other.typeKey) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.path, other.path) && Objects.equals(this.parentKey, other.parentKey) && Objects.equals(this.parentPath, other.parentPath) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.relationshipType == null ? 43 : this.relationshipType.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.typeName == null ? 43 : this.typeName.hashCode());
        result = result * 59 + (this.typeKey == null ? 43 : this.typeKey.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.parentKey == null ? 43 : this.parentKey.hashCode());
        result = result * 59 + (this.parentPath == null ? 43 : this.parentPath.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="relationshipType")
        private String relationshipType;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="typeName")
        private String typeName;
        @JsonProperty(value="typeKey")
        private String typeKey;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="parentKey")
        private String parentKey;
        @JsonProperty(value="parentPath")
        private String parentPath;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            this.__explicitlySet__.add("relationshipType");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            this.__explicitlySet__.add("typeName");
            return this;
        }

        public Builder typeKey(String typeKey) {
            this.typeKey = typeKey;
            this.__explicitlySet__.add("typeKey");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder parentKey(String parentKey) {
            this.parentKey = parentKey;
            this.__explicitlySet__.add("parentKey");
            return this;
        }

        public Builder parentPath(String parentPath) {
            this.parentPath = parentPath;
            this.__explicitlySet__.add("parentPath");
            return this;
        }

        public ObjectRelationship build() {
            ObjectRelationship model = new ObjectRelationship(this.relationshipType, this.key, this.name, this.typeName, this.typeKey, this.timeCreated, this.timeUpdated, this.path, this.parentKey, this.parentPath);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectRelationship model) {
            if (model.wasPropertyExplicitlySet("relationshipType")) {
                this.relationshipType(model.getRelationshipType());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("typeName")) {
                this.typeName(model.getTypeName());
            }
            if (model.wasPropertyExplicitlySet("typeKey")) {
                this.typeKey(model.getTypeKey());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("parentKey")) {
                this.parentKey(model.getParentKey());
            }
            if (model.wasPropertyExplicitlySet("parentPath")) {
                this.parentPath(model.getParentPath());
            }
            return this;
        }
    }
}

