/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobMetricSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="jobExecutionKey")
    private final String jobExecutionKey;
    @JsonProperty(value="uri")
    private final String uri;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeInserted")
    private final Date timeInserted;
    @JsonProperty(value="category")
    private final String category;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="subCategory")
    private final String subCategory;
    @JsonProperty(value="unit")
    private final String unit;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="batchKey")
    private final String batchKey;

    @Deprecated
    @ConstructorProperties(value={"key", "description", "jobExecutionKey", "uri", "timeCreated", "timeInserted", "category", "displayName", "subCategory", "unit", "value", "batchKey"})
    public JobMetricSummary(String key, String description, String jobExecutionKey, String uri, Date timeCreated, Date timeInserted, String category, String displayName, String subCategory, String unit, String value, String batchKey) {
        this.key = key;
        this.description = description;
        this.jobExecutionKey = jobExecutionKey;
        this.uri = uri;
        this.timeCreated = timeCreated;
        this.timeInserted = timeInserted;
        this.category = category;
        this.displayName = displayName;
        this.subCategory = subCategory;
        this.unit = unit;
        this.value = value;
        this.batchKey = batchKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobExecutionKey() {
        return this.jobExecutionKey;
    }

    public String getUri() {
        return this.uri;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeInserted() {
        return this.timeInserted;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getValue() {
        return this.value;
    }

    public String getBatchKey() {
        return this.batchKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobMetricSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", jobExecutionKey=").append(String.valueOf(this.jobExecutionKey));
        sb.append(", uri=").append(String.valueOf(this.uri));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeInserted=").append(String.valueOf(this.timeInserted));
        sb.append(", category=").append(String.valueOf(this.category));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", subCategory=").append(String.valueOf(this.subCategory));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", batchKey=").append(String.valueOf(this.batchKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobMetricSummary)) {
            return false;
        }
        JobMetricSummary other = (JobMetricSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.description, other.description) && Objects.equals(this.jobExecutionKey, other.jobExecutionKey) && Objects.equals(this.uri, other.uri) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeInserted, other.timeInserted) && Objects.equals(this.category, other.category) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.subCategory, other.subCategory) && Objects.equals(this.unit, other.unit) && Objects.equals(this.value, other.value) && Objects.equals(this.batchKey, other.batchKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.jobExecutionKey == null ? 43 : this.jobExecutionKey.hashCode());
        result = result * 59 + (this.uri == null ? 43 : this.uri.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeInserted == null ? 43 : this.timeInserted.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.subCategory == null ? 43 : this.subCategory.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.batchKey == null ? 43 : this.batchKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="jobExecutionKey")
        private String jobExecutionKey;
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeInserted")
        private Date timeInserted;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="subCategory")
        private String subCategory;
        @JsonProperty(value="unit")
        private String unit;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="batchKey")
        private String batchKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder jobExecutionKey(String jobExecutionKey) {
            this.jobExecutionKey = jobExecutionKey;
            this.__explicitlySet__.add("jobExecutionKey");
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            this.__explicitlySet__.add("uri");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeInserted(Date timeInserted) {
            this.timeInserted = timeInserted;
            this.__explicitlySet__.add("timeInserted");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder subCategory(String subCategory) {
            this.subCategory = subCategory;
            this.__explicitlySet__.add("subCategory");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder batchKey(String batchKey) {
            this.batchKey = batchKey;
            this.__explicitlySet__.add("batchKey");
            return this;
        }

        public JobMetricSummary build() {
            JobMetricSummary model = new JobMetricSummary(this.key, this.description, this.jobExecutionKey, this.uri, this.timeCreated, this.timeInserted, this.category, this.displayName, this.subCategory, this.unit, this.value, this.batchKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobMetricSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("jobExecutionKey")) {
                this.jobExecutionKey(model.getJobExecutionKey());
            }
            if (model.wasPropertyExplicitlySet("uri")) {
                this.uri(model.getUri());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeInserted")) {
                this.timeInserted(model.getTimeInserted());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("subCategory")) {
                this.subCategory(model.getSubCategory());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("batchKey")) {
                this.batchKey(model.getBatchKey());
            }
            return this;
        }
    }
}

