/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobLog
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="jobExecutionKey")
    private final String jobExecutionKey;
    @JsonProperty(value="createdById")
    private final String createdById;
    @JsonProperty(value="updatedById")
    private final String updatedById;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="severity")
    private final String severity;
    @JsonProperty(value="logMessage")
    private final String logMessage;
    @JsonProperty(value="uri")
    private final String uri;

    @Deprecated
    @ConstructorProperties(value={"key", "jobExecutionKey", "createdById", "updatedById", "timeUpdated", "timeCreated", "severity", "logMessage", "uri"})
    public JobLog(String key, String jobExecutionKey, String createdById, String updatedById, Date timeUpdated, Date timeCreated, String severity, String logMessage, String uri) {
        this.key = key;
        this.jobExecutionKey = jobExecutionKey;
        this.createdById = createdById;
        this.updatedById = updatedById;
        this.timeUpdated = timeUpdated;
        this.timeCreated = timeCreated;
        this.severity = severity;
        this.logMessage = logMessage;
        this.uri = uri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getJobExecutionKey() {
        return this.jobExecutionKey;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobLog(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", jobExecutionKey=").append(String.valueOf(this.jobExecutionKey));
        sb.append(", createdById=").append(String.valueOf(this.createdById));
        sb.append(", updatedById=").append(String.valueOf(this.updatedById));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", severity=").append(String.valueOf(this.severity));
        sb.append(", logMessage=").append(String.valueOf(this.logMessage));
        sb.append(", uri=").append(String.valueOf(this.uri));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobLog)) {
            return false;
        }
        JobLog other = (JobLog)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.jobExecutionKey, other.jobExecutionKey) && Objects.equals(this.createdById, other.createdById) && Objects.equals(this.updatedById, other.updatedById) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.severity, other.severity) && Objects.equals(this.logMessage, other.logMessage) && Objects.equals(this.uri, other.uri) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.jobExecutionKey == null ? 43 : this.jobExecutionKey.hashCode());
        result = result * 59 + (this.createdById == null ? 43 : this.createdById.hashCode());
        result = result * 59 + (this.updatedById == null ? 43 : this.updatedById.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.logMessage == null ? 43 : this.logMessage.hashCode());
        result = result * 59 + (this.uri == null ? 43 : this.uri.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="jobExecutionKey")
        private String jobExecutionKey;
        @JsonProperty(value="createdById")
        private String createdById;
        @JsonProperty(value="updatedById")
        private String updatedById;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="severity")
        private String severity;
        @JsonProperty(value="logMessage")
        private String logMessage;
        @JsonProperty(value="uri")
        private String uri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder jobExecutionKey(String jobExecutionKey) {
            this.jobExecutionKey = jobExecutionKey;
            this.__explicitlySet__.add("jobExecutionKey");
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            this.__explicitlySet__.add("createdById");
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            this.__explicitlySet__.add("updatedById");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder logMessage(String logMessage) {
            this.logMessage = logMessage;
            this.__explicitlySet__.add("logMessage");
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            this.__explicitlySet__.add("uri");
            return this;
        }

        public JobLog build() {
            JobLog model = new JobLog(this.key, this.jobExecutionKey, this.createdById, this.updatedById, this.timeUpdated, this.timeCreated, this.severity, this.logMessage, this.uri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobLog model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("jobExecutionKey")) {
                this.jobExecutionKey(model.getJobExecutionKey());
            }
            if (model.wasPropertyExplicitlySet("createdById")) {
                this.createdById(model.getCreatedById());
            }
            if (model.wasPropertyExplicitlySet("updatedById")) {
                this.updatedById(model.getUpdatedById());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("logMessage")) {
                this.logMessage(model.getLogMessage());
            }
            if (model.wasPropertyExplicitlySet("uri")) {
                this.uri(model.getUri());
            }
            return this;
        }
    }
}

