/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datacatalog.model.JobExecutionState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImportDataAssetJobResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dataAssetKey")
    private final String dataAssetKey;
    @JsonProperty(value="importJobDefinitionKey")
    private final String importJobDefinitionKey;
    @JsonProperty(value="importJobKey")
    private final String importJobKey;
    @JsonProperty(value="importJobExecutionKey")
    private final String importJobExecutionKey;
    @JsonProperty(value="importJobExecutionStatus")
    private final JobExecutionState importJobExecutionStatus;

    @Deprecated
    @ConstructorProperties(value={"dataAssetKey", "importJobDefinitionKey", "importJobKey", "importJobExecutionKey", "importJobExecutionStatus"})
    public ImportDataAssetJobResult(String dataAssetKey, String importJobDefinitionKey, String importJobKey, String importJobExecutionKey, JobExecutionState importJobExecutionStatus) {
        this.dataAssetKey = dataAssetKey;
        this.importJobDefinitionKey = importJobDefinitionKey;
        this.importJobKey = importJobKey;
        this.importJobExecutionKey = importJobExecutionKey;
        this.importJobExecutionStatus = importJobExecutionStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getImportJobDefinitionKey() {
        return this.importJobDefinitionKey;
    }

    public String getImportJobKey() {
        return this.importJobKey;
    }

    public String getImportJobExecutionKey() {
        return this.importJobExecutionKey;
    }

    public JobExecutionState getImportJobExecutionStatus() {
        return this.importJobExecutionStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImportDataAssetJobResult(");
        sb.append("super=").append(super.toString());
        sb.append("dataAssetKey=").append(String.valueOf(this.dataAssetKey));
        sb.append(", importJobDefinitionKey=").append(String.valueOf(this.importJobDefinitionKey));
        sb.append(", importJobKey=").append(String.valueOf(this.importJobKey));
        sb.append(", importJobExecutionKey=").append(String.valueOf(this.importJobExecutionKey));
        sb.append(", importJobExecutionStatus=").append(String.valueOf((Object)this.importJobExecutionStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportDataAssetJobResult)) {
            return false;
        }
        ImportDataAssetJobResult other = (ImportDataAssetJobResult)((Object)o);
        return Objects.equals(this.dataAssetKey, other.dataAssetKey) && Objects.equals(this.importJobDefinitionKey, other.importJobDefinitionKey) && Objects.equals(this.importJobKey, other.importJobKey) && Objects.equals(this.importJobExecutionKey, other.importJobExecutionKey) && Objects.equals((Object)this.importJobExecutionStatus, (Object)other.importJobExecutionStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dataAssetKey == null ? 43 : this.dataAssetKey.hashCode());
        result = result * 59 + (this.importJobDefinitionKey == null ? 43 : this.importJobDefinitionKey.hashCode());
        result = result * 59 + (this.importJobKey == null ? 43 : this.importJobKey.hashCode());
        result = result * 59 + (this.importJobExecutionKey == null ? 43 : this.importJobExecutionKey.hashCode());
        result = result * 59 + (this.importJobExecutionStatus == null ? 43 : this.importJobExecutionStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dataAssetKey")
        private String dataAssetKey;
        @JsonProperty(value="importJobDefinitionKey")
        private String importJobDefinitionKey;
        @JsonProperty(value="importJobKey")
        private String importJobKey;
        @JsonProperty(value="importJobExecutionKey")
        private String importJobExecutionKey;
        @JsonProperty(value="importJobExecutionStatus")
        private JobExecutionState importJobExecutionStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            this.__explicitlySet__.add("dataAssetKey");
            return this;
        }

        public Builder importJobDefinitionKey(String importJobDefinitionKey) {
            this.importJobDefinitionKey = importJobDefinitionKey;
            this.__explicitlySet__.add("importJobDefinitionKey");
            return this;
        }

        public Builder importJobKey(String importJobKey) {
            this.importJobKey = importJobKey;
            this.__explicitlySet__.add("importJobKey");
            return this;
        }

        public Builder importJobExecutionKey(String importJobExecutionKey) {
            this.importJobExecutionKey = importJobExecutionKey;
            this.__explicitlySet__.add("importJobExecutionKey");
            return this;
        }

        public Builder importJobExecutionStatus(JobExecutionState importJobExecutionStatus) {
            this.importJobExecutionStatus = importJobExecutionStatus;
            this.__explicitlySet__.add("importJobExecutionStatus");
            return this;
        }

        public ImportDataAssetJobResult build() {
            ImportDataAssetJobResult model = new ImportDataAssetJobResult(this.dataAssetKey, this.importJobDefinitionKey, this.importJobKey, this.importJobExecutionKey, this.importJobExecutionStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImportDataAssetJobResult model) {
            if (model.wasPropertyExplicitlySet("dataAssetKey")) {
                this.dataAssetKey(model.getDataAssetKey());
            }
            if (model.wasPropertyExplicitlySet("importJobDefinitionKey")) {
                this.importJobDefinitionKey(model.getImportJobDefinitionKey());
            }
            if (model.wasPropertyExplicitlySet("importJobKey")) {
                this.importJobKey(model.getImportJobKey());
            }
            if (model.wasPropertyExplicitlySet("importJobExecutionKey")) {
                this.importJobExecutionKey(model.getImportJobExecutionKey());
            }
            if (model.wasPropertyExplicitlySet("importJobExecutionStatus")) {
                this.importJobExecutionStatus(model.getImportJobExecutionStatus());
            }
            return this;
        }
    }
}

