/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FacetedSearchAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="aggregation")
    private final Map<String, Long> aggregation;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="propertyType")
    private final PropertyType propertyType;

    @Deprecated
    @ConstructorProperties(value={"type", "aggregation", "dataType", "propertyType"})
    public FacetedSearchAggregation(String type, Map<String, Long> aggregation, String dataType, PropertyType propertyType) {
        this.type = type;
        this.aggregation = aggregation;
        this.dataType = dataType;
        this.propertyType = propertyType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Long> getAggregation() {
        return this.aggregation;
    }

    public String getDataType() {
        return this.dataType;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FacetedSearchAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("type=").append(String.valueOf(this.type));
        sb.append(", aggregation=").append(String.valueOf(this.aggregation));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", propertyType=").append(String.valueOf((Object)this.propertyType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FacetedSearchAggregation)) {
            return false;
        }
        FacetedSearchAggregation other = (FacetedSearchAggregation)((Object)o);
        return Objects.equals(this.type, other.type) && Objects.equals(this.aggregation, other.aggregation) && Objects.equals(this.dataType, other.dataType) && Objects.equals((Object)this.propertyType, (Object)other.propertyType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.aggregation == null ? 43 : this.aggregation.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.propertyType == null ? 43 : this.propertyType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PropertyType implements BmcEnum
    {
        CustomProperty("CUSTOM_PROPERTY"),
        DefaultProperty("DEFAULT_PROPERTY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PropertyType> map;

        private PropertyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PropertyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PropertyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PropertyType.class);
            map = new HashMap<String, PropertyType>();
            for (PropertyType v : PropertyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="aggregation")
        private Map<String, Long> aggregation;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="propertyType")
        private PropertyType propertyType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder aggregation(Map<String, Long> aggregation) {
            this.aggregation = aggregation;
            this.__explicitlySet__.add("aggregation");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder propertyType(PropertyType propertyType) {
            this.propertyType = propertyType;
            this.__explicitlySet__.add("propertyType");
            return this;
        }

        public FacetedSearchAggregation build() {
            FacetedSearchAggregation model = new FacetedSearchAggregation(this.type, this.aggregation, this.dataType, this.propertyType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FacetedSearchAggregation model) {
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("aggregation")) {
                this.aggregation(model.getAggregation());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("propertyType")) {
                this.propertyType(model.getPropertyType());
            }
            return this;
        }
    }
}

