/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datacatalog.DataCatalog;
import com.oracle.bmc.datacatalog.DataCatalogAsyncClient;
import com.oracle.bmc.datacatalog.DataCatalogPaginators;
import com.oracle.bmc.datacatalog.DataCatalogWaiters;
import com.oracle.bmc.datacatalog.model.Attribute;
import com.oracle.bmc.datacatalog.model.AttributeCollection;
import com.oracle.bmc.datacatalog.model.AttributeTag;
import com.oracle.bmc.datacatalog.model.AttributeTagCollection;
import com.oracle.bmc.datacatalog.model.Catalog;
import com.oracle.bmc.datacatalog.model.CatalogPrivateEndpoint;
import com.oracle.bmc.datacatalog.model.CatalogPrivateEndpointSummary;
import com.oracle.bmc.datacatalog.model.CatalogSummary;
import com.oracle.bmc.datacatalog.model.Connection;
import com.oracle.bmc.datacatalog.model.ConnectionAliasSummary;
import com.oracle.bmc.datacatalog.model.ConnectionCollection;
import com.oracle.bmc.datacatalog.model.CustomProperty;
import com.oracle.bmc.datacatalog.model.CustomPropertyCollection;
import com.oracle.bmc.datacatalog.model.DataAsset;
import com.oracle.bmc.datacatalog.model.DataAssetCollection;
import com.oracle.bmc.datacatalog.model.DataAssetTag;
import com.oracle.bmc.datacatalog.model.DataAssetTagCollection;
import com.oracle.bmc.datacatalog.model.Entity;
import com.oracle.bmc.datacatalog.model.EntityCollection;
import com.oracle.bmc.datacatalog.model.EntityTag;
import com.oracle.bmc.datacatalog.model.EntityTagCollection;
import com.oracle.bmc.datacatalog.model.Folder;
import com.oracle.bmc.datacatalog.model.FolderCollection;
import com.oracle.bmc.datacatalog.model.FolderTag;
import com.oracle.bmc.datacatalog.model.FolderTagCollection;
import com.oracle.bmc.datacatalog.model.Glossary;
import com.oracle.bmc.datacatalog.model.GlossaryCollection;
import com.oracle.bmc.datacatalog.model.GlossaryTreeElement;
import com.oracle.bmc.datacatalog.model.ImportDataAssetJobResult;
import com.oracle.bmc.datacatalog.model.Job;
import com.oracle.bmc.datacatalog.model.JobCollection;
import com.oracle.bmc.datacatalog.model.JobDefinition;
import com.oracle.bmc.datacatalog.model.JobDefinitionCollection;
import com.oracle.bmc.datacatalog.model.JobExecution;
import com.oracle.bmc.datacatalog.model.JobExecutionCollection;
import com.oracle.bmc.datacatalog.model.JobLog;
import com.oracle.bmc.datacatalog.model.JobLogCollection;
import com.oracle.bmc.datacatalog.model.JobMetric;
import com.oracle.bmc.datacatalog.model.JobMetricCollection;
import com.oracle.bmc.datacatalog.model.Metastore;
import com.oracle.bmc.datacatalog.model.MetastoreSummary;
import com.oracle.bmc.datacatalog.model.Namespace;
import com.oracle.bmc.datacatalog.model.NamespaceCollection;
import com.oracle.bmc.datacatalog.model.Pattern;
import com.oracle.bmc.datacatalog.model.PatternCollection;
import com.oracle.bmc.datacatalog.model.ProcessRecommendationDetails;
import com.oracle.bmc.datacatalog.model.RecommendationCollection;
import com.oracle.bmc.datacatalog.model.RuleCollection;
import com.oracle.bmc.datacatalog.model.SearchResultCollection;
import com.oracle.bmc.datacatalog.model.SuggestResults;
import com.oracle.bmc.datacatalog.model.Term;
import com.oracle.bmc.datacatalog.model.TermCollection;
import com.oracle.bmc.datacatalog.model.TermRelationship;
import com.oracle.bmc.datacatalog.model.TermRelationshipCollection;
import com.oracle.bmc.datacatalog.model.Type;
import com.oracle.bmc.datacatalog.model.TypeCollection;
import com.oracle.bmc.datacatalog.model.ValidateConnectionResult;
import com.oracle.bmc.datacatalog.model.ValidatePatternResult;
import com.oracle.bmc.datacatalog.model.WorkRequest;
import com.oracle.bmc.datacatalog.model.WorkRequestError;
import com.oracle.bmc.datacatalog.model.WorkRequestLog;
import com.oracle.bmc.datacatalog.requests.AddDataSelectorPatternsRequest;
import com.oracle.bmc.datacatalog.requests.AssociateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.AttachCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.ChangeCatalogCompartmentRequest;
import com.oracle.bmc.datacatalog.requests.ChangeCatalogPrivateEndpointCompartmentRequest;
import com.oracle.bmc.datacatalog.requests.ChangeMetastoreCompartmentRequest;
import com.oracle.bmc.datacatalog.requests.CreateAttributeRequest;
import com.oracle.bmc.datacatalog.requests.CreateAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.CreateCatalogRequest;
import com.oracle.bmc.datacatalog.requests.CreateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.CreateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.CreateDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.CreateDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateEntityRequest;
import com.oracle.bmc.datacatalog.requests.CreateEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateFolderRequest;
import com.oracle.bmc.datacatalog.requests.CreateFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.CreateGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobExecutionRequest;
import com.oracle.bmc.datacatalog.requests.CreateJobRequest;
import com.oracle.bmc.datacatalog.requests.CreateMetastoreRequest;
import com.oracle.bmc.datacatalog.requests.CreateNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.CreatePatternRequest;
import com.oracle.bmc.datacatalog.requests.CreateTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.CreateTermRequest;
import com.oracle.bmc.datacatalog.requests.DeleteAttributeRequest;
import com.oracle.bmc.datacatalog.requests.DeleteAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCatalogRequest;
import com.oracle.bmc.datacatalog.requests.DeleteConnectionRequest;
import com.oracle.bmc.datacatalog.requests.DeleteCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.DeleteDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.DeleteDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteEntityRequest;
import com.oracle.bmc.datacatalog.requests.DeleteEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteFolderRequest;
import com.oracle.bmc.datacatalog.requests.DeleteFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.DeleteGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.DeleteJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.DeleteJobRequest;
import com.oracle.bmc.datacatalog.requests.DeleteMetastoreRequest;
import com.oracle.bmc.datacatalog.requests.DeleteNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.DeletePatternRequest;
import com.oracle.bmc.datacatalog.requests.DeleteTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.DeleteTermRequest;
import com.oracle.bmc.datacatalog.requests.DetachCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.DisassociateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.ExpandTreeForGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.ExportGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.GetAttributeRequest;
import com.oracle.bmc.datacatalog.requests.GetAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogRequest;
import com.oracle.bmc.datacatalog.requests.GetConnectionRequest;
import com.oracle.bmc.datacatalog.requests.GetCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.GetGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.GetJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobExecutionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobLogRequest;
import com.oracle.bmc.datacatalog.requests.GetJobMetricsRequest;
import com.oracle.bmc.datacatalog.requests.GetJobRequest;
import com.oracle.bmc.datacatalog.requests.GetMetastoreRequest;
import com.oracle.bmc.datacatalog.requests.GetNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.GetPatternRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRequest;
import com.oracle.bmc.datacatalog.requests.GetTypeRequest;
import com.oracle.bmc.datacatalog.requests.GetWorkRequestRequest;
import com.oracle.bmc.datacatalog.requests.ImportConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ImportDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.ImportGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.ListAggregatedPhysicalEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListAttributeTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListAttributesRequest;
import com.oracle.bmc.datacatalog.requests.ListCatalogPrivateEndpointsRequest;
import com.oracle.bmc.datacatalog.requests.ListCatalogsRequest;
import com.oracle.bmc.datacatalog.requests.ListConnectionsRequest;
import com.oracle.bmc.datacatalog.requests.ListCustomPropertiesRequest;
import com.oracle.bmc.datacatalog.requests.ListDataAssetTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListDataAssetsRequest;
import com.oracle.bmc.datacatalog.requests.ListDerivedLogicalEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListEntitiesRequest;
import com.oracle.bmc.datacatalog.requests.ListEntityTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListFolderTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListFoldersRequest;
import com.oracle.bmc.datacatalog.requests.ListGlossariesRequest;
import com.oracle.bmc.datacatalog.requests.ListJobDefinitionsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobExecutionsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobLogsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobMetricsRequest;
import com.oracle.bmc.datacatalog.requests.ListJobsRequest;
import com.oracle.bmc.datacatalog.requests.ListMetastoresRequest;
import com.oracle.bmc.datacatalog.requests.ListNamespacesRequest;
import com.oracle.bmc.datacatalog.requests.ListPatternsRequest;
import com.oracle.bmc.datacatalog.requests.ListRulesRequest;
import com.oracle.bmc.datacatalog.requests.ListTagsRequest;
import com.oracle.bmc.datacatalog.requests.ListTermRelationshipsRequest;
import com.oracle.bmc.datacatalog.requests.ListTermsRequest;
import com.oracle.bmc.datacatalog.requests.ListTypesRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datacatalog.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datacatalog.requests.ObjectStatsRequest;
import com.oracle.bmc.datacatalog.requests.ParseConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ProcessRecommendationRequest;
import com.oracle.bmc.datacatalog.requests.RecommendationsRequest;
import com.oracle.bmc.datacatalog.requests.RemoveDataSelectorPatternsRequest;
import com.oracle.bmc.datacatalog.requests.SearchCriteriaRequest;
import com.oracle.bmc.datacatalog.requests.SuggestMatchesRequest;
import com.oracle.bmc.datacatalog.requests.SynchronousExportDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.TestConnectionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateAttributeRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCatalogRequest;
import com.oracle.bmc.datacatalog.requests.UpdateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.UpdateDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.UpdateEntityRequest;
import com.oracle.bmc.datacatalog.requests.UpdateFolderRequest;
import com.oracle.bmc.datacatalog.requests.UpdateGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.UpdateJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.UpdateJobRequest;
import com.oracle.bmc.datacatalog.requests.UpdateMetastoreRequest;
import com.oracle.bmc.datacatalog.requests.UpdateNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.UpdatePatternRequest;
import com.oracle.bmc.datacatalog.requests.UpdateTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.UpdateTermRequest;
import com.oracle.bmc.datacatalog.requests.UploadCredentialsRequest;
import com.oracle.bmc.datacatalog.requests.UsersRequest;
import com.oracle.bmc.datacatalog.requests.ValidateConnectionRequest;
import com.oracle.bmc.datacatalog.requests.ValidatePatternRequest;
import com.oracle.bmc.datacatalog.responses.AddDataSelectorPatternsResponse;
import com.oracle.bmc.datacatalog.responses.AssociateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.AttachCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.ChangeCatalogCompartmentResponse;
import com.oracle.bmc.datacatalog.responses.ChangeCatalogPrivateEndpointCompartmentResponse;
import com.oracle.bmc.datacatalog.responses.ChangeMetastoreCompartmentResponse;
import com.oracle.bmc.datacatalog.responses.CreateAttributeResponse;
import com.oracle.bmc.datacatalog.responses.CreateAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.CreateCatalogResponse;
import com.oracle.bmc.datacatalog.responses.CreateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.CreateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.CreateDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.CreateDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateEntityResponse;
import com.oracle.bmc.datacatalog.responses.CreateEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateFolderResponse;
import com.oracle.bmc.datacatalog.responses.CreateFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.CreateGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobExecutionResponse;
import com.oracle.bmc.datacatalog.responses.CreateJobResponse;
import com.oracle.bmc.datacatalog.responses.CreateMetastoreResponse;
import com.oracle.bmc.datacatalog.responses.CreateNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.CreatePatternResponse;
import com.oracle.bmc.datacatalog.responses.CreateTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.CreateTermResponse;
import com.oracle.bmc.datacatalog.responses.DeleteAttributeResponse;
import com.oracle.bmc.datacatalog.responses.DeleteAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCatalogResponse;
import com.oracle.bmc.datacatalog.responses.DeleteConnectionResponse;
import com.oracle.bmc.datacatalog.responses.DeleteCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.DeleteDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.DeleteDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteEntityResponse;
import com.oracle.bmc.datacatalog.responses.DeleteEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteFolderResponse;
import com.oracle.bmc.datacatalog.responses.DeleteFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.DeleteGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.DeleteJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.DeleteJobResponse;
import com.oracle.bmc.datacatalog.responses.DeleteMetastoreResponse;
import com.oracle.bmc.datacatalog.responses.DeleteNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.DeletePatternResponse;
import com.oracle.bmc.datacatalog.responses.DeleteTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.DeleteTermResponse;
import com.oracle.bmc.datacatalog.responses.DetachCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.DisassociateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.ExpandTreeForGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.ExportGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.GetAttributeResponse;
import com.oracle.bmc.datacatalog.responses.GetAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogResponse;
import com.oracle.bmc.datacatalog.responses.GetConnectionResponse;
import com.oracle.bmc.datacatalog.responses.GetCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.GetGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.GetJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobExecutionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobLogResponse;
import com.oracle.bmc.datacatalog.responses.GetJobMetricsResponse;
import com.oracle.bmc.datacatalog.responses.GetJobResponse;
import com.oracle.bmc.datacatalog.responses.GetMetastoreResponse;
import com.oracle.bmc.datacatalog.responses.GetNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.GetPatternResponse;
import com.oracle.bmc.datacatalog.responses.GetTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.GetTermResponse;
import com.oracle.bmc.datacatalog.responses.GetTypeResponse;
import com.oracle.bmc.datacatalog.responses.GetWorkRequestResponse;
import com.oracle.bmc.datacatalog.responses.ImportConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ImportDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.ImportGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.ListAggregatedPhysicalEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListAttributeTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListAttributesResponse;
import com.oracle.bmc.datacatalog.responses.ListCatalogPrivateEndpointsResponse;
import com.oracle.bmc.datacatalog.responses.ListCatalogsResponse;
import com.oracle.bmc.datacatalog.responses.ListConnectionsResponse;
import com.oracle.bmc.datacatalog.responses.ListCustomPropertiesResponse;
import com.oracle.bmc.datacatalog.responses.ListDataAssetTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListDataAssetsResponse;
import com.oracle.bmc.datacatalog.responses.ListDerivedLogicalEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListEntitiesResponse;
import com.oracle.bmc.datacatalog.responses.ListEntityTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListFolderTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListFoldersResponse;
import com.oracle.bmc.datacatalog.responses.ListGlossariesResponse;
import com.oracle.bmc.datacatalog.responses.ListJobDefinitionsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobExecutionsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobLogsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobMetricsResponse;
import com.oracle.bmc.datacatalog.responses.ListJobsResponse;
import com.oracle.bmc.datacatalog.responses.ListMetastoresResponse;
import com.oracle.bmc.datacatalog.responses.ListNamespacesResponse;
import com.oracle.bmc.datacatalog.responses.ListPatternsResponse;
import com.oracle.bmc.datacatalog.responses.ListRulesResponse;
import com.oracle.bmc.datacatalog.responses.ListTagsResponse;
import com.oracle.bmc.datacatalog.responses.ListTermRelationshipsResponse;
import com.oracle.bmc.datacatalog.responses.ListTermsResponse;
import com.oracle.bmc.datacatalog.responses.ListTypesResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datacatalog.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datacatalog.responses.ObjectStatsResponse;
import com.oracle.bmc.datacatalog.responses.ParseConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ProcessRecommendationResponse;
import com.oracle.bmc.datacatalog.responses.RecommendationsResponse;
import com.oracle.bmc.datacatalog.responses.RemoveDataSelectorPatternsResponse;
import com.oracle.bmc.datacatalog.responses.SearchCriteriaResponse;
import com.oracle.bmc.datacatalog.responses.SuggestMatchesResponse;
import com.oracle.bmc.datacatalog.responses.SynchronousExportDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.TestConnectionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateAttributeResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCatalogResponse;
import com.oracle.bmc.datacatalog.responses.UpdateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.UpdateDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.UpdateEntityResponse;
import com.oracle.bmc.datacatalog.responses.UpdateFolderResponse;
import com.oracle.bmc.datacatalog.responses.UpdateGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.UpdateJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.UpdateJobResponse;
import com.oracle.bmc.datacatalog.responses.UpdateMetastoreResponse;
import com.oracle.bmc.datacatalog.responses.UpdateNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.UpdatePatternResponse;
import com.oracle.bmc.datacatalog.responses.UpdateTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.UpdateTermResponse;
import com.oracle.bmc.datacatalog.responses.UploadCredentialsResponse;
import com.oracle.bmc.datacatalog.responses.UsersResponse;
import com.oracle.bmc.datacatalog.responses.ValidateConnectionResponse;
import com.oracle.bmc.datacatalog.responses.ValidatePatternResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCatalogClient
extends BaseSyncClient
implements DataCatalog {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATACATALOG").serviceEndpointPrefix("").serviceEndpointTemplate("https://datacatalog.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataCatalogAsyncClient.class);
    private final DataCatalogWaiters waiters;
    private final DataCatalogPaginators paginators;

    private DataCatalogClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DataCatalog-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataCatalogWaiters(executorService, this);
        this.paginators = new DataCatalogPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddDataSelectorPatternsResponse addDataSelectorPatterns(AddDataSelectorPatternsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDataSelectorPatternDetails(), "dataSelectorPatternDetails is required");
        return (AddDataSelectorPatternsResponse)this.clientCall(request, AddDataSelectorPatternsResponse::builder).logger(LOG, "addDataSelectorPatterns").serviceDetails("DataCatalog", "AddDataSelectorPatterns", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/AddDataSelectorPatterns").method(Method.POST).requestBuilder(AddDataSelectorPatternsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("actions").appendPathParam("addDataSelectorPatterns").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataAsset.class, AddDataSelectorPatternsResponse.Builder::dataAsset).handleResponseHeaderString("etag", AddDataSelectorPatternsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddDataSelectorPatternsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AssociateCustomPropertyResponse associateCustomProperty(AssociateCustomPropertyRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTypeKey(), (String)"typeKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAssociateCustomPropertyDetails(), "associateCustomPropertyDetails is required");
        return (AssociateCustomPropertyResponse)this.clientCall(request, AssociateCustomPropertyResponse::builder).logger(LOG, "associateCustomProperty").serviceDetails("DataCatalog", "AssociateCustomProperty", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Type/AssociateCustomProperty").method(Method.POST).requestBuilder(AssociateCustomPropertyRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("types").appendPathParam(request.getTypeKey()).appendPathParam("actions").appendPathParam("associateCustomProperties").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Type.class, AssociateCustomPropertyResponse.Builder::type).handleResponseHeaderString("etag", AssociateCustomPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AssociateCustomPropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AttachCatalogPrivateEndpointResponse attachCatalogPrivateEndpoint(AttachCatalogPrivateEndpointRequest request) {
        Objects.requireNonNull(request.getAttachCatalogPrivateEndpointDetails(), "attachCatalogPrivateEndpointDetails is required");
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (AttachCatalogPrivateEndpointResponse)this.clientCall(request, AttachCatalogPrivateEndpointResponse::builder).logger(LOG, "attachCatalogPrivateEndpoint").serviceDetails("DataCatalog", "AttachCatalogPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/AttachCatalogPrivateEndpoint").method(Method.POST).requestBuilder(AttachCatalogPrivateEndpointRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("attachCatalogPrivateEndpoint").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", AttachCatalogPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AttachCatalogPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeCatalogCompartmentResponse changeCatalogCompartment(ChangeCatalogCompartmentRequest request) {
        Objects.requireNonNull(request.getChangeCatalogCompartmentDetails(), "changeCatalogCompartmentDetails is required");
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ChangeCatalogCompartmentResponse)this.clientCall(request, ChangeCatalogCompartmentResponse::builder).logger(LOG, "changeCatalogCompartment").serviceDetails("DataCatalog", "ChangeCatalogCompartment", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/ChangeCatalogCompartment").method(Method.POST).requestBuilder(ChangeCatalogCompartmentRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeCatalogCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeCatalogCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeCatalogPrivateEndpointCompartmentResponse changeCatalogPrivateEndpointCompartment(ChangeCatalogPrivateEndpointCompartmentRequest request) {
        Objects.requireNonNull(request.getChangeCatalogPrivateEndpointCompartmentDetails(), "changeCatalogPrivateEndpointCompartmentDetails is required");
        Validate.notBlank((String)request.getCatalogPrivateEndpointId(), (String)"catalogPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return (ChangeCatalogPrivateEndpointCompartmentResponse)this.clientCall(request, ChangeCatalogPrivateEndpointCompartmentResponse::builder).logger(LOG, "changeCatalogPrivateEndpointCompartment").serviceDetails("DataCatalog", "ChangeCatalogPrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CatalogPrivateEndpoint/ChangeCatalogPrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangeCatalogPrivateEndpointCompartmentRequest::builder).basePath("/20190325").appendPathParam("catalogPrivateEndpoints").appendPathParam(request.getCatalogPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeCatalogPrivateEndpointCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeCatalogPrivateEndpointCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeMetastoreCompartmentResponse changeMetastoreCompartment(ChangeMetastoreCompartmentRequest request) {
        Objects.requireNonNull(request.getChangeMetastoreCompartmentDetails(), "changeMetastoreCompartmentDetails is required");
        Validate.notBlank((String)request.getMetastoreId(), (String)"metastoreId must not be blank", (Object[])new Object[0]);
        return (ChangeMetastoreCompartmentResponse)this.clientCall(request, ChangeMetastoreCompartmentResponse::builder).logger(LOG, "changeMetastoreCompartment").serviceDetails("DataCatalog", "ChangeMetastoreCompartment", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Metastore/ChangeMetastoreCompartment").method(Method.POST).requestBuilder(ChangeMetastoreCompartmentRequest::builder).basePath("/20190325").appendPathParam("metastores").appendPathParam(request.getMetastoreId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeMetastoreCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeMetastoreCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAttributeResponse createAttribute(CreateAttributeRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAttributeDetails(), "createAttributeDetails is required");
        return (CreateAttributeResponse)this.clientCall(request, CreateAttributeResponse::builder).logger(LOG, "createAttribute").serviceDetails("DataCatalog", "CreateAttribute", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Attribute/CreateAttribute").method(Method.POST).requestBuilder(CreateAttributeRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Attribute.class, CreateAttributeResponse.Builder::attribute).handleResponseHeaderString("etag", CreateAttributeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAttributeTagResponse createAttributeTag(CreateAttributeTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttributeKey(), (String)"attributeKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAttributeTagDetails(), "createAttributeTagDetails is required");
        return (CreateAttributeTagResponse)this.clientCall(request, CreateAttributeTagResponse::builder).logger(LOG, "createAttributeTag").serviceDetails("DataCatalog", "CreateAttributeTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/AttributeTag/CreateAttributeTag").method(Method.POST).requestBuilder(CreateAttributeTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendPathParam(request.getAttributeKey()).appendPathParam("tags").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AttributeTag.class, CreateAttributeTagResponse.Builder::attributeTag).handleResponseHeaderString("etag", CreateAttributeTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAttributeTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCatalogResponse createCatalog(CreateCatalogRequest request) {
        Objects.requireNonNull(request.getCreateCatalogDetails(), "createCatalogDetails is required");
        return (CreateCatalogResponse)this.clientCall(request, CreateCatalogResponse::builder).logger(LOG, "createCatalog").serviceDetails("DataCatalog", "CreateCatalog", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/CreateCatalog").method(Method.POST).requestBuilder(CreateCatalogRequest::builder).basePath("/20190325").appendPathParam("catalogs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateCatalogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateCatalogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCatalogPrivateEndpointResponse createCatalogPrivateEndpoint(CreateCatalogPrivateEndpointRequest request) {
        Objects.requireNonNull(request.getCreateCatalogPrivateEndpointDetails(), "createCatalogPrivateEndpointDetails is required");
        return (CreateCatalogPrivateEndpointResponse)this.clientCall(request, CreateCatalogPrivateEndpointResponse::builder).logger(LOG, "createCatalogPrivateEndpoint").serviceDetails("DataCatalog", "CreateCatalogPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CatalogPrivateEndpoint/CreateCatalogPrivateEndpoint").method(Method.POST).requestBuilder(CreateCatalogPrivateEndpointRequest::builder).basePath("/20190325").appendPathParam("catalogPrivateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateCatalogPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateCatalogPrivateEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return (CreateConnectionResponse)this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("DataCatalog", "CreateConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Connection/CreateConnection").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateCustomPropertyResponse createCustomProperty(CreateCustomPropertyRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateCustomPropertyDetails(), "createCustomPropertyDetails is required");
        return (CreateCustomPropertyResponse)this.clientCall(request, CreateCustomPropertyResponse::builder).logger(LOG, "createCustomProperty").serviceDetails("DataCatalog", "CreateCustomProperty", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CustomProperty/CreateCustomProperty").method(Method.POST).requestBuilder(CreateCustomPropertyRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).appendPathParam("customProperties").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CustomProperty.class, CreateCustomPropertyResponse.Builder::customProperty).handleResponseHeaderString("etag", CreateCustomPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCustomPropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDataAssetResponse createDataAsset(CreateDataAssetRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataAssetDetails(), "createDataAssetDetails is required");
        return (CreateDataAssetResponse)this.clientCall(request, CreateDataAssetResponse::builder).logger(LOG, "createDataAsset").serviceDetails("DataCatalog", "CreateDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/CreateDataAsset").method(Method.POST).requestBuilder(CreateDataAssetRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataAsset.class, CreateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", CreateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataAssetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDataAssetTagResponse createDataAssetTag(CreateDataAssetTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDataAssetTagDetails(), "createDataAssetTagDetails is required");
        return (CreateDataAssetTagResponse)this.clientCall(request, CreateDataAssetTagResponse::builder).logger(LOG, "createDataAssetTag").serviceDetails("DataCatalog", "CreateDataAssetTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAssetTag/CreateDataAssetTag").method(Method.POST).requestBuilder(CreateDataAssetTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("tags").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataAssetTag.class, CreateDataAssetTagResponse.Builder::dataAssetTag).handleResponseHeaderString("etag", CreateDataAssetTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDataAssetTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateEntityResponse createEntity(CreateEntityRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateEntityDetails(), "createEntityDetails is required");
        return (CreateEntityResponse)this.clientCall(request, CreateEntityResponse::builder).logger(LOG, "createEntity").serviceDetails("DataCatalog", "CreateEntity", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Entity/CreateEntity").method(Method.POST).requestBuilder(CreateEntityRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Entity.class, CreateEntityResponse.Builder::entity).handleResponseHeaderString("etag", CreateEntityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateEntityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateEntityTagResponse createEntityTag(CreateEntityTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateEntityTagDetails(), "createEntityTagDetails is required");
        return (CreateEntityTagResponse)this.clientCall(request, CreateEntityTagResponse::builder).logger(LOG, "createEntityTag").serviceDetails("DataCatalog", "CreateEntityTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/EntityTag/CreateEntityTag").method(Method.POST).requestBuilder(CreateEntityTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("tags").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(EntityTag.class, CreateEntityTagResponse.Builder::entityTag).handleResponseHeaderString("etag", CreateEntityTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateEntityTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateFolderDetails(), "createFolderDetails is required");
        return (CreateFolderResponse)this.clientCall(request, CreateFolderResponse::builder).logger(LOG, "createFolder").serviceDetails("DataCatalog", "CreateFolder", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Folder/CreateFolder").method(Method.POST).requestBuilder(CreateFolderRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Folder.class, CreateFolderResponse.Builder::folder).handleResponseHeaderString("etag", CreateFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFolderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateFolderTagResponse createFolderTag(CreateFolderTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateFolderTagDetails(), "createFolderTagDetails is required");
        return (CreateFolderTagResponse)this.clientCall(request, CreateFolderTagResponse::builder).logger(LOG, "createFolderTag").serviceDetails("DataCatalog", "CreateFolderTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/FolderTag/CreateFolderTag").method(Method.POST).requestBuilder(CreateFolderTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendPathParam(request.getFolderKey()).appendPathParam("tags").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(FolderTag.class, CreateFolderTagResponse.Builder::folderTag).handleResponseHeaderString("etag", CreateFolderTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateFolderTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateGlossaryResponse createGlossary(CreateGlossaryRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateGlossaryDetails(), "createGlossaryDetails is required");
        return (CreateGlossaryResponse)this.clientCall(request, CreateGlossaryResponse::builder).logger(LOG, "createGlossary").serviceDetails("DataCatalog", "CreateGlossary", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/CreateGlossary").method(Method.POST).requestBuilder(CreateGlossaryRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Glossary.class, CreateGlossaryResponse.Builder::glossary).handleResponseHeaderString("etag", CreateGlossaryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateGlossaryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateJobDetails(), "createJobDetails is required");
        return (CreateJobResponse)this.clientCall(request, CreateJobResponse::builder).logger(LOG, "createJob").serviceDetails("DataCatalog", "CreateJob", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Job/CreateJob").method(Method.POST).requestBuilder(CreateJobRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Job.class, CreateJobResponse.Builder::job).handleResponseHeaderString("etag", CreateJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJobDefinitionResponse createJobDefinition(CreateJobDefinitionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateJobDefinitionDetails(), "createJobDefinitionDetails is required");
        return (CreateJobDefinitionResponse)this.clientCall(request, CreateJobDefinitionResponse::builder).logger(LOG, "createJobDefinition").serviceDetails("DataCatalog", "CreateJobDefinition", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobDefinition/CreateJobDefinition").method(Method.POST).requestBuilder(CreateJobDefinitionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobDefinitions").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(JobDefinition.class, CreateJobDefinitionResponse.Builder::jobDefinition).handleResponseHeaderString("etag", CreateJobDefinitionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateJobDefinitionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJobExecutionResponse createJobExecution(CreateJobExecutionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateJobExecutionDetails(), "createJobExecutionDetails is required");
        return (CreateJobExecutionResponse)this.clientCall(request, CreateJobExecutionResponse::builder).logger(LOG, "createJobExecution").serviceDetails("DataCatalog", "CreateJobExecution", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobExecution/CreateJobExecution").method(Method.POST).requestBuilder(CreateJobExecutionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendPathParam("executions").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(JobExecution.class, CreateJobExecutionResponse.Builder::jobExecution).handleResponseHeaderString("etag", CreateJobExecutionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateJobExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateMetastoreResponse createMetastore(CreateMetastoreRequest request) {
        Objects.requireNonNull(request.getCreateMetastoreDetails(), "createMetastoreDetails is required");
        return (CreateMetastoreResponse)this.clientCall(request, CreateMetastoreResponse::builder).logger(LOG, "createMetastore").serviceDetails("DataCatalog", "CreateMetastore", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Metastore/CreateMetastore").method(Method.POST).requestBuilder(CreateMetastoreRequest::builder).basePath("/20190325").appendPathParam("metastores").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateMetastoreResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateMetastoreResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateNamespaceDetails(), "createNamespaceDetails is required");
        return (CreateNamespaceResponse)this.clientCall(request, CreateNamespaceResponse::builder).logger(LOG, "createNamespace").serviceDetails("DataCatalog", "CreateNamespace", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Namespace/CreateNamespace").method(Method.POST).requestBuilder(CreateNamespaceRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Namespace.class, CreateNamespaceResponse.Builder::namespace).handleResponseHeaderString("etag", CreateNamespaceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateNamespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePatternResponse createPattern(CreatePatternRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePatternDetails(), "createPatternDetails is required");
        return (CreatePatternResponse)this.clientCall(request, CreatePatternResponse::builder).logger(LOG, "createPattern").serviceDetails("DataCatalog", "CreatePattern", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Pattern/CreatePattern").method(Method.POST).requestBuilder(CreatePatternRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("patterns").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Pattern.class, CreatePatternResponse.Builder::pattern).handleResponseHeaderString("etag", CreatePatternResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreatePatternResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateTermResponse createTerm(CreateTermRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTermDetails(), "createTermDetails is required");
        return (CreateTermResponse)this.clientCall(request, CreateTermResponse::builder).logger(LOG, "createTerm").serviceDetails("DataCatalog", "CreateTerm", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Term/CreateTerm").method(Method.POST).requestBuilder(CreateTermRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Term.class, CreateTermResponse.Builder::term).handleResponseHeaderString("etag", CreateTermResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTermResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateTermRelationshipResponse createTermRelationship(CreateTermRelationshipRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTermRelationshipDetails(), "createTermRelationshipDetails is required");
        return (CreateTermRelationshipResponse)this.clientCall(request, CreateTermRelationshipResponse::builder).logger(LOG, "createTermRelationship").serviceDetails("DataCatalog", "CreateTermRelationship", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/TermRelationship/CreateTermRelationship").method(Method.POST).requestBuilder(CreateTermRelationshipRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).appendPathParam("termRelationships").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TermRelationship.class, CreateTermRelationshipResponse.Builder::termRelationship).handleResponseHeaderString("etag", CreateTermRelationshipResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateTermRelationshipResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAttributeResponse deleteAttribute(DeleteAttributeRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttributeKey(), (String)"attributeKey must not be blank", (Object[])new Object[0]);
        return (DeleteAttributeResponse)this.clientCall(request, DeleteAttributeResponse::builder).logger(LOG, "deleteAttribute").serviceDetails("DataCatalog", "DeleteAttribute", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Attribute/DeleteAttribute").method(Method.DELETE).requestBuilder(DeleteAttributeRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendPathParam(request.getAttributeKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAttributeTagResponse deleteAttributeTag(DeleteAttributeTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttributeKey(), (String)"attributeKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (DeleteAttributeTagResponse)this.clientCall(request, DeleteAttributeTagResponse::builder).logger(LOG, "deleteAttributeTag").serviceDetails("DataCatalog", "DeleteAttributeTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/AttributeTag/DeleteAttributeTag").method(Method.DELETE).requestBuilder(DeleteAttributeTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendPathParam(request.getAttributeKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAttributeTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCatalogResponse deleteCatalog(DeleteCatalogRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (DeleteCatalogResponse)this.clientCall(request, DeleteCatalogResponse::builder).logger(LOG, "deleteCatalog").serviceDetails("DataCatalog", "DeleteCatalog", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/DeleteCatalog").method(Method.DELETE).requestBuilder(DeleteCatalogRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteCatalogResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCatalogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCatalogPrivateEndpointResponse deleteCatalogPrivateEndpoint(DeleteCatalogPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getCatalogPrivateEndpointId(), (String)"catalogPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return (DeleteCatalogPrivateEndpointResponse)this.clientCall(request, DeleteCatalogPrivateEndpointResponse::builder).logger(LOG, "deleteCatalogPrivateEndpoint").serviceDetails("DataCatalog", "DeleteCatalogPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CatalogPrivateEndpoint/DeleteCatalogPrivateEndpoint").method(Method.DELETE).requestBuilder(DeleteCatalogPrivateEndpointRequest::builder).basePath("/20190325").appendPathParam("catalogPrivateEndpoints").appendPathParam(request.getCatalogPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteCatalogPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCatalogPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return (DeleteConnectionResponse)this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("DataCatalog", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCustomPropertyResponse deleteCustomProperty(DeleteCustomPropertyRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCustomPropertyKey(), (String)"customPropertyKey must not be blank", (Object[])new Object[0]);
        return (DeleteCustomPropertyResponse)this.clientCall(request, DeleteCustomPropertyResponse::builder).logger(LOG, "deleteCustomProperty").serviceDetails("DataCatalog", "DeleteCustomProperty", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CustomProperty/DeleteCustomProperty").method(Method.DELETE).requestBuilder(DeleteCustomPropertyRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).appendPathParam("customProperties").appendPathParam(request.getCustomPropertyKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteCustomPropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDataAssetResponse deleteDataAsset(DeleteDataAssetRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return (DeleteDataAssetResponse)this.clientCall(request, DeleteDataAssetResponse::builder).logger(LOG, "deleteDataAsset").serviceDetails("DataCatalog", "DeleteDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/DeleteDataAsset").method(Method.DELETE).requestBuilder(DeleteDataAssetRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataAssetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDataAssetTagResponse deleteDataAssetTag(DeleteDataAssetTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (DeleteDataAssetTagResponse)this.clientCall(request, DeleteDataAssetTagResponse::builder).logger(LOG, "deleteDataAssetTag").serviceDetails("DataCatalog", "DeleteDataAssetTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAssetTag/DeleteDataAssetTag").method(Method.DELETE).requestBuilder(DeleteDataAssetTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDataAssetTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteEntityResponse deleteEntity(DeleteEntityRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        return (DeleteEntityResponse)this.clientCall(request, DeleteEntityResponse::builder).logger(LOG, "deleteEntity").serviceDetails("DataCatalog", "DeleteEntity", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Entity/DeleteEntity").method(Method.DELETE).requestBuilder(DeleteEntityRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteEntityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteEntityTagResponse deleteEntityTag(DeleteEntityTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (DeleteEntityTagResponse)this.clientCall(request, DeleteEntityTagResponse::builder).logger(LOG, "deleteEntityTag").serviceDetails("DataCatalog", "DeleteEntityTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/EntityTag/DeleteEntityTag").method(Method.DELETE).requestBuilder(DeleteEntityTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteEntityTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        return (DeleteFolderResponse)this.clientCall(request, DeleteFolderResponse::builder).logger(LOG, "deleteFolder").serviceDetails("DataCatalog", "DeleteFolder", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Folder/DeleteFolder").method(Method.DELETE).requestBuilder(DeleteFolderRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendPathParam(request.getFolderKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFolderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFolderTagResponse deleteFolderTag(DeleteFolderTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (DeleteFolderTagResponse)this.clientCall(request, DeleteFolderTagResponse::builder).logger(LOG, "deleteFolderTag").serviceDetails("DataCatalog", "DeleteFolderTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/FolderTag/DeleteFolderTag").method(Method.DELETE).requestBuilder(DeleteFolderTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendPathParam(request.getFolderKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteFolderTagResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteGlossaryResponse deleteGlossary(DeleteGlossaryRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        return (DeleteGlossaryResponse)this.clientCall(request, DeleteGlossaryResponse::builder).logger(LOG, "deleteGlossary").serviceDetails("DataCatalog", "DeleteGlossary", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/DeleteGlossary").method(Method.DELETE).requestBuilder(DeleteGlossaryRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteGlossaryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        return (DeleteJobResponse)this.clientCall(request, DeleteJobResponse::builder).logger(LOG, "deleteJob").serviceDetails("DataCatalog", "DeleteJob", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Job/DeleteJob").method(Method.DELETE).requestBuilder(DeleteJobRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJobDefinitionResponse deleteJobDefinition(DeleteJobDefinitionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobDefinitionKey(), (String)"jobDefinitionKey must not be blank", (Object[])new Object[0]);
        return (DeleteJobDefinitionResponse)this.clientCall(request, DeleteJobDefinitionResponse::builder).logger(LOG, "deleteJobDefinition").serviceDetails("DataCatalog", "DeleteJobDefinition", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobDefinition/DeleteJobDefinition").method(Method.DELETE).requestBuilder(DeleteJobDefinitionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobDefinitions").appendPathParam(request.getJobDefinitionKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteJobDefinitionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteMetastoreResponse deleteMetastore(DeleteMetastoreRequest request) {
        Validate.notBlank((String)request.getMetastoreId(), (String)"metastoreId must not be blank", (Object[])new Object[0]);
        return (DeleteMetastoreResponse)this.clientCall(request, DeleteMetastoreResponse::builder).logger(LOG, "deleteMetastore").serviceDetails("DataCatalog", "DeleteMetastore", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Metastore/DeleteMetastore").method(Method.DELETE).requestBuilder(DeleteMetastoreRequest::builder).basePath("/20190325").appendPathParam("metastores").appendPathParam(request.getMetastoreId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteMetastoreResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteMetastoreResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        return (DeleteNamespaceResponse)this.clientCall(request, DeleteNamespaceResponse::builder).logger(LOG, "deleteNamespace").serviceDetails("DataCatalog", "DeleteNamespace", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Namespace/DeleteNamespace").method(Method.DELETE).requestBuilder(DeleteNamespaceRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteNamespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePatternResponse deletePattern(DeletePatternRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPatternKey(), (String)"patternKey must not be blank", (Object[])new Object[0]);
        return (DeletePatternResponse)this.clientCall(request, DeletePatternResponse::builder).logger(LOG, "deletePattern").serviceDetails("DataCatalog", "DeletePattern", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Pattern/DeletePattern").method(Method.DELETE).requestBuilder(DeletePatternRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("patterns").appendPathParam(request.getPatternKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePatternResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTermResponse deleteTerm(DeleteTermRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        return (DeleteTermResponse)this.clientCall(request, DeleteTermResponse::builder).logger(LOG, "deleteTerm").serviceDetails("DataCatalog", "DeleteTerm", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Term/DeleteTerm").method(Method.DELETE).requestBuilder(DeleteTermRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTermResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTermRelationshipResponse deleteTermRelationship(DeleteTermRelationshipRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermRelationshipKey(), (String)"termRelationshipKey must not be blank", (Object[])new Object[0]);
        return (DeleteTermRelationshipResponse)this.clientCall(request, DeleteTermRelationshipResponse::builder).logger(LOG, "deleteTermRelationship").serviceDetails("DataCatalog", "DeleteTermRelationship", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/TermRelationship/DeleteTermRelationship").method(Method.DELETE).requestBuilder(DeleteTermRelationshipRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).appendPathParam("termRelationships").appendPathParam(request.getTermRelationshipKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteTermRelationshipResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachCatalogPrivateEndpointResponse detachCatalogPrivateEndpoint(DetachCatalogPrivateEndpointRequest request) {
        Objects.requireNonNull(request.getDetachCatalogPrivateEndpointDetails(), "detachCatalogPrivateEndpointDetails is required");
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (DetachCatalogPrivateEndpointResponse)this.clientCall(request, DetachCatalogPrivateEndpointResponse::builder).logger(LOG, "detachCatalogPrivateEndpoint").serviceDetails("DataCatalog", "DetachCatalogPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/DetachCatalogPrivateEndpoint").method(Method.POST).requestBuilder(DetachCatalogPrivateEndpointRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("detachCatalogPrivateEndpoint").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", DetachCatalogPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DetachCatalogPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DisassociateCustomPropertyResponse disassociateCustomProperty(DisassociateCustomPropertyRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTypeKey(), (String)"typeKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisassociateCustomPropertyDetails(), "disassociateCustomPropertyDetails is required");
        return (DisassociateCustomPropertyResponse)this.clientCall(request, DisassociateCustomPropertyResponse::builder).logger(LOG, "disassociateCustomProperty").serviceDetails("DataCatalog", "DisassociateCustomProperty", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Type/DisassociateCustomProperty").method(Method.POST).requestBuilder(DisassociateCustomPropertyRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("types").appendPathParam(request.getTypeKey()).appendPathParam("actions").appendPathParam("disassociateCustomProperties").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Type.class, DisassociateCustomPropertyResponse.Builder::type).handleResponseHeaderString("etag", DisassociateCustomPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", DisassociateCustomPropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExpandTreeForGlossaryResponse expandTreeForGlossary(ExpandTreeForGlossaryRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        return (ExpandTreeForGlossaryResponse)this.clientCall(request, ExpandTreeForGlossaryResponse::builder).logger(LOG, "expandTreeForGlossary").serviceDetails("DataCatalog", "ExpandTreeForGlossary", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/ExpandTreeForGlossary").method(Method.POST).requestBuilder(ExpandTreeForGlossaryRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("actions").appendPathParam("expandTree").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBodyList(GlossaryTreeElement.class, ExpandTreeForGlossaryResponse.Builder::items).handleResponseHeaderString("etag", ExpandTreeForGlossaryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ExpandTreeForGlossaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExportGlossaryResponse exportGlossary(ExportGlossaryRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        return (ExportGlossaryResponse)this.clientCall(request, ExportGlossaryResponse::builder).logger(LOG, "exportGlossary").serviceDetails("DataCatalog", "ExportGlossary", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/ExportGlossary").method(Method.POST).requestBuilder(ExportGlossaryRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("actions").appendPathParam("export").appendQueryParam("isRelationshipExported", (Object)request.getIsRelationshipExported()).accept(new String[]{"application/json, text/csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(String.class, ExportGlossaryResponse.Builder::value).handleResponseHeaderString("etag", ExportGlossaryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ExportGlossaryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAttributeResponse getAttribute(GetAttributeRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttributeKey(), (String)"attributeKey must not be blank", (Object[])new Object[0]);
        return (GetAttributeResponse)this.clientCall(request, GetAttributeResponse::builder).logger(LOG, "getAttribute").serviceDetails("DataCatalog", "GetAttribute", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Attribute/GetAttribute").method(Method.GET).requestBuilder(GetAttributeRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendPathParam(request.getAttributeKey()).appendQueryParam("isIncludeObjectRelationships", (Object)request.getIsIncludeObjectRelationships()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Attribute.class, GetAttributeResponse.Builder::attribute).handleResponseHeaderString("etag", GetAttributeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAttributeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetAttributeTagResponse getAttributeTag(GetAttributeTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttributeKey(), (String)"attributeKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (GetAttributeTagResponse)this.clientCall(request, GetAttributeTagResponse::builder).logger(LOG, "getAttributeTag").serviceDetails("DataCatalog", "GetAttributeTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/AttributeTag/GetAttributeTag").method(Method.GET).requestBuilder(GetAttributeTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendPathParam(request.getAttributeKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AttributeTag.class, GetAttributeTagResponse.Builder::attributeTag).handleResponseHeaderString("etag", GetAttributeTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAttributeTagResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetCatalogResponse getCatalog(GetCatalogRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (GetCatalogResponse)this.clientCall(request, GetCatalogResponse::builder).logger(LOG, "getCatalog").serviceDetails("DataCatalog", "GetCatalog", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/GetCatalog").method(Method.GET).requestBuilder(GetCatalogRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Catalog.class, GetCatalogResponse.Builder::catalog).handleResponseHeaderString("etag", GetCatalogResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCatalogResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetCatalogPrivateEndpointResponse getCatalogPrivateEndpoint(GetCatalogPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getCatalogPrivateEndpointId(), (String)"catalogPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return (GetCatalogPrivateEndpointResponse)this.clientCall(request, GetCatalogPrivateEndpointResponse::builder).logger(LOG, "getCatalogPrivateEndpoint").serviceDetails("DataCatalog", "GetCatalogPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CatalogPrivateEndpoint/GetCatalogPrivateEndpoint").method(Method.GET).requestBuilder(GetCatalogPrivateEndpointRequest::builder).basePath("/20190325").appendPathParam("catalogPrivateEndpoints").appendPathParam(request.getCatalogPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CatalogPrivateEndpoint.class, GetCatalogPrivateEndpointResponse.Builder::catalogPrivateEndpoint).handleResponseHeaderString("opc-request-id", GetCatalogPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetCatalogPrivateEndpointResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return (GetConnectionResponse)this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("DataCatalog", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetCustomPropertyResponse getCustomProperty(GetCustomPropertyRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCustomPropertyKey(), (String)"customPropertyKey must not be blank", (Object[])new Object[0]);
        return (GetCustomPropertyResponse)this.clientCall(request, GetCustomPropertyResponse::builder).logger(LOG, "getCustomProperty").serviceDetails("DataCatalog", "GetCustomProperty", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CustomProperty/GetCustomProperty").method(Method.GET).requestBuilder(GetCustomPropertyRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).appendPathParam("customProperties").appendPathParam(request.getCustomPropertyKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CustomProperty.class, GetCustomPropertyResponse.Builder::customProperty).handleResponseHeaderString("etag", GetCustomPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCustomPropertyResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetDataAssetResponse getDataAsset(GetDataAssetRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return (GetDataAssetResponse)this.clientCall(request, GetDataAssetResponse::builder).logger(LOG, "getDataAsset").serviceDetails("DataCatalog", "GetDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/GetDataAsset").method(Method.GET).requestBuilder(GetDataAssetRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAsset.class, GetDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", GetDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataAssetResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetDataAssetTagResponse getDataAssetTag(GetDataAssetTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (GetDataAssetTagResponse)this.clientCall(request, GetDataAssetTagResponse::builder).logger(LOG, "getDataAssetTag").serviceDetails("DataCatalog", "GetDataAssetTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAssetTag/GetDataAssetTag").method(Method.GET).requestBuilder(GetDataAssetTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAssetTag.class, GetDataAssetTagResponse.Builder::dataAssetTag).handleResponseHeaderString("etag", GetDataAssetTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDataAssetTagResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetEntityResponse getEntity(GetEntityRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        return (GetEntityResponse)this.clientCall(request, GetEntityResponse::builder).logger(LOG, "getEntity").serviceDetails("DataCatalog", "GetEntity", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Entity/GetEntity").method(Method.GET).requestBuilder(GetEntityRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendQueryParam("isIncludeObjectRelationships", (Object)request.getIsIncludeObjectRelationships()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Entity.class, GetEntityResponse.Builder::entity).handleResponseHeaderString("etag", GetEntityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEntityResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetEntityTagResponse getEntityTag(GetEntityTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (GetEntityTagResponse)this.clientCall(request, GetEntityTagResponse::builder).logger(LOG, "getEntityTag").serviceDetails("DataCatalog", "GetEntityTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/EntityTag/GetEntityTag").method(Method.GET).requestBuilder(GetEntityTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EntityTag.class, GetEntityTagResponse.Builder::entityTag).handleResponseHeaderString("etag", GetEntityTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEntityTagResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetFolderResponse getFolder(GetFolderRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        return (GetFolderResponse)this.clientCall(request, GetFolderResponse::builder).logger(LOG, "getFolder").serviceDetails("DataCatalog", "GetFolder", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Folder/GetFolder").method(Method.GET).requestBuilder(GetFolderRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendPathParam(request.getFolderKey()).appendQueryParam("isIncludeObjectRelationships", (Object)request.getIsIncludeObjectRelationships()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Folder.class, GetFolderResponse.Builder::folder).handleResponseHeaderString("etag", GetFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFolderResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetFolderTagResponse getFolderTag(GetFolderTagRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTagKey(), (String)"tagKey must not be blank", (Object[])new Object[0]);
        return (GetFolderTagResponse)this.clientCall(request, GetFolderTagResponse::builder).logger(LOG, "getFolderTag").serviceDetails("DataCatalog", "GetFolderTag", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/FolderTag/GetFolderTag").method(Method.GET).requestBuilder(GetFolderTagRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendPathParam(request.getFolderKey()).appendPathParam("tags").appendPathParam(request.getTagKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FolderTag.class, GetFolderTagResponse.Builder::folderTag).handleResponseHeaderString("etag", GetFolderTagResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFolderTagResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetGlossaryResponse getGlossary(GetGlossaryRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        return (GetGlossaryResponse)this.clientCall(request, GetGlossaryResponse::builder).logger(LOG, "getGlossary").serviceDetails("DataCatalog", "GetGlossary", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/GetGlossary").method(Method.GET).requestBuilder(GetGlossaryRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Glossary.class, GetGlossaryResponse.Builder::glossary).handleResponseHeaderString("etag", GetGlossaryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGlossaryResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        return (GetJobResponse)this.clientCall(request, GetJobResponse::builder).logger(LOG, "getJob").serviceDetails("DataCatalog", "GetJob", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Job/GetJob").method(Method.GET).requestBuilder(GetJobRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, GetJobResponse.Builder::job).handleResponseHeaderString("etag", GetJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobDefinitionResponse getJobDefinition(GetJobDefinitionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobDefinitionKey(), (String)"jobDefinitionKey must not be blank", (Object[])new Object[0]);
        return (GetJobDefinitionResponse)this.clientCall(request, GetJobDefinitionResponse::builder).logger(LOG, "getJobDefinition").serviceDetails("DataCatalog", "GetJobDefinition", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobDefinition/GetJobDefinition").method(Method.GET).requestBuilder(GetJobDefinitionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobDefinitions").appendPathParam(request.getJobDefinitionKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobDefinition.class, GetJobDefinitionResponse.Builder::jobDefinition).handleResponseHeaderString("etag", GetJobDefinitionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobDefinitionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobExecutionResponse getJobExecution(GetJobExecutionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobExecutionKey(), (String)"jobExecutionKey must not be blank", (Object[])new Object[0]);
        return (GetJobExecutionResponse)this.clientCall(request, GetJobExecutionResponse::builder).logger(LOG, "getJobExecution").serviceDetails("DataCatalog", "GetJobExecution", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobExecution/GetJobExecution").method(Method.GET).requestBuilder(GetJobExecutionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendPathParam("executions").appendPathParam(request.getJobExecutionKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecution.class, GetJobExecutionResponse.Builder::jobExecution).handleResponseHeaderString("etag", GetJobExecutionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobExecutionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobLogResponse getJobLog(GetJobLogRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobExecutionKey(), (String)"jobExecutionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobLogKey(), (String)"jobLogKey must not be blank", (Object[])new Object[0]);
        return (GetJobLogResponse)this.clientCall(request, GetJobLogResponse::builder).logger(LOG, "getJobLog").serviceDetails("DataCatalog", "GetJobLog", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobLog/GetJobLog").method(Method.GET).requestBuilder(GetJobLogRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendPathParam("executions").appendPathParam(request.getJobExecutionKey()).appendPathParam("logs").appendPathParam(request.getJobLogKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobLog.class, GetJobLogResponse.Builder::jobLog).handleResponseHeaderString("etag", GetJobLogResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobLogResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobMetricsResponse getJobMetrics(GetJobMetricsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobExecutionKey(), (String)"jobExecutionKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobMetricsKey(), (String)"jobMetricsKey must not be blank", (Object[])new Object[0]);
        return (GetJobMetricsResponse)this.clientCall(request, GetJobMetricsResponse::builder).logger(LOG, "getJobMetrics").serviceDetails("DataCatalog", "GetJobMetrics", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobMetric/GetJobMetrics").method(Method.GET).requestBuilder(GetJobMetricsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendPathParam("executions").appendPathParam(request.getJobExecutionKey()).appendPathParam("metrics").appendPathParam(request.getJobMetricsKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobMetric.class, GetJobMetricsResponse.Builder::jobMetric).handleResponseHeaderString("etag", GetJobMetricsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobMetricsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetMetastoreResponse getMetastore(GetMetastoreRequest request) {
        Validate.notBlank((String)request.getMetastoreId(), (String)"metastoreId must not be blank", (Object[])new Object[0]);
        return (GetMetastoreResponse)this.clientCall(request, GetMetastoreResponse::builder).logger(LOG, "getMetastore").serviceDetails("DataCatalog", "GetMetastore", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Metastore/GetMetastore").method(Method.GET).requestBuilder(GetMetastoreRequest::builder).basePath("/20190325").appendPathParam("metastores").appendPathParam(request.getMetastoreId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Metastore.class, GetMetastoreResponse.Builder::metastore).handleResponseHeaderString("etag", GetMetastoreResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMetastoreResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        return (GetNamespaceResponse)this.clientCall(request, GetNamespaceResponse::builder).logger(LOG, "getNamespace").serviceDetails("DataCatalog", "GetNamespace", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Namespace/GetNamespace").method(Method.GET).requestBuilder(GetNamespaceRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Namespace.class, GetNamespaceResponse.Builder::namespace).handleResponseHeaderString("etag", GetNamespaceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNamespaceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetPatternResponse getPattern(GetPatternRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPatternKey(), (String)"patternKey must not be blank", (Object[])new Object[0]);
        return (GetPatternResponse)this.clientCall(request, GetPatternResponse::builder).logger(LOG, "getPattern").serviceDetails("DataCatalog", "GetPattern", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Pattern/GetPattern").method(Method.GET).requestBuilder(GetPatternRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("patterns").appendPathParam(request.getPatternKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Pattern.class, GetPatternResponse.Builder::pattern).handleResponseHeaderString("etag", GetPatternResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPatternResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTermResponse getTerm(GetTermRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        return (GetTermResponse)this.clientCall(request, GetTermResponse::builder).logger(LOG, "getTerm").serviceDetails("DataCatalog", "GetTerm", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Term/GetTerm").method(Method.GET).requestBuilder(GetTermRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Term.class, GetTermResponse.Builder::term).handleResponseHeaderString("etag", GetTermResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTermResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTermRelationshipResponse getTermRelationship(GetTermRelationshipRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermRelationshipKey(), (String)"termRelationshipKey must not be blank", (Object[])new Object[0]);
        return (GetTermRelationshipResponse)this.clientCall(request, GetTermRelationshipResponse::builder).logger(LOG, "getTermRelationship").serviceDetails("DataCatalog", "GetTermRelationship", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/TermRelationship/GetTermRelationship").method(Method.GET).requestBuilder(GetTermRelationshipRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).appendPathParam("termRelationships").appendPathParam(request.getTermRelationshipKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TermRelationship.class, GetTermRelationshipResponse.Builder::termRelationship).handleResponseHeaderString("etag", GetTermRelationshipResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTermRelationshipResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetTypeResponse getType(GetTypeRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTypeKey(), (String)"typeKey must not be blank", (Object[])new Object[0]);
        return (GetTypeResponse)this.clientCall(request, GetTypeResponse::builder).logger(LOG, "getType").serviceDetails("DataCatalog", "GetType", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Type/GetType").method(Method.GET).requestBuilder(GetTypeRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("types").appendPathParam(request.getTypeKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Type.class, GetTypeResponse.Builder::type).handleResponseHeaderString("etag", GetTypeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTypeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataCatalog", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190325").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ImportConnectionResponse importConnection(ImportConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportConnectionDetails(), "importConnectionDetails is required");
        return (ImportConnectionResponse)this.clientCall(request, ImportConnectionResponse::builder).logger(LOG, "importConnection").serviceDetails("DataCatalog", "ImportConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/ImportConnection").method(Method.POST).requestBuilder(ImportConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("actions").appendPathParam("importConnection").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Connection.class, ImportConnectionResponse.Builder::connection).handleResponseHeaderString("etag", ImportConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ImportConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ImportDataAssetResponse importDataAsset(ImportDataAssetRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportDataAssetDetails(), "importDataAssetDetails is required");
        Objects.requireNonNull(request.getImportType(), "importType is required");
        return (ImportDataAssetResponse)this.clientCall(request, ImportDataAssetResponse::builder).logger(LOG, "importDataAsset").serviceDetails("DataCatalog", "ImportDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/ImportDataAsset").method(Method.POST).requestBuilder(ImportDataAssetRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("actions").appendPathParam("import").appendListQueryParam("importType", request.getImportType(), CollectionFormatType.Multi).appendQueryParam("isMissingValueIgnored", (Object)request.getIsMissingValueIgnored()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ImportDataAssetJobResult.class, ImportDataAssetResponse.Builder::importDataAssetJobResult).handleResponseHeaderString("opc-request-id", ImportDataAssetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ImportGlossaryResponse importGlossary(ImportGlossaryRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportGlossaryDetails(), "importGlossaryDetails is required");
        return (ImportGlossaryResponse)this.clientCall(request, ImportGlossaryResponse::builder).logger(LOG, "importGlossary").serviceDetails("DataCatalog", "ImportGlossary", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/ImportGlossary").method(Method.POST).requestBuilder(ImportGlossaryRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("actions").appendPathParam("import").appendQueryParam("isRelationshipImported", (Object)request.getIsRelationshipImported()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ImportGlossaryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ImportGlossaryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAggregatedPhysicalEntitiesResponse listAggregatedPhysicalEntities(ListAggregatedPhysicalEntitiesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        return (ListAggregatedPhysicalEntitiesResponse)this.clientCall(request, ListAggregatedPhysicalEntitiesResponse::builder).logger(LOG, "listAggregatedPhysicalEntities").serviceDetails("DataCatalog", "ListAggregatedPhysicalEntities", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Entity/ListAggregatedPhysicalEntities").method(Method.POST).requestBuilder(ListAggregatedPhysicalEntitiesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("actions").appendPathParam("listAggregatedPhysicalEntities").appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("isIncludeProperties", (Object)request.getIsIncludeProperties()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EntityCollection.class, ListAggregatedPhysicalEntitiesResponse.Builder::entityCollection).handleResponseHeaderString("opc-request-id", ListAggregatedPhysicalEntitiesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAttributeTagsResponse listAttributeTags(ListAttributeTagsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttributeKey(), (String)"attributeKey must not be blank", (Object[])new Object[0]);
        return (ListAttributeTagsResponse)this.clientCall(request, ListAttributeTagsResponse::builder).logger(LOG, "listAttributeTags").serviceDetails("DataCatalog", "ListAttributeTags", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/AttributeTagCollection/ListAttributeTags").method(Method.GET).requestBuilder(ListAttributeTagsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendPathParam(request.getAttributeKey()).appendPathParam("tags").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("termKey", (Object)request.getTermKey()).appendQueryParam("termPath", (Object)request.getTermPath()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AttributeTagCollection.class, ListAttributeTagsResponse.Builder::attributeTagCollection).handleResponseHeaderString("opc-request-id", ListAttributeTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAttributeTagsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListAttributesResponse listAttributes(ListAttributesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        return (ListAttributesResponse)this.clientCall(request, ListAttributesResponse::builder).logger(LOG, "listAttributes").serviceDetails("DataCatalog", "ListAttributes", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/AttributeCollection/ListAttributes").method(Method.GET).requestBuilder(ListAttributesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("businessName", (Object)request.getBusinessName()).appendQueryParam("displayOrBusinessNameContains", (Object)request.getDisplayOrBusinessNameContains()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendQueryParam("externalKey", (Object)request.getExternalKey()).appendQueryParam("timeExternal", (Object)request.getTimeExternal()).appendQueryParam("externalTypeName", (Object)request.getExternalTypeName()).appendQueryParam("isIncrementalData", (Object)request.getIsIncrementalData()).appendQueryParam("isNullable", (Object)request.getIsNullable()).appendQueryParam("length", (Object)request.getLength()).appendQueryParam("position", (Object)request.getPosition()).appendQueryParam("precision", (Object)request.getPrecision()).appendQueryParam("scale", (Object)request.getScale()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AttributeCollection.class, ListAttributesResponse.Builder::attributeCollection).handleResponseHeaderString("opc-request-id", ListAttributesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAttributesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCatalogPrivateEndpointsResponse listCatalogPrivateEndpoints(ListCatalogPrivateEndpointsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCatalogPrivateEndpointsResponse)this.clientCall(request, ListCatalogPrivateEndpointsResponse::builder).logger(LOG, "listCatalogPrivateEndpoints").serviceDetails("DataCatalog", "ListCatalogPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CatalogPrivateEndpointSummary/ListCatalogPrivateEndpoints").method(Method.GET).requestBuilder(ListCatalogPrivateEndpointsRequest::builder).basePath("/20190325").appendPathParam("catalogPrivateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CatalogPrivateEndpointSummary.class, ListCatalogPrivateEndpointsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCatalogPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCatalogPrivateEndpointsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCatalogsResponse listCatalogs(ListCatalogsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCatalogsResponse)this.clientCall(request, ListCatalogsResponse::builder).logger(LOG, "listCatalogs").serviceDetails("DataCatalog", "ListCatalogs", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CatalogSummary/ListCatalogs").method(Method.GET).requestBuilder(ListCatalogsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CatalogSummary.class, ListCatalogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListCatalogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCatalogsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return (ListConnectionsResponse)this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("DataCatalog", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/ConnectionCollection/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("connections").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendQueryParam("externalKey", (Object)request.getExternalKey()).appendQueryParam("timeStatusUpdated", (Object)request.getTimeStatusUpdated()).appendQueryParam("isDefault", (Object)request.getIsDefault()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConnectionCollection.class, ListConnectionsResponse.Builder::connectionCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListCustomPropertiesResponse listCustomProperties(ListCustomPropertiesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        return (ListCustomPropertiesResponse)this.clientCall(request, ListCustomPropertiesResponse::builder).logger(LOG, "listCustomProperties").serviceDetails("DataCatalog", "ListCustomProperties", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CustomProperty/ListCustomProperties").method(Method.GET).requestBuilder(ListCustomPropertiesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).appendPathParam("customProperties").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendListQueryParam("dataTypes", request.getDataTypes(), CollectionFormatType.Multi).appendListQueryParam("typeName", request.getTypeName(), CollectionFormatType.Multi).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CustomPropertyCollection.class, ListCustomPropertiesResponse.Builder::customPropertyCollection).handleResponseHeaderString("opc-request-id", ListCustomPropertiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCustomPropertiesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListDataAssetTagsResponse listDataAssetTags(ListDataAssetTagsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return (ListDataAssetTagsResponse)this.clientCall(request, ListDataAssetTagsResponse::builder).logger(LOG, "listDataAssetTags").serviceDetails("DataCatalog", "ListDataAssetTags", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAssetTagCollection/ListDataAssetTags").method(Method.GET).requestBuilder(ListDataAssetTagsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("tags").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("termKey", (Object)request.getTermKey()).appendQueryParam("termPath", (Object)request.getTermPath()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAssetTagCollection.class, ListDataAssetTagsResponse.Builder::dataAssetTagCollection).handleResponseHeaderString("opc-request-id", ListDataAssetTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataAssetTagsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListDataAssetsResponse listDataAssets(ListDataAssetsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListDataAssetsResponse)this.clientCall(request, ListDataAssetsResponse::builder).logger(LOG, "listDataAssets").serviceDetails("DataCatalog", "ListDataAssets", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAssetCollection/ListDataAssets").method(Method.GET).requestBuilder(ListDataAssetsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendQueryParam("externalKey", (Object)request.getExternalKey()).appendQueryParam("typeKey", (Object)request.getTypeKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataAssetCollection.class, ListDataAssetsResponse.Builder::dataAssetCollection).handleResponseHeaderString("opc-request-id", ListDataAssetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDataAssetsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListDerivedLogicalEntitiesResponse listDerivedLogicalEntities(ListDerivedLogicalEntitiesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPatternKey(), (String)"patternKey must not be blank", (Object[])new Object[0]);
        return (ListDerivedLogicalEntitiesResponse)this.clientCall(request, ListDerivedLogicalEntitiesResponse::builder).logger(LOG, "listDerivedLogicalEntities").serviceDetails("DataCatalog", "ListDerivedLogicalEntities", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Pattern/ListDerivedLogicalEntities").method(Method.POST).requestBuilder(ListDerivedLogicalEntitiesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("patterns").appendPathParam(request.getPatternKey()).appendPathParam("actions").appendPathParam("listDerivedLogicalEntities").appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(EntityCollection.class, ListDerivedLogicalEntitiesResponse.Builder::entityCollection).handleResponseHeaderString("opc-request-id", ListDerivedLogicalEntitiesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEntitiesResponse listEntities(ListEntitiesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return (ListEntitiesResponse)this.clientCall(request, ListEntitiesResponse::builder).logger(LOG, "listEntities").serviceDetails("DataCatalog", "ListEntities", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Entity/ListEntities").method(Method.GET).requestBuilder(ListEntitiesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("businessName", (Object)request.getBusinessName()).appendQueryParam("displayOrBusinessNameContains", (Object)request.getDisplayOrBusinessNameContains()).appendQueryParam("typeKey", (Object)request.getTypeKey()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendQueryParam("externalKey", (Object)request.getExternalKey()).appendQueryParam("patternKey", (Object)request.getPatternKey()).appendQueryParam("timeExternal", (Object)request.getTimeExternal()).appendQueryParam("timeStatusUpdated", (Object)request.getTimeStatusUpdated()).appendQueryParam("isLogical", (Object)request.getIsLogical()).appendQueryParam("isPartition", (Object)request.getIsPartition()).appendQueryParam("folderKey", (Object)request.getFolderKey()).appendQueryParam("path", (Object)request.getPath()).appendEnumQueryParam("harvestStatus", (BmcEnum)request.getHarvestStatus()).appendQueryParam("lastJobKey", (Object)request.getLastJobKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EntityCollection.class, ListEntitiesResponse.Builder::entityCollection).handleResponseHeaderString("opc-request-id", ListEntitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEntitiesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEntityTagsResponse listEntityTags(ListEntityTagsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        return (ListEntityTagsResponse)this.clientCall(request, ListEntityTagsResponse::builder).logger(LOG, "listEntityTags").serviceDetails("DataCatalog", "ListEntityTags", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/EntityTagCollection/ListEntityTags").method(Method.GET).requestBuilder(ListEntityTagsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("tags").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("termKey", (Object)request.getTermKey()).appendQueryParam("termPath", (Object)request.getTermPath()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EntityTagCollection.class, ListEntityTagsResponse.Builder::entityTagCollection).handleResponseHeaderString("opc-request-id", ListEntityTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEntityTagsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListFolderTagsResponse listFolderTags(ListFolderTagsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        return (ListFolderTagsResponse)this.clientCall(request, ListFolderTagsResponse::builder).logger(LOG, "listFolderTags").serviceDetails("DataCatalog", "ListFolderTags", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/FolderTagCollection/ListFolderTags").method(Method.GET).requestBuilder(ListFolderTagsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendPathParam(request.getFolderKey()).appendPathParam("tags").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("termKey", (Object)request.getTermKey()).appendQueryParam("termPath", (Object)request.getTermPath()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FolderTagCollection.class, ListFolderTagsResponse.Builder::folderTagCollection).handleResponseHeaderString("opc-request-id", ListFolderTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFolderTagsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListFoldersResponse listFolders(ListFoldersRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        return (ListFoldersResponse)this.clientCall(request, ListFoldersResponse::builder).logger(LOG, "listFolders").serviceDetails("DataCatalog", "ListFolders", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/FolderCollection/ListFolders").method(Method.GET).requestBuilder(ListFoldersRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("businessName", (Object)request.getBusinessName()).appendQueryParam("displayOrBusinessNameContains", (Object)request.getDisplayOrBusinessNameContains()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("parentFolderKey", (Object)request.getParentFolderKey()).appendQueryParam("path", (Object)request.getPath()).appendQueryParam("externalKey", (Object)request.getExternalKey()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendEnumQueryParam("harvestStatus", (BmcEnum)request.getHarvestStatus()).appendQueryParam("lastJobKey", (Object)request.getLastJobKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(FolderCollection.class, ListFoldersResponse.Builder::folderCollection).handleResponseHeaderString("opc-request-id", ListFoldersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFoldersResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListGlossariesResponse listGlossaries(ListGlossariesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListGlossariesResponse)this.clientCall(request, ListGlossariesResponse::builder).logger(LOG, "listGlossaries").serviceDetails("DataCatalog", "ListGlossaries", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/ListGlossaries").method(Method.GET).requestBuilder(ListGlossariesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GlossaryCollection.class, ListGlossariesResponse.Builder::glossaryCollection).handleResponseHeaderString("opc-request-id", ListGlossariesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListGlossariesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobDefinitionsResponse listJobDefinitions(ListJobDefinitionsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListJobDefinitionsResponse)this.clientCall(request, ListJobDefinitionsResponse::builder).logger(LOG, "listJobDefinitions").serviceDetails("DataCatalog", "ListJobDefinitions", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobDefinitionCollection/ListJobDefinitions").method(Method.GET).requestBuilder(ListJobDefinitionsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobDefinitions").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("jobExecutionState", (BmcEnum)request.getJobExecutionState()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("jobType", (BmcEnum)request.getJobType()).appendQueryParam("isIncremental", (Object)request.getIsIncremental()).appendQueryParam("dataAssetKey", (Object)request.getDataAssetKey()).appendQueryParam("connectionKey", (Object)request.getConnectionKey()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendQueryParam("sampleDataSizeInMBs", (Object)request.getSampleDataSizeInMBs()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobDefinitionCollection.class, ListJobDefinitionsResponse.Builder::jobDefinitionCollection).handleResponseHeaderString("opc-request-id", ListJobDefinitionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobDefinitionsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobExecutionsResponse listJobExecutions(ListJobExecutionsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        return (ListJobExecutionsResponse)this.clientCall(request, ListJobExecutionsResponse::builder).logger(LOG, "listJobExecutions").serviceDetails("DataCatalog", "ListJobExecutions", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobExecutionCollection/ListJobExecutions").method(Method.GET).requestBuilder(ListJobExecutionsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendPathParam("executions").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendEnumQueryParam("jobType", (BmcEnum)request.getJobType()).appendQueryParam("subType", (Object)request.getSubType()).appendQueryParam("parentKey", (Object)request.getParentKey()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("errorCode", (Object)request.getErrorCode()).appendQueryParam("errorMessage", (Object)request.getErrorMessage()).appendQueryParam("processKey", (Object)request.getProcessKey()).appendQueryParam("externalUrl", (Object)request.getExternalUrl()).appendQueryParam("eventKey", (Object)request.getEventKey()).appendQueryParam("dataEntityKey", (Object)request.getDataEntityKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecutionCollection.class, ListJobExecutionsResponse.Builder::jobExecutionCollection).handleResponseHeaderString("opc-request-id", ListJobExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobExecutionsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobLogsResponse listJobLogs(ListJobLogsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobExecutionKey(), (String)"jobExecutionKey must not be blank", (Object[])new Object[0]);
        return (ListJobLogsResponse)this.clientCall(request, ListJobLogsResponse::builder).logger(LOG, "listJobLogs").serviceDetails("DataCatalog", "ListJobLogs", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobLogCollection/ListJobLogs").method(Method.GET).requestBuilder(ListJobLogsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendPathParam("executions").appendPathParam(request.getJobExecutionKey()).appendPathParam("logs").appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("severity", (Object)request.getSeverity()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobLogCollection.class, ListJobLogsResponse.Builder::jobLogCollection).handleResponseHeaderString("opc-request-id", ListJobLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobLogsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobMetricsResponse listJobMetrics(ListJobMetricsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobExecutionKey(), (String)"jobExecutionKey must not be blank", (Object[])new Object[0]);
        return (ListJobMetricsResponse)this.clientCall(request, ListJobMetricsResponse::builder).logger(LOG, "listJobMetrics").serviceDetails("DataCatalog", "ListJobMetrics", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobMetricCollection/ListJobMetrics").method(Method.GET).requestBuilder(ListJobMetricsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).appendPathParam("executions").appendPathParam(request.getJobExecutionKey()).appendPathParam("metrics").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("category", (Object)request.getCategory()).appendQueryParam("subCategory", (Object)request.getSubCategory()).appendQueryParam("unit", (Object)request.getUnit()).appendQueryParam("value", (Object)request.getValue()).appendQueryParam("batchKey", (Object)request.getBatchKey()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("timeInserted", (Object)request.getTimeInserted()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobMetricCollection.class, ListJobMetricsResponse.Builder::jobMetricCollection).handleResponseHeaderString("opc-request-id", ListJobMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobMetricsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListJobsResponse)this.clientCall(request, ListJobsResponse::builder).logger(LOG, "listJobs").serviceDetails("DataCatalog", "ListJobs", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobCollection/ListJobs").method(Method.GET).requestBuilder(ListJobsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendEnumQueryParam("jobType", (BmcEnum)request.getJobType()).appendQueryParam("jobDefinitionKey", (Object)request.getJobDefinitionKey()).appendQueryParam("dataAssetKey", (Object)request.getDataAssetKey()).appendQueryParam("scheduleCronExpression", (Object)request.getScheduleCronExpression()).appendQueryParam("timeScheduleBegin", (Object)request.getTimeScheduleBegin()).appendQueryParam("timeScheduleEnd", (Object)request.getTimeScheduleEnd()).appendEnumQueryParam("scheduleType", (BmcEnum)request.getScheduleType()).appendQueryParam("connectionKey", (Object)request.getConnectionKey()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("executionCount", (Object)request.getExecutionCount()).appendQueryParam("timeOfLatestExecution", (Object)request.getTimeOfLatestExecution()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobCollection.class, ListJobsResponse.Builder::jobCollection).handleResponseHeaderString("opc-request-id", ListJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListMetastoresResponse listMetastores(ListMetastoresRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListMetastoresResponse)this.clientCall(request, ListMetastoresResponse::builder).logger(LOG, "listMetastores").serviceDetails("DataCatalog", "ListMetastores", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/MetastoreSummary/ListMetastores").method(Method.GET).requestBuilder(ListMetastoresRequest::builder).basePath("/20190325").appendPathParam("metastores").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(MetastoreSummary.class, ListMetastoresResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListMetastoresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMetastoresResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListNamespacesResponse)this.clientCall(request, ListNamespacesResponse::builder).logger(LOG, "listNamespaces").serviceDetails("DataCatalog", "ListNamespaces", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Namespace/ListNamespaces").method(Method.GET).requestBuilder(ListNamespacesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NamespaceCollection.class, ListNamespacesResponse.Builder::namespaceCollection).handleResponseHeaderString("opc-request-id", ListNamespacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNamespacesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListPatternsResponse listPatterns(ListPatternsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListPatternsResponse)this.clientCall(request, ListPatternsResponse::builder).logger(LOG, "listPatterns").serviceDetails("DataCatalog", "ListPatterns", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Pattern/ListPatterns").method(Method.GET).requestBuilder(ListPatternsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("patterns").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PatternCollection.class, ListPatternsResponse.Builder::patternCollection).handleResponseHeaderString("opc-request-id", ListPatternsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPatternsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListRulesResponse listRules(ListRulesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        return (ListRulesResponse)this.clientCall(request, ListRulesResponse::builder).logger(LOG, "listRules").serviceDetails("DataCatalog", "ListRules", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/RuleSummary/ListRules").method(Method.GET).requestBuilder(ListRulesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("rules").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("ruleType", (BmcEnum)request.getRuleType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("originType", (BmcEnum)request.getOriginType()).appendQueryParam("externalKey", (Object)request.getExternalKey()).appendQueryParam("timeCreated", (Object)request.getTimeCreated()).appendQueryParam("timeUpdated", (Object)request.getTimeUpdated()).appendQueryParam("createdById", (Object)request.getCreatedById()).appendQueryParam("updatedById", (Object)request.getUpdatedById()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RuleCollection.class, ListRulesResponse.Builder::ruleCollection).handleResponseHeaderString("opc-request-id", ListRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRulesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListTagsResponse)this.clientCall(request, ListTagsResponse::builder).logger(LOG, "listTags").serviceDetails("DataCatalog", "ListTags", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Term/ListTags").method(Method.GET).requestBuilder(ListTagsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("tags").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TermCollection.class, ListTagsResponse.Builder::termCollection).handleResponseHeaderString("opc-request-id", ListTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTagsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTermRelationshipsResponse listTermRelationships(ListTermRelationshipsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        return (ListTermRelationshipsResponse)this.clientCall(request, ListTermRelationshipsResponse::builder).logger(LOG, "listTermRelationships").serviceDetails("DataCatalog", "ListTermRelationships", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/TermRelationship/ListTermRelationships").method(Method.GET).requestBuilder(ListTermRelationshipsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).appendPathParam("termRelationships").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TermRelationshipCollection.class, ListTermRelationshipsResponse.Builder::termRelationshipCollection).handleResponseHeaderString("opc-request-id", ListTermRelationshipsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTermRelationshipsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTermsResponse listTerms(ListTermsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        return (ListTermsResponse)this.clientCall(request, ListTermsResponse::builder).logger(LOG, "listTerms").serviceDetails("DataCatalog", "ListTerms", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Term/ListTerms").method(Method.GET).requestBuilder(ListTermsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("parentTermKey", (Object)request.getParentTermKey()).appendQueryParam("isAllowedToHaveChildTerms", (Object)request.getIsAllowedToHaveChildTerms()).appendEnumQueryParam("workflowStatus", (BmcEnum)request.getWorkflowStatus()).appendQueryParam("path", (Object)request.getPath()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TermCollection.class, ListTermsResponse.Builder::termCollection).handleResponseHeaderString("opc-request-id", ListTermsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTermsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListTypesResponse listTypes(ListTypesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ListTypesResponse)this.clientCall(request, ListTypesResponse::builder).logger(LOG, "listTypes").serviceDetails("DataCatalog", "ListTypes", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/TypeCollection/ListTypes").method(Method.GET).requestBuilder(ListTypesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("types").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("isInternal", (Object)request.getIsInternal()).appendQueryParam("isTag", (Object)request.getIsTag()).appendQueryParam("isApproved", (Object)request.getIsApproved()).appendQueryParam("externalTypeName", (Object)request.getExternalTypeName()).appendQueryParam("typeCategory", (Object)request.getTypeCategory()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TypeCollection.class, ListTypesResponse.Builder::typeCollection).handleResponseHeaderString("opc-request-id", ListTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTypesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataCatalog", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190325").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataCatalog", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190325").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLog.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataCatalog", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190325").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequest.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ObjectStatsResponse objectStats(ObjectStatsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (ObjectStatsResponse)this.clientCall(request, ObjectStatsResponse::builder).logger(LOG, "objectStats").serviceDetails("DataCatalog", "ObjectStats", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/ObjectStats").method(Method.POST).requestBuilder(ObjectStatsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("objectStats").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(String.class, ObjectStatsResponse.Builder::value).handleResponseHeaderString("opc-request-id", ObjectStatsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ObjectStatsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ParseConnectionResponse parseConnection(ParseConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getParseConnectionDetails(), "parseConnectionDetails is required");
        return (ParseConnectionResponse)this.clientCall(request, ParseConnectionResponse::builder).logger(LOG, "parseConnection").serviceDetails("DataCatalog", "ParseConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/ParseConnection").method(Method.POST).requestBuilder(ParseConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("actions").appendPathParam("parseConnection").appendQueryParam("connectionKey", (Object)request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBodyList(ConnectionAliasSummary.class, ParseConnectionResponse.Builder::items).handleResponseHeaderString("etag", ParseConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ParseConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ProcessRecommendationResponse processRecommendation(ProcessRecommendationRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getProcessRecommendationDetails(), "processRecommendationDetails is required");
        return (ProcessRecommendationResponse)this.clientCall(request, ProcessRecommendationResponse::builder).logger(LOG, "processRecommendation").serviceDetails("DataCatalog", "ProcessRecommendation", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/ProcessRecommendation").method(Method.POST).requestBuilder(ProcessRecommendationRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("processRecommendation").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ProcessRecommendationDetails.class, ProcessRecommendationResponse.Builder::processRecommendationDetails).handleResponseHeaderString("etag", ProcessRecommendationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ProcessRecommendationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RecommendationsResponse recommendations(RecommendationsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRecommendationType(), "recommendationType is required");
        Objects.requireNonNull(request.getSourceObjectKey(), "sourceObjectKey is required");
        Objects.requireNonNull(request.getSourceObjectType(), "sourceObjectType is required");
        return (RecommendationsResponse)this.clientCall(request, RecommendationsResponse::builder).logger(LOG, "recommendations").serviceDetails("DataCatalog", "Recommendations", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/Recommendations").method(Method.POST).requestBuilder(RecommendationsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("getRecommendations").appendListQueryParam("recommendationType", request.getRecommendationType(), CollectionFormatType.Multi).appendQueryParam("sourceObjectKey", (Object)request.getSourceObjectKey()).appendEnumQueryParam("sourceObjectType", (BmcEnum)request.getSourceObjectType()).appendEnumQueryParam("recommendationStatus", (BmcEnum)request.getRecommendationStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecommendationCollection.class, RecommendationsResponse.Builder::recommendationCollection).handleResponseHeaderString("opc-request-id", RecommendationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveDataSelectorPatternsResponse removeDataSelectorPatterns(RemoveDataSelectorPatternsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDataSelectorPatternDetails(), "dataSelectorPatternDetails is required");
        return (RemoveDataSelectorPatternsResponse)this.clientCall(request, RemoveDataSelectorPatternsResponse::builder).logger(LOG, "removeDataSelectorPatterns").serviceDetails("DataCatalog", "RemoveDataSelectorPatterns", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/RemoveDataSelectorPatterns").method(Method.POST).requestBuilder(RemoveDataSelectorPatternsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("actions").appendPathParam("removeDataSelectorPatterns").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DataAsset.class, RemoveDataSelectorPatternsResponse.Builder::dataAsset).handleResponseHeaderString("etag", RemoveDataSelectorPatternsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveDataSelectorPatternsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SearchCriteriaResponse searchCriteria(SearchCriteriaRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (SearchCriteriaResponse)this.clientCall(request, SearchCriteriaResponse::builder).logger(LOG, "searchCriteria").serviceDetails("DataCatalog", "SearchCriteria", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/SearchResult/SearchCriteria").method(Method.POST).requestBuilder(SearchCriteriaRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("search").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("timeout", (Object)request.getTimeout()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SearchResultCollection.class, SearchCriteriaResponse.Builder::searchResultCollection).handleResponseHeaderString("opc-request-id", SearchCriteriaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SearchCriteriaResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SuggestMatchesResponse suggestMatches(SuggestMatchesRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInputText(), "inputText is required");
        return (SuggestMatchesResponse)this.clientCall(request, SuggestMatchesResponse::builder).logger(LOG, "suggestMatches").serviceDetails("DataCatalog", "SuggestMatches", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/SuggestResults/SuggestMatches").method(Method.POST).requestBuilder(SuggestMatchesRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("suggest").appendQueryParam("timeout", (Object)request.getTimeout()).appendQueryParam("inputText", (Object)request.getInputText()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SuggestResults.class, SuggestMatchesResponse.Builder::suggestResults).handleResponseHeaderString("opc-request-id", SuggestMatchesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SynchronousExportDataAssetResponse synchronousExportDataAsset(SynchronousExportDataAssetRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSynchronousExportDataAssetDetails(), "synchronousExportDataAssetDetails is required");
        Objects.requireNonNull(request.getExportType(), "exportType is required");
        return (SynchronousExportDataAssetResponse)this.clientCall(request, SynchronousExportDataAssetResponse::builder).logger(LOG, "synchronousExportDataAsset").serviceDetails("DataCatalog", "SynchronousExportDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/SynchronousExportDataAsset").method(Method.POST).requestBuilder(SynchronousExportDataAssetRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("actions").appendPathParam("synchronousExport").appendListQueryParam("exportType", request.getExportType(), CollectionFormatType.Multi).accept(new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InputStream.class, SynchronousExportDataAssetResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", SynchronousExportDataAssetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public TestConnectionResponse testConnection(TestConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        return (TestConnectionResponse)this.clientCall(request, TestConnectionResponse::builder).logger(LOG, "testConnection").serviceDetails("DataCatalog", "TestConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Connection/TestConnection").method(Method.POST).requestBuilder(TestConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("actions").appendPathParam("test").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(ValidateConnectionResult.class, TestConnectionResponse.Builder::validateConnectionResult).handleResponseHeaderString("etag", TestConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", TestConnectionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateAttributeResponse updateAttribute(UpdateAttributeRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttributeKey(), (String)"attributeKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAttributeDetails(), "updateAttributeDetails is required");
        return (UpdateAttributeResponse)this.clientCall(request, UpdateAttributeResponse::builder).logger(LOG, "updateAttribute").serviceDetails("DataCatalog", "UpdateAttribute", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Attribute/UpdateAttribute").method(Method.PUT).requestBuilder(UpdateAttributeRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).appendPathParam("attributes").appendPathParam(request.getAttributeKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Attribute.class, UpdateAttributeResponse.Builder::attribute).handleResponseHeaderString("etag", UpdateAttributeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAttributeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCatalogResponse updateCatalog(UpdateCatalogRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCatalogDetails(), "updateCatalogDetails is required");
        return (UpdateCatalogResponse)this.clientCall(request, UpdateCatalogResponse::builder).logger(LOG, "updateCatalog").serviceDetails("DataCatalog", "UpdateCatalog", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/UpdateCatalog").method(Method.PUT).requestBuilder(UpdateCatalogRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Catalog.class, UpdateCatalogResponse.Builder::catalog).handleResponseHeaderString("etag", UpdateCatalogResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCatalogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCatalogPrivateEndpointResponse updateCatalogPrivateEndpoint(UpdateCatalogPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getCatalogPrivateEndpointId(), (String)"catalogPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCatalogPrivateEndpointDetails(), "updateCatalogPrivateEndpointDetails is required");
        return (UpdateCatalogPrivateEndpointResponse)this.clientCall(request, UpdateCatalogPrivateEndpointResponse::builder).logger(LOG, "updateCatalogPrivateEndpoint").serviceDetails("DataCatalog", "UpdateCatalogPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CatalogPrivateEndpoint/UpdateCatalogPrivateEndpoint").method(Method.PUT).requestBuilder(UpdateCatalogPrivateEndpointRequest::builder).basePath("/20190325").appendPathParam("catalogPrivateEndpoints").appendPathParam(request.getCatalogPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateCatalogPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateCatalogPrivateEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return (UpdateConnectionResponse)this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("DataCatalog", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Connection.class, UpdateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", UpdateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateCustomPropertyResponse updateCustomProperty(UpdateCustomPropertyRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCustomPropertyKey(), (String)"customPropertyKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCustomPropertyDetails(), "updateCustomPropertyDetails is required");
        return (UpdateCustomPropertyResponse)this.clientCall(request, UpdateCustomPropertyResponse::builder).logger(LOG, "updateCustomProperty").serviceDetails("DataCatalog", "UpdateCustomProperty", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/CustomProperty/UpdateCustomProperty").method(Method.PUT).requestBuilder(UpdateCustomPropertyRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).appendPathParam("customProperties").appendPathParam(request.getCustomPropertyKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CustomProperty.class, UpdateCustomPropertyResponse.Builder::customProperty).handleResponseHeaderString("etag", UpdateCustomPropertyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCustomPropertyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDataAssetResponse updateDataAsset(UpdateDataAssetRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDataAssetDetails(), "updateDataAssetDetails is required");
        return (UpdateDataAssetResponse)this.clientCall(request, UpdateDataAssetResponse::builder).logger(LOG, "updateDataAsset").serviceDetails("DataCatalog", "UpdateDataAsset", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/UpdateDataAsset").method(Method.PUT).requestBuilder(UpdateDataAssetRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DataAsset.class, UpdateDataAssetResponse.Builder::dataAsset).handleResponseHeaderString("etag", UpdateDataAssetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDataAssetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateEntityResponse updateEntity(UpdateEntityRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEntityKey(), (String)"entityKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEntityDetails(), "updateEntityDetails is required");
        return (UpdateEntityResponse)this.clientCall(request, UpdateEntityResponse::builder).logger(LOG, "updateEntity").serviceDetails("DataCatalog", "UpdateEntity", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Entity/UpdateEntity").method(Method.PUT).requestBuilder(UpdateEntityRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("entities").appendPathParam(request.getEntityKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Entity.class, UpdateEntityResponse.Builder::entity).handleResponseHeaderString("etag", UpdateEntityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEntityResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFolderResponse updateFolder(UpdateFolderRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFolderKey(), (String)"folderKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFolderDetails(), "updateFolderDetails is required");
        return (UpdateFolderResponse)this.clientCall(request, UpdateFolderResponse::builder).logger(LOG, "updateFolder").serviceDetails("DataCatalog", "UpdateFolder", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Folder/UpdateFolder").method(Method.PUT).requestBuilder(UpdateFolderRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("folders").appendPathParam(request.getFolderKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Folder.class, UpdateFolderResponse.Builder::folder).handleResponseHeaderString("etag", UpdateFolderResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateFolderResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateGlossaryResponse updateGlossary(UpdateGlossaryRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateGlossaryDetails(), "updateGlossaryDetails is required");
        return (UpdateGlossaryResponse)this.clientCall(request, UpdateGlossaryResponse::builder).logger(LOG, "updateGlossary").serviceDetails("DataCatalog", "UpdateGlossary", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Glossary/UpdateGlossary").method(Method.PUT).requestBuilder(UpdateGlossaryRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Glossary.class, UpdateGlossaryResponse.Builder::glossary).handleResponseHeaderString("etag", UpdateGlossaryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateGlossaryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDetails(), "updateJobDetails is required");
        return (UpdateJobResponse)this.clientCall(request, UpdateJobResponse::builder).logger(LOG, "updateJob").serviceDetails("DataCatalog", "UpdateJob", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Job/UpdateJob").method(Method.PUT).requestBuilder(UpdateJobRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobs").appendPathParam(request.getJobKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Job.class, UpdateJobResponse.Builder::job).handleResponseHeaderString("etag", UpdateJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateJobDefinitionResponse updateJobDefinition(UpdateJobDefinitionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobDefinitionKey(), (String)"jobDefinitionKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDefinitionDetails(), "updateJobDefinitionDetails is required");
        return (UpdateJobDefinitionResponse)this.clientCall(request, UpdateJobDefinitionResponse::builder).logger(LOG, "updateJobDefinition").serviceDetails("DataCatalog", "UpdateJobDefinition", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/JobDefinition/UpdateJobDefinition").method(Method.PUT).requestBuilder(UpdateJobDefinitionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("jobDefinitions").appendPathParam(request.getJobDefinitionKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(JobDefinition.class, UpdateJobDefinitionResponse.Builder::jobDefinition).handleResponseHeaderString("etag", UpdateJobDefinitionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateJobDefinitionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateMetastoreResponse updateMetastore(UpdateMetastoreRequest request) {
        Validate.notBlank((String)request.getMetastoreId(), (String)"metastoreId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMetastoreDetails(), "updateMetastoreDetails is required");
        return (UpdateMetastoreResponse)this.clientCall(request, UpdateMetastoreResponse::builder).logger(LOG, "updateMetastore").serviceDetails("DataCatalog", "UpdateMetastore", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Metastore/UpdateMetastore").method(Method.PUT).requestBuilder(UpdateMetastoreRequest::builder).basePath("/20190325").appendPathParam("metastores").appendPathParam(request.getMetastoreId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Metastore.class, UpdateMetastoreResponse.Builder::metastore).handleResponseHeaderString("etag", UpdateMetastoreResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateMetastoreResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateNamespaceResponse updateNamespace(UpdateNamespaceRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNamespaceDetails(), "updateNamespaceDetails is required");
        return (UpdateNamespaceResponse)this.clientCall(request, UpdateNamespaceResponse::builder).logger(LOG, "updateNamespace").serviceDetails("DataCatalog", "UpdateNamespace", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Namespace/UpdateNamespace").method(Method.PUT).requestBuilder(UpdateNamespaceRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("namespaces").appendPathParam(request.getNamespaceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Namespace.class, UpdateNamespaceResponse.Builder::namespace).handleResponseHeaderString("etag", UpdateNamespaceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateNamespaceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePatternResponse updatePattern(UpdatePatternRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPatternKey(), (String)"patternKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePatternDetails(), "updatePatternDetails is required");
        return (UpdatePatternResponse)this.clientCall(request, UpdatePatternResponse::builder).logger(LOG, "updatePattern").serviceDetails("DataCatalog", "UpdatePattern", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Pattern/UpdatePattern").method(Method.PUT).requestBuilder(UpdatePatternRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("patterns").appendPathParam(request.getPatternKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Pattern.class, UpdatePatternResponse.Builder::pattern).handleResponseHeaderString("etag", UpdatePatternResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePatternResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTermResponse updateTerm(UpdateTermRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTermDetails(), "updateTermDetails is required");
        return (UpdateTermResponse)this.clientCall(request, UpdateTermResponse::builder).logger(LOG, "updateTerm").serviceDetails("DataCatalog", "UpdateTerm", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Term/UpdateTerm").method(Method.PUT).requestBuilder(UpdateTermRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Term.class, UpdateTermResponse.Builder::term).handleResponseHeaderString("etag", UpdateTermResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTermResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTermRelationshipResponse updateTermRelationship(UpdateTermRelationshipRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTermRelationshipKey(), (String)"termRelationshipKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTermRelationshipDetails(), "updateTermRelationshipDetails is required");
        return (UpdateTermRelationshipResponse)this.clientCall(request, UpdateTermRelationshipResponse::builder).logger(LOG, "updateTermRelationship").serviceDetails("DataCatalog", "UpdateTermRelationship", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/TermRelationship/UpdateTermRelationship").method(Method.PUT).requestBuilder(UpdateTermRelationshipRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("glossaries").appendPathParam(request.getGlossaryKey()).appendPathParam("terms").appendPathParam(request.getTermKey()).appendPathParam("termRelationships").appendPathParam(request.getTermRelationshipKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TermRelationship.class, UpdateTermRelationshipResponse.Builder::termRelationship).handleResponseHeaderString("etag", UpdateTermRelationshipResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateTermRelationshipResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UploadCredentialsResponse uploadCredentials(UploadCredentialsRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getConnectionKey(), (String)"connectionKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadCredentialsDetails(), "uploadCredentialsDetails is required");
        return (UploadCredentialsResponse)this.clientCall(request, UploadCredentialsResponse::builder).logger(LOG, "uploadCredentials").serviceDetails("DataCatalog", "UploadCredentials", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Connection/UploadCredentials").method(Method.POST).requestBuilder(UploadCredentialsRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("connections").appendPathParam(request.getConnectionKey()).appendPathParam("actions").appendPathParam("uploadCredentials").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Connection.class, UploadCredentialsResponse.Builder::connection).handleResponseHeaderString("etag", UploadCredentialsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UploadCredentialsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UsersResponse users(UsersRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        return (UsersResponse)this.clientCall(request, UsersResponse::builder).logger(LOG, "users").serviceDetails("DataCatalog", "Users", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Catalog/Users").method(Method.POST).requestBuilder(UsersRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("actions").appendPathParam("users").appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(String.class, UsersResponse.Builder::value).handleResponseHeaderString("opc-request-id", UsersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", UsersResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ValidateConnectionResponse validateConnection(ValidateConnectionRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getValidateConnectionDetails(), "validateConnectionDetails is required");
        return (ValidateConnectionResponse)this.clientCall(request, ValidateConnectionResponse::builder).logger(LOG, "validateConnection").serviceDetails("DataCatalog", "ValidateConnection", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/DataAsset/ValidateConnection").method(Method.POST).requestBuilder(ValidateConnectionRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("dataAssets").appendPathParam(request.getDataAssetKey()).appendPathParam("actions").appendPathParam("validateConnection").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ValidateConnectionResult.class, ValidateConnectionResponse.Builder::validateConnectionResult).handleResponseHeaderString("etag", ValidateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ValidateConnectionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ValidatePatternResponse validatePattern(ValidatePatternRequest request) {
        Validate.notBlank((String)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPatternKey(), (String)"patternKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getValidatePatternDetails(), "validatePatternDetails is required");
        return (ValidatePatternResponse)this.clientCall(request, ValidatePatternResponse::builder).logger(LOG, "validatePattern").serviceDetails("DataCatalog", "ValidatePattern", "https://docs.oracle.com/iaas/api/#/en/data-catalog/20190325/Pattern/ValidatePattern").method(Method.POST).requestBuilder(ValidatePatternRequest::builder).basePath("/20190325").appendPathParam("catalogs").appendPathParam(request.getCatalogId()).appendPathParam("patterns").appendPathParam(request.getPatternKey()).appendPathParam("actions").appendPathParam("validate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ValidatePatternResult.class, ValidatePatternResponse.Builder::validatePatternResult).handleResponseHeaderString("opc-request-id", ValidatePatternResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DataCatalogWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataCatalogPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DataCatalogClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataCatalogClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataCatalogClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataCatalogClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataCatalogClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataCatalogClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataCatalogClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataCatalogClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataCatalogClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataCatalogClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataCatalogClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataCatalogClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataCatalogClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataCatalogClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataCatalogClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

