/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.WaiterConfiguration;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;

public class MaxTimeTerminationStrategy
implements TerminationStrategy {
    private final long maxTimeInMillis;

    @Override
    public boolean shouldTerminate(WaiterConfiguration.WaitContext context) {
        long currentTime;
        long endTime = context.getStartTime() + this.maxTimeInMillis;
        return endTime <= (currentTime = context.getCurrentTime());
    }

    public static MaxTimeTerminationStrategy ofTimeUnit(long maxTime, TimeUnit timeUnit) {
        return new MaxTimeTerminationStrategy(timeUnit.toMillis(maxTime));
    }

    public static MaxTimeTerminationStrategy ofMillis(long maxTimeInMillis) {
        return MaxTimeTerminationStrategy.ofTimeUnit(maxTimeInMillis, TimeUnit.MILLISECONDS);
    }

    public static MaxTimeTerminationStrategy ofSeconds(long maxTimeInSeconds) {
        return MaxTimeTerminationStrategy.ofTimeUnit(maxTimeInSeconds, TimeUnit.SECONDS);
    }

    public static MaxTimeTerminationStrategy ofMinutes(long maxTimeInMinutes) {
        return MaxTimeTerminationStrategy.ofTimeUnit(maxTimeInMinutes, TimeUnit.MINUTES);
    }

    @ConstructorProperties(value={"maxTimeInMillis"})
    public MaxTimeTerminationStrategy(long maxTimeInMillis) {
        this.maxTimeInMillis = maxTimeInMillis;
    }
}

