/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.common;

import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.internal.Alloy;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegionalClientBuilder<B extends RegionalClientBuilder, C>
extends ClientBuilderBase<B, C> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionalClientBuilder.class);
    protected Region region;

    public RegionalClientBuilder(Service service) {
        super(service);
    }

    public B region(Region region) {
        if (Alloy.shouldUseOnlyAlloyRegions()) {
            try {
                Region.valueOf(region.getRegionId());
            }
            catch (IllegalArgumentException e) {
                Alloy.throwUnknownAlloyRegionIfAppropriate(region.getRegionId(), e);
            }
        }
        this.region = region;
        return (B)this;
    }

    public B region(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            return this.region(region);
        }
        catch (IllegalArgumentException e) {
            Alloy.throwUnknownAlloyRegionIfAppropriate(regionId, e);
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(this.service, regionId);
            return (B)((RegionalClientBuilder)this.endpoint(endpoint));
        }
    }

    @Override
    public B copyFrom(B fromBuilder) {
        return ((RegionalClientBuilder)super.copyFrom(fromBuilder)).region(this.region);
    }
}

