/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.SigningStrategy;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import lombok.NonNull;

@Priority(value=1000)
public class AuthnClientFilter
implements ClientRequestFilter {
    public static final String SIGNING_STRATEGY_PROPERTY_NAME = "x-obmcs-internal-signing-strategy-name";
    private final RequestSigner defaultRequestSigner;
    private final Map<SigningStrategy, RequestSigner> requestSigners;

    public void filter(@NonNull ClientRequestContext clientRequestContext) throws IOException {
        if (clientRequestContext == null) {
            throw new NullPointerException("clientRequestContext is marked @NonNull but is null");
        }
        RequestSigner chosenRequestSigner = this.defaultRequestSigner;
        SigningStrategy perOperationSigningStrategy = (SigningStrategy)((Object)clientRequestContext.getProperty(SIGNING_STRATEGY_PROPERTY_NAME));
        if (perOperationSigningStrategy != null && this.requestSigners.containsKey((Object)perOperationSigningStrategy)) {
            chosenRequestSigner = this.requestSigners.get((Object)perOperationSigningStrategy);
            clientRequestContext.removeProperty(SIGNING_STRATEGY_PROPERTY_NAME);
        }
        MultivaluedMap stringHeaders = clientRequestContext.getStringHeaders();
        Map<String, String> authHeaders = chosenRequestSigner.signRequest(clientRequestContext.getUri(), clientRequestContext.getMethod(), (Map<String, List<String>>)stringHeaders, clientRequestContext.getEntity());
        MultivaluedMap headers = clientRequestContext.getHeaders();
        for (Map.Entry<String, String> e : authHeaders.entrySet()) {
            if (headers.keySet().contains(e.getKey())) continue;
            headers.putSingle((Object)e.getKey(), (Object)e.getValue());
        }
    }

    @ConstructorProperties(value={"defaultRequestSigner", "requestSigners"})
    public AuthnClientFilter(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners) {
        this.defaultRequestSigner = defaultRequestSigner;
        this.requestSigners = requestSigners;
    }
}

