/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.internal.parameterizedendpoints;

import com.oracle.bmc.http.client.InternalSdk;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalSdk
public enum ParameterizedEndpointUtil {
    INSTANCE;

    private static final Logger LOG;
    private static final Pattern PLACEHOLDER_PATTERN;
    public static final String OPTIONS_REGEX = "\\{(\\w+)\\?((\\w+\\.\\:\\w+\\.)|(\\w+\\.:\\s*)|(\\s*:\\w+\\.))\\}+";
    public static final Pattern OPTIONS_PATTERN;
    public static final String DUAL_STACK_OPTION = "dualStack";

    public String getEndpointWithPopulatedServiceParameters(String baseUriString, Map<String, Object> requiredParametersMap, Map<String, Boolean> optionsMap) {
        String endpoint = baseUriString;
        LOG.trace("getEndpointWithPopulateServiceParameters: baseUriString='{}'", (Object)endpoint);
        if (!this.isEndpointParameterized(endpoint)) {
            LOG.trace("getEndpointWithPopulateServiceParameters: baseUriString not parameterized, endpoint='{}'", (Object)endpoint);
            return endpoint;
        }
        StringBuilder updatedEndpointBuilder = new StringBuilder();
        int afterLastMatch = 0;
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(endpoint);
        while (matcher.find()) {
            String paramName;
            updatedEndpointBuilder.append(endpoint.substring(afterLastMatch, matcher.start()));
            afterLastMatch = matcher.end();
            String group = matcher.group();
            Matcher optionMatcher = OPTIONS_PATTERN.matcher(group);
            if (optionMatcher.matches()) {
                String option = matcher.group();
                String optionName = optionMatcher.group(1);
                if (!optionsMap.containsKey(optionName)) {
                    LOG.debug("The option {} cannot be populated since its value was not provided, removing {} from endpoint entirely", (Object)optionName, (Object)option);
                    continue;
                }
                boolean optionValue = optionsMap.get(optionName);
                String optionEnabledParam = option.substring(option.indexOf("?") + 1, option.indexOf(":"));
                String optionDisabledParam = option.substring(option.indexOf(":") + 1, option.indexOf("}"));
                String replacement = optionValue ? optionEnabledParam : optionDisabledParam;
                updatedEndpointBuilder.append(replacement);
                continue;
            }
            String parameter = matcher.group();
            boolean appendDot = false;
            if (parameter.endsWith("+Dot}")) {
                appendDot = true;
                paramName = parameter.substring(1, parameter.indexOf("+"));
            } else {
                paramName = parameter.substring(1, parameter.length() - 1);
            }
            if (requiredParametersMap.containsKey(paramName)) {
                Object paramValue = requiredParametersMap.get(paramName);
                if (!(paramValue instanceof String)) {
                    LOG.debug("The parameter for {} cannot be populated since the value is not of type String", (Object)paramName);
                    continue;
                }
                updatedEndpointBuilder.append(paramValue);
                if (!appendDot) continue;
                updatedEndpointBuilder.append('.');
                continue;
            }
            LOG.trace("getEndpointWithPopulateServiceParameters: parameter '{}' not found in requiredParametersMap, removing placeholder", (Object)paramName);
        }
        updatedEndpointBuilder.append(endpoint.substring(afterLastMatch));
        String updatedEndpoint = updatedEndpointBuilder.toString();
        LOG.trace("getEndpointWithPopulateServiceParameters: processed all parameters, endpoint='{}'", (Object)updatedEndpoint);
        return updatedEndpoint;
    }

    public boolean isEndpointParameterized(String endpoint) {
        return endpoint.contains("{");
    }

    public String removeAllParametersFromEndpoint(String updatedEndpoint) {
        return updatedEndpoint.replaceAll("\\{.*?\\}", "");
    }

    static {
        LOG = LoggerFactory.getLogger(ParameterizedEndpointUtil.class);
        PLACEHOLDER_PATTERN = Pattern.compile("\\{(.*?)\\}");
        OPTIONS_PATTERN = Pattern.compile(OPTIONS_REGEX);
    }
}

