/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.glassfish.jersey.client.ClientAsyncExecutor;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.spi.ThreadPoolExecutorProvider;

@ClientAsyncExecutor
public class DaemonClientAsyncExecutorProvider
extends ThreadPoolExecutorProvider {
    private static final Logger LOGGER = Logger.getLogger(DaemonClientAsyncExecutorProvider.class.getName());
    private final LazyValue<Integer> asyncThreadPoolSize;

    @Inject
    public DaemonClientAsyncExecutorProvider(final @Named(value="ClientAsyncThreadPoolSize") int poolSize) {
        super("jersey-client-async-executor");
        this.asyncThreadPoolSize = Values.lazy((Value)new Value<Integer>(){

            public Integer get() {
                if (poolSize <= 0) {
                    LOGGER.config(LocalizationMessages.IGNORED_ASYNC_THREADPOOL_SIZE((Object)poolSize));
                    return Integer.MAX_VALUE;
                }
                LOGGER.config(LocalizationMessages.USING_FIXED_ASYNC_THREADPOOL((Object)poolSize));
                return poolSize;
            }
        });
    }

    protected int getMaximumPoolSize() {
        return (Integer)this.asyncThreadPoolSize.get();
    }

    protected int getCorePoolSize() {
        Integer maximumPoolSize = this.getMaximumPoolSize();
        if (maximumPoolSize != Integer.MAX_VALUE) {
            return maximumPoolSize;
        }
        return 0;
    }

    protected ThreadFactory getBackingThreadFactory() {
        return task -> {
            Thread thread = new Thread(task);
            thread.setDaemon(true);
            return thread;
        };
    }
}

