/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificatesmanagement.model.CertificateProfileType;
import com.oracle.bmc.certificatesmanagement.model.CertificateSubject;
import com.oracle.bmc.certificatesmanagement.model.CertificateSubjectAlternativeName;
import com.oracle.bmc.certificatesmanagement.model.CreateCertificateConfigDetails;
import com.oracle.bmc.certificatesmanagement.model.KeyAlgorithm;
import com.oracle.bmc.certificatesmanagement.model.SignatureAlgorithm;
import com.oracle.bmc.certificatesmanagement.model.Validity;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateCertificateIssuedByInternalCaConfigDetails
extends CreateCertificateConfigDetails {
    @JsonProperty(value="certificateProfileType")
    private final CertificateProfileType certificateProfileType;
    @JsonProperty(value="issuerCertificateAuthorityId")
    private final String issuerCertificateAuthorityId;
    @JsonProperty(value="validity")
    private final Validity validity;
    @JsonProperty(value="subject")
    private final CertificateSubject subject;
    @JsonProperty(value="subjectAlternativeNames")
    private final List<CertificateSubjectAlternativeName> subjectAlternativeNames;
    @JsonProperty(value="keyAlgorithm")
    private final KeyAlgorithm keyAlgorithm;
    @JsonProperty(value="signatureAlgorithm")
    private final SignatureAlgorithm signatureAlgorithm;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateCertificateIssuedByInternalCaConfigDetails(String versionName, CertificateProfileType certificateProfileType, String issuerCertificateAuthorityId, Validity validity, CertificateSubject subject, List<CertificateSubjectAlternativeName> subjectAlternativeNames, KeyAlgorithm keyAlgorithm, SignatureAlgorithm signatureAlgorithm) {
        super(versionName);
        this.certificateProfileType = certificateProfileType;
        this.issuerCertificateAuthorityId = issuerCertificateAuthorityId;
        this.validity = validity;
        this.subject = subject;
        this.subjectAlternativeNames = subjectAlternativeNames;
        this.keyAlgorithm = keyAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public CertificateProfileType getCertificateProfileType() {
        return this.certificateProfileType;
    }

    public String getIssuerCertificateAuthorityId() {
        return this.issuerCertificateAuthorityId;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public CertificateSubject getSubject() {
        return this.subject;
    }

    public List<CertificateSubjectAlternativeName> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public KeyAlgorithm getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateCertificateIssuedByInternalCaConfigDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", certificateProfileType=").append(String.valueOf((Object)this.certificateProfileType));
        sb.append(", issuerCertificateAuthorityId=").append(String.valueOf(this.issuerCertificateAuthorityId));
        sb.append(", validity=").append(String.valueOf((Object)this.validity));
        sb.append(", subject=").append(String.valueOf((Object)this.subject));
        sb.append(", subjectAlternativeNames=").append(String.valueOf(this.subjectAlternativeNames));
        sb.append(", keyAlgorithm=").append(String.valueOf((Object)this.keyAlgorithm));
        sb.append(", signatureAlgorithm=").append(String.valueOf((Object)this.signatureAlgorithm));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCertificateIssuedByInternalCaConfigDetails)) {
            return false;
        }
        CreateCertificateIssuedByInternalCaConfigDetails other = (CreateCertificateIssuedByInternalCaConfigDetails)((Object)o);
        return Objects.equals((Object)this.certificateProfileType, (Object)other.certificateProfileType) && Objects.equals(this.issuerCertificateAuthorityId, other.issuerCertificateAuthorityId) && Objects.equals((Object)this.validity, (Object)other.validity) && Objects.equals((Object)this.subject, (Object)other.subject) && Objects.equals(this.subjectAlternativeNames, other.subjectAlternativeNames) && Objects.equals((Object)this.keyAlgorithm, (Object)other.keyAlgorithm) && Objects.equals((Object)this.signatureAlgorithm, (Object)other.signatureAlgorithm) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certificateProfileType == null ? 43 : this.certificateProfileType.hashCode());
        result = result * 59 + (this.issuerCertificateAuthorityId == null ? 43 : this.issuerCertificateAuthorityId.hashCode());
        result = result * 59 + (this.validity == null ? 43 : this.validity.hashCode());
        result = result * 59 + (this.subject == null ? 43 : this.subject.hashCode());
        result = result * 59 + (this.subjectAlternativeNames == null ? 43 : this.subjectAlternativeNames.hashCode());
        result = result * 59 + (this.keyAlgorithm == null ? 43 : this.keyAlgorithm.hashCode());
        result = result * 59 + (this.signatureAlgorithm == null ? 43 : this.signatureAlgorithm.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="versionName")
        private String versionName;
        @JsonProperty(value="certificateProfileType")
        private CertificateProfileType certificateProfileType;
        @JsonProperty(value="issuerCertificateAuthorityId")
        private String issuerCertificateAuthorityId;
        @JsonProperty(value="validity")
        private Validity validity;
        @JsonProperty(value="subject")
        private CertificateSubject subject;
        @JsonProperty(value="subjectAlternativeNames")
        private List<CertificateSubjectAlternativeName> subjectAlternativeNames;
        @JsonProperty(value="keyAlgorithm")
        private KeyAlgorithm keyAlgorithm;
        @JsonProperty(value="signatureAlgorithm")
        private SignatureAlgorithm signatureAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            this.__explicitlySet__.add("versionName");
            return this;
        }

        public Builder certificateProfileType(CertificateProfileType certificateProfileType) {
            this.certificateProfileType = certificateProfileType;
            this.__explicitlySet__.add("certificateProfileType");
            return this;
        }

        public Builder issuerCertificateAuthorityId(String issuerCertificateAuthorityId) {
            this.issuerCertificateAuthorityId = issuerCertificateAuthorityId;
            this.__explicitlySet__.add("issuerCertificateAuthorityId");
            return this;
        }

        public Builder validity(Validity validity) {
            this.validity = validity;
            this.__explicitlySet__.add("validity");
            return this;
        }

        public Builder subject(CertificateSubject subject) {
            this.subject = subject;
            this.__explicitlySet__.add("subject");
            return this;
        }

        public Builder subjectAlternativeNames(List<CertificateSubjectAlternativeName> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            this.__explicitlySet__.add("subjectAlternativeNames");
            return this;
        }

        public Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.__explicitlySet__.add("keyAlgorithm");
            return this;
        }

        public Builder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            this.__explicitlySet__.add("signatureAlgorithm");
            return this;
        }

        public CreateCertificateIssuedByInternalCaConfigDetails build() {
            CreateCertificateIssuedByInternalCaConfigDetails model = new CreateCertificateIssuedByInternalCaConfigDetails(this.versionName, this.certificateProfileType, this.issuerCertificateAuthorityId, this.validity, this.subject, this.subjectAlternativeNames, this.keyAlgorithm, this.signatureAlgorithm);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateCertificateIssuedByInternalCaConfigDetails model) {
            if (model.wasPropertyExplicitlySet("versionName")) {
                this.versionName(model.getVersionName());
            }
            if (model.wasPropertyExplicitlySet("certificateProfileType")) {
                this.certificateProfileType(model.getCertificateProfileType());
            }
            if (model.wasPropertyExplicitlySet("issuerCertificateAuthorityId")) {
                this.issuerCertificateAuthorityId(model.getIssuerCertificateAuthorityId());
            }
            if (model.wasPropertyExplicitlySet("validity")) {
                this.validity(model.getValidity());
            }
            if (model.wasPropertyExplicitlySet("subject")) {
                this.subject(model.getSubject());
            }
            if (model.wasPropertyExplicitlySet("subjectAlternativeNames")) {
                this.subjectAlternativeNames(model.getSubjectAlternativeNames());
            }
            if (model.wasPropertyExplicitlySet("keyAlgorithm")) {
                this.keyAlgorithm(model.getKeyAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("signatureAlgorithm")) {
                this.signatureAlgorithm(model.getSignatureAlgorithm());
            }
            return this;
        }
    }
}

