/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.certificatesmanagement.CertificatesManagementAsync;
import com.oracle.bmc.certificatesmanagement.model.Association;
import com.oracle.bmc.certificatesmanagement.model.AssociationCollection;
import com.oracle.bmc.certificatesmanagement.model.CaBundle;
import com.oracle.bmc.certificatesmanagement.model.CaBundleCollection;
import com.oracle.bmc.certificatesmanagement.model.Certificate;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthority;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityCollection;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityVersion;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityVersionCollection;
import com.oracle.bmc.certificatesmanagement.model.CertificateCollection;
import com.oracle.bmc.certificatesmanagement.model.CertificateVersion;
import com.oracle.bmc.certificatesmanagement.model.CertificateVersionCollection;
import com.oracle.bmc.certificatesmanagement.requests.CancelCertificateAuthorityDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.CancelCertificateAuthorityVersionDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.CancelCertificateDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.CancelCertificateVersionDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.ChangeCaBundleCompartmentRequest;
import com.oracle.bmc.certificatesmanagement.requests.ChangeCertificateAuthorityCompartmentRequest;
import com.oracle.bmc.certificatesmanagement.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.certificatesmanagement.requests.CreateCaBundleRequest;
import com.oracle.bmc.certificatesmanagement.requests.CreateCertificateAuthorityRequest;
import com.oracle.bmc.certificatesmanagement.requests.CreateCertificateRequest;
import com.oracle.bmc.certificatesmanagement.requests.DeleteCaBundleRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetAssociationRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCaBundleRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCertificateAuthorityRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCertificateAuthorityVersionRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCertificateRequest;
import com.oracle.bmc.certificatesmanagement.requests.GetCertificateVersionRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListAssociationsRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCaBundlesRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificateAuthoritiesRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificateAuthorityVersionsRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificateVersionsRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificatesRequest;
import com.oracle.bmc.certificatesmanagement.requests.RevokeCertificateAuthorityVersionRequest;
import com.oracle.bmc.certificatesmanagement.requests.RevokeCertificateVersionRequest;
import com.oracle.bmc.certificatesmanagement.requests.ScheduleCertificateAuthorityDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.ScheduleCertificateAuthorityVersionDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.ScheduleCertificateDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.ScheduleCertificateVersionDeletionRequest;
import com.oracle.bmc.certificatesmanagement.requests.UpdateCaBundleRequest;
import com.oracle.bmc.certificatesmanagement.requests.UpdateCertificateAuthorityRequest;
import com.oracle.bmc.certificatesmanagement.requests.UpdateCertificateRequest;
import com.oracle.bmc.certificatesmanagement.responses.CancelCertificateAuthorityDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.CancelCertificateAuthorityVersionDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.CancelCertificateDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.CancelCertificateVersionDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.ChangeCaBundleCompartmentResponse;
import com.oracle.bmc.certificatesmanagement.responses.ChangeCertificateAuthorityCompartmentResponse;
import com.oracle.bmc.certificatesmanagement.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.certificatesmanagement.responses.CreateCaBundleResponse;
import com.oracle.bmc.certificatesmanagement.responses.CreateCertificateAuthorityResponse;
import com.oracle.bmc.certificatesmanagement.responses.CreateCertificateResponse;
import com.oracle.bmc.certificatesmanagement.responses.DeleteCaBundleResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetAssociationResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCaBundleResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCertificateAuthorityResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCertificateAuthorityVersionResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCertificateResponse;
import com.oracle.bmc.certificatesmanagement.responses.GetCertificateVersionResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListAssociationsResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCaBundlesResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificateAuthoritiesResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificateAuthorityVersionsResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificateVersionsResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificatesResponse;
import com.oracle.bmc.certificatesmanagement.responses.RevokeCertificateAuthorityVersionResponse;
import com.oracle.bmc.certificatesmanagement.responses.RevokeCertificateVersionResponse;
import com.oracle.bmc.certificatesmanagement.responses.ScheduleCertificateAuthorityDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.ScheduleCertificateAuthorityVersionDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.ScheduleCertificateDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.ScheduleCertificateVersionDeletionResponse;
import com.oracle.bmc.certificatesmanagement.responses.UpdateCaBundleResponse;
import com.oracle.bmc.certificatesmanagement.responses.UpdateCertificateAuthorityResponse;
import com.oracle.bmc.certificatesmanagement.responses.UpdateCertificateResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesManagementAsyncClient
extends BaseAsyncClient
implements CertificatesManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CERTIFICATESMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://certificatesmanagement.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(CertificatesManagementAsyncClient.class);

    private CertificatesManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelCertificateAuthorityDeletionResponse> cancelCertificateAuthorityDeletion(CancelCertificateAuthorityDeletionRequest request, AsyncHandler<CancelCertificateAuthorityDeletionRequest, CancelCertificateAuthorityDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelCertificateAuthorityDeletionResponse::builder).logger(LOG, "cancelCertificateAuthorityDeletion").serviceDetails("CertificatesManagement", "CancelCertificateAuthorityDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthority/CancelCertificateAuthorityDeletion").method(Method.POST).requestBuilder(CancelCertificateAuthorityDeletionRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("etag", CancelCertificateAuthorityDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelCertificateAuthorityDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelCertificateAuthorityVersionDeletionResponse> cancelCertificateAuthorityVersionDeletion(CancelCertificateAuthorityVersionDeletionRequest request, AsyncHandler<CancelCertificateAuthorityVersionDeletionRequest, CancelCertificateAuthorityVersionDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelCertificateAuthorityVersionDeletionResponse::builder).logger(LOG, "cancelCertificateAuthorityVersionDeletion").serviceDetails("CertificatesManagement", "CancelCertificateAuthorityVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthorityVersion/CancelCertificateAuthorityVersionDeletion").method(Method.POST).requestBuilder(CancelCertificateAuthorityVersionDeletionRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("version").appendPathParam((Number)request.getCertificateAuthorityVersionNumber()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("etag", CancelCertificateAuthorityVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelCertificateAuthorityVersionDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelCertificateDeletionResponse> cancelCertificateDeletion(CancelCertificateDeletionRequest request, AsyncHandler<CancelCertificateDeletionRequest, CancelCertificateDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelCertificateDeletionResponse::builder).logger(LOG, "cancelCertificateDeletion").serviceDetails("CertificatesManagement", "CancelCertificateDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/Certificate/CancelCertificateDeletion").method(Method.POST).requestBuilder(CancelCertificateDeletionRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("etag", CancelCertificateDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelCertificateDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelCertificateVersionDeletionResponse> cancelCertificateVersionDeletion(CancelCertificateVersionDeletionRequest request, AsyncHandler<CancelCertificateVersionDeletionRequest, CancelCertificateVersionDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelCertificateVersionDeletionResponse::builder).logger(LOG, "cancelCertificateVersionDeletion").serviceDetails("CertificatesManagement", "CancelCertificateVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateVersion/CancelCertificateVersionDeletion").method(Method.POST).requestBuilder(CancelCertificateVersionDeletionRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("version").appendPathParam((Number)request.getCertificateVersionNumber()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("etag", CancelCertificateVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelCertificateVersionDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeCaBundleCompartmentResponse> changeCaBundleCompartment(ChangeCaBundleCompartmentRequest request, AsyncHandler<ChangeCaBundleCompartmentRequest, ChangeCaBundleCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCaBundleId(), (String)"caBundleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCaBundleCompartmentDetails(), "changeCaBundleCompartmentDetails is required");
        return this.clientCall(request, ChangeCaBundleCompartmentResponse::builder).logger(LOG, "changeCaBundleCompartment").serviceDetails("CertificatesManagement", "ChangeCaBundleCompartment", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CaBundle/ChangeCaBundleCompartment").method(Method.POST).requestBuilder(ChangeCaBundleCompartmentRequest::builder).basePath("/20210224").appendPathParam("caBundles").appendPathParam(request.getCaBundleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCaBundleCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeCertificateAuthorityCompartmentResponse> changeCertificateAuthorityCompartment(ChangeCertificateAuthorityCompartmentRequest request, AsyncHandler<ChangeCertificateAuthorityCompartmentRequest, ChangeCertificateAuthorityCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCertificateAuthorityCompartmentDetails(), "changeCertificateAuthorityCompartmentDetails is required");
        return this.clientCall(request, ChangeCertificateAuthorityCompartmentResponse::builder).logger(LOG, "changeCertificateAuthorityCompartment").serviceDetails("CertificatesManagement", "ChangeCertificateAuthorityCompartment", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthority/ChangeCertificateAuthorityCompartment").method(Method.POST).requestBuilder(ChangeCertificateAuthorityCompartmentRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCertificateAuthorityCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeCertificateCompartmentResponse> changeCertificateCompartment(ChangeCertificateCompartmentRequest request, AsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCertificateCompartmentDetails(), "changeCertificateCompartmentDetails is required");
        return this.clientCall(request, ChangeCertificateCompartmentResponse::builder).logger(LOG, "changeCertificateCompartment").serviceDetails("CertificatesManagement", "ChangeCertificateCompartment", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/Certificate/ChangeCertificateCompartment").method(Method.POST).requestBuilder(ChangeCertificateCompartmentRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCertificateCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateCaBundleResponse> createCaBundle(CreateCaBundleRequest request, AsyncHandler<CreateCaBundleRequest, CreateCaBundleResponse> handler) {
        Objects.requireNonNull(request.getCreateCaBundleDetails(), "createCaBundleDetails is required");
        return this.clientCall(request, CreateCaBundleResponse::builder).logger(LOG, "createCaBundle").serviceDetails("CertificatesManagement", "CreateCaBundle", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CaBundle/CreateCaBundle").method(Method.POST).requestBuilder(CreateCaBundleRequest::builder).basePath("/20210224").appendPathParam("caBundles").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CaBundle.class, CreateCaBundleResponse.Builder::caBundle).handleResponseHeaderString("etag", CreateCaBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCaBundleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        Objects.requireNonNull(request.getCreateCertificateDetails(), "createCertificateDetails is required");
        return this.clientCall(request, CreateCertificateResponse::builder).logger(LOG, "createCertificate").serviceDetails("CertificatesManagement", "CreateCertificate", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/Certificate/CreateCertificate").method(Method.POST).requestBuilder(CreateCertificateRequest::builder).basePath("/20210224").appendPathParam("certificates").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Certificate.class, CreateCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", CreateCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateCertificateAuthorityResponse> createCertificateAuthority(CreateCertificateAuthorityRequest request, AsyncHandler<CreateCertificateAuthorityRequest, CreateCertificateAuthorityResponse> handler) {
        Objects.requireNonNull(request.getCreateCertificateAuthorityDetails(), "createCertificateAuthorityDetails is required");
        return this.clientCall(request, CreateCertificateAuthorityResponse::builder).logger(LOG, "createCertificateAuthority").serviceDetails("CertificatesManagement", "CreateCertificateAuthority", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthority/CreateCertificateAuthority").method(Method.POST).requestBuilder(CreateCertificateAuthorityRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CertificateAuthority.class, CreateCertificateAuthorityResponse.Builder::certificateAuthority).handleResponseHeaderString("etag", CreateCertificateAuthorityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCertificateAuthorityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCaBundleResponse> deleteCaBundle(DeleteCaBundleRequest request, AsyncHandler<DeleteCaBundleRequest, DeleteCaBundleResponse> handler) {
        Validate.notBlank((String)request.getCaBundleId(), (String)"caBundleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCaBundleResponse::builder).logger(LOG, "deleteCaBundle").serviceDetails("CertificatesManagement", "DeleteCaBundle", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CaBundle/DeleteCaBundle").method(Method.DELETE).requestBuilder(DeleteCaBundleRequest::builder).basePath("/20210224").appendPathParam("caBundles").appendPathParam(request.getCaBundleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteCaBundleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAssociationResponse> getAssociation(GetAssociationRequest request, AsyncHandler<GetAssociationRequest, GetAssociationResponse> handler) {
        Validate.notBlank((String)request.getAssociationId(), (String)"associationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAssociationResponse::builder).logger(LOG, "getAssociation").serviceDetails("CertificatesManagement", "GetAssociation", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/Association/GetAssociation").method(Method.GET).requestBuilder(GetAssociationRequest::builder).basePath("/20210224").appendPathParam("associations").appendPathParam(request.getAssociationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Association.class, GetAssociationResponse.Builder::association).handleResponseHeaderString("etag", GetAssociationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAssociationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCaBundleResponse> getCaBundle(GetCaBundleRequest request, AsyncHandler<GetCaBundleRequest, GetCaBundleResponse> handler) {
        Validate.notBlank((String)request.getCaBundleId(), (String)"caBundleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCaBundleResponse::builder).logger(LOG, "getCaBundle").serviceDetails("CertificatesManagement", "GetCaBundle", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CaBundle/GetCaBundle").method(Method.GET).requestBuilder(GetCaBundleRequest::builder).basePath("/20210224").appendPathParam("caBundles").appendPathParam(request.getCaBundleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CaBundle.class, GetCaBundleResponse.Builder::caBundle).handleResponseHeaderString("etag", GetCaBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCaBundleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCertificateResponse> getCertificate(GetCertificateRequest request, AsyncHandler<GetCertificateRequest, GetCertificateResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCertificateResponse::builder).logger(LOG, "getCertificate").serviceDetails("CertificatesManagement", "GetCertificate", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/Certificate/GetCertificate").method(Method.GET).requestBuilder(GetCertificateRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Certificate.class, GetCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", GetCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCertificateAuthorityResponse> getCertificateAuthority(GetCertificateAuthorityRequest request, AsyncHandler<GetCertificateAuthorityRequest, GetCertificateAuthorityResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCertificateAuthorityResponse::builder).logger(LOG, "getCertificateAuthority").serviceDetails("CertificatesManagement", "GetCertificateAuthority", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthority/GetCertificateAuthority").method(Method.GET).requestBuilder(GetCertificateAuthorityRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateAuthority.class, GetCertificateAuthorityResponse.Builder::certificateAuthority).handleResponseHeaderString("etag", GetCertificateAuthorityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateAuthorityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCertificateAuthorityVersionResponse> getCertificateAuthorityVersion(GetCertificateAuthorityVersionRequest request, AsyncHandler<GetCertificateAuthorityVersionRequest, GetCertificateAuthorityVersionResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCertificateAuthorityVersionResponse::builder).logger(LOG, "getCertificateAuthorityVersion").serviceDetails("CertificatesManagement", "GetCertificateAuthorityVersion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthorityVersion/GetCertificateAuthorityVersion").method(Method.GET).requestBuilder(GetCertificateAuthorityVersionRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("version").appendPathParam((Number)request.getCertificateAuthorityVersionNumber()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateAuthorityVersion.class, GetCertificateAuthorityVersionResponse.Builder::certificateAuthorityVersion).handleResponseHeaderString("etag", GetCertificateAuthorityVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateAuthorityVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCertificateVersionResponse> getCertificateVersion(GetCertificateVersionRequest request, AsyncHandler<GetCertificateVersionRequest, GetCertificateVersionResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCertificateVersionResponse::builder).logger(LOG, "getCertificateVersion").serviceDetails("CertificatesManagement", "GetCertificateVersion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateVersion/GetCertificateVersion").method(Method.GET).requestBuilder(GetCertificateVersionRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("version").appendPathParam((Number)request.getCertificateVersionNumber()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateVersion.class, GetCertificateVersionResponse.Builder::certificateVersion).handleResponseHeaderString("etag", GetCertificateVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCertificateVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAssociationsResponse> listAssociations(ListAssociationsRequest request, AsyncHandler<ListAssociationsRequest, ListAssociationsResponse> handler) {
        return this.clientCall(request, ListAssociationsResponse::builder).logger(LOG, "listAssociations").serviceDetails("CertificatesManagement", "ListAssociations", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/AssociationSummary/ListAssociations").method(Method.GET).requestBuilder(ListAssociationsRequest::builder).basePath("/20210224").appendPathParam("associations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("certificatesResourceId", (Object)request.getCertificatesResourceId()).appendQueryParam("associatedResourceId", (Object)request.getAssociatedResourceId()).appendQueryParam("associationId", (Object)request.getAssociationId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("associationType", (BmcEnum)request.getAssociationType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssociationCollection.class, ListAssociationsResponse.Builder::associationCollection).handleResponseHeaderString("opc-request-id", ListAssociationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssociationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCaBundlesResponse> listCaBundles(ListCaBundlesRequest request, AsyncHandler<ListCaBundlesRequest, ListCaBundlesResponse> handler) {
        return this.clientCall(request, ListCaBundlesResponse::builder).logger(LOG, "listCaBundles").serviceDetails("CertificatesManagement", "ListCaBundles", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CaBundleSummary/ListCaBundles").method(Method.GET).requestBuilder(ListCaBundlesRequest::builder).basePath("/20210224").appendPathParam("caBundles").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("caBundleId", (Object)request.getCaBundleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CaBundleCollection.class, ListCaBundlesResponse.Builder::caBundleCollection).handleResponseHeaderString("opc-request-id", ListCaBundlesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCaBundlesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCertificateAuthoritiesResponse> listCertificateAuthorities(ListCertificateAuthoritiesRequest request, AsyncHandler<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse> handler) {
        return this.clientCall(request, ListCertificateAuthoritiesResponse::builder).logger(LOG, "listCertificateAuthorities").serviceDetails("CertificatesManagement", "ListCertificateAuthorities", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthoritySummary/ListCertificateAuthorities").method(Method.GET).requestBuilder(ListCertificateAuthoritiesRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("issuerCertificateAuthorityId", (Object)request.getIssuerCertificateAuthorityId()).appendQueryParam("certificateAuthorityId", (Object)request.getCertificateAuthorityId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateAuthorityCollection.class, ListCertificateAuthoritiesResponse.Builder::certificateAuthorityCollection).handleResponseHeaderString("opc-request-id", ListCertificateAuthoritiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCertificateAuthoritiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCertificateAuthorityVersionsResponse> listCertificateAuthorityVersions(ListCertificateAuthorityVersionsRequest request, AsyncHandler<ListCertificateAuthorityVersionsRequest, ListCertificateAuthorityVersionsResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListCertificateAuthorityVersionsResponse::builder).logger(LOG, "listCertificateAuthorityVersions").serviceDetails("CertificatesManagement", "ListCertificateAuthorityVersions", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthorityVersionSummary/ListCertificateAuthorityVersions").method(Method.GET).requestBuilder(ListCertificateAuthorityVersionsRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("versions").appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateAuthorityVersionCollection.class, ListCertificateAuthorityVersionsResponse.Builder::certificateAuthorityVersionCollection).handleResponseHeaderString("opc-request-id", ListCertificateAuthorityVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCertificateAuthorityVersionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListCertificateVersionsResponse> listCertificateVersions(ListCertificateVersionsRequest request, AsyncHandler<ListCertificateVersionsRequest, ListCertificateVersionsResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListCertificateVersionsResponse::builder).logger(LOG, "listCertificateVersions").serviceDetails("CertificatesManagement", "ListCertificateVersions", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateVersionSummary/ListCertificateVersions").method(Method.GET).requestBuilder(ListCertificateVersionsRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("versions").appendQueryParam("versionNumber", (Object)request.getVersionNumber()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateVersionCollection.class, ListCertificateVersionsResponse.Builder::certificateVersionCollection).handleResponseHeaderString("opc-next-page", ListCertificateVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCertificateVersionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        return this.clientCall(request, ListCertificatesResponse::builder).logger(LOG, "listCertificates").serviceDetails("CertificatesManagement", "ListCertificates", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateSummary/ListCertificates").method(Method.GET).requestBuilder(ListCertificatesRequest::builder).basePath("/20210224").appendPathParam("certificates").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("issuerCertificateAuthorityId", (Object)request.getIssuerCertificateAuthorityId()).appendQueryParam("certificateId", (Object)request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CertificateCollection.class, ListCertificatesResponse.Builder::certificateCollection).handleResponseHeaderString("opc-request-id", ListCertificatesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCertificatesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RevokeCertificateAuthorityVersionResponse> revokeCertificateAuthorityVersion(RevokeCertificateAuthorityVersionRequest request, AsyncHandler<RevokeCertificateAuthorityVersionRequest, RevokeCertificateAuthorityVersionResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRevokeCertificateAuthorityVersionDetails(), "revokeCertificateAuthorityVersionDetails is required");
        return this.clientCall(request, RevokeCertificateAuthorityVersionResponse::builder).logger(LOG, "revokeCertificateAuthorityVersion").serviceDetails("CertificatesManagement", "RevokeCertificateAuthorityVersion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthorityVersion/RevokeCertificateAuthorityVersion").method(Method.POST).requestBuilder(RevokeCertificateAuthorityVersionRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("version").appendPathParam((Number)request.getCertificateAuthorityVersionNumber()).appendPathParam("actions").appendPathParam("revoke").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", RevokeCertificateAuthorityVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RevokeCertificateAuthorityVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RevokeCertificateVersionResponse> revokeCertificateVersion(RevokeCertificateVersionRequest request, AsyncHandler<RevokeCertificateVersionRequest, RevokeCertificateVersionResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRevokeCertificateVersionDetails(), "revokeCertificateVersionDetails is required");
        return this.clientCall(request, RevokeCertificateVersionResponse::builder).logger(LOG, "revokeCertificateVersion").serviceDetails("CertificatesManagement", "RevokeCertificateVersion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateVersion/RevokeCertificateVersion").method(Method.POST).requestBuilder(RevokeCertificateVersionRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("version").appendPathParam((Number)request.getCertificateVersionNumber()).appendPathParam("actions").appendPathParam("revoke").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", RevokeCertificateVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RevokeCertificateVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleCertificateAuthorityDeletionResponse> scheduleCertificateAuthorityDeletion(ScheduleCertificateAuthorityDeletionRequest request, AsyncHandler<ScheduleCertificateAuthorityDeletionRequest, ScheduleCertificateAuthorityDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleCertificateAuthorityDeletionDetails(), "scheduleCertificateAuthorityDeletionDetails is required");
        return this.clientCall(request, ScheduleCertificateAuthorityDeletionResponse::builder).logger(LOG, "scheduleCertificateAuthorityDeletion").serviceDetails("CertificatesManagement", "ScheduleCertificateAuthorityDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthority/ScheduleCertificateAuthorityDeletion").method(Method.POST).requestBuilder(ScheduleCertificateAuthorityDeletionRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", ScheduleCertificateAuthorityDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleCertificateAuthorityDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleCertificateAuthorityVersionDeletionResponse> scheduleCertificateAuthorityVersionDeletion(ScheduleCertificateAuthorityVersionDeletionRequest request, AsyncHandler<ScheduleCertificateAuthorityVersionDeletionRequest, ScheduleCertificateAuthorityVersionDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleCertificateAuthorityVersionDeletionDetails(), "scheduleCertificateAuthorityVersionDeletionDetails is required");
        return this.clientCall(request, ScheduleCertificateAuthorityVersionDeletionResponse::builder).logger(LOG, "scheduleCertificateAuthorityVersionDeletion").serviceDetails("CertificatesManagement", "ScheduleCertificateAuthorityVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthorityVersion/ScheduleCertificateAuthorityVersionDeletion").method(Method.POST).requestBuilder(ScheduleCertificateAuthorityVersionDeletionRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).appendPathParam("version").appendPathParam((Number)request.getCertificateAuthorityVersionNumber()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", ScheduleCertificateAuthorityVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleCertificateAuthorityVersionDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleCertificateDeletionResponse> scheduleCertificateDeletion(ScheduleCertificateDeletionRequest request, AsyncHandler<ScheduleCertificateDeletionRequest, ScheduleCertificateDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleCertificateDeletionDetails(), "scheduleCertificateDeletionDetails is required");
        return this.clientCall(request, ScheduleCertificateDeletionResponse::builder).logger(LOG, "scheduleCertificateDeletion").serviceDetails("CertificatesManagement", "ScheduleCertificateDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/Certificate/ScheduleCertificateDeletion").method(Method.POST).requestBuilder(ScheduleCertificateDeletionRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", ScheduleCertificateDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleCertificateDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleCertificateVersionDeletionResponse> scheduleCertificateVersionDeletion(ScheduleCertificateVersionDeletionRequest request, AsyncHandler<ScheduleCertificateVersionDeletionRequest, ScheduleCertificateVersionDeletionResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleCertificateVersionDeletionDetails(), "scheduleCertificateVersionDeletionDetails is required");
        return this.clientCall(request, ScheduleCertificateVersionDeletionResponse::builder).logger(LOG, "scheduleCertificateVersionDeletion").serviceDetails("CertificatesManagement", "ScheduleCertificateVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateVersion/ScheduleCertificateVersionDeletion").method(Method.POST).requestBuilder(ScheduleCertificateVersionDeletionRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).appendPathParam("version").appendPathParam((Number)request.getCertificateVersionNumber()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("etag", ScheduleCertificateVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleCertificateVersionDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateCaBundleResponse> updateCaBundle(UpdateCaBundleRequest request, AsyncHandler<UpdateCaBundleRequest, UpdateCaBundleResponse> handler) {
        Validate.notBlank((String)request.getCaBundleId(), (String)"caBundleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCaBundleDetails(), "updateCaBundleDetails is required");
        return this.clientCall(request, UpdateCaBundleResponse::builder).logger(LOG, "updateCaBundle").serviceDetails("CertificatesManagement", "UpdateCaBundle", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CaBundle/UpdateCaBundle").method(Method.PUT).requestBuilder(UpdateCaBundleRequest::builder).basePath("/20210224").appendPathParam("caBundles").appendPathParam(request.getCaBundleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(CaBundle.class, UpdateCaBundleResponse.Builder::caBundle).handleResponseHeaderString("etag", UpdateCaBundleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCaBundleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest request, AsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handler) {
        Validate.notBlank((String)request.getCertificateId(), (String)"certificateId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCertificateDetails(), "updateCertificateDetails is required");
        return this.clientCall(request, UpdateCertificateResponse::builder).logger(LOG, "updateCertificate").serviceDetails("CertificatesManagement", "UpdateCertificate", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/Certificate/UpdateCertificate").method(Method.PUT).requestBuilder(UpdateCertificateRequest::builder).basePath("/20210224").appendPathParam("certificates").appendPathParam(request.getCertificateId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Certificate.class, UpdateCertificateResponse.Builder::certificate).handleResponseHeaderString("etag", UpdateCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateCertificateAuthorityResponse> updateCertificateAuthority(UpdateCertificateAuthorityRequest request, AsyncHandler<UpdateCertificateAuthorityRequest, UpdateCertificateAuthorityResponse> handler) {
        Validate.notBlank((String)request.getCertificateAuthorityId(), (String)"certificateAuthorityId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCertificateAuthorityDetails(), "updateCertificateAuthorityDetails is required");
        return this.clientCall(request, UpdateCertificateAuthorityResponse::builder).logger(LOG, "updateCertificateAuthority").serviceDetails("CertificatesManagement", "UpdateCertificateAuthority", "https://docs.oracle.com/iaas/api/#/en/certificatesmgmt/20210224/CertificateAuthority/UpdateCertificateAuthority").method(Method.PUT).requestBuilder(UpdateCertificateAuthorityRequest::builder).basePath("/20210224").appendPathParam("certificateAuthorities").appendPathParam(request.getCertificateAuthorityId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(CertificateAuthority.class, UpdateCertificateAuthorityResponse.Builder::certificateAuthority).handleResponseHeaderString("etag", UpdateCertificateAuthorityResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCertificateAuthorityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public CertificatesManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)CertificatesManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(CertificatesManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)CertificatesManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)CertificatesManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)CertificatesManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)CertificatesManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public CertificatesManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)CertificatesManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, CertificatesManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public CertificatesManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new CertificatesManagementAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

