/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;

class XSDIdConstraintTable {
    XSDIdentity definition;
    Hashtable idInstances;
    XSDSimpleType[] keyTypes;
    int nkeys;

    XSDIdConstraintTable(XSDIdentity xSDIdentity) {
        this.definition = xSDIdentity;
        this.idInstances = new Hashtable();
        this.nkeys = xSDIdentity.nfields;
    }

    void addElement(XMLElement xMLElement) {
        NodeTable nodeTable = new NodeTable();
        this.idInstances.put(xMLElement, nodeTable);
    }

    void validateIdConstraints() throws XSDException {
        Enumeration enumeration = this.idInstances.keys();
        while (enumeration.hasMoreElements()) {
            this.addConstraint((XMLElement)enumeration.nextElement());
        }
    }

    void validateKeyref(XSDIdConstraintTable xSDIdConstraintTable) throws XSDException {
        Enumeration enumeration = this.idInstances.elements();
        while (enumeration.hasMoreElements()) {
            NodeTable nodeTable = (NodeTable)enumeration.nextElement();
            for (int i = 0; i < nodeTable.len; ++i) {
                boolean bl = false;
                Enumeration enumeration2 = xSDIdConstraintTable.idInstances.elements();
                while (enumeration2.hasMoreElements()) {
                    NodeTable nodeTable2 = (NodeTable)enumeration2.nextElement();
                    if (!nodeTable2.findKeySeq(nodeTable.keySequences[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new XSDException("Key sequence not found in key reference");
            }
        }
    }

    void addConstraint(XMLElement xMLElement) throws XSDException {
        NodeList nodeList;
        try {
            nodeList = xMLElement.selectNodes(this.definition.getSelectorExpr());
        }
        catch (XSLException xSLException) {
            throw new XSDException("XPath error");
        }
        NodeTable nodeTable = (NodeTable)this.idInstances.get(xMLElement);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = (XMLElement)nodeList.item(i);
            nodeTable.addKeySequence(xMLElement2);
        }
        this.idInstances.put(xMLElement, nodeTable);
    }

    class NodeTable {
        XMLElement[] targetNodes;
        String[][] keySequences;
        int size = 16;
        int len = 0;

        NodeTable() {
            this.keySequences = new String[this.size][XSDIdConstraintTable.this.nkeys];
            this.targetNodes = new XMLElement[this.size];
        }

        void addKeySequence(XMLElement xMLElement) throws XSDException {
            int n;
            this.ensureCapacity();
            this.targetNodes[this.len] = xMLElement;
            int n2 = XSDIdConstraintTable.this.definition.nodeType;
            block6: for (n = 0; n < XSDIdConstraintTable.this.nkeys; ++n) {
                NodeList nodeList;
                try {
                    nodeList = xMLElement.selectNodes(XSDIdConstraintTable.this.definition.getFieldExpr(n));
                }
                catch (XSLException xSLException) {
                    throw new XSDException("XPathe error");
                }
                switch (nodeList.getLength()) {
                    case 0: {
                        XSDIdentity cfr_ignored_0 = XSDIdConstraintTable.this.definition;
                        if (n2 == 23) {
                            throw new XSDException("empty key");
                        }
                        return;
                    }
                    case 1: {
                        this.keySequences[this.len][n] = ((XMLNode)nodeList.item(0)).getText().intern();
                        continue block6;
                    }
                    default: {
                        throw new XSDException("constraint is not unique");
                    }
                }
            }
            XSDIdentity cfr_ignored_1 = XSDIdConstraintTable.this.definition;
            if (n2 != 24) {
                for (n = 0; n < this.len; ++n) {
                    if (!this.equalKeySeq(n, this.len)) continue;
                    throw new XSDException("duplicate keys");
                }
            }
            ++this.len;
        }

        boolean equalKeySeq(int n, int n2) {
            for (int i = 0; i < XSDIdConstraintTable.this.nkeys; ++i) {
                if (this.keySequences[n][i] == this.keySequences[n2][i]) continue;
                return false;
            }
            return true;
        }

        boolean findKeySeq(String[] stringArray) {
            for (int i = 0; i < this.len; ++i) {
                boolean bl = true;
                for (int j = 0; j < XSDIdConstraintTable.this.nkeys; ++j) {
                    if (stringArray[j].intern() == this.keySequences[i][j].intern()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }

        void ensureCapacity() {
            if (this.len >= this.size) {
                XMLElement[] xMLElementArray = this.targetNodes;
                String[][] stringArray = this.keySequences;
                this.targetNodes = new XMLElement[this.size * 2];
                this.keySequences = new String[this.size * 2][XSDIdConstraintTable.this.nkeys];
                System.arraycopy(xMLElementArray, 0, this.targetNodes, 0, this.size);
                System.arraycopy(stringArray, 0, this.keySequences, 0, this.size);
                this.size *= 2;
            }
        }
    }
}

