/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.ComparisonExpr;
import oracle.xml.xpath.OrExpr;
import oracle.xml.xpath.StreamingSequence;
import oracle.xml.xpath.XPathAttributeAxis;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathChildAxis;
import oracle.xml.xpath.XPathError;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xslt.XSLException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

class StreamNodeSequence
implements StreamingSequence {
    XMLNode curNode = null;
    StreamNodeSequence ctxSeq = null;
    int axistype = -1;
    XPathStep step = null;
    XPathRuntimeContext context;
    int[] posArray = null;
    boolean started = false;
    boolean create = false;
    boolean isHitCreateNodeErr = false;

    StreamNodeSequence(XPathStep xPathStep, XPathRuntimeContext xPathRuntimeContext, StreamNodeSequence object, XMLNode xMLNode) {
        if (xPathStep != null) {
            Object object2;
            this.step = xPathStep;
            this.axistype = xPathStep.getAxisType();
            if (this.step.prevSeparator == 6) {
                if (this.axistype == 2) {
                    object2 = new StreamNodeSequence(null, xPathRuntimeContext, (StreamNodeSequence)object, null);
                    ((StreamNodeSequence)object2).axistype = 5;
                    object = object2;
                } else {
                    this.axistype = this.axistype == 11 ? 5 : 4;
                }
            }
            if ((object2 = xPathStep.predicates) != null && ((XPathPredicate)object2).checkPosLastFN() > 0) {
                int n = ((XPathPredicate)object2).predicateSize;
                this.posArray = new int[n];
            }
        }
        this.context = xPathRuntimeContext;
        this.ctxSeq = object;
        if (xMLNode != null) {
            this.curNode = xMLNode;
        }
    }

    void reset(XMLNode xMLNode) {
        this.started = false;
        this.isHitCreateNodeErr = false;
        if (this.ctxSeq != null) {
            this.ctxSeq.reset(xMLNode);
        } else {
            this.curNode = xMLNode;
        }
    }

    @Override
    public boolean isDone() {
        return this.started && this.curNode == null;
    }

    void resetPosArray() {
        for (int i = 0; i < this.posArray.length; ++i) {
            this.posArray[i] = 0;
        }
    }

    @Override
    public boolean next() throws XSLException {
        XMLNode xMLNode = null;
        boolean bl = false;
        switch (this.axistype) {
            case 4: 
            case 5: {
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                }
                xMLNode = this.ctxSeq.getNode();
                while (xMLNode != null) {
                    if (this.curNode == null) {
                        this.curNode = xMLNode;
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                        if (this.axistype == 5) {
                            if (this.step == null) {
                                return true;
                            }
                            if ((this.step.anyNode || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) && (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context))) {
                                return true;
                            }
                        }
                    }
                    XMLNode xMLNode2 = this.curNode;
                    while (this.curNode != null) {
                        this.curNode = (XMLNode)xMLNode2.getFirstChild();
                        while (this.curNode == null && !xMLNode2.isSameNode(xMLNode)) {
                            this.curNode = (XMLNode)xMLNode2.getNextSibling();
                            if (this.curNode != null) continue;
                            xMLNode2 = (XMLNode)xMLNode2.getParentNode();
                        }
                        if (this.curNode == null) continue;
                        if (this.step == null) {
                            return true;
                        }
                        if ((this.step.anyNode && !(this.curNode instanceof DocumentType) || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) && (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context))) {
                            return true;
                        }
                        xMLNode2 = this.curNode;
                    }
                    this.ctxSeq.next();
                    xMLNode = this.ctxSeq.getNode();
                }
                return false;
            }
            case 3: {
                XMLNode xMLNode3 = null;
                XMLNode xMLNode4 = null;
                boolean bl2 = true;
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                    this.create = this.step.createNode;
                }
                xMLNode = this.ctxSeq.getNode();
                while (xMLNode != null) {
                    if (this.curNode == null) {
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                        xMLNode3 = xMLNode;
                        this.curNode = (XMLNode)xMLNode.getFirstChild();
                        if (this.curNode == null) {
                            bl2 = false;
                        }
                    } else {
                        xMLNode3 = this.curNode;
                        this.curNode = (XMLNode)this.curNode.getNextSibling();
                    }
                    while (this.curNode != null) {
                        xMLNode3 = this.curNode;
                        if (this.step.anyNode && !(this.curNode instanceof DocumentType) || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) {
                            xMLNode4 = this.curNode;
                            if (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context)) {
                                this.create = false;
                                return true;
                            }
                        }
                        this.curNode = (XMLNode)this.curNode.getNextSibling();
                    }
                    if (this.ctxSeq.next()) {
                        xMLNode = this.ctxSeq.getNode();
                        continue;
                    }
                    xMLNode = null;
                }
                if (this.create && !this.ctxSeq.isHitCreateNodeErr) {
                    this.create = false;
                    return this.createNode(xMLNode3, xMLNode4, bl2);
                }
                return false;
            }
            case 11: {
                while (this.ctxSeq.next()) {
                    this.curNode = this.ctxSeq.getNode();
                    if (this.posArray != null) {
                        this.resetPosArray();
                    }
                    if (!this.step.anyNode && !this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name) || this.step.predicates != null && !this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context)) continue;
                    return true;
                }
                this.curNode = null;
                return false;
            }
            case 2: {
                boolean bl3 = false;
                XMLNode xMLNode5 = null;
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                    xMLNode5 = this.ctxSeq.getNode();
                }
                xMLNode = this.ctxSeq.getNode();
                while (xMLNode != null) {
                    if (this.curNode == null) {
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                        if (xMLNode instanceof XMLElement) {
                            this.curNode = ((XMLElement)xMLNode).getFirstAttribute();
                        }
                    } else {
                        this.curNode = ((XMLAttr)this.curNode).getNextAttribute();
                    }
                    while (this.curNode != null) {
                        if (!this.curNode.isNodeFlag(262144) && (this.step.anyNode || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) && (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context))) {
                            bl3 = true;
                            return true;
                        }
                        this.curNode = ((XMLAttr)this.curNode).getNextAttribute();
                    }
                    if (this.ctxSeq.next()) {
                        xMLNode5 = xMLNode = this.ctxSeq.getNode();
                        continue;
                    }
                    xMLNode = null;
                }
                if (!bl3 && this.step.createNode && xMLNode5 instanceof XMLElement) {
                    String string = this.step.nameSpace;
                    String string2 = this.step.name;
                    XMLElement xMLElement = (XMLElement)xMLNode5;
                    if (string != null && string.length() > 0) {
                        String string3 = XPathAxis.getNewPrefix(xMLElement, string);
                        string2 = string3 + ":" + string2;
                    }
                    xMLElement.setAttributeNS(string, string2, "");
                    this.curNode = (XMLAttr)xMLElement.getAttributeNodeNS(string, this.step.name);
                    return true;
                }
                return false;
            }
            case -1: {
                if (this.started) {
                    this.curNode = null;
                    return false;
                }
                this.started = true;
                return true;
            }
        }
        return false;
    }

    boolean createNode(XMLNode xMLNode, XMLNode xMLNode2, boolean bl) throws XSLException {
        if (this.step.createNode) {
            Node node = null;
            node = xMLNode != null && bl ? xMLNode.getParentNode() : xMLNode;
            boolean bl2 = false;
            if (node != null && node instanceof XMLElement) {
                XMLDocument xMLDocument = ((XMLElement)node).getDocument();
                int n = 1;
                boolean bl3 = true;
                if (this.step.predicates != null && (n = this.step.predicates.getPosition(this.context)) == 0) {
                    bl3 = false;
                    n = 1;
                }
                int n2 = ((XMLElement)node).getChildrenByTagName(this.step.name, this.step.nameSpace).getLength();
                if (bl3) {
                    n -= n2;
                }
                String string = this.step.nameSpace;
                String string2 = null;
                if (string != null && string.length() > 0 && !(node instanceof XMLDocument)) {
                    string2 = node.lookupPrefix(string);
                }
                if (string2 == "#default") {
                    string2 = null;
                }
                String string3 = this.step.name;
                if (string2 != null) {
                    string3 = string2 + ":" + string3;
                }
                if (xMLNode2 != null) {
                    xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
                }
                for (int i = 0; i < n; ++i) {
                    this.curNode = (XMLElement)xMLDocument.createElementNS(string, string3);
                    if (xMLNode2 != null) {
                        node.insertBefore(this.curNode, xMLNode2);
                    } else {
                        node.appendChild(this.curNode);
                    }
                    bl2 = true;
                }
                if (bl2 && this.step.predicates != null) {
                    int n3;
                    XMLElement xMLElement = (XMLElement)this.curNode;
                    FastVector fastVector = this.step.predicates.predicates;
                    int n4 = fastVector.size();
                    int n5 = n3 = bl3 ? 1 : 0;
                    while (n3 < n4) {
                        XSLExprBase xSLExprBase = (XSLExprBase)this.step.predicates.predicates.elementAt(n3);
                        while (xSLExprBase != null) {
                            int n6 = xSLExprBase.operator;
                            if (n6 == 107) {
                                XSLExprBase xSLExprBase2 = xSLExprBase.leftExpr;
                                xMLElement = XPathAxis.addAttribute(xMLElement, xSLExprBase2, this.context);
                                xSLExprBase = xSLExprBase.rightExpr;
                                continue;
                            }
                            if (xSLExprBase instanceof OrExpr) {
                                xSLExprBase = xSLExprBase.leftExpr;
                                continue;
                            }
                            if (xSLExprBase instanceof ComparisonExpr) {
                                Object object;
                                boolean bl4 = false;
                                ArrayList arrayList = xSLExprBase.leftExpr.getStepList();
                                if (arrayList != null && !arrayList.isEmpty()) {
                                    object = arrayList.get(0);
                                    if (object instanceof XPathStep) {
                                        XPathAxis xPathAxis = ((XPathStep)object).axisClass;
                                        if (xPathAxis instanceof XPathChildAxis) {
                                            this.isHitCreateNodeErr = true;
                                        } else if (xPathAxis instanceof XPathAttributeAxis) {
                                            if (xSLExprBase.operator == 216 || xSLExprBase.operator == 208) {
                                                xMLElement = XPathAxis.addAttribute(xMLElement, xSLExprBase, this.context);
                                            } else {
                                                bl4 = true;
                                                this.isHitCreateNodeErr = true;
                                            }
                                        }
                                    }
                                } else {
                                    this.isHitCreateNodeErr = true;
                                }
                                if (!this.isHitCreateNodeErr) break;
                                if (this.context.getEnableException()) {
                                    object = ((ComparisonExpr)xSLExprBase).getRefinedNormalizedExpr();
                                    if (bl4 && object != null && ((String)object).length() > 0 && ((String)object).startsWith("/")) {
                                        object = ((String)object).replace("/", "@");
                                    }
                                    throw new XPathException(23057, (String)object);
                                }
                                return false;
                            }
                            xMLElement = XPathAxis.addAttribute(xMLElement, xSLExprBase, this.context);
                            break;
                        }
                        ++n3;
                    }
                }
            }
            return bl2;
        }
        if (this.context.getEnableException()) {
            if (this.context.getXPathContext() == null) {
                return false;
            }
            Node node = null;
            node = xMLNode != null && bl ? xMLNode.getParentNode() : xMLNode;
            int n = ((XMLElement)node).getChildrenByTagName(this.step.name, this.step.nameSpace).getLength();
            int n7 = 1;
            if (this.step.predicates != null && this.step.predicates.getPositionTest() > 0) {
                n7 = this.step.predicates.getPositionTest();
            }
            if (n7 > n) {
                XPathError xPathError = new XPathError();
                xPathError.setMissingNode(new QName(this.step.nameSpace, this.step.name));
                xPathError.setXpath(this.createXPath());
                if (node != null && node instanceof XMLDocument) {
                    this.context.getXPathContext().setError(xPathError);
                } else if (node != null && node instanceof XMLElement) {
                    if (this.step.predicates != null && this.step.predicates.getPositionTest() != 0) {
                        xPathError.setPosition(this.step.predicates.getPositionTest());
                    }
                    xPathError.setParentNode(new QName(((XMLElement)node).getNamespaceURI(), ((XMLElement)node).getLocalName()));
                    this.context.getXPathContext().setError(xPathError);
                }
            }
        }
        return false;
    }

    private String createXPath() {
        String string = "";
        String string2 = "";
        StreamNodeSequence streamNodeSequence = this;
        do {
            if (streamNodeSequence.step == null) continue;
            string2 = "/" + streamNodeSequence.step.name;
            if (streamNodeSequence.step.predicates != null && streamNodeSequence.step.predicates.getPositionTest() > 0) {
                string2 = string2 + "[" + streamNodeSequence.step.predicates.getPositionTest() + "]";
            }
            string = string2 + string;
        } while ((streamNodeSequence = streamNodeSequence.ctxSeq) != null);
        return string;
    }

    @Override
    public XMLNode getNode() {
        return this.curNode;
    }
}

