/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class XPathCompatibiltyExpr
extends XSLExprBase {
    boolean conversion = false;
    boolean numberConv = false;
    boolean atomize = false;
    OXMLSequenceType eType;

    XPathCompatibiltyExpr(XSLExprBase xSLExprBase, boolean bl, boolean bl2) {
        this.leftExpr = xSLExprBase;
        this.conversion = bl;
        this.numberConv = bl2;
    }

    XPathCompatibiltyExpr(XSLExprBase xSLExprBase, OXMLSequenceType oXMLSequenceType) {
        this.leftExpr = xSLExprBase;
        this.eType = oXMLSequenceType;
        this.conversion = false;
        this.numberConv = false;
        if (this.eType == OXMLSequenceType.ANYATOMIC_ZERO_OR_ONE) {
            this.atomize = true;
        }
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.leftExpr.evaluate(xPathRuntimeContext);
        XPathItem xPathItem = ((XPathSequence)xPathRuntimeContext.peekExprValue()).retainFirstItem();
        if (this.conversion) {
            if (xPathItem == null) {
                xPathItem = (XPathItem)xPathRuntimeContext.createItem();
                if (this.numberConv) {
                    xPathItem.setDouble(OXMLSequenceType.TDOUBLE, Double.NaN);
                } else {
                    xPathItem.setString(OXMLSequenceType.TSTRING, "");
                }
                ((XPathSequence)xPathRuntimeContext.peekExprValue()).appendItem(xPathItem);
            }
            if (!this.numberConv || xPathItem.isNode()) {
                xPathItem.setString(OXMLSequenceType.TSTRING, xPathItem.getLexicalValue());
            }
            if (this.numberConv) {
                xPathItem.convert2Double();
            }
        } else {
            XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.peekExprValue();
            if (this.atomize) {
                xPathSequence.atomizeInPlace();
            } else if (!xPathSequence.isOfType(this.eType)) {
                throw new XPathException(23006);
            }
        }
    }

    @Override
    int checkPosLastFN() {
        if (this.flag < 0) {
            this.flag = this.leftExpr.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        return "";
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    @Override
    void cacheSubExpr() {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }
}

