/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import oracle.xml.parser.v2.XMLByteReader;

class XMLUCS4Reader
extends XMLByteReader {
    boolean surrogate = false;

    XMLUCS4Reader(InputStream inputStream, String string, String string2) {
        super(inputStream, string, string2);
    }

    @Override
    void reset() {
        this.surrogate = false;
        super.reset();
    }

    @Override
    void fillBuffer() throws IOException {
        while (true) {
            try {
                while (true) {
                    if (this.byteIndex >= this.eofIndex) {
                        this.setEOF(this.endPos);
                        return;
                    }
                    this.charBuffer[this.endPos] = this.nextChar();
                    this.byteIndex += 4;
                    ++this.endPos;
                    ++this.charsRead;
                    if (this.charBuffer[this.endPos - 1] != '\r' && this.charBuffer[this.endPos - 1] != '\n') continue;
                    char c = this.charBuffer[this.endPos - 1];
                    this.setLineNumber(this.endPos - 1);
                    this.charBuffer[this.endPos - 1] = 10;
                    this.charBuffer[this.endPos] = this.nextChar();
                    this.byteIndex += 4;
                    if (c != '\r' || this.charBuffer[this.endPos] == '\n') continue;
                    ++this.endPos;
                    ++this.charsRead;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.endPos < this.BUFSIZE) {
                    this.fillByteBuffer();
                    continue;
                }
                return;
            }
            break;
        }
    }

    char nextChar() throws IOException {
        int n = (this.byteBuffer[this.byteIndex + this.first] & 0xFF) << 24 | (this.byteBuffer[this.byteIndex + this.second] & 0xFF) << 16 | (this.byteBuffer[this.byteIndex + this.third] & 0xFF) << 8 | this.byteBuffer[this.byteIndex + this.fourth] & 0xFF;
        if (n >= 55296 && n < 57344 || n > 0x10FFFF) {
            String string = this.err.getMessage1(171, Integer.toHexString(n));
            throw new IOException(string);
        }
        if (n >= 65536) {
            if (!this.surrogate) {
                n = (n - 65536 >> 10) + 55296;
                this.surrogate = true;
                this.byteIndex -= 4;
            } else {
                n = (n - 65536 & 0x3FF) + 56320;
                this.surrogate = false;
            }
        }
        if (n == 65535 || n == 65534) {
            String string = this.err.getMessage1(171, Integer.toHexString(n));
            throw new IOException(string);
        }
        return (char)n;
    }

    @Override
    void setByteOrder(int n) {
        this.byteOrder = n;
        if (n == 1) {
            this.first = 3;
            this.second = 2;
            this.third = 1;
            this.fourth = 0;
        } else if (n == 3) {
            this.first = 1;
            this.second = 0;
            this.third = 3;
            this.fourth = 2;
        } else if (n == 4) {
            this.first = 2;
            this.second = 3;
            this.third = 0;
            this.fourth = 1;
        }
    }
}

