/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.ArrayList;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.PageManager;
import oracle.xml.util.ArrayPool;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLSort;
import oracle.xml.xslt.XSLTContext;

public class PagedNodeList {
    InfosetReader reader;
    PageManager pageMgr;
    XMLElement parent;
    ArrayList<XMLNode> parentList;
    ArrayList pageIds;
    int pageNo;
    int startPage;
    int nodeListLen;
    int[] idxList;
    int idxLen;
    XMLNode currentNode;
    byte[] buf;
    int bufindex;
    int bufsize;
    byte[] sortbuf1;
    byte[] sortbuf2;
    Object[] keyArray;
    int keyIndex;
    XSLSort sort;
    XSLTContext context;
    InfosetReader.Offset[] keyOffset;
    private static final ArrayPool arrPool = new ArrayPool(65536);

    public PagedNodeList(PageManager pageManager, InfosetReader infosetReader, XMLElement xMLElement) {
        this.pageMgr = pageManager;
        this.reader = infosetReader;
        this.pageIds = new ArrayList();
        this.buf = arrPool.allocByteArr();
        this.bufindex = 0;
        this.nodeListLen = 0;
        this.startPage = 0;
        this.parent = xMLElement;
        this.parentList = null;
    }

    public void setSort(XSLTContext xSLTContext, XSLSort xSLSort) {
        this.sort = xSLSort;
        this.context = xSLTContext;
        this.keyIndex = 0;
        this.keyArray = new Object[this.buf.length / 8];
        this.keyOffset = new InfosetReader.Offset[this.buf.length / 8];
    }

    public void addNode(XMLNode xMLNode) {
        byte by;
        InfosetReader.Offset offset = xMLNode.xdkGetOffset();
        XMLElement xMLElement = (XMLElement)xMLNode.getParentNode();
        if (xMLElement != this.parent) {
            if (this.parentList == null) {
                this.parentList = new ArrayList();
            }
            this.parentList.add(this.parent);
            this.parent = xMLElement;
        }
        if ((by = this.reader.offsetToBytes(offset, this.buf, this.bufindex + 1)) == -1) {
            this.flushPage();
            by = this.reader.offsetToBytes(offset, this.buf, this.bufindex + 1);
        }
        this.buf[this.bufindex] = by;
        this.bufindex += by + 1;
        ++this.nodeListLen;
    }

    public void addNode(XMLNode xMLNode, Object object) {
        int n;
        int n2;
        if (this.keyIndex >= this.keyArray.length) {
            for (n2 = 0; n2 < this.keyIndex && (n = this.reader.offsetToBytes(this.keyOffset[n2], this.buf, this.bufindex + 1)) != -1; ++n2) {
                this.buf[this.bufindex] = n;
                this.bufindex += n + 1;
            }
            this.flushPage();
            if (n2 < this.keyIndex) {
                this.keyIndex -= n2;
                System.arraycopy(this.keyArray, n2, this.keyArray, 0, this.keyIndex);
                System.arraycopy(this.keyOffset, n2, this.keyOffset, 0, this.keyIndex);
            } else {
                this.keyIndex = 0;
            }
        }
        n2 = 0;
        int n3 = 0;
        int n4 = this.keyIndex;
        while (n3 < n4) {
            n2 = (n3 + n4) / 2;
            n = this.sort.compareObjects(this.keyArray[n2], object);
            if (n > 0) {
                n4 = n2;
                continue;
            }
            n3 = n2 + 1;
        }
        if (n4 < this.keyIndex) {
            System.arraycopy(this.keyArray, n4, this.keyArray, n4 + 1, this.keyIndex - n4);
            System.arraycopy(this.keyOffset, n4, this.keyOffset, n4 + 1, this.keyIndex - n4);
        }
        this.keyArray[n4] = object;
        this.keyOffset[n4] = xMLNode.xdkGetOffset();
        ++this.keyIndex;
        ++this.nodeListLen;
    }

    public void finishSort() throws XSLException {
        int n;
        if (this.keyIndex > 0) {
            for (int i = 0; i < this.keyIndex; ++i) {
                n = this.reader.offsetToBytes(this.keyOffset[i], this.buf, this.bufindex + 1);
                if (n == -1) {
                    this.flushPage();
                    n = this.reader.offsetToBytes(this.keyOffset[i], this.buf, this.bufindex + 1);
                }
                this.buf[this.bufindex] = n;
                this.bufindex += n + 1;
            }
            this.flushPage();
            this.keyIndex = 0;
        }
        this.sortbuf1 = arrPool.allocByteArr();
        this.sortbuf2 = arrPool.allocByteArr();
        this.idxLen = this.pageIds.size();
        this.idxList = new int[this.idxLen + 1];
        for (n = 0; n < this.idxLen; ++n) {
            this.idxList[n] = n + 1;
        }
        this.startPage = 0;
        this.pageSort();
        arrPool.freeByteArr(this.sortbuf1);
        arrPool.freeByteArr(this.sortbuf2);
    }

    void pageSort() throws XSLException {
        int n = 0;
        int n2 = this.startPage;
        this.startPage = this.pageIds.size();
        for (int i = 0; i < this.idxLen; i += 2) {
            int n3 = this.idxList[i];
            int n4 = n3 - n2;
            int n5 = 0;
            if (i < this.idxLen - 1) {
                n5 = this.idxList[i + 1] - n3;
                this.sortPages(n2, n3, n4, n5);
            } else {
                while (n2 < n3) {
                    this.pageIds.add(this.pageIds.get(n2++));
                }
            }
            this.idxList[n] = this.pageIds.size();
            ++n;
            n2 = this.idxList[i + 1];
        }
        this.idxLen = n;
        if (n > 1) {
            this.pageSort();
        }
    }

    void sortPages(int n, int n2, int n3, int n4) throws XSLException {
        block11: {
            InfosetReader.Offset offset;
            byte by;
            XMLNode xMLNode;
            int n5;
            int n6;
            block10: {
                n6 = 0;
                int n7 = 0;
                n5 = 0;
                int n8 = 0;
                xMLNode = null;
                XMLNode xMLNode2 = null;
                String string = null;
                String string2 = null;
                PageManager.PageId pageId = (PageManager.PageId)this.pageIds.get(n++);
                n5 = this.pageMgr.readPage(pageId, this.sortbuf1, 0);
                by = this.sortbuf1[n6];
                offset = this.reader.offsetFromBytes(this.sortbuf1, n6 + 1);
                xMLNode = this.parent.createChildFromOffset(offset);
                string = this.sort.getKeyValue(this.context, xMLNode);
                --n3;
                pageId = (PageManager.PageId)this.pageIds.get(n2++);
                n8 = this.pageMgr.readPage(pageId, this.sortbuf2, 0);
                byte by2 = this.sortbuf2[n7];
                offset = this.reader.offsetFromBytes(this.sortbuf2, n7 + 1);
                xMLNode2 = this.parent.createChildFromOffset(offset);
                string2 = this.sort.getKeyValue(this.context, xMLNode2);
                --n4;
                while (true) {
                    if (this.sort.compareObjects(string, string2) <= 0) {
                        this.addNode(xMLNode);
                        if ((n6 += by + 1) >= n5) {
                            if (n3 == 0) {
                                n3 = -1;
                                break;
                            }
                            pageId = (PageManager.PageId)this.pageIds.get(n++);
                            n5 = this.pageMgr.readPage(pageId, this.sortbuf1, 0);
                            n6 = 0;
                            --n3;
                        }
                        by = this.sortbuf1[n6];
                        offset = this.reader.offsetFromBytes(this.sortbuf1, n6 + 1);
                        xMLNode = this.parent.createChildFromOffset(offset);
                        string = this.sort.getKeyValue(this.context, xMLNode);
                        continue;
                    }
                    this.addNode(xMLNode2);
                    if ((n7 += by2 + 1) >= n8) {
                        if (n4 == 0) {
                            n4 = -1;
                            break;
                        }
                        pageId = (PageManager.PageId)this.pageIds.get(n2++);
                        n8 = this.pageMgr.readPage(pageId, this.sortbuf2, 0);
                        n7 = 0;
                        --n4;
                    }
                    by2 = this.sortbuf2[n7];
                    offset = this.reader.offsetFromBytes(this.sortbuf2, n7 + 1);
                    xMLNode2 = this.parent.createChildFromOffset(offset);
                    string2 = this.sort.getKeyValue(this.context, xMLNode2);
                }
                if (n3 != -1) break block10;
                while (true) {
                    this.addNode(xMLNode2);
                    if ((n7 += by2 + 1) >= n8) break;
                    by2 = this.sortbuf2[n7];
                    offset = this.reader.offsetFromBytes(this.sortbuf2, n7 + 1);
                    xMLNode2 = this.parent.createChildFromOffset(offset);
                }
                this.flushPage();
                for (int i = n4; i > 0; --i) {
                    this.pageIds.add(this.pageIds.get(n2));
                    ++n2;
                }
                break block11;
            }
            if (n4 != -1) break block11;
            while (true) {
                this.addNode(xMLNode);
                if ((n6 += by + 1) >= n5) break;
                by = this.sortbuf1[n6];
                offset = this.reader.offsetFromBytes(this.sortbuf1, n6 + 1);
                xMLNode = this.parent.createChildFromOffset(offset);
            }
            this.flushPage();
            for (int i = n3; i > 0; --i) {
                this.pageIds.add(this.pageIds.get(n));
                ++n;
            }
        }
    }

    public void flushPage() {
        if (this.bufindex != 0) {
            PageManager.PageId pageId = this.pageMgr.writePage(this.buf, 0, this.bufindex);
            this.pageIds.add(pageId);
            this.bufindex = 0;
        }
    }

    public void start() {
        this.pageNo = this.startPage;
        this.readPage();
    }

    public void reset() {
        this.pageIds = null;
        arrPool.freeByteArr(this.buf);
    }

    void readPage() {
        PageManager.PageId pageId = (PageManager.PageId)this.pageIds.get(this.pageNo);
        this.bufsize = this.pageMgr.readPage(pageId, this.buf, 0);
        this.bufindex = 0;
    }

    private XMLNode getParent(InfosetReader.Offset offset) {
        if (this.parentList == null) {
            return this.parent;
        }
        int n = this.parentList.size();
        int n2 = 0;
        int n3 = n / 2;
        XMLNode xMLNode = null;
        while (n3 != n2) {
            xMLNode = this.parentList.get(n3);
            InfosetReader.Offset offset2 = xMLNode.xdkGetOffset();
            if (offset.compareTo(offset2) > 0) {
                n2 = n3;
                n3 += (n - n2) / 2;
                continue;
            }
            n = n3;
            n3 += (n - n2) / 2;
        }
        return this.parentList.get(n3);
    }

    public boolean next() {
        if (this.bufindex >= this.bufsize) {
            ++this.pageNo;
            if (this.pageNo >= this.pageIds.size()) {
                this.currentNode = null;
                return false;
            }
            this.readPage();
        }
        byte by = this.buf[this.bufindex++];
        InfosetReader.Offset offset = this.reader.offsetFromBytes(this.buf, this.bufindex);
        this.bufindex += by;
        this.currentNode = this.getParent(offset).createChildFromOffset(offset);
        return true;
    }

    public XMLNode getNode() {
        return this.currentNode;
    }

    public int getLength() {
        return this.nodeListLen;
    }
}

