/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import oracle.jdbc.internal.OracleConnection;
import oracle.xdb.spi.XDBResourceContext;

public class XDBContextFactory
implements InitialContextFactory {
    public static String RETURN_OBJECT_TYPE = "ReturnObjectType";
    public static String RETURN_TYPE_RESOURCE = "Resource";
    public static String ENV_CONNECTION = "Connection";

    public Context getInitialContext(Hashtable env) throws NamingException {
        try {
            String osName;
            OracleConnection conn = (OracleConnection)env.get(ENV_CONNECTION);
            if (conn != null && (conn.getProtocolType().equals("oci8") || conn.getProtocolType().equals("oci")) && (osName = System.getProperty("os.name")).toUpperCase().startsWith("WINDOWS")) {
                System.loadLibrary("orageneric18");
                System.loadLibrary("oraclient18");
            }
            return new XDBResourceContext(env);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw new ServiceUnavailableException("SQL Error: " + ((SQLException)e).getErrorCode());
            }
            throw (NamingException)e;
        }
    }
}

