/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.OracleFileWalletImpl;
import oracle.security.pki.OraclePKIDebug;

public class FileLocker {
    private static final String b = "pki_data";
    private static final String c = ".lck";
    private RandomAccessFile d;
    private String e;
    private FileChannel f;
    private FileLock g;
    private static File h;
    static ResourceBundle a;

    public FileLocker(String string) throws IOException {
        block3: {
            this.d = null;
            this.e = string;
            FileLocker.a("FileLocker.FileLocker(): enter");
            File file = FileLocker.b(string);
            File file2 = new File(string);
            FileLocker.a("FileLocker.FileLocker(): Lock file Absolute location: " + file.getAbsolutePath());
            FileLocker.a("FileLocker.FileLocker(): Lock file Canonical location: " + file.getCanonicalPath());
            try {
                if (!file.exists()) {
                    FileLocker.a(file, file2);
                }
            }
            catch (IOException iOException) {
                file = FileLocker.c(string);
                FileLocker.a("FileLocker.FileLocker(): Alternate file location" + file.getCanonicalPath());
                if (file.exists()) break block3;
                FileLocker.a(file, file2);
            }
        }
        FileLocker.a("FileLocker.FileLocker(): exit");
    }

    private static void a(File file, File file2) throws IOException {
        FileLocker.a("FileLocker.createLockFile(): enter");
        file.createNewFile();
        FileLocker.a("Lock file does not exist, so created a new wallet lock file");
        if (file.exists()) {
            if (file2.exists()) {
                OracleFileWalletImpl.a(file2, file);
            } else {
                OracleFileWalletImpl.a(file);
            }
        }
        FileLocker.a("FileLocker.createLockFile(): exit");
    }

    private static File b(String string) {
        FileLocker.a("FileLocker.getLockFile(): Lock file location: " + string + c);
        return new File(string + c);
    }

    private static File c(String string) {
        FileLocker.a("FileLocker.getAltLockFile(): Alternate lock file location: pki_data" + string.hashCode() + c);
        return new File(h, b + string.hashCode() + c);
    }

    public FileLocker(File file) throws IOException {
        this(file.getCanonicalPath());
        FileLocker.a("FileLocker.FileLocker(): lock file: " + file.getCanonicalPath());
    }

    public boolean lock(boolean bl) throws IOException {
        String string = "Unknown reason";
        boolean bl2 = false;
        FileLocker.a("FileLocker.lock(): enter");
        try {
            File file = FileLocker.b(this.e);
            bl2 = this.a(file, bl);
            FileLocker.a("FileLocker.lock(): exit");
            return bl2;
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            FileLocker.a("FileLocker.lock(): mesg: " + string);
            try {
                File file = FileLocker.c(this.e);
                bl2 = this.a(file, bl);
                FileLocker.a("FileLocker.lock(): exit");
                return bl2;
            }
            catch (IOException iOException2) {
                string = "Failed to lock...\n attempt 1: " + string + "\n attempt 2: " + iOException2.getMessage();
                if (OraclePKIDebug.getDebugFlag()) {
                    iOException.printStackTrace();
                }
                throw new IOException(string);
            }
        }
    }

    private boolean a(File file, boolean bl) throws IOException {
        FileLocker.a("FileLocker.getlock(): enter");
        FileLocker.a("FileLocker.getlock(): lkfile: " + file.getCanonicalPath());
        try {
            if (bl) {
                FileLocker.a("FileLocker.getlock(): Creating Random Access File with read/write permission");
                this.d = new RandomAccessFile(file, "rw");
                this.f = this.d.getChannel();
                this.g = FileLockProvider.a(file, this.f);
            } else {
                FileLocker.a("FileLocker.getlock(): Creating Random Access File with read permission");
                this.d = new RandomAccessFile(file, "r");
                this.f = this.d.getChannel();
                this.g = FileLockProvider.a(file, this.f, 0L, 0L, true);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileLocker.a("FileLocker.getlock(): Lock file = " + file + ", exclusive = " + (bl ? 1 : 0));
            throw new IOException(fileNotFoundException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            if (this.f != null) {
                this.f.close();
                this.f = null;
            }
            if (this.d != null) {
                this.d.close();
                this.d = null;
            }
            FileLocker.a("FileLocker.getlock(): exit");
            return false;
        }
        FileLocker.a("FileLocker.getlock(): exit");
        return this.g != null && this.g.isValid();
    }

    public void unlock() throws IOException {
        FileLocker.a("FileLocker.unlock(): entry");
        if (this.g != null) {
            this.g.release();
            this.g = null;
        }
        if (this.f != null) {
            this.f.close();
            this.f = null;
        }
        if (this.d != null) {
            this.d.close();
            this.d = null;
        }
        FileLocker.a("FileLocker.unlock(): exit");
    }

    static void a(String string) {
        OraclePKIDebug.a(string);
    }

    static {
        a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
        h = AccessController.doPrivileged(new PrivilegedAction<File>(){

            public File a() {
                return new File(System.getProperty("java.io.tmpdir"));
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        });
    }
}

