/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert.ext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.util.Utils;

public class IssuerAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID f = PKIX.G;
    private ArrayList<GeneralName> g = new ArrayList();

    public IssuerAltNameExtension() {
        super(f);
    }

    public IssuerAltNameExtension(GeneralName generalName) throws IOException {
        this(generalName, false);
    }

    public IssuerAltNameExtension(GeneralName generalName, boolean bl) throws IOException {
        super(f, bl);
        this.g.add(generalName);
        this.a(this.f());
    }

    public IssuerAltNameExtension(List<GeneralName> list) throws IOException {
        this(list, false);
    }

    public IssuerAltNameExtension(List<GeneralName> list, boolean bl) throws IOException {
        super(f, bl);
        this.g = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<GeneralName>(list));
        this.a(this.f());
    }

    public IssuerAltNameExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public ArrayList<GeneralName> e() {
        if (!this.e) {
            this.g();
        }
        return this.g;
    }

    public void a(GeneralName generalName) throws IOException {
        this.g.add(generalName);
        this.a(this.f());
    }

    private byte[] f() throws IOException {
        byte[] byArray = Utils.toBytes(new ASN1Sequence((ASN1Object)((Object)this.g)));
        this.e = true;
        return byArray;
    }

    private void g() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.d());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(byteArrayInputStream);
            this.g = new ArrayList();
            while (aSN1SequenceInputStream.a()) {
                this.g.add(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.b();
            if (this.g.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.e = true;
    }

    @Override
    public String toString() {
        if (!this.e) {
            this.g();
        }
        StringBuffer stringBuffer = new StringBuffer("issuerAltNameExtension {oid = " + f.d() + ", critical = " + this.c() + ", value = [");
        if (this.g != null) {
            stringBuffer.append("issuerAltNames = {");
            boolean bl = false;
            int n = this.g.size();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.g.get(i).toString());
                bl = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

