/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Base64;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.util.Utils;

public final class OraclePKIX509CertReqHelper {
    private static final String a = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String b = "-----END NEW CERTIFICATE REQUEST-----";

    public static final ByteArrayInputStream readB64CertReqFrom(String string) throws IOException {
        CertificateRequest certificateRequest = OraclePKIX509CertReqHelper.readB64CertReqFrom(new StringReader(string));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output(byteArrayOutputStream);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static final CertificateRequest readB64CertReqFrom(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.startsWith(a)) {
                bl = true;
                stringBuffer.append(string.substring(a.length()));
                break;
            }
            string = bufferedReader.readLine();
        }
        if (!bl) {
            throw new IOException();
        }
        string = bufferedReader.readLine();
        while (string != null) {
            if (string.indexOf(b) != -1) {
                bl2 = true;
                stringBuffer.append(string.substring(0, string.indexOf(b)));
                break;
            }
            stringBuffer.append(string);
            string = bufferedReader.readLine();
        }
        if (!bl2) {
            throw new IOException();
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != ' ') continue;
            stringBuffer.deleteCharAt(i);
        }
        return new CertificateRequest(new ByteArrayInputStream(Base64.getMimeDecoder().decode(stringBuffer.toString())));
    }

    public static final void writeB64X509CertReqTo(Writer writer, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output(byteArrayOutputStream);
        String string = Utils.getBase64EncodedCert(byteArrayOutputStream.toByteArray(), a, b);
        writer.write(string);
        writer.close();
    }

    public static final String addCertReqHeaderFooter(String string) throws IOException {
        String string2 = null;
        string2 = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + string + "\n" + b;
        return string2;
    }

    public static final String removeCertReqHeaderFooter(String string) throws IOException {
        String string2 = null;
        if (!string.startsWith(a) || !string.endsWith(b)) {
            throw new IOException("No header or footer in B64 cert");
        }
        string2 = string.substring(a.length(), string.length() - b.length());
        return string2;
    }
}

