/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SimpleTimeZone;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.cert.PKCS7;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.FixedByteArrayOutputStream;
import oracle.security.pki.util.InvalidFormatException;
import oracle.security.pki.util.Streamable;
import oracle.security.pki.util.StreamableOutputException;

public class Utils {
    private static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public static void setArray(byte[] byArray, byte by) {
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = by;
        }
    }

    public static void setArray(byte[] byArray, int n, int n2, byte by) {
        if (byArray == null) {
            return;
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byArray[i] = by;
        }
    }

    public static void charsToBytes(char[] cArray, byte[] byArray) {
        int n = 0;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            byArray[n++] = (byte)(cArray[i] >> 8);
            byArray[n++] = (byte)cArray[i];
        }
    }

    public static byte[] unicodeToBytes(String string) {
        char[] cArray = new char[string.length()];
        byte[] byArray = new byte[cArray.length << 1];
        string.getChars(0, cArray.length, cArray, 0);
        Utils.charsToBytes(cArray, byArray);
        return byArray;
    }

    public static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static void toByteArray(BigInteger bigInteger, byte[] byArray, int n, int n2) throws ArithmeticException {
        byte[] byArray2 = Utils.toByteArray(bigInteger);
        if (byArray2.length > n2) {
            throw new ArithmeticException("The argument is too big to fit in the destination buffer");
        }
        Utils.setArray(byArray, n, n2, (byte)0);
        System.arraycopy(byArray2, 0, byArray, n + (n2 - byArray2.length), byArray2.length);
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static String fromUTF8(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = byArray[i] & 0xFF;
            if (n4 < 128) {
                stringBuffer.append((char)n4);
                continue;
            }
            if ((n4 & 0xE0) == 192) {
                if (i == byArray.length - 1) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                if (((n3 = byArray[++i] & 0xFF) & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n4 & 0x1F) << 6 | n3 & 0x3F));
                continue;
            }
            if ((n4 & 0xF0) == 224) {
                if (i >= byArray.length - 2) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n3 = byArray[++i] & 0xFF;
                n2 = byArray[++i] & 0xFF;
                if ((n3 & 0xC0) != 128 || (n2 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n4 & 0xF) << 12 | (n3 & 0x3F) << 6 | n2 & 0x3F));
                continue;
            }
            if ((n4 & 0xF8) == 240) {
                if (i >= byArray.length - 3) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n3 = byArray[++i] & 0xFF;
                n2 = byArray[++i] & 0xFF;
                int n5 = byArray[++i] & 0xFF;
                if ((n3 & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n5 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                int n6 = ((n4 & 1) << 20 | (n3 & 0x3F) << 12 | (n2 & 0x3F) << 6 | n5 & 0x3F) - 65536;
                stringBuffer.append((char)(55296 + (n6 >> 10)));
                stringBuffer.append((char)(56320 + (n6 & 0x3FF)));
                continue;
            }
            throw new InvalidFormatException("Illegal UTF encoding");
        }
        return stringBuffer.toString();
    }

    public static byte[] toUTF8(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byteArrayOutputStream.write((byte)c);
                continue;
            }
            if (c < '\u0800') {
                byteArrayOutputStream.write(0xC0 | c >> 6);
                byteArrayOutputStream.write(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\ud800' && c < '\udc00' && i != string.length() - 1 && string.charAt(i + 1) >= '\udc00' && string.charAt(i + 1) < '\ue000') {
                int n2 = c - 55296 << 10 + (string.charAt(i + 1) - 56320) + 65536;
                byteArrayOutputStream.write(0xF0 | n2 >> 18);
                byteArrayOutputStream.write(0x80 | n2 >> 12 & 0x3F);
                byteArrayOutputStream.write(0x80 | n2 >> 6 & 0x3F);
                byteArrayOutputStream.write(0x80 | n2 & 0x3F);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | c >> 12);
            byteArrayOutputStream.write(0x80 | c >> 6 & 0x3F);
            byteArrayOutputStream.write(0x80 | c & 0x3F);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte inputByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public static byte[] inputBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        return Utils.inputByteArray(byArray, inputStream);
    }

    public static byte[] inputByteArray(byte[] byArray, InputStream inputStream) throws IOException {
        Utils.inputByteArray(byArray, 0, byArray.length, inputStream);
        return byArray;
    }

    public static void inputByteArray(byte[] byArray, int n, int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4 = n + n2;
        for (int i = n; i < n4; i += n3) {
            n3 = inputStream.read(byArray, i, n4 - i);
            if (n3 != -1) continue;
            throw new IOException("End of stream reached before all " + n2 + " expected bytes could be read. Only received " + (i - n) + " bytes before the end of the stream was reached");
        }
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            stringBuffer.append(string.charAt((byArray[i] & 0xFF) >> 4));
            stringBuffer.append(string.charAt(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Utils.toHexString(byArray, 0, byArray.length);
    }

    public static byte[] fromHexString(String string) {
        if (string.length() % 2 != 0) {
            throw new NumberFormatException("malformed hex string (non-even length)");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = string.length() / 2;
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    static int a(String string, int n) {
        return 10 * (string.charAt(n) - 48) + (string.charAt(n + 1) - 48);
    }

    public static Date parseDate(String string) {
        return Utils.parseDate(string, false);
    }

    public static Date parseDate(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = -2;
        int n2 = 0;
        if (bl || string.indexOf(90) == 14 || string.indexOf(43) == 14 || string.indexOf(45) == 14) {
            n2 = 100 * Utils.a(string, n += 2);
            n2 += Utils.a(string, n += 2);
        } else {
            n2 = 1900 + Utils.a(string, n += 2);
            if (n2 < 1950) {
                n2 += 100;
            }
        }
        int n3 = Utils.a(string, n += 2);
        int n4 = Utils.a(string, n += 2);
        int n5 = Utils.a(string, n += 2);
        int n6 = Utils.a(string, n += 2);
        int n7 = 0;
        if (string.charAt(n + 2) >= '0' && string.charAt(n + 2) <= '9') {
            n7 = Utils.a(string, n += 2);
        }
        int n8 = 0;
        if (string.charAt(n += 2) != 'Z') {
            int n9 = Utils.a(string, n + 1);
            int n10 = Utils.a(string, n + 3);
            n8 = (n9 * 60 + n10) * 60 * 1000;
            if (string.charAt(n) == '-') {
                n8 = -n8;
            }
        }
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n8, "");
        Calendar calendar = Calendar.getInstance(simpleTimeZone);
        calendar.set(n2, n3 - 1, n4, n5, n6, n7);
        return calendar.getTime();
    }

    static String a(int n) {
        String string = Integer.toString(n);
        if (string.length() == 2) {
            return string;
        }
        return "0" + string;
    }

    public static Date daysFrom(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static Date daysFromNow(int n) {
        return Utils.daysFrom(new Date(), n);
    }

    public static String formatDate(Date date, boolean bl) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, ""));
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(Utils.a(gregorianCalendar.get(1) / 100));
        }
        stringBuffer.append(Utils.a(gregorianCalendar.get(1) % 100));
        stringBuffer.append(Utils.a(gregorianCalendar.get(2) + 1));
        stringBuffer.append(Utils.a(gregorianCalendar.get(5)));
        int n = gregorianCalendar.get(10);
        if (gregorianCalendar.get(9) == 1) {
            n += 12;
        }
        stringBuffer.append(Utils.a(n));
        stringBuffer.append(Utils.a(gregorianCalendar.get(12)));
        stringBuffer.append(Utils.a(gregorianCalendar.get(13)));
        return stringBuffer.append("Z").toString();
    }

    public static byte[] toBytes(Streamable streamable) {
        try {
            FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(streamable.length());
            streamable.output(fixedByteArrayOutputStream);
            return fixedByteArrayOutputStream.getBytes();
        }
        catch (IOException iOException) {
            throw new StreamableOutputException(iOException);
        }
    }

    public static InputStream toStream(Streamable streamable) {
        return new ByteArrayInputStream(Utils.toBytes(streamable));
    }

    public static int hashBytes(Streamable streamable) {
        return new String(Utils.toBytes(streamable)).hashCode();
    }

    public static String toString(List<?> list) {
        if (list == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(list.get(i).toString());
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static String bytesToReadable(byte[] byArray) {
        try {
            String string = new String(byArray, StandardCharsets.UTF_8);
            if (string.chars().allMatch(n -> n >= 32 && n <= 126)) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Base64.getEncoder().encodeToString(byArray);
    }

    public static String getBase64EncodedCert(byte[] byArray, String string, String string2) {
        byte[] byArray2 = System.getProperty("line.separator").getBytes();
        String string3 = string + "\n" + Base64.getMimeEncoder(64, byArray2).encodeToString(byArray) + "\n" + string2;
        return string3;
    }

    public static byte[] getPKCS7EncodedCertificate(X509 x509) {
        PKCS7 pKCS7 = new PKCS7();
        pKCS7.a(x509);
        return pKCS7.f();
    }

    public static String getSubjectDNFromKey(Key key, String string) {
        CertificateRequest certificateRequest = null;
        if (string == "RSA") {
            certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
        } else if (string == "EC") {
            certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
        }
        return certificateRequest.e().toString();
    }

    public static String getSignAlgFromKey(Key key, String string) {
        CertificateRequest certificateRequest = null;
        if (string == "RSA") {
            certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
        } else if (string == "EC") {
            certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
        }
        return CryptoUtils.getSignatureAlg(certificateRequest.g());
    }

    public static ArrayList<X509> ValidateCertificateData(byte[] byArray) {
        ArrayList<X509> arrayList = new ArrayList<X509>();
        try {
            arrayList.add(new X509(byArray));
        }
        catch (IOException iOException) {
            try {
                arrayList = new PKCS7(new ByteArrayInputStream(byArray)).a();
            }
            catch (IOException iOException2) {
                StringReader stringReader = new StringReader(new String(byArray));
                try {
                    arrayList.addAll(OraclePKIX509CertHelper.readB64X509CertsFrom(stringReader));
                }
                catch (IOException iOException3) {
                    try {
                        stringReader.reset();
                        arrayList = OraclePKIX509CertHelper.readB64X509PKCS7From(stringReader);
                    }
                    catch (IOException iOException4) {
                        return null;
                    }
                }
            }
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList;
    }

    public static void validateSpaceAvailableForWallet(long l, int n) throws IOException {
        long l2;
        FileStore fileStore = Files.getFileStore(Paths.get("", new String[0]));
        long l3 = fileStore.getUsableSpace();
        if (l3 < (l2 = l * 2L + (long)n)) {
            throw new IOException(a.getString("PKI-02024"));
        }
    }

    private static boolean a(X509Certificate x509Certificate, String string) {
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        return set != null && set.contains(string);
    }

    private static void a(String string) throws CertificateException {
        String string2 = a.getString("PKI-04030") + " " + string;
        throw new CertificateException(string2);
    }

    public static void trustedCertificateValidation(String string, boolean bl) throws CertificateException {
        CertificateFactory certificateFactory = null;
        X509Certificate x509Certificate = null;
        certificateFactory = CertificateFactory.getInstance("X.509");
        try {
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(string));
        }
        catch (FileNotFoundException | CertificateException exception) {
            throw new CertificateException("Certificate generation failed");
        }
        Utils.trustedCertificateValidation(x509Certificate, bl);
    }

    public static void trustedCertificateValidation(X509Certificate x509Certificate, boolean bl) throws CertificateException {
        block16: {
            String string = "2.5.29.19";
            String string2 = "2.5.29.35";
            String string3 = "2.5.29.14";
            try {
                int n = x509Certificate.getVersion();
                if (n == 1) {
                    return;
                }
                if (n == 3) {
                    byte[] byArray;
                    boolean bl2;
                    Collection<List<?>> collection;
                    int n2;
                    byte[] byArray2 = x509Certificate.getExtensionValue(string);
                    if (byArray2 == null) {
                        Utils.a("BasicConstraint extension is not present");
                    } else {
                        n2 = x509Certificate.getBasicConstraints();
                        if (n2 < 0) {
                            Utils.a("Either CA flag is set to false or path length is negative.");
                        }
                        if (!Utils.a(x509Certificate, string)) {
                            Utils.a("BasicConstraint is not marked as a critical extension");
                        }
                    }
                    if (x509Certificate.getKeyUsage() == null) {
                        Utils.a("KeyUsage extension is not present");
                    }
                    if ((n2 = x509Certificate.getKeyUsage()[5]) == 0) {
                        Utils.a("keycertsign bit is not set");
                    }
                    if (x509Certificate.getIssuerDN() == null) {
                        Utils.a("Issuer name is empty");
                    }
                    if (x509Certificate.getSubjectX500Principal() == null) {
                        Utils.a("Subject name is empty");
                    }
                    if ((collection = x509Certificate.getSubjectAlternativeNames()) != null && collection.isEmpty()) {
                        Utils.a("SubjectAlternativeName extension is empty.");
                    }
                    if (Utils.a(x509Certificate, string2) || Utils.a(x509Certificate, string3)) {
                        Utils.a("Either AuthorityKeyIdentifier or   SubjectKeyIdentifier is a critical extension.");
                    }
                    if (!(bl2 = Arrays.equals(x509Certificate.getSubjectX500Principal().getName().getBytes(), x509Certificate.getIssuerX500Principal().getName().getBytes())) && x509Certificate.getExtensionValue(string2) == null) {
                        Utils.a("A non-self signed certificate should have the AuthorityKeyIdentifier extension.");
                    }
                    if ((byArray = x509Certificate.getExtensionValue(string3)) == null) {
                        Utils.a("SubjectKeyIdentifier extension should be present in certificate.");
                    }
                    break block16;
                }
                throw new CertificateException("Invalid certificate version");
            }
            catch (CertificateException certificateException) {
                if (!bl) break block16;
                throw new CertificateException(certificateException.getMessage());
            }
        }
    }
}

