/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;

public class PQCObjectIdentifiers {
    private static final Map<String, AlgorithmIdentifier> a;

    private PQCObjectIdentifiers() {
    }

    public static AlgorithmIdentifier a(String string) {
        if (string == null || string.trim().isEmpty()) {
            OraclePKIDebug.debug("Algorithm name cannot be null or empty");
            return null;
        }
        return a.getOrDefault(string, null);
    }

    public static boolean a(ASN1ObjectID aSN1ObjectID) {
        return aSN1ObjectID.equals(AlgID.V.a()) || aSN1ObjectID.equals(AlgID.W.a()) || aSN1ObjectID.equals(AlgID.X.a());
    }

    public static boolean b(ASN1ObjectID aSN1ObjectID) {
        return aSN1ObjectID.equals(AlgID.Y.a()) || aSN1ObjectID.equals(AlgID.Z.a()) || aSN1ObjectID.equals(AlgID.aa.a());
    }

    static {
        HashMap<String, AlgorithmIdentifier> hashMap = new HashMap<String, AlgorithmIdentifier>();
        hashMap.put("ML-KEM-512", AlgID.Y);
        hashMap.put("ML-KEM-768", AlgID.Z);
        hashMap.put("ML-KEM-1024", AlgID.aa);
        hashMap.put("ML-DSA-44", AlgID.V);
        hashMap.put("ML-DSA-65", AlgID.W);
        hashMap.put("ML-DSA-87", AlgID.X);
        hashMap.put("SLH-DSA-SHA2-128s", AlgID.ab);
        hashMap.put("SLH-DSA-SHA2-128f", AlgID.ac);
        hashMap.put("SLH-DSA-SHA2-192s", AlgID.ad);
        hashMap.put("SLH-DSA-SHA2-192f", AlgID.ae);
        hashMap.put("SLH-DSA-SHA2-256s", AlgID.af);
        hashMap.put("SLH-DSA-SHA2-256f", AlgID.ag);
        hashMap.put("SLH-DSA-SHAKE-128s", AlgID.ah);
        hashMap.put("SLH-DSA-SHAKE-128f", AlgID.ai);
        hashMap.put("SLH-DSA-SHAKE-192s", AlgID.aj);
        hashMap.put("SLH-DSA-SHAKE-192f", AlgID.ak);
        hashMap.put("SLH-DSA-SHAKE-256s", AlgID.al);
        hashMap.put("SLH-DSA-SHAKE-256f", AlgID.am);
        a = Collections.unmodifiableMap(hashMap);
    }
}

