/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.util;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.util.OraclePKIKeyPair;

public class OraclePKIPQCKeyPair
extends OraclePKIKeyPair {
    private OraclePKIPQCKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        super(privateKey, publicKey);
    }

    public static OraclePKIPQCKeyPair a(String string) throws GeneralSecurityException {
        Objects.requireNonNull(string, "Key algorithm cannot be null");
        if (string.contains("ML-DSA")) {
            return OraclePKIPQCKeyPair.b(string);
        }
        if (string.contains("SLH-DSA")) {
            return OraclePKIPQCKeyPair.c(string);
        }
        throw new NoSuchAlgorithmException("Unknown PQC algorithm: " + string);
    }

    public static OraclePKIPQCKeyPair b(String string) throws GeneralSecurityException {
        try {
            Object object;
            KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance("ML-DSA");
            Class<?> clazz = Class.forName("java.security.spec.NamedParameterSpec");
            switch (string) {
                case "ML-DSA-44": {
                    object = clazz.getField("ML_DSA_44").get(null);
                    break;
                }
                case "ML-DSA-65": {
                    object = clazz.getField("ML_DSA_65").get(null);
                    break;
                }
                case "ML-DSA-87": {
                    object = clazz.getField("ML_DSA_87").get(null);
                    break;
                }
                default: {
                    OraclePKIDebug.debug("Unsupported algorithm for ML-DSA: " + string);
                    throw new IllegalArgumentException("Unknown key algorithm: " + string);
                }
            }
            keyPairGenerator.initialize((AlgorithmParameterSpec)object);
            Object object2 = keyPairGenerator.generateKeyPair();
            return new OraclePKIPQCKeyPair(((KeyPair)object2).getPrivate(), ((KeyPair)object2).getPublic());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GeneralSecurityException("PQC algorithms not supported on this JDK version", classNotFoundException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new GeneralSecurityException("Failed to access PQC parameters", reflectiveOperationException);
        }
    }

    public static OraclePKIPQCKeyPair c(String string) throws GeneralSecurityException {
        try {
            KeyPairGenerator keyPairGenerator;
            try {
                keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new GeneralSecurityException("This provider doesn't support " + string + "key  algorithm");
            }
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return new OraclePKIPQCKeyPair(keyPair.getPrivate(), keyPair.getPublic());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            OraclePKIDebug.debug("Unsupported key algorithm for SLH-DSA: " + string);
            throw new IllegalArgumentException("Unknown key algorithm: " + string);
        }
    }
}

