/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.util.EnumSet;
import oracle.security.pki.internal.pqc.keys.OraclePKIPQCPublicKey;
import oracle.security.pki.internal.pqc.util.KeyUsage;
import oracle.security.pki.util.Utils;

public class OraclePKISLHDSAPublicKey
extends OraclePKIPQCPublicKey {
    private String h;
    byte[] a;
    String b;

    public OraclePKISLHDSAPublicKey(String string, int n, String string2, EnumSet<KeyUsage> enumSet, byte[] byArray, String string3) {
        super(string, n, enumSet, string2, byArray);
        this.h = string3;
    }

    public OraclePKISLHDSAPublicKey(PublicKey publicKey) {
        super(publicKey);
    }

    public void a(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 96) {
            throw new IllegalArgumentException("Invalid SLH-DSA private key length.");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            byteArrayInputStream.skip(64L);
            this.a = new byte[32];
            if (byteArrayInputStream.read(this.a) != 32) {
                throw new IOException("Failed to read public_seed.");
            }
            if (byteArrayInputStream.available() > 0) {
                byte[] byArray2 = new byte[byteArrayInputStream.available()];
                byteArrayInputStream.read(byArray2);
                this.b = Utils.bytesToReadable(byArray2);
            }
        }
    }

    public String toString() {
        return "SLH-DSA Key: " + this.h + ", , Public Key Seed: " + Utils.bytesToReadable(this.a);
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.a.clone();
    }

    public void b(byte[] byArray) {
    }
}

