/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.keys;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.EnumSet;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.internal.pqc.keys.OraclePKIPQCKey;
import oracle.security.pki.internal.pqc.util.KeyUsage;
import oracle.security.pki.internal.pqc.util.PQCKeyUtil;
import oracle.security.pki.internal.pqc.util.PQCUtils;
import oracle.security.pki.util.CryptoUtils;

public abstract class OraclePKIPQCPublicKey
extends OraclePKIPQCKey
implements PublicKey {
    protected final PublicKey g;

    public OraclePKIPQCPublicKey(String string, int n, EnumSet<KeyUsage> enumSet, String string2, byte[] byArray) {
        super(string, n, enumSet, string2);
        try {
            this.g = CryptoUtils.generatePublicKeyFromBytes(byArray, "ML-DSA");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public OraclePKIPQCPublicKey(PublicKey publicKey) {
        super(PQCUtils.a(publicKey, "Public"), PQCKeyUtil.a(publicKey, "Public"), null, null);
        this.g = publicKey;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public String getAlgorithm() {
        return this.g.getAlgorithm();
    }

    @Override
    public byte[] getEncoded() {
        return this.g.getEncoded();
    }

    public PublicKey a() {
        return this.g;
    }

    public boolean a(String string, byte[] byArray, byte[] byArray2) throws Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Algorithm cannot be null or empty");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new IllegalArgumentException("Signature cannot be null or empty");
        }
        try {
            Signature signature = JCEUtil.getSignatureInstance(string);
            if (signature == null) {
                throw new NoSuchAlgorithmException("Unsupported signature algorithm: " + string);
            }
            signature.initVerify(this.g);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (Exception exception) {
            throw new Exception("Error during verification", exception);
        }
    }
}

