/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.util.EnumSet;
import oracle.security.pki.internal.pqc.keys.OraclePKIPQCPublicKey;
import oracle.security.pki.internal.pqc.util.KeyUsage;
import oracle.security.pki.internal.pqc.util.PQCKeyUtil;
import oracle.security.pki.util.Utils;

public class OraclePKIMLKEMPublicKey
extends OraclePKIPQCPublicKey {
    private byte[] a;
    private byte[] b;

    public OraclePKIMLKEMPublicKey(String string, int n, EnumSet<KeyUsage> enumSet, String string2, byte[] byArray) {
        super(string, n, enumSet, string2, byArray);
        if (byArray.length < 64) {
            throw new IllegalArgumentException("Invalid ML-KEM public key length.");
        }
    }

    public OraclePKIMLKEMPublicKey(PublicKey publicKey) {
        super(publicKey);
    }

    public int a(String string) {
        PQCKeyUtil.PQCKeyInfo pQCKeyInfo = PQCKeyUtil.a(string);
        if (pQCKeyInfo == null) {
            throw new IllegalStateException("Key size information is unavailable for the specified algorithm and security level.");
        }
        return pQCKeyInfo.a();
    }

    public void a(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 64) {
            throw new IllegalArgumentException("Invalid ML-KEM public key length. Expected 64 bytes.");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            this.a = new byte[32];
            int n = byteArrayInputStream.read(this.a);
            if (n != 32) {
                throw new IOException("Failed to read rho. Expected 32 bytes but read " + n + ".");
            }
            int n2 = byteArrayInputStream.available();
            this.b = new byte[n2];
            n = byteArrayInputStream.read(this.b);
            if (n != n2) {
                throw new IOException("Failed to read t. Expected " + n2 + " bytes but read " + n + ".");
            }
        }
    }

    public String toString() {
        try {
            this.a(this.getEncoded());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to extract ML-KEM public key attributes", iOException);
        }
        return "ML-KEM Public Key:\n\tAlias = " + this.e + "\n\trho (Public Seed): " + Utils.bytesToReadable(this.a) + " (32 bytes)\n\tPublic Key Polynomial (t): " + Utils.bytesToReadable(this.b) + " bytes\n\tTotal Public Key Length: " + (this.a.length + this.b.length) + " bytes";
    }
}

