/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.AlgorithmIdentifierException;
import oracle.security.pki.internal.core.CipherException;
import oracle.security.pki.internal.core.PBEAlgorithmIdentifier;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.Utils;

public class JCEPBE {
    private boolean d;
    private int e;
    private SecretKeyFactory f;
    private AlgorithmParameterSpec g;
    private Cipher h;
    protected PBEAlgorithmIdentifier a;
    protected AlgorithmIdentifier b;
    protected AlgorithmIdentifier c;
    private int i;

    public void a(int n, AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier instanceof PBEAlgorithmIdentifier) {
            this.a = (PBEAlgorithmIdentifier)algorithmIdentifier;
        } else {
            try {
                this.a = new PBEAlgorithmIdentifier(Utils.toStream(algorithmIdentifier));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException);
            }
        }
        ASN1ObjectID aSN1ObjectID = this.a.a();
        try {
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.i)) {
                this.d = true;
                this.c = this.a.g();
                this.i = this.a.e();
                this.b = this.a.f();
                this.b(n);
            } else {
                this.d = false;
                this.b = AlgID.O;
                if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.k)) {
                    this.c = AlgID.i;
                    this.i = 16;
                } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.l)) {
                    this.c = AlgID.i;
                    this.i = 5;
                } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.m)) {
                    this.c = AlgID.d;
                    this.i = 24;
                } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.n)) {
                    this.c = AlgID.d;
                    this.i = 16;
                } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.o)) {
                    this.c = AlgID.h;
                    this.i = 16;
                } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.p)) {
                    this.c = AlgID.h;
                    this.i = 5;
                } else {
                    throw new AlgorithmIdentifierException("Unknown algorithm identifier: " + this.a);
                }
                this.a(n);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AlgorithmIdentifierException(generalSecurityException);
        }
    }

    public void a(int n, byte[] byArray, int n2) throws AlgorithmIdentifierException {
        this.a(n, new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.a, n), byArray, n2));
    }

    public ASN1Object a() {
        return this.a;
    }

    public byte[] a(String string, PrivateKey privateKey) throws CipherException {
        return this.b(string, privateKey.getEncoded());
    }

    public PrivateKey a(String string, byte[] byArray) throws CipherException, IOException {
        byte[] byArray2 = this.c(string, byArray);
        PrivateKey privateKey = CryptoUtils.inputPrivateKey(new ByteArrayInputStream(byArray2));
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    public byte[] b(String string, byte[] byArray) throws CipherException {
        if (string == null) {
            throw new CipherException("Password not specified during encryption operation.");
        }
        try {
            return this.a(1, string.toCharArray(), byArray);
        }
        catch (Exception exception) {
            throw new CipherException(exception.getMessage());
        }
    }

    public byte[] c(String string, byte[] byArray) throws CipherException {
        if (string == null) {
            throw new CipherException("Password not specified during decryption operation.");
        }
        try {
            return this.a(2, string.toCharArray(), byArray);
        }
        catch (Exception exception) {
            throw new CipherException(exception.getMessage());
        }
    }

    private void a(int n) throws GeneralSecurityException {
        ASN1ObjectID aSN1ObjectID = this.a.a();
        this.g = new PBEParameterSpec(this.a.c(), this.a.d());
        if (n == 2) {
            this.h = aSN1ObjectID.equals(PBEAlgorithmIdentifier.m) ? Cipher.getInstance(aSN1ObjectID.d()) : JCEUtil.getCipherInstance(aSN1ObjectID.d());
        } else {
            String string = CryptoUtils.getCipherTransformation(AlgID.r, true);
            this.h = JCEUtil.getCipherInstance(string);
        }
    }

    private void b(int n) throws GeneralSecurityException, AlgorithmIdentifierException {
        String string;
        AlgorithmIdentifier algorithmIdentifier = this.a.f();
        AlgorithmIdentifier algorithmIdentifier2 = this.a.g();
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier2.a();
        boolean bl = JCEUtil.isJsafeJCERegistered();
        if (algorithmIdentifier.equals(AlgID.ap)) {
            string = "PBKDF2WithHmacSHA1";
        } else if (algorithmIdentifier.equals(AlgID.aq)) {
            string = bl ? "PBKDF2WithSHA224" : "PBKDF2WithHmacSHA224";
        } else if (algorithmIdentifier.equals(AlgID.ar)) {
            string = bl ? "PBKDF2WithSHA256" : "PBKDF2WithHmacSHA256";
        } else if (algorithmIdentifier.equals(AlgID.as)) {
            string = bl ? "PBKDF2WithSHA384" : "PBKDF2WithHmacSHA384";
        } else if (algorithmIdentifier.equals(AlgID.at)) {
            string = bl ? "PBKDF2WithSHA512" : "PBKDF2WithHmacSHA512";
        } else {
            throw new AlgorithmIdentifierException("PBES2 KDF not supported: " + algorithmIdentifier);
        }
        if (aSN1ObjectID.equals(AlgID.n.a())) {
            this.e = 128;
        } else if (aSN1ObjectID.equals(AlgID.p.a())) {
            this.e = 192;
        } else if (aSN1ObjectID.equals(AlgID.r.a())) {
            this.e = 256;
        } else {
            throw new AlgorithmIdentifierException("PBES2 Encryption Scheme not supported: " + algorithmIdentifier2);
        }
        this.f = JCEUtil.getSecretKeyFactoryInstance(string);
        try {
            this.g = new IvParameterSpec(CryptoUtils.getIV(algorithmIdentifier2));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AlgorithmIdentifierException("Invalid ES parameters", algorithmIdentifierException);
        }
        String string2 = null;
        if (n == 2) {
            string2 = CryptoUtils.getCipherTransformation(this.c, true);
            this.h = this.c == AlgID.d ? Cipher.getInstance(string2) : JCEUtil.getCipherInstance(string2);
        } else {
            string2 = CryptoUtils.getCipherTransformation(AlgID.r, true);
            this.h = JCEUtil.getCipherInstance(string2);
        }
    }

    private byte[] a(int n, char[] cArray, byte[] byArray) throws Exception {
        try {
            this.a(n, cArray);
            return this.h.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CipherException("Invalid padding string (or incorrect password)", badPaddingException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CipherException(generalSecurityException.getMessage());
        }
    }

    private void a(int n, char[] cArray) throws Exception {
        if (this.d) {
            this.c(n, cArray);
        } else {
            this.b(n, cArray);
        }
    }

    private void b(int n, char[] cArray) throws Exception {
        byte[] byArray = JCEPBE.a(this.b, new String(cArray), this.a.c(), this.a.d(), (byte)1, this.i);
        byte[] byArray2 = JCEPBE.a(this.b, new String(cArray), this.a.c(), this.a.d(), (byte)2, 8);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
        String string = CryptoUtils.getEncryptionAlgorithm(this.c);
        if (string.startsWith("AES")) {
            string = "AES";
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
        String string2 = CryptoUtils.getCipherTransformation(this.c, true);
        if (this.c == AlgID.h) {
            if (this.a.a().equals(PBEAlgorithmIdentifier.p)) {
                this.h = Cipher.getInstance("RC2/CBC/PKCS5PADDING", CryptoUtils.searchServiceProvider("Cipher", "PBEWithSHA1AndRC2_40"));
            } else if (this.a.a().equals(PBEAlgorithmIdentifier.o)) {
                this.h = Cipher.getInstance("RC2/CBC/PKCS5PADDING", CryptoUtils.searchServiceProvider("Cipher", "PBEWithSHA1AndRC2_128"));
            }
            RC2ParameterSpec rC2ParameterSpec = new RC2ParameterSpec(this.i * 8, byArray2);
            this.h.init(n, (Key)secretKeySpec, rC2ParameterSpec);
        } else {
            this.h = Cipher.getInstance(string2);
            this.h.init(n, (Key)secretKeySpec, ivParameterSpec);
        }
    }

    private void c(int n, char[] cArray) throws GeneralSecurityException, CipherException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, this.a.c(), this.a.d(), this.e);
        SecretKey secretKey = this.f.generateSecret(pBEKeySpec);
        String string = CryptoUtils.getEncryptionAlgorithm(this.c);
        if (string.startsWith("AES")) {
            string = "AES";
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), string);
        this.h.init(n, (Key)secretKeySpec, this.g);
    }

    private static byte[] a(AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n, byte by, int n2) throws CipherException, NoSuchAlgorithmException, InvalidKeyException {
        int n3;
        MessageDigest messageDigest;
        if (string == null) {
            throw new CipherException("Password not set");
        }
        byte[] byArray2 = null;
        try {
            String string2 = CryptoUtils.getDigestAlg(algorithmIdentifier);
            messageDigest = MessageDigest.getInstance(string2);
        }
        catch (Exception exception) {
            throw new CipherException(exception.toString());
        }
        int n4 = messageDigest.getDigestLength();
        int n5 = CryptoUtils.getHashAlgoBlockSize(algorithmIdentifier);
        byte[] byArray3 = new byte[n5];
        Utils.setArray(byArray3, by);
        byte[] byArray4 = Utils.unicodeToBytes(string);
        byte[] byArray5 = new byte[byArray4.length + 2];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        byArray5[byArray5.length - 1] = 0;
        byArray5[byArray5.length - 2] = 0;
        int n6 = byArray.length == 0 ? 0 : ((byArray.length - 1) / n5 + 1) * n5;
        int n7 = byArray5.length == 0 ? 0 : ((byArray5.length - 1) / n5 + 1) * n5;
        byte[] byArray6 = new byte[n6 + n7];
        for (n3 = 0; n3 < n6; n3 += byArray.length) {
            System.arraycopy(byArray, 0, byArray6, n3, Math.min(n6 - n3, byArray.length));
        }
        int n8 = byArray6.length;
        for (n3 = n6; n3 < n8; n3 += byArray5.length) {
            System.arraycopy(byArray5, 0, byArray6, n3, Math.min(byArray6.length - n3, byArray5.length));
        }
        Utils.setArray(byArray5, (byte)0);
        Utils.setArray(byArray4, (byte)0);
        byte[] byArray7 = new byte[n2];
        for (n8 = 0; n8 < n2; n8 += n4) {
            messageDigest.update(byArray3);
            messageDigest.update(byArray6);
            byArray2 = messageDigest.digest();
            int n9 = n - 1;
            for (int i = 0; i < n9; ++i) {
                messageDigest.reset();
                messageDigest.update(byArray2);
                byArray2 = messageDigest.digest();
            }
            byte[] byArray8 = new byte[n5];
            for (n9 = 0; n9 < n5; n9 += n4) {
                System.arraycopy(byArray2, 0, byArray8, n9, Math.min(n5 - n9, n4));
            }
            BigInteger bigInteger = new BigInteger(1, byArray8).add(BigInteger.ONE);
            BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(n5 * 8).subtract(BigInteger.ONE);
            int n10 = byArray6.length;
            for (int i = 0; i < n10; i += n5) {
                byte[] byArray9 = new byte[n5];
                System.arraycopy(byArray6, i, byArray9, 0, n5);
                BigInteger bigInteger3 = new BigInteger(1, byArray9).add(bigInteger).and(bigInteger2);
                Utils.toByteArray(bigInteger3, byArray6, i, n5);
            }
            System.arraycopy(byArray2, 0, byArray7, n8, Math.min(n2 - n8, n4));
        }
        Utils.setArray(byArray2, (byte)0);
        return byArray7;
    }
}

