/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.util.Map;
import java.util.TreeMap;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;

public enum SignatureAlgorithms {
    MD5("md5", "MD5withRSA", AlgID.x),
    SHA1("sha1", "SHA1withRSA", AlgID.y),
    SHA256("sha256", "SHA256withRSA", AlgID.A),
    SHA384("sha384", "SHA384withRSA", AlgID.B),
    SHA512("sha512", "SHA512withRSA", AlgID.C),
    ECDSASHA1("ecdsasha1", "SHA1withECDSA", AlgID.G),
    ECDSASHA256("ecdsasha256", "SHA256withECDSA", AlgID.H),
    ECDSASHA384("ecdsasha384", "SHA384withECDSA", AlgID.I),
    ECDSASHA512("ecdsasha512", "SHA512withECDSA", AlgID.J);

    private String a;
    private String b;
    private AlgorithmIdentifier c;
    private static final Map<String, SignatureAlgorithms> d;
    private static final Map<String, SignatureAlgorithms> e;

    private SignatureAlgorithms(String string2, String string3, AlgorithmIdentifier algorithmIdentifier) {
        this.a = string2;
        this.b = string3;
        this.c = algorithmIdentifier;
    }

    public AlgorithmIdentifier getSignAlgorithmId() {
        return this.c;
    }

    public String getSignAlgorithmName() {
        return this.a;
    }

    public static AlgorithmIdentifier getSignatureAlgorithm(String string) {
        if (d != null && !d.isEmpty() && string != null) {
            String string2 = string.toLowerCase();
            SignatureAlgorithms signatureAlgorithms = d.get(string2);
            if (signatureAlgorithms != null) {
                return signatureAlgorithms.getSignAlgorithmId();
            }
            if (e != null && !e.isEmpty() && string != null) {
                SignatureAlgorithms signatureAlgorithms2 = e.get(string);
                if (signatureAlgorithms2 != null) {
                    return signatureAlgorithms2.getSignAlgorithmId();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean isSignAlgorithmValid(String string) {
        if (d.containsKey(string)) {
            return true;
        }
        return e.containsKey(string);
    }

    public String getStandardJCEName() {
        return this.b;
    }

    static {
        d = new TreeMap<String, SignatureAlgorithms>(String.CASE_INSENSITIVE_ORDER);
        e = new TreeMap<String, SignatureAlgorithms>(String.CASE_INSENSITIVE_ORDER);
        for (SignatureAlgorithms signatureAlgorithms : SignatureAlgorithms.values()) {
            d.put(signatureAlgorithms.getSignAlgorithmName(), signatureAlgorithms);
        }
        for (SignatureAlgorithms signatureAlgorithms : SignatureAlgorithms.values()) {
            e.put(signatureAlgorithms.getStandardJCEName(), signatureAlgorithms);
        }
    }
}

