/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1GenericPrimitive;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.AlgorithmIdentifierException;
import oracle.security.pki.internal.core.CBCAlgorithmIdentifier;
import oracle.security.pki.internal.core.CipherException;
import oracle.security.pki.internal.core.JCEPBE;
import oracle.security.pki.internal.core.PBEAlgorithmIdentifier;
import oracle.security.pki.internal.pkcs12.PKCS12;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class PKCS12Safe
implements Externalizable,
ASN1Object {
    private PKCS12 a;
    private ASN1ObjectID b;
    private AlgorithmIdentifier c;
    private AlgorithmIdentifier d;
    private ArrayList<PKCS12Bag> e;
    private char[] f;
    private ASN1Sequence g;

    public PKCS12Safe() {
    }

    public PKCS12Safe(PKCS12 pKCS12) {
        this.a = pKCS12;
        this.e = new ArrayList();
    }

    public PKCS12Safe(PKCS12 pKCS12, ASN1ObjectID aSN1ObjectID) {
        this(pKCS12);
        this.a(aSN1ObjectID);
    }

    public PKCS12Safe(PKCS12 pKCS12, InputStream inputStream) throws IOException {
        this(pKCS12);
        this.input(inputStream);
    }

    public PKCS12Safe(PKCS12 pKCS12, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12);
        this.a(aSN1Sequence);
    }

    void a() {
        this.g = null;
        if (this.a != null) {
            this.a.a();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    public void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.a();
        try {
            Object object;
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.a(0);
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.a(1);
            byte[] byArray = null;
            if (aSN1ObjectID.a(ASN1Utils.e, 7, 1)) {
                this.b = null;
                byArray = ((ASN1OctetString)aSN1GenericConstructed.a(0)).b();
            } else if (aSN1ObjectID.a(ASN1Utils.e, 7, 6)) {
                Object object2;
                byte[] byArray2;
                object = (ASN1Sequence)aSN1GenericConstructed.a(0);
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1Sequence)object).a(1);
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence2.a(1);
                PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(Utils.toStream(aSN1Sequence3));
                this.b = new ASN1ObjectID(Utils.toStream(pBEAlgorithmIdentifier.a()));
                this.d = pBEAlgorithmIdentifier.g();
                this.c = pBEAlgorithmIdentifier.f();
                ASN1Object aSN1Object = aSN1Sequence2.a(2);
                if (aSN1Object instanceof ASN1GenericPrimitive) {
                    byArray2 = ((ASN1OctetString)((ASN1GenericPrimitive)aSN1Object).a(4)).b();
                } else if (aSN1Object instanceof ASN1GenericConstructed) {
                    int n;
                    object2 = ((ASN1GenericConstructed)aSN1Object).b();
                    byte[][] byArray3 = new byte[((ArrayList)object2).size()][0];
                    int n2 = 0;
                    int n3 = byArray3.length;
                    for (n = 0; n < n3; ++n) {
                        byArray3[n] = ((ASN1OctetString)((ArrayList)object2).get(n)).b();
                        n2 += byArray3[n].length;
                    }
                    byArray2 = new byte[n2];
                    n = 0;
                    int n4 = byArray3.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        System.arraycopy(byArray3[n3], 0, byArray2, n, byArray3[n3].length);
                        n += byArray3[n3].length;
                    }
                } else {
                    throw new IOException("Cound not read encrypted content.");
                }
                object2 = new JCEPBE();
                try {
                    ((JCEPBE)object2).a(pBEAlgorithmIdentifier);
                    byArray = ((JCEPBE)object2).c(this.b(), byArray2);
                }
                catch (AlgorithmIdentifierException | CipherException exception) {
                    throw new IOException(exception.getMessage());
                }
            } else {
                throw new IOException("Unrecognized ContentType " + aSN1ObjectID);
            }
            object = new ASN1SequenceInputStream(new ByteArrayInputStream(byArray));
            while (((ASN1ConstructedInputStream)object).a()) {
                this.a(PKCS12Bag.a(this, new ASN1Sequence((InputStream)object)));
            }
            ((ASN1ConstructedInputStream)object).b();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
        this.g = aSN1Sequence;
    }

    private static byte[] f() {
        return PKCS12Safe.b(8);
    }

    private static byte[] g() {
        return PKCS12Safe.b(16);
    }

    private static byte[] b(int n) {
        SecureRandom secureRandom = JCEUtil.getSecureRandom();
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.h().output(outputStream);
    }

    private ASN1Sequence h() {
        if (this.g != null) {
            return this.g;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.e));
        if (this.b == null) {
            aSN1Sequence.a(new ASN1ObjectID(ASN1Utils.e, 7, 1));
            aSN1Sequence.a(new ASN1GenericConstructed(new ASN1OctetString(byArray), 0));
        } else {
            try {
                PBEAlgorithmIdentifier pBEAlgorithmIdentifier;
                Object object;
                byte[] byArray2 = PKCS12Safe.f();
                if (this.b.equals(PBEAlgorithmIdentifier.i)) {
                    int n = 0;
                    if (this.d.a().equals(AlgID.m.a())) {
                        n = 16;
                    } else if (this.d.a().equals(AlgID.o.a())) {
                        n = 24;
                    } else if (this.d.a().equals(AlgID.q.a())) {
                        n = 32;
                    }
                    object = PKCS12Safe.g();
                    pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(byArray2, 10000, n, this.c, new CBCAlgorithmIdentifier(this.d.a(), (byte[])object));
                } else {
                    pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(this.b, byArray2, 10000);
                }
                byte[] byArray3 = null;
                try {
                    object = new JCEPBE();
                    ((JCEPBE)object).a(pBEAlgorithmIdentifier);
                    byArray3 = ((JCEPBE)object).b(this.b(), byArray);
                }
                catch (CipherException cipherException) {
                    throw new StreamableOutputException(cipherException.toString());
                }
                aSN1Sequence.a(new ASN1ObjectID(ASN1Utils.e, 7, 6));
                object = new ASN1Sequence();
                ((ASN1Sequence)object).a(new ASN1Integer(0L));
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                aSN1Sequence2.a(new ASN1ObjectID(ASN1Utils.e, 7, 1));
                aSN1Sequence2.a(pBEAlgorithmIdentifier);
                aSN1Sequence2.a(new ASN1GenericPrimitive(new ASN1OctetString(byArray3), 0));
                ((ASN1Sequence)object).a(aSN1Sequence2);
                aSN1Sequence.a(new ASN1GenericConstructed((ASN1Object)object, 0));
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new StreamableOutputException(algorithmIdentifierException.toString());
            }
        }
        this.g = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.h().length();
    }

    public void a(String string) {
        this.f = string == null ? null : string.toCharArray();
        this.a();
    }

    public void a(char[] cArray) {
        this.f = cArray;
        this.a();
    }

    public String b() {
        return this.f != null ? new String(this.f) : this.a.b();
    }

    public char[] c() {
        return this.f != null ? this.f : this.a.c();
    }

    public ArrayList<PKCS12Bag> d() {
        return this.e;
    }

    public void a(List<PKCS12Bag> list) {
        this.e = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<PKCS12Bag>(list));
        this.a();
    }

    public void a(PKCS12Bag pKCS12Bag) {
        this.e.add(pKCS12Bag);
        this.a();
    }

    public void a(int n) {
        this.a();
        if (n == -2) {
            this.a(PBEAlgorithmIdentifier.b);
        } else if (n == -1) {
            this.a(PBEAlgorithmIdentifier.d);
        } else if (n == 0) {
            this.a((ASN1ObjectID)null);
        } else {
            this.a(new ASN1ObjectID(PBEAlgorithmIdentifier.j, n));
        }
    }

    public void a(ASN1ObjectID aSN1ObjectID) {
        this.b = aSN1ObjectID;
        this.a();
    }

    public void a(ASN1ObjectID aSN1ObjectID, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        this.b = aSN1ObjectID;
        this.c = algorithmIdentifier;
        this.d = algorithmIdentifier2;
        this.a();
    }

    public ASN1ObjectID e() {
        return this.b;
    }

    public String toString() {
        String string = "pbeOID = {" + this.b + "}";
        for (PKCS12Bag pKCS12Bag : this.e) {
            string = string + ", {" + pKCS12Bag + "}";
        }
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

