/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.Utils;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.NZNative;
import oracle.security.pki.OracleKSEntry;
import oracle.security.pki.OracleKSIdentityEntry;
import oracle.security.pki.OracleKSTrustedCertEntry;
import oracle.security.pki.OracleKeyStoreSpi$1;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIECPublicKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIRSAPublicKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSSEntry;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet$DEF_TF_ADD;
import oracle.security.pki.internal.OracleTrustFlagHelper;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.CertType;
import oracle.security.pki.util.TrustFlags;

public class OracleKeyStoreSpi
extends KeyStoreSpi {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private PKCS12 b = null;
    private Hashtable c = new Hashtable();
    private Hashtable d = new Hashtable();
    private String e;
    private String f;
    private String g;
    private String h;
    private static final int[] i = new int[]{1, 2, 840, 113549, 1, 12, 0, 0, 0};
    private static final byte[] j = new byte[]{0, 0, 0, 0};
    private static final int k = 0;
    private static final int l = 1;
    private static final String m = "secret";
    private static final int n = 100;
    public static final String p11LibOID = "2.16.840.1.113894.2.99.300.2";
    public static final String p11TokLblOID = "2.16.840.1.113894.2.99.300.3";
    public static final String p11TokPwdOID = "2.16.840.1.113894.2.99.300.4";
    public static final String p11CrtLblOID = "2.16.840.1.113894.2.99.300.5";
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";
    private static final String o = "orakey";

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(string)) {
            return ((OracleKSEntry)this.c.get(string)).a();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        try {
            OraclePKIDebug.a("OracleKeyStoreSpi: getCertificateChain alias \"" + (null == string ? "null" : string) + "\"");
            if (this.engineContainsAlias(string)) {
                return ((OracleKSEntry)this.c.get(string)).c();
            }
        }
        catch (Exception exception) {
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            System.out.println(exception.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        OraclePKIDebug.a("OracleKeyStoreSpi: getCertificate alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((OracleKSEntry)this.c.get(string)).b();
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        if (this.engineContainsAlias(string)) {
            return ((OracleKSEntry)this.c.get(string)).g();
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.engineContainsAlias(string) && !((OracleKSEntry)this.c.get(string)).d()) {
            throw new KeyStoreException(a.getString("PKI-04013"));
        }
        OracleKSTrustedCertEntry oracleKSTrustedCertEntry = new OracleKSTrustedCertEntry(certificate);
        this.c.put(string, oracleKSTrustedCertEntry);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (!this.engineContainsAlias(string)) {
            throw new KeyStoreException(a.getString("PKI-04014"));
        }
        this.c.remove(string);
    }

    public Enumeration engineAliases() {
        return new Vector(this.c.keySet()).elements();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.c.containsKey(string);
    }

    @Override
    public int engineSize() {
        return this.c.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((OracleKSEntry)this.c.get(string)).e();
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((OracleKSEntry)this.c.get(string)).d();
        }
        return false;
    }

    public boolean IsPubKeyMatching(OraclePKIX509CertImpl oraclePKIX509CertImpl, OraclePKIX509CertImpl oraclePKIX509CertImpl2) {
        boolean bl = false;
        if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("EC") && oraclePKIX509CertImpl2.getPublicKey().getAlgorithm().equals("EC")) {
            OraclePKIECPublicKey oraclePKIECPublicKey = (OraclePKIECPublicKey)oraclePKIX509CertImpl.getPublicKey();
            OraclePKIECPublicKey oraclePKIECPublicKey2 = (OraclePKIECPublicKey)oraclePKIX509CertImpl2.getPublicKey();
            ECParameterSpec eCParameterSpec = oraclePKIECPublicKey.getParams();
            ECParameterSpec eCParameterSpec2 = oraclePKIECPublicKey2.getParams();
            if (oraclePKIECPublicKey2.getW().equals(oraclePKIECPublicKey2.getW()) && eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor() && eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator()) && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder())) {
                bl = true;
            }
        } else if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("RSA") && oraclePKIX509CertImpl2.getPublicKey().getAlgorithm().equals("RSA")) {
            OraclePKIRSAPublicKey oraclePKIRSAPublicKey = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl.getPublicKey();
            OraclePKIRSAPublicKey oraclePKIRSAPublicKey2 = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl2.getPublicKey();
            if (oraclePKIRSAPublicKey.getModulus().equals(oraclePKIRSAPublicKey2.getModulus()) && oraclePKIRSAPublicKey.getPublicExponent().equals(oraclePKIRSAPublicKey2.getPublicExponent())) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            if (!((OracleKSEntry)entry.getValue()).b().equals(certificate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.load(inputStream, cArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(InputStream inputStream, char[] cArray, boolean bl) throws IOException, CertificateException {
        PKCS12 pKCS12 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: Loading wallet from stream");
        AccessController.doPrivileged(new OracleKeyStoreSpi$1(this));
        if (inputStream == null) {
            pKCS12 = new PKCS12();
            pKCS12.setPasswd(cArray);
        } else {
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            boolean bl2 = false;
            try {
                try {
                    if (inputStream instanceof FileInputStream) {
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:getting channel..");
                        fileChannel = ((FileInputStream)inputStream).getChannel();
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locking file (shared)..");
                        fileLock = FileLockProvider.a(null, fileChannel, 0L, inputStream.available(), true);
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locked file.");
                        bl2 = true;
                    }
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad: Ignoring OverlappingFileLockException ");
                }
                pKCS12 = new PKCS12(cArray, inputStream);
            }
            finally {
                if (fileLock != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:releasing lock..");
                    fileLock.release();
                }
                if (bl2 && fileChannel != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:closing channel..");
                    fileChannel.close();
                }
            }
        }
        boolean bl3 = false;
        try {
            bl3 = pKCS12.verify();
        }
        catch (AuthenticationException authenticationException) {
            bl3 = false;
        }
        if (!bl3) {
            throw new IOException(a.getString("PKI-02010"));
        }
        this.a(pKCS12, bl);
        OraclePKIDebug.a("OracleKeyStoreSpi: Keystore Loaded");
    }

    public void printLocalKeyIDs(PKCS12 pKCS12) {
        System.out.println("-------------------");
        PKCS12Safe pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            if (OracleKeyStoreSpi.b(pKCS12Bag)) {
                System.out.println("CertReqBag = " + OracleLocalKeyId.l(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && OracleLocalKeyId.c(byArray)) {
                System.out.println("User CertBag = " + OracleLocalKeyId.l(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && OracleLocalKeyId.d(pKCS12Bag.getLocalKeyID())) {
                System.out.println("Trusted CertBag = " + OracleLocalKeyId.l(byArray));
            }
            if (OracleKeyStoreSpi.c(pKCS12Bag)) {
                System.out.println("KeyBag = " + OracleLocalKeyId.l(byArray));
            }
            if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
            System.out.println("SecretStoreBag = " + OracleLocalKeyId.l(byArray));
        }
    }

    int a() {
        return this.d.size();
    }

    Enumeration b() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        treeSet.addAll(this.d.keySet());
        return new Vector<Object>(treeSet).elements();
    }

    Enumeration c() {
        return new Vector(this.d.keySet()).elements();
    }

    public void secretStoreDeleteSecret(String string) throws OracleSecretStoreException {
        if (!this.secretStoreContainsAlias(string)) {
            throw new OracleSecretStoreException("No such alias in secret store");
        }
        this.d.remove(string);
    }

    public void secretStoreSetSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            OracleSSEntry oracleSSEntry = (OracleSSEntry)this.d.get(string);
            oracleSSEntry.a(cArray);
        } else {
            OracleSSEntry oracleSSEntry = new OracleSSEntry(string, cArray);
            this.d.put(oracleSSEntry.b(), oracleSSEntry);
        }
    }

    public char[] secretStoreGetSecret(String string) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            return ((OracleSSEntry)this.d.get(string)).a();
        }
        return null;
    }

    public boolean secretStoreContainsAlias(String string) throws OracleSecretStoreException {
        return this.d.containsKey(string);
    }

    public void secretStoreCreateCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        int n = 1;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = (OracleSSEntry)enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            throw new OracleSecretStoreException("Credential already exists");
        }
        while (this.secretStoreContainsAlias(CREDENTIAL_CONNECT_STRING + n)) {
            ++n;
        }
        this.secretStoreSetSecret(CREDENTIAL_CONNECT_STRING + n, cArray);
        this.secretStoreSetSecret(CREDENTIAL_USERNAME + n, cArray2);
        this.secretStoreSetSecret(CREDENTIAL_PASSWORD + n, cArray3);
    }

    public void secretStoreModifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = (OracleSSEntry)enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreSetSecret(CREDENTIAL_USERNAME + string3, cArray2);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            this.secretStoreSetSecret(CREDENTIAL_PASSWORD + string3, cArray3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreDeleteCredential(char[] cArray) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = (OracleSSEntry)enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            this.secretStoreDeleteSecret(string2);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreListCredential() throws OracleSecretStoreException {
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.println("List credential (index: connect_string username)");
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = (OracleSSEntry)enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING)) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println(string3 + ": " + string + " " + new String(this.secretStoreGetSecret(CREDENTIAL_USERNAME + string3)));
        }
    }

    private static boolean a(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12CertBag;
    }

    private static boolean b(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.b(pKCS12Bag.getLocalKeyID());
    }

    private static boolean c(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12KeyBag || pKCS12Bag instanceof PKCS12ShroudedKeyBag;
    }

    private static boolean d(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.e(pKCS12Bag.getLocalKeyID());
    }

    private static boolean e(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.f(pKCS12Bag.getLocalKeyID());
    }

    private static boolean f(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.g(pKCS12Bag.getLocalKeyID());
    }

    private static boolean g(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.h(pKCS12Bag.getLocalKeyID());
    }

    private static boolean h(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.i(pKCS12Bag.getLocalKeyID());
    }

    private static Vector b(PKCS12 pKCS12) {
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList arrayList2 = pKCS12Safe.getBagsAsList();
            for (int j = 0; j < arrayList2.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList2.get(j);
                if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found secret store bag");
                vector.addElement(pKCS12Bag);
                arrayList2.remove(j);
                --j;
            }
            pKCS12Safe.setBags((List)arrayList2);
        }
        return vector;
    }

    private void c(PKCS12 pKCS12) {
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList arrayList2 = pKCS12Safe.getBagsAsList();
            for (int j = 0; j < arrayList2.size(); ++j) {
                ASN1Object aSN1Object;
                PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList2.get(j);
                if (OracleKeyStoreSpi.e(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 lib info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.e = new String(((ASN1OctetString)aSN1Object).getValue());
                    arrayList2.remove(j);
                    --j;
                }
                if (OracleKeyStoreSpi.f(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.f = new String(((ASN1OctetString)aSN1Object).getValue());
                    arrayList2.remove(j);
                    --j;
                }
                if (OracleKeyStoreSpi.g(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.g = new String(((ASN1OctetString)aSN1Object).getValue());
                    arrayList2.remove(j);
                    --j;
                }
                if (!OracleKeyStoreSpi.h(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                this.h = new String(((ASN1OctetString)aSN1Object).getValue());
                arrayList2.remove(j);
                --j;
            }
            pKCS12Safe.setBags((List)arrayList2);
        }
    }

    public String getP11Lib() {
        return this.e;
    }

    public String getP11TokenLabel() {
        return this.f;
    }

    public String getP11TokenPassphrase() {
        return this.g;
    }

    public String getP11CertLabel() {
        return this.h;
    }

    byte[] a(InputStream inputStream, char[] cArray, String string, byte by) throws IOException, KeyStoreException {
        PKCS12Bag pKCS12Bag;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            pKCS12Bag = (PKCS12Bag)arrayList.get(n);
            if (!OracleKeyStoreSpi.e(pKCS12Bag)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 lib bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        pKCS12Bag = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11LibOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)pKCS12Bag);
        pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.a(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 lib bag ");
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray, String string, byte by) throws IOException, KeyStoreException {
        PKCS12Bag pKCS12Bag;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            pKCS12Bag = (PKCS12Bag)arrayList.get(n);
            if (!OracleKeyStoreSpi.f(pKCS12Bag)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token label bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        pKCS12Bag = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)pKCS12Bag);
        pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.b(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token label bag ");
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] c(InputStream inputStream, char[] cArray, String string, byte by) throws IOException, KeyStoreException {
        PKCS12Bag pKCS12Bag;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            pKCS12Bag = (PKCS12Bag)arrayList.get(n);
            if (!OracleKeyStoreSpi.g(pKCS12Bag)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token pwd bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        pKCS12Bag = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokPwdOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)pKCS12Bag);
        pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.c(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token pwd bag ");
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] d(InputStream inputStream, char[] cArray, String string, byte by) throws IOException, KeyStoreException {
        PKCS12Bag pKCS12Bag;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            pKCS12Bag = (PKCS12Bag)arrayList.get(n);
            if (!OracleKeyStoreSpi.h(pKCS12Bag)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 cert label bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        pKCS12Bag = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11CrtLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, aSN1ObjectID, (ASN1Object)pKCS12Bag);
        pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.d(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 cert label bag ");
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static void a(PKCS12 pKCS12, Vector<PKCS12Bag> vector, Vector<PKCS12Bag> vector2, Vector<PKCS12Bag> vector3) {
        if (null == vector) {
            vector = new Vector();
        }
        if (null == vector2) {
            vector2 = new Vector();
        }
        if (null == vector3) {
            vector3 = new Vector();
        }
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList arrayList2 = pKCS12Safe.getBagsAsList();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)iterator.next();
                if (OracleKeyStoreSpi.c(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                    vector.add(pKCS12Bag);
                    iterator.remove();
                    continue;
                }
                if (OracleKeyStoreSpi.a(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
                    vector2.add(pKCS12Bag);
                    iterator.remove();
                    continue;
                }
                if (!OracleKeyStoreSpi.b(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found certReq bag");
                vector3.add(pKCS12Bag);
                iterator.remove();
            }
            pKCS12Safe.setBags((List)arrayList2);
        }
    }

    private static Vector d(PKCS12 pKCS12) {
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList arrayList2 = pKCS12Safe.getBagsAsList();
            for (int j = 0; j < arrayList2.size(); ++j) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList2.get(j);
                if (!OracleKeyStoreSpi.a(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
                vector.addElement(pKCS12Bag);
                arrayList2.remove(j);
                --j;
            }
            pKCS12Safe.setBags((List)arrayList2);
        }
        return vector;
    }

    void a(PKCS12 pKCS12) throws NoSuchAlgorithmException, CertificateException, IOException {
        this.a(pKCS12, false);
    }

    void a(PKCS12 pKCS12, boolean bl) throws CertificateException, IOException {
        int n;
        String string;
        String string2;
        OracleKSEntry oracleKSEntry;
        Object object;
        int n2;
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        Vector<PKCS12Bag> vector3 = new Vector<PKCS12Bag>();
        OracleKeyStoreSpi.a(pKCS12, vector, vector2, vector3);
        Vector vector4 = OracleKeyStoreSpi.b(pKCS12);
        this.c(pKCS12);
        Hashtable<String, OracleKSEntry> hashtable = new Hashtable<String, OracleKSEntry>(vector.size() + vector2.size());
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(vector4.size());
        for (n2 = 0; n2 < vector.size(); ++n2) {
            OraclePKIDebug.a("Processing identity " + n2);
            object = vector.get(n2);
            oracleKSEntry = new OracleKSIdentityEntry((PKCS12Bag)object, vector2, vector3);
            string2 = null;
            string = object.getFriendlyName();
            if (!bl) {
                if (string != null) {
                    string2 = string;
                } else {
                    string2 = oracleKSEntry.f();
                    n = 1;
                    while (hashtable.containsKey(string2)) {
                        string2 = string2 + ' ' + Integer.toString(n);
                        ++n;
                    }
                }
                OraclePKIDebug.a("Storing identity " + n2 + " as " + string2);
                hashtable.put(string2, oracleKSEntry);
                continue;
            }
            n = OracleKeyStoreSpi.getHighestIndexForAliasWithOrakeyPrefix(Collections.list(hashtable.keys())) + 1;
            hashtable.put(o + n, oracleKSEntry);
        }
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            OraclePKIDebug.a("Processing CertReq with no matching pvt key " + n2);
            object = vector3.get(n2);
            oracleKSEntry = new OracleKSIdentityEntry((PKCS12Bag)object, vector2);
            string2 = null;
            string = object.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = oracleKSEntry.f();
                n = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = string2 + ' ' + Integer.toString(n);
                    ++n;
                }
            }
            OraclePKIDebug.a("Storing creq " + n2 + " as " + string2);
            hashtable.put(string2, oracleKSEntry);
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            OraclePKIDebug.a("Processing TP " + n2);
            object = vector2.get(n2);
            oracleKSEntry = new OracleKSTrustedCertEntry((PKCS12CertBag)object);
            string2 = null;
            string = object.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = oracleKSEntry.f();
                n = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = oracleKSEntry.f() + ' ' + Integer.toString(n);
                    ++n;
                }
            }
            OraclePKIDebug.a("Storing TP " + n2 + " as " + string2);
            hashtable.put(string2, oracleKSEntry);
        }
        try {
            for (n2 = 0; n2 < vector4.size(); ++n2) {
                OraclePKIDebug.a("OracleKeyStoreSpi: Storing Secret" + n2);
                object = new OracleSSEntry((PKCS12SecretBag)vector4.get(n2));
                hashtable2.put(((OracleSSEntry)object).b(), object);
            }
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            throw new IOException(oracleSecretStoreException.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.c = hashtable;
        this.d = hashtable2;
    }

    byte[] a(InputStream inputStream, char[] cArray, byte by) throws IOException, OracleSecretStoreException {
        Object object;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = null;
        pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
            OracleKeyStoreSpi.b(pKCS122);
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new secret store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + "bags");
        if (this.d.size() > 0) {
            Set set = this.d.entrySet();
            object = set.iterator();
            int n = 0;
            while (object.hasNext()) {
                OracleSSEntry oracleSSEntry = (OracleSSEntry)object.next().getValue();
                PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12);
                oracleSSEntry.a(pKCS12SecretBag);
                pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.a(0, n));
                arrayList.add(0, pKCS12SecretBag);
                ++n;
                OraclePKIDebug.a("OracleWallet: added secret bag");
            }
        }
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        int n = pKCS122.length();
        OraclePKIDebug.a("OracleWallet: wallet has " + pKCS122.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleWallet: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, KeyStore keyStore, char[] cArray, byte by) throws IOException, KeyStoreException, CertificateException {
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        boolean bl = false;
        boolean bl2 = false;
        if ((by & 1) != 0) {
            bl = true;
        }
        if ((by & 4) != 0) {
            bl2 = true;
        }
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
            OracleKeyStoreSpi.a(pKCS122, null, null, null);
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        if (bl2) {
            pKCS12.setMode(3);
        } else {
            pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                int n = 0;
                String string = enumeration.nextElement();
                if (keyStore.isCertificateEntry(string)) {
                    X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                    X509 x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
                    PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, x509);
                    pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n));
                    arrayList.add(0, pKCS12CertBag);
                    OraclePKIDebug.a("OracleWallet: added cert bag");
                    continue;
                }
                if (!keyStore.isKeyEntry(string)) continue;
                throw new IOException("Not Implemented for private keys");
            }
        }
        catch (Exception exception) {
            throw new IOException("Encountered error while adding certificate bag");
        }
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() >= 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        int n = pKCS122.length();
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("OracleWallet: wallet has " + pKCS122.getAuthSafesAsList().size() + " safes");
            OraclePKIDebug.a("OracleWallet: wallet size " + n);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, KeyStore keyStore, char[] cArray) throws IOException, KeyStoreException, CertificateException {
        return this.a(inputStream, keyStore, cArray, (byte)0);
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2) throws IOException {
        OracleKeyStoreSpi.a(inputStream, cArray, outputStream, cArray2, (byte)0);
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, byte by) throws IOException {
        PKCS12 pKCS12 = new PKCS12(cArray, inputStream);
        boolean bl = cArray.length == cArray2.length;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        byte[] byArray = Arrays.copyOf(j, j.length);
        for (int i = 0; bl && i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            bl = false;
        }
        pKCS12.setPasswd(cArray2);
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        if ((by & 4) != 0) {
            bl5 = true;
        }
        if ((by & 1) != 0) {
            bl4 = true;
        }
        if ((by & 2) != 0) {
            bl7 = true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag;
            boolean bl8 = false;
            PKCS12Safe pKCS12Safe = (PKCS12Safe)arrayList.get(0);
            ArrayList arrayList2 = pKCS12Safe.getBagsAsList();
            for (int j = 0; j < arrayList2.size(); ++j) {
                PKCS12ShroudedKeyBag pKCS12ShroudedKeyBag;
                pKCS12Bag = (PKCS12Bag)arrayList2.get(j);
                if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
                    pKCS12ShroudedKeyBag = (PKCS12ShroudedKeyBag)pKCS12Bag;
                    pKCS12ShroudedKeyBag.setPasswd(cArray);
                    PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag(pKCS12Safe, pKCS12ShroudedKeyBag.getPrivateKey());
                    pKCS12KeyBag.setLocalKeyID(pKCS12ShroudedKeyBag.getLocalKeyID());
                    pKCS12KeyBag.setFriendlyName(pKCS12ShroudedKeyBag.getFriendlyName());
                    arrayList2.remove(j);
                    arrayList2.add(j, pKCS12KeyBag);
                    continue;
                }
                if (!(pKCS12Bag instanceof PKCS12SecretBag) || !(pKCS12ShroudedKeyBag = (PKCS12SecretBag)pKCS12Bag).getSecretType().equals((Object)new ASN1ObjectID(OracleKeyStoreSpi.i))) continue;
                bl8 = true;
                byArray = ((ASN1OctetString)pKCS12ShroudedKeyBag.getSecretValue()).getValue();
                if (byArray[0] == 1) {
                    bl2 = true;
                }
                if (byArray[1] == 1) {
                    bl6 = true;
                }
                arrayList2.remove(j);
            }
            byArray = Arrays.copyOf(j, j.length);
            if (bl2 || bl4) {
                byArray[0] = 1;
            }
            if (bl6 || bl7) {
                byArray[1] = 1;
            }
            if (OraclePKIDebug.getDebugFlag()) {
                OraclePKIDebug.a("Array length: " + j.length);
                OraclePKIDebug.a("Wallet Conf :" + by);
                OraclePKIDebug.a("Trust Flags: Now Previous :" + bl7 + "," + bl6);
                OraclePKIDebug.a("V12 Flags: Now Previous :" + bl4 + "," + bl2);
                OraclePKIDebug.a("Final value of secret bag:" + Arrays.toString(byArray));
            }
            ASN1OctetString aSN1OctetString = new ASN1OctetString(byArray);
            if (bl5) {
                pKCS12Safe.setMode(3);
            } else {
                pKCS12Safe.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
            if (bl4 || bl2 || bl6 || bl7) {
                pKCS12Bag = new PKCS12SecretBag(pKCS12Safe, new ASN1ObjectID(OracleKeyStoreSpi.i), (ASN1Object)aSN1OctetString);
                pKCS12Bag.setLocalKeyID(OracleLocalKeyId.a(0, 0, OracleLocalKeyId.a));
                pKCS12Bag.setFriendlyName(m + new Random().nextInt(100));
                arrayList2.add(pKCS12Bag);
            }
            pKCS12Safe.setBags((List)arrayList2);
            pKCS12Safe.setPasswd(cArray2);
        }
        try {
            pKCS12.output(outputStream);
            if (OraclePKIDebug.getDebugFlag()) {
                OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
            }
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not store wallet " + (Object)((Object)authenticationException));
        }
    }

    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, oracle.security.crypto.core.PrivateKey privateKey, String string, byte by) throws IOException, KeyStoreException {
        int n;
        Object object;
        Object object2;
        PKCS12 pKCS12;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3;
            object2 = (PKCS12Bag)arrayList.get(i);
            if (OracleKeyStoreSpi.c(object2)) {
                OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                if (string != null && object2.getFriendlyName().equalsIgnoreCase(string)) {
                    throw new IOException(a.getString("PKI-04008") + string);
                }
                object = object2.getLocalKeyID();
                n3 = OracleLocalKeyId.l(object);
                if (n3 == n2) {
                    ++n2;
                } else if (n3 > n2) {
                    n2 = n3 + 1;
                }
            }
            if (!OracleKeyStoreSpi.b(object2) || (n = OracleKeyStoreSpi.a(pKCS122, n3 = OracleLocalKeyId.l(object = object2.getLocalKeyID()), by)) != 0) continue;
            if (n3 == n2) {
                ++n2;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3 + 1;
        }
        if (string == null) {
            string = n2 == 0 ? o : o + Integer.toString(n2);
        }
        if (privateKey != null) {
            PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag((PKCS12Safe)pKCS12, privateKey);
            pKCS12KeyBag.setLocalKeyID(OracleLocalKeyId.c(0, n2));
            pKCS12KeyBag.setFriendlyName(string.toLowerCase());
            arrayList.add(pKCS12KeyBag);
            OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)byteArrayOutputStream);
        object2 = byteArrayOutputStream.toByteArray();
        object = new ASN1OctetString((byte[])object2);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)pKCS12, new ASN1ObjectID("42.134.72.134.247.13.1.10"), (ASN1Object)object);
        pKCS12SecretBag.setLocalKeyID(OracleLocalKeyId.d(0, n2));
        pKCS12SecretBag.setFriendlyName(string.toLowerCase());
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleKeyStoreSpi: added req bag " + n2);
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        n = pKCS122.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(n);
        pKCS122.output((OutputStream)byteArrayOutputStream2);
        return byteArrayOutputStream2.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, boolean bl, byte by) throws IOException, KeyStoreException {
        Object object;
        Object object2;
        PKCS12 pKCS12;
        if (this.a(oraclePKIX509CertImpl)) {
            throw new KeyStoreException(a.getString("PKI-04003"));
        }
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = null;
        ArrayList arrayList = pKCS122.getAuthSafesAsList();
        if (arrayList.size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)arrayList.get(0);
        }
        ArrayList arrayList2 = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList2.size() + " bags");
        int n = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            object2 = (PKCS12Bag)arrayList2.get(i);
            if (string != null && (object = object2.getFriendlyName()) != null && ((String)object).equalsIgnoreCase(string)) {
                throw new IOException(a.getString("PKI-04008") + string);
            }
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object2) || !OracleLocalKeyId.d(object2.getLocalKeyID())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
            ++n;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n));
        if (bl && null != oraclePKIX509CertImpl) {
            object2 = oraclePKIX509CertImpl.getSubjectDN();
            object = oraclePKIX509CertImpl.getIssuerDN();
            String string3 = object2 != null ? object2.getName() : null;
            String string4 = object != null ? object.getName() : null;
            string2 = OracleTrustFlagHelper.recalculateTrustFlagforTrustCert(string3, string4, oraclePKIX509CertImpl.getBasicConstraints(), string2);
            byte[] byArray = pKCS12CertBag.getLocalKeyID();
            OracleLocalKeyId.a(byArray, string2);
            pKCS12CertBag.setLocalKeyID(byArray);
        }
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string.toLowerCase());
        }
        arrayList2.add(pKCS12CertBag);
        int n2 = pKCS122.length();
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("OracleWallet: added key bag " + n);
            OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + arrayList.size() + " safes");
            OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n2);
        }
        object = new ByteArrayOutputStream(n2);
        pKCS122.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2)) continue;
            Key key = this.engineGetKey(string2, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else {
                if (!key.getAlgorithm().equals("EC")) continue;
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            }
            if (certificateRequest == null || !x500Name.equals((Object)new X500Name(string = certificateRequest.getSubject().toString()))) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching DN.");
            throw new IOException(a.getString("PKI-04005"));
        }
        return this.a(inputStream, cArray, certificateRequest, true);
    }

    byte[] a(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || !string.equals(string2)) continue;
            Key key = this.engineGetKey(string2, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else {
                if (!key.getAlgorithm().equals("EC")) continue;
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        return this.a(inputStream, cArray, certificateRequest, true);
    }

    byte[] b(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || !string.equals(string2)) continue;
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)this.engineGetKey(string2, null);
            certificateRequest = oraclePKIRSAPrivateKey.getCertificateRequest();
            if (!oraclePKIRSAPrivateKey.isPvtKeyPresent()) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
            if (certificateRequest == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemovePrivateKey: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        return this.a(inputStream, cArray, certificateRequest, false);
    }

    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, boolean bl) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n;
        Object object;
        PKCS12Safe pKCS12Safe;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray3;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals(byArray, byArray3 = ((ASN1OctetString)(object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray2 = pKCS12Bag.getLocalKeyID();
            if (!bl) break;
            arrayList.remove(i);
            break;
        }
        byte[] byArray4 = OracleLocalKeyId.c(OracleLocalKeyId.k(byArray2), OracleLocalKeyId.l(byArray2));
        for (n = 0; n < arrayList.size(); ++n) {
            object = (PKCS12Bag)arrayList.get(n);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)object) || !this.a(object.getLocalKeyID(), byArray4)) continue;
            arrayList.remove(n);
            break;
        }
        pKCS12Safe.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS12.getAuthSafesAsList().isEmpty()) {
            pKCS12.addAuthSafe(pKCS12Safe);
        }
        n = pKCS12.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    int c(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PKCS12Safe pKCS12Safe;
        Object object;
        Object object2;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || !string.equals(object2)) continue;
            object = this.engineGetKey((String)object2, null);
            if (object.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            } else if (object.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCRCompNum: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object2 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            ASN1Object aSN1Object;
            byte[] byArray2;
            boolean bl2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object, byArray2 = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray = pKCS12Bag.getLocalKeyID();
            return OracleLocalKeyId.l(byArray);
        }
        throw new IOException("Check wallet.");
    }

    byte[] b(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.a(inputStream, cArray, x500Principal, null, null);
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        BigInteger bigInteger;
        Object object2;
        Object object3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        String string3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        X500Name x500Name = null;
        BigInteger bigInteger2 = null;
        X500Name x500Name2 = new X500Name(x500Principal.toString());
        if (string != null) {
            x500Name = new X500Name(string);
        }
        bigInteger2 = OraclePKIGenFunc.calculateSerialNumber(string2);
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            oraclePKIX509CertImpl = null;
            if (!this.engineIsKeyEntry(string3) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string3)) == null) continue;
            object3 = oraclePKIX509CertImpl.getSubjectDN().toString();
            object2 = oraclePKIX509CertImpl.getIssuerDN().toString();
            bigInteger = oraclePKIX509CertImpl.getSerialNumber();
            bl = false;
            bl2 = false;
            if (!x500Name2.equals((Object)new X500Name((String)object3))) continue;
            if (string == null || string != null && x500Name != null && x500Name.equals((Object)new X500Name((String)object2))) {
                bl = true;
            }
            if (string2 == null || string2 != null && bigInteger2 != null && bigInteger2.equals(bigInteger)) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            if (!bl3) {
                bl3 = true;
                oraclePKIX509CertImpl2 = oraclePKIX509CertImpl;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025"));
        }
        if (!bl3) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        string3 = new PKCS12();
        string3.setPasswd(cArray);
        if (inputStream != null) {
            oraclePKIX509CertImpl = new PKCS12(new String(cArray), inputStream);
            string3.setAuthSafes((List)oraclePKIX509CertImpl.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        oraclePKIX509CertImpl = (PKCS12Safe)string3.getAuthSafesAsList().get(0);
        object3 = oraclePKIX509CertImpl.getBagsAsList();
        object2 = new ArrayList(((ArrayList)object3).size());
        bigInteger = null;
        X509 x509 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + " bags");
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.c(object.getLocalKeyID())) {
                bigInteger = ((PKCS12CertBag)object).getCert();
                if (oraclePKIX509CertImpl2 != null) {
                    x509 = new X509(oraclePKIX509CertImpl2.getEncoded());
                }
                if (x509 != null && x509.equals((Object)bigInteger)) continue;
                ((ArrayList)object2).add(object);
                continue;
            }
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && !OracleLocalKeyId.d(object.getLocalKeyID())) {
                bigInteger = ((PKCS12CertBag)object).getCert();
                if (oraclePKIX509CertImpl2 != null) {
                    x509 = new X509(oraclePKIX509CertImpl2.getEncoded());
                }
                if (x509 != null && x509.equals((Object)bigInteger)) continue;
            }
            ((ArrayList)object2).add(object);
        }
        oraclePKIX509CertImpl.setBags((List)object2);
        if (((ArrayList)object2).size() > 0 && string3.getAuthSafesAsList().isEmpty()) {
            string3.addAuthSafe((PKCS12Safe)oraclePKIX509CertImpl);
        }
        n = string3.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string3.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string3.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] d(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        string2 = new PKCS12();
        string2.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        ArrayList<PKCS12Bag> arrayList2 = new ArrayList<PKCS12Bag>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (n = 0; n < arrayList.size(); ++n) {
            object = (PKCS12Bag)arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.c(object.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)object).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                arrayList2.add((PKCS12Bag)object);
                continue;
            }
            arrayList2.add((PKCS12Bag)object);
        }
        pKCS12Safe.setBags(arrayList2);
        if (arrayList2.size() > 0 && string2.getAuthSafesAsList().isEmpty()) {
            string2.addAuthSafe(pKCS12Safe);
        }
        n = string2.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string2.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string2.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        BigInteger bigInteger;
        Object object2;
        Object object3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2;
        String string3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        BigInteger bigInteger2 = null;
        x500Name = new X500Name(oraclePKIX509CertImpl.getSubjectDN().toString());
        if (string != null) {
            x500Name2 = new X500Name(string);
        }
        if (string2 != null) {
            bigInteger2 = string2.length() > 2 && string2.charAt(0) == '0' && (string2.charAt(1) == 'x' || string2.charAt(1) == 'X') ? new BigInteger(string2.substring(2), 16) : new BigInteger(string2);
        }
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            oraclePKIX509CertImpl2 = null;
            if (!this.engineIsKeyEntry(string3) || (oraclePKIX509CertImpl2 = (OraclePKIX509CertImpl)this.engineGetCertificate(string3)) == null) continue;
            object3 = oraclePKIX509CertImpl2.getSubjectDN().toString();
            object2 = oraclePKIX509CertImpl2.getIssuerDN().toString();
            bigInteger = oraclePKIX509CertImpl2.getSerialNumber();
            bl = false;
            bl2 = false;
            bl3 = false;
            if (!x500Name.equals((Object)new X500Name((String)object3))) continue;
            if (string == null || x500Name2 != null && x500Name2.equals((Object)new X500Name((String)object2))) {
                bl = true;
            }
            if (string2 == null || string2 != null && bigInteger2.equals(bigInteger)) {
                bl2 = true;
            }
            if (this.IsPubKeyMatching(oraclePKIX509CertImpl, oraclePKIX509CertImpl2)) {
                bl3 = true;
            }
            if (!bl || !bl2 || !bl3) continue;
            if (!bl4) {
                bl4 = true;
                oraclePKIX509CertImpl3 = oraclePKIX509CertImpl2;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025"));
        }
        if (!bl4) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        string3 = new PKCS12();
        string3.setPasswd(cArray);
        if (inputStream != null) {
            oraclePKIX509CertImpl2 = new PKCS12(new String(cArray), inputStream);
            string3.setAuthSafes((List)oraclePKIX509CertImpl2.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        oraclePKIX509CertImpl2 = (PKCS12Safe)string3.getAuthSafesAsList().get(0);
        object3 = oraclePKIX509CertImpl2.getBagsAsList();
        object2 = new ArrayList(((ArrayList)object3).size());
        bigInteger = null;
        X509 x509 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + " bags");
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.c(object.getLocalKeyID())) {
                bigInteger = ((PKCS12CertBag)object).getCert();
                if (oraclePKIX509CertImpl3 != null) {
                    x509 = new X509(oraclePKIX509CertImpl3.getEncoded());
                }
                if (x509 != null && x509.equals((Object)bigInteger)) continue;
                ((ArrayList)object2).add(object);
                continue;
            }
            ((ArrayList)object2).add(object);
        }
        oraclePKIX509CertImpl2.setBags((List)object2);
        if (((ArrayList)object2).size() > 0 && string3.getAuthSafesAsList().isEmpty()) {
            string3.addAuthSafe((PKCS12Safe)oraclePKIX509CertImpl2);
        }
        n = string3.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string3.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string3.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    boolean a(InputStream inputStream, char[] cArray) throws IOException, SignatureException, CertificateEncodingException {
        PKCS12 pKCS12;
        OraclePKIDebug.a("OracleKeyStoreSpi::checkTrustFlagsEnabled: Entry");
        byte[] byArray = new byte[]{0, 0, 0, 0};
        boolean bl = false;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12.getBagsAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12SecretBag pKCS12SecretBag;
            if (!((PKCS12Bag)arrayList.get(i) instanceof PKCS12SecretBag) || !(pKCS12SecretBag = (PKCS12SecretBag)arrayList.get(i)).getSecretType().equals((Object)new ASN1ObjectID(OracleKeyStoreSpi.i)) || (byArray = ((ASN1OctetString)pKCS12SecretBag.getSecretValue()).getValue())[1] != 1) continue;
            bl = true;
            break;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::checkTrustFlagsEnabled: Exit");
        return bl;
    }

    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, SignatureException, CertificateEncodingException {
        PKCS12 pKCS12;
        OraclePKIDebug.a("OracleKeyStoreSpi::getTrustFlagsValue: Entry");
        String string = null;
        String string2 = null;
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12.getBagsAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray;
            string = null;
            string2 = null;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || (byArray = pKCS12Bag.getLocalKeyID()) == null || (string = OracleLocalKeyId.a(byArray)) == null || "".equals(string)) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            String string3 = x509.getIssuer().toString();
            String string4 = x509.getSerialNo().toString();
            if (OracleLocalKeyId.c(byArray)) {
                string2 = CertType.b.b() + x509.getSubject().toString() + string3 + string4;
            } else if (OracleLocalKeyId.d(byArray)) {
                string2 = CertType.a.b() + x509.getSubject().toString() + string3 + string4;
            }
            if (string2 == null || string == null) continue;
            hashMap.put(string2, string);
            OraclePKIDebug.a("OracleKeyStoreSpi::getTrustFlagsValue: " + string2 + " = " + string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS122.length());
        pKCS122.output((OutputStream)byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::getTrustFlagsValue: Exit");
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, String string, String string2, String string3, String string4, HashMap hashMap) throws IOException, SignatureException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        String string5;
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Entry");
        boolean bl = false;
        boolean bl2 = false;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = null;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string5 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string5) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string5)) == null || !(bl = this.a(oraclePKIX509CertImpl.getX509(), string, string2, string3))) continue;
            if (bl2) {
                OraclePKIDebug.a(a.getString("PKI-04025"));
                throw new IOException(a.getString("PKI-04025"));
            }
            oraclePKIX509CertImpl2 = oraclePKIX509CertImpl;
            bl2 = true;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Found 1 matching cert for assigning Trust Flags.");
        if (!bl2) {
            OraclePKIDebug.a(a.getString("PKI-04023"));
            throw new IOException(a.getString("PKI-04023"));
        }
        if (TrustFlags.c.c().equals(string4) && oraclePKIX509CertImpl2 != null && oraclePKIX509CertImpl2.getBasicConstraints() != -1) {
            OraclePKIDebug.a("Cannot assign VALID_PEER flag to a CA certificate.");
            throw new IOException("Cannot assign VALID_PEER flag to a CA certificate.");
        }
        if (oraclePKIX509CertImpl2 != null && oraclePKIX509CertImpl2.getBasicConstraints() == -1 && (TrustFlags.a.c().equals(string4) || TrustFlags.b.c().equals(string4) || string4 != null && string4.equals(TrustFlags.a.c() + "," + TrustFlags.b.c()))) {
            OraclePKIDebug.a("Cannot assign SERVER_AUTH/CLIENT_AUTH flag to an EE certificate.");
            throw new IOException("Cannot assign SERVER_AUTH/CLIENT_AUTH flag to an EE certificate.");
        }
        if (!this.a(oraclePKIX509CertImpl2, hashMap, string4)) {
            OraclePKIDebug.a("This operation will result in wallet going into an inconsistent state.");
            throw new IOException("This operation will result in wallet going into an inconsistent state.");
        }
        string5 = new PKCS12();
        string5.setPasswd(cArray);
        if (inputStream != null) {
            oraclePKIX509CertImpl = new PKCS12(new String(cArray), inputStream);
            string5.setAuthSafes((List)oraclePKIX509CertImpl.getAuthSafesAsList());
        }
        oraclePKIX509CertImpl = (PKCS12Safe)string5.getAuthSafesAsList().get(0);
        ArrayList arrayList = oraclePKIX509CertImpl.getBagsAsList();
        X509 x509 = new X509(oraclePKIX509CertImpl2.getEncoded());
        for (int i = 0; i < arrayList.size(); ++i) {
            bl = false;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.d(pKCS12Bag.getLocalKeyID())) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            X509 x5092 = ((PKCS12CertBag)pKCS12Bag).getCert();
            if (x509 == null || !x509.equals((Object)x5092)) continue;
            OracleLocalKeyId.a(byArray, string4);
            pKCS12Bag.setLocalKeyID(byArray);
            OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Trust Flags successfully assigned to matching certificate.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string5.length());
        string5.output((OutputStream)byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Exit");
        return byteArrayOutputStream.toByteArray();
    }

    private boolean a(X509 x509, String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        BigInteger bigInteger = null;
        if (string == null) {
            return false;
        }
        string4 = x509.getSubject().toString();
        string5 = x509.getIssuer().toString();
        bigInteger = x509.getSerialNo();
        if (null != bigInteger) {
            string6 = bigInteger.toString();
            string7 = bigInteger.toString(16);
            string8 = "0x" + bigInteger.toString(16);
        }
        x500Name = new X500Name(new X500Principal(string).toString());
        if (string2 != null) {
            x500Name2 = new X500Name(new X500Principal(string2).toString());
        }
        if (x500Name.equals((Object)new X500Name(string4))) {
            if (x500Name2 != null && !x500Name2.equals((Object)new X500Name(string5))) {
                return false;
            }
            return string3 == null || null == bigInteger || string3.equals(string6) || string3.equalsIgnoreCase(string7) || string3.equalsIgnoreCase(string8);
        }
        return false;
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl, HashMap hashMap, String string) throws IOException {
        boolean bl = true;
        boolean bl2 = false;
        if (oraclePKIX509CertImpl == null) {
            return bl;
        }
        String string2 = CertType.a.b() + oraclePKIX509CertImpl.getSubjectDN().toString() + oraclePKIX509CertImpl.getIssuerDN().toString() + oraclePKIX509CertImpl.getSerialNumber().toString();
        if (hashMap == null) {
            return bl;
        }
        String string3 = (String)hashMap.get(string2);
        String string4 = TrustFlags.a.c();
        if (string3 == null) {
            return bl;
        }
        if (string3.indexOf(string4) == -1) {
            return bl;
        }
        if (string3.indexOf(string4) != -1 && string.indexOf(string4) != -1) {
            return bl;
        }
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && bl) {
            Certificate[] certificateArray;
            Map.Entry entry = iterator.next();
            if (!((OracleKSEntry)entry.getValue() instanceof OracleKSIdentityEntry) || (certificateArray = ((OracleKSIdentityEntry)entry.getValue()).c()) == null || ((X509Certificate)certificateArray[certificateArray.length - 1]).getSubjectDN().getName().equals(((X509Certificate)certificateArray[certificateArray.length - 1]).getIssuerDN().getName())) continue;
            bl2 = false;
            for (int i = 1; i < certificateArray.length; ++i) {
                String string5;
                if (oraclePKIX509CertImpl.equals(certificateArray[i]) || (string5 = (String)hashMap.get(string2 = CertType.a.b() + ((X509Certificate)certificateArray[i]).getSubjectDN().getName() + ((X509Certificate)certificateArray[i]).getIssuerDN().getName() + ((X509Certificate)certificateArray[i]).getSerialNumber().toString())) == null || string5.indexOf(string4) == -1) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    byte[] a(InputStream inputStream, char[] cArray, OracleWallet$DEF_TF_ADD oracleWallet$DEF_TF_ADD) throws IOException, SignatureException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        OraclePKIDebug.a("OracleKeyStoreSpi::addDefaultFlagtoTrustedCerts: Entry");
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi::addDefaultFlagtoTrustedCerts: Number of bags in wallet: " + arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.d(pKCS12Bag.getLocalKeyID())) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            if (oracleWallet$DEF_TF_ADD == OracleWallet$DEF_TF_ADD.SERVER_CLIENT_AUTH) {
                OracleLocalKeyId.a(byArray, TrustFlags.a.c() + "," + TrustFlags.b.c());
            } else if (oracleWallet$DEF_TF_ADD == OracleWallet$DEF_TF_ADD.NULL) {
                OracleLocalKeyId.a(byArray, TrustFlags.e.c());
            } else {
                throw new IOException("Invalid cert type input.");
            }
            pKCS12Bag.setLocalKeyID(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::addDefaultFlagtoTrustedCerts: Default Flags added to Trusted certificates.");
        OraclePKIDebug.a("OracleKeyStoreSpi::addDefaultFlagtoTrustedCerts: Exit");
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray) throws IOException, SignatureException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        OraclePKIDebug.a("OracleKeyStoreSpi::addDefaultFlagtoUserCerts: Entry");
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.c(pKCS12Bag.getLocalKeyID())) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            OracleLocalKeyId.a(byArray, TrustFlags.d.c());
            pKCS12Bag.setLocalKeyID(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::addDefaultFlagtoUserCerts: Default Trust Flags successfully added to User certificates.");
        OraclePKIDebug.a("OracleKeyStoreSpi::addDefaultFlagtoUserCerts: Exit");
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        String string;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.engineIsCertificateEntry(string) && (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string)) == null) continue;
        }
        string = new PKCS12();
        string.setPasswd(cArray);
        if (inputStream != null) {
            oraclePKIX509CertImpl = new PKCS12(new String(cArray), inputStream);
            string.setAuthSafes((List)oraclePKIX509CertImpl.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        oraclePKIX509CertImpl = (PKCS12Safe)string.getAuthSafesAsList().get(0);
        ArrayList arrayList = oraclePKIX509CertImpl.getBagsAsList();
        ArrayList<PKCS12Bag> arrayList2 = new ArrayList<PKCS12Bag>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (n = 0; n < arrayList.size(); ++n) {
            object = (PKCS12Bag)arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(object.getLocalKeyID())) continue;
            arrayList2.add((PKCS12Bag)object);
        }
        oraclePKIX509CertImpl.setBags(arrayList2);
        if (arrayList2.size() > 0 && string.getAuthSafesAsList().isEmpty()) {
            string.addAuthSafe((PKCS12Safe)oraclePKIX509CertImpl);
        }
        n = string.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    boolean a(X500Principal x500Principal, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !x500Name.equals((Object)new X500Name(string = oraclePKIX509CertImpl.getSubjectDN().toString()))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching DN.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl, hashMap);
    }

    boolean a(String string, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2)) continue;
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (!string.equals(string2) || oraclePKIX509CertImpl == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching alias.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl, hashMap);
    }

    int e(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCertCompNum: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        string2 = new PKCS12();
        string2.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.c(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals((Object)x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return OracleLocalKeyId.l(byArray);
        }
        return 0;
    }

    int f(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        PKCS12 pKCS12;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetTCertCompNum: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        string2 = new PKCS12();
        string2.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(cArray, inputStream);
            string2.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12 = (PKCS12Safe)string2.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.d(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals((Object)x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return OracleLocalKeyId.l(byArray);
        }
        return 0;
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.a(inputStream, cArray, x500Principal, null, null, hashMap);
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        Object object2;
        Object object3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        String string3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        X500Name x500Name = null;
        BigInteger bigInteger = null;
        X500Name x500Name2 = new X500Name(x500Principal.toString());
        if (string != null) {
            x500Name = new X500Name(string);
        }
        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string2);
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            oraclePKIX509CertImpl = null;
            if (!this.engineIsCertificateEntry(string3) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string3)) == null) continue;
            object3 = oraclePKIX509CertImpl.getSubjectDN().toString();
            object2 = oraclePKIX509CertImpl.getIssuerDN().toString();
            BigInteger bigInteger2 = oraclePKIX509CertImpl.getSerialNumber();
            bl = false;
            bl2 = false;
            if (!x500Name2.equals((Object)new X500Name((String)object3))) continue;
            if (string == null || string != null && x500Name.equals((Object)new X500Name((String)object2))) {
                bl = true;
            }
            if (string2 == null || string2 != null && bigInteger.equals(bigInteger2)) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            if (!bl3) {
                bl3 = true;
                oraclePKIX509CertImpl2 = oraclePKIX509CertImpl;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025") + " " + oraclePKIX509CertImpl.getSubjectDN().toString());
        }
        if (!bl3) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        string3 = new PKCS12();
        string3.setPasswd(cArray);
        if (inputStream != null) {
            oraclePKIX509CertImpl = new PKCS12(new String(cArray), inputStream);
            string3.setAuthSafes((List)oraclePKIX509CertImpl.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        oraclePKIX509CertImpl = (PKCS12Safe)string3.getAuthSafesAsList().get(0);
        object3 = oraclePKIX509CertImpl.getBagsAsList();
        object2 = new ArrayList(((ArrayList)object3).size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + "bags");
        int n2 = 0;
        X509 x509 = null;
        X509 x5092 = null;
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(object.getLocalKeyID())) {
                String string4;
                x509 = ((PKCS12CertBag)object).getCert();
                if (oraclePKIX509CertImpl2 != null) {
                    x5092 = new X509(oraclePKIX509CertImpl2.getEncoded());
                }
                if (x5092 != null && x5092.equals((Object)x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)oraclePKIX509CertImpl, x509);
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n2));
                String string5 = null;
                byte[] byArray = object.getLocalKeyID();
                string5 = OracleLocalKeyId.a(byArray);
                if (string5 != null && !"".equals(string5)) {
                    byArray = pKCS12CertBag.getLocalKeyID();
                    OracleLocalKeyId.a(byArray, string5);
                    pKCS12CertBag.setLocalKeyID(byArray);
                }
                if ((string4 = object.getFriendlyName()) != null) {
                    pKCS12CertBag.setFriendlyName(string4);
                }
                ((ArrayList)object2).add(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            ((ArrayList)object2).add(object);
        }
        oraclePKIX509CertImpl.setBags((List)object2);
        if (((ArrayList)object2).size() > 0 && string3.getAuthSafesAsList().isEmpty()) {
            string3.addAuthSafe((PKCS12Safe)oraclePKIX509CertImpl);
        }
        n = string3.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string3.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string3.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    protected void a(boolean bl) throws CertificateException {
        for (Object k : this.c.keySet()) {
            OracleKSIdentityEntry oracleKSIdentityEntry;
            Certificate[] certificateArray;
            String string = (String)k;
            if (!this.engineIsKeyEntry(string) || (certificateArray = (oracleKSIdentityEntry = (OracleKSIdentityEntry)this.c.get(string)).c()) == null) continue;
            for (int i = 1; i < certificateArray.length; ++i) {
                X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
                Utils.trustedCertificateValidation((X509Certificate)x509Certificate, (boolean)bl);
            }
        }
    }

    byte[] a(InputStream inputStream, char[] cArray, String string, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        PKCS12Safe pKCS12Safe;
        String string2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !string.equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        string2 = new PKCS12();
        string2.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string2.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        int n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            object = (PKCS12Bag)arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(object.getLocalKeyID())) {
                String string3;
                X509 x509 = ((PKCS12CertBag)object).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals((Object)x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag(pKCS12Safe, x509);
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n2));
                String string4 = null;
                byte[] byArray = object.getLocalKeyID();
                string4 = OracleLocalKeyId.a(byArray);
                if (string4 != null && !"".equals(string4)) {
                    byArray = pKCS12CertBag.getLocalKeyID();
                    OracleLocalKeyId.a(byArray, string4);
                    pKCS12CertBag.setLocalKeyID(byArray);
                }
                if ((string3 = object.getFriendlyName()) != null) {
                    pKCS12CertBag.setFriendlyName(string3);
                }
                arrayList2.add(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            arrayList2.add(object);
        }
        pKCS12Safe.setBags(arrayList2);
        if (arrayList2.size() > 0 && string2.getAuthSafesAsList().isEmpty()) {
            string2.addAuthSafe(pKCS12Safe);
        }
        n = string2.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string2.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string2.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public int retainOnlyLatestAndValidCertificateForUniquePrivateKey() {
        int n = 0;
        Hashtable hashtable = new Hashtable();
        HashMap<Key, OracleKSEntry> hashMap = new HashMap<Key, OracleKSEntry>();
        block3: for (Object object : this.c.keySet()) {
            Object object2 = (String)object;
            if (!this.engineIsKeyEntry((String)object2)) continue;
            OracleKSEntry oracleKSEntry = (OracleKSEntry)this.c.get(object2);
            Key key = oracleKSEntry.a();
            Certificate[] certificateArray = oracleKSEntry.c();
            if (certificateArray != null) {
                for (Certificate certificate : certificateArray) {
                    StringBuilder stringBuilder;
                    X509Certificate x509Certificate;
                    X509Certificate x509Certificate2 = (X509Certificate)certificate;
                    try {
                        x509Certificate2.checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        x509Certificate = (X509Certificate)certificateArray[0];
                        stringBuilder = new StringBuilder("Certificate with Subject DN=").append(x509Certificate2.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate2.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate2.getSerialNumber());
                        stringBuilder.append(" has already expired. ");
                        stringBuilder.append("So import of private key, certificate chain pair having user certificate with SubjectDN=");
                        stringBuilder.append(x509Certificate.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate.getSerialNumber());
                        stringBuilder.append(" is skipped.");
                        System.out.println(stringBuilder);
                        if (OraclePKIDebug.getDebugFlag()) {
                            certificateExpiredException.printStackTrace();
                        }
                        ++n;
                        continue block3;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        x509Certificate = (X509Certificate)certificateArray[0];
                        stringBuilder = new StringBuilder("Certificate with Subject DN=").append(x509Certificate2.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate2.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate2.getSerialNumber());
                        stringBuilder.append(" is not yet into its validity period. ");
                        stringBuilder.append("So import of private key, certificate chain pair having user certificate with SubjectDN=");
                        stringBuilder.append(x509Certificate.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate.getSerialNumber());
                        stringBuilder.append(" is skipped.");
                        System.out.println(stringBuilder);
                        if (OraclePKIDebug.getDebugFlag()) {
                            certificateNotYetValidException.printStackTrace();
                        }
                        ++n;
                        continue block3;
                    }
                }
            }
            if (!hashMap.containsKey(key)) {
                hashMap.put(key, oracleKSEntry);
                continue;
            }
            Object object3 = null;
            X509Certificate x509Certificate = null;
            Certificate[] certificateArray2 = ((OracleKSEntry)hashMap.get(key)).c();
            if (certificateArray2 != null) {
                object3 = (X509Certificate)certificateArray2[0];
            }
            if (certificateArray != null) {
                x509Certificate = (X509Certificate)certificateArray[0];
            }
            if (object3 != null && ((X509Certificate)object3).getNotBefore().compareTo(x509Certificate.getNotBefore()) < 0) {
                hashMap.put(key, oracleKSEntry);
                StringBuilder stringBuilder = new StringBuilder("User certificate with Subject DN=").append(((X509Certificate)object3).getSubjectDN());
                stringBuilder.append(", Issuer DN=").append(((X509Certificate)object3).getIssuerDN());
                stringBuilder.append(", Serial No.=").append(((X509Certificate)object3).getSerialNumber());
                stringBuilder.append(" and corresponding certificate chain are not imported because another user certificate for same private key is more recently issued.");
                System.out.println(stringBuilder);
                continue;
            }
            if (x509Certificate == null) continue;
            StringBuilder stringBuilder = new StringBuilder("User certificate with Subject DN=").append(x509Certificate.getSubjectDN());
            stringBuilder.append(", Issuer DN=").append(x509Certificate.getIssuerDN());
            stringBuilder.append(", Serial No.=").append(x509Certificate.getSerialNumber());
            stringBuilder.append(" and corresponding certificate chain are not imported because another user certificate for same private key is more recently issued.");
            System.out.println(stringBuilder);
        }
        int n2 = 0;
        for (Object object2 : hashMap.keySet()) {
            hashtable.put(o + n2++, hashMap.get(object2));
        }
        this.c = hashtable;
        return n;
    }

    public static ArrayList<String> getAliases(PKCS12 pKCS12) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PKCS12Safe pKCS12Safe : pKCS12.getAuthSafesAsList()) {
            for (PKCS12Bag pKCS12Bag : pKCS12Safe.getBagsAsList()) {
                if (pKCS12Bag.getFriendlyName() == null) continue;
                arrayList.add(pKCS12Bag.getFriendlyName());
            }
        }
        return arrayList;
    }

    public static int getHighestIndexForAliasWithOrakeyPrefix(List<String> list) {
        int n = -1;
        for (String string : list) {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            if (!string2.startsWith(o)) continue;
            String string3 = string2.substring(o.length());
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= n) continue;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public static int getHighestComponentNumber(PKCS12 pKCS12) throws IOException {
        return OracleKeyStoreSpi.getHighestComponentNumber(pKCS12, (byte)0);
    }

    public static int getHighestComponentNumber(PKCS12 pKCS12, byte by) throws IOException {
        int n = 0;
        for (PKCS12Safe pKCS12Safe : pKCS12.getAuthSafesAsList()) {
            for (PKCS12Bag pKCS12Bag : pKCS12Safe.getBagsAsList()) {
                if (!OracleKeyStoreSpi.c(pKCS12Bag) && !OracleKeyStoreSpi.b(pKCS12Bag)) continue;
                byte[] byArray = pKCS12Bag.getLocalKeyID();
                int n2 = OracleLocalKeyId.l(byArray);
                if (OracleKeyStoreSpi.c(pKCS12Bag) && n2 > n) {
                    n = n2;
                    continue;
                }
                if (!OracleKeyStoreSpi.b(pKCS12Bag) || OracleKeyStoreSpi.a(pKCS12, n2, by) || n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    private boolean a(Key key, Certificate[] certificateArray) {
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyAndCertificateChainPresentAlready: Entry");
        for (String string : this.c.keySet()) {
            Certificate[] certificateArray2;
            Key key2;
            OracleKSEntry oracleKSEntry = (OracleKSEntry)this.c.get(string);
            if (!this.engineIsKeyEntry(string) || (key2 = oracleKSEntry.a()) == null || (certificateArray2 = oracleKSEntry.c()) == null || certificateArray2.length <= 0) continue;
            Certificate certificate = certificateArray2[0];
            if (!Arrays.equals(key.getEncoded(), key2.getEncoded()) || !certificateArray[0].equals(certificate)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyAndCertificateChainPresentAlready: Exit");
            return true;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyAndCertificateChainPresentAlready: Exit");
        return false;
    }

    private boolean a(Key key) {
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyPresentAlready: Entry");
        for (String string : this.c.keySet()) {
            Key key2;
            OracleKSEntry oracleKSEntry = (OracleKSEntry)this.c.get(string);
            if (!this.engineIsKeyEntry(string) || (key2 = oracleKSEntry.a()) == null || !Arrays.equals(key.getEncoded(), key2.getEncoded())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyPresentAlready: Exit");
            return true;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyPresentAlready: Exit");
        return false;
    }

    public byte[] internalAddPrivateKeyAndCertificateChain(InputStream inputStream, char[] cArray, String string, Key key, Certificate[] certificateArray) throws IOException, CertificateEncodingException {
        Object object;
        int n;
        Serializable serializable;
        OraclePKIDebug.a("OracleKeyStoreSpi::internalAddPrivateKeyAndCertificateChain: Entry");
        X509 x509 = new X509(certificateArray[0].getEncoded());
        X500Name x500Name = new X500Name(x509.getSubject().toString());
        X500Name x500Name2 = new X500Name(x509.getIssuer().toString());
        X500Name x500Name3 = null;
        X500Name x500Name4 = null;
        X500Name x500Name5 = null;
        X500Name x500Name6 = null;
        boolean bl = false;
        if (x500Name != null && x500Name.equals((Object)x500Name2)) {
            bl = true;
        }
        boolean bl2 = this.a(key);
        boolean bl3 = false;
        if (this.a(key, certificateArray)) {
            bl3 = true;
        }
        if (bl3) {
            PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
            StringBuilder stringBuilder = new StringBuilder("Skipped import of private key, certificate chain pair having user certificate with Subject DN=");
            stringBuilder.append(x509.getSubject());
            stringBuilder.append(", Issuer DN=").append(x509.getIssuer());
            stringBuilder.append(", Serial No.=").append(x509.getSerialNo());
            stringBuilder.append(", because this private key and certificate chain are already present in the wallet.");
            System.out.println(stringBuilder);
            pKCS12.output((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPasswd(cArray);
        ArrayList arrayList = null;
        PKCS12Safe pKCS12Safe = null;
        int n2 = 1;
        ArrayList<String> arrayList2 = null;
        if (inputStream != null) {
            PKCS12 pKCS122 = new PKCS12(new String(cArray), inputStream);
            arrayList = pKCS122.getAuthSafesAsList();
            n2 = OracleKeyStoreSpi.getHighestComponentNumber(pKCS122) + 1;
            arrayList2 = OracleKeyStoreSpi.getAliases(pKCS122);
        } else {
            arrayList = new ArrayList();
            arrayList.add(new PKCS12Safe(pKCS12));
            arrayList2 = new ArrayList<String>();
        }
        int n3 = OracleKeyStoreSpi.getHighestIndexForAliasWithOrakeyPrefix(arrayList2) + 1;
        pKCS12Safe = (PKCS12Safe)arrayList.get(0);
        ArrayList arrayList3 = pKCS12Safe.getBagsAsList();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        boolean bl8 = true;
        boolean bl9 = false;
        boolean bl10 = false;
        PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag(pKCS12Safe, (PrivateKey)key);
        if (!bl2) {
            pKCS12KeyBag.setFriendlyName(o + n3);
            pKCS12KeyBag.setLocalKeyID(OracleLocalKeyId.c(0, n2));
            pKCS12Safe.getBagsAsList().add(pKCS12KeyBag);
            serializable = new StringBuilder("Imported private key, certificate chain pair having Subject DN=");
            ((StringBuilder)serializable).append(x509.getSubject());
            ((StringBuilder)serializable).append(", Issuer DN=").append(x509.getIssuer());
            ((StringBuilder)serializable).append(", Serial No.=").append(x509.getSerialNo());
            ((StringBuilder)serializable).append(" with alias (inside wallet) as ").append(o).append(n3);
            OraclePKIDebug.a(((StringBuilder)serializable).toString());
        }
        serializable = new ArrayList();
        for (n = certificateArray.length - 1; n >= 0; --n) {
            Object object2;
            bl4 = false;
            bl5 = false;
            bl6 = false;
            bl7 = true;
            bl8 = true;
            bl9 = false;
            bl10 = false;
            object = new X509(certificateArray[n].getEncoded());
            for (int i = 0; i < arrayList3.size(); ++i) {
                X509 x5092;
                object2 = (PKCS12Bag)arrayList3.get(i);
                if (OracleKeyStoreSpi.a((PKCS12Bag)object2) && OracleLocalKeyId.d(object2.getLocalKeyID())) {
                    x5092 = ((PKCS12CertBag)object2).getCert();
                    if (x5092 != null && x5092.equals(object)) {
                        bl4 = true;
                        if (n != 0) {
                            break;
                        }
                    } else {
                        x500Name3 = new X500Name(object.getSubject().toString());
                        x500Name4 = new X500Name(object.getIssuer().toString());
                        x500Name5 = new X500Name(x5092.getSubject().toString());
                        x500Name6 = new X500Name(x5092.getIssuer().toString());
                        if (x500Name3 != null && x500Name3.equals((Object)x500Name5) && x500Name4 != null && x500Name4.equals((Object)x500Name6) && this.IsPubKeyMatching(new OraclePKIX509CertImpl((X509)object), new OraclePKIX509CertImpl(x5092))) {
                            if (object.getNotBefore().compareTo(x5092.getNotBefore()) > 0) {
                                bl10 = true;
                                arrayList3.remove(i);
                                if (n != 0) break;
                                --i;
                            } else {
                                bl8 = false;
                            }
                        }
                    }
                }
                if (n != 0 || !OracleKeyStoreSpi.a((PKCS12Bag)object2) || !OracleLocalKeyId.c(object2.getLocalKeyID())) continue;
                x5092 = ((PKCS12CertBag)object2).getCert();
                if (x5092 != null && x5092.equals(object)) {
                    bl5 = true;
                    continue;
                }
                if (!this.IsPubKeyMatching(new OraclePKIX509CertImpl(x509), new OraclePKIX509CertImpl(x5092))) continue;
                bl6 = true;
                x500Name5 = new X500Name(x5092.getSubject().toString());
                x500Name6 = new X500Name(x5092.getIssuer().toString());
                if (x500Name == null || !x500Name.equals((Object)x500Name5) || x500Name2 == null || !x500Name2.equals((Object)x500Name6)) continue;
                if (x509.getNotBefore().compareTo(x5092.getNotBefore()) > 0) {
                    bl9 = true;
                    arrayList3.remove(i);
                    continue;
                }
                bl7 = false;
            }
            PKCS12CertBag pKCS12CertBag = new PKCS12CertBag(pKCS12Safe, (X509)object);
            if (n != 0 && !bl4 && bl8) {
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, 0));
                ((ArrayList)serializable).add(pKCS12CertBag);
                continue;
            }
            if (n != 0) continue;
            if (bl && !bl4 && bl8) {
                object2 = new PKCS12CertBag(pKCS12Safe, (X509)object);
                object2.setLocalKeyID(OracleLocalKeyId.b(0, 0));
                ((ArrayList)serializable).add(object2);
            }
            if (!bl6 || bl9) {
                pKCS12CertBag.setFriendlyName(o + n3);
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.c(0, n2));
                ((ArrayList)serializable).add(pKCS12CertBag);
                continue;
            }
            object2 = new StringBuilder("Skipped import of user certificate with Subject DN=");
            ((StringBuilder)object2).append(x509.getSubject());
            ((StringBuilder)object2).append(", Issuer DN=").append(x509.getIssuer());
            ((StringBuilder)object2).append(", Serial No.=").append(x509.getSerialNo());
            ((StringBuilder)object2).append(", because a user cert with same private key is already present in the wallet and that is most recently issued certificate.");
            System.out.println(object2);
        }
        arrayList3.addAll(serializable);
        pKCS12Safe.setBags((List)arrayList3);
        if (!bl2) {
            OracleKSIdentityEntry oracleKSIdentityEntry = new OracleKSIdentityEntry((PKCS12Bag)pKCS12KeyBag, new Vector(serializable), new Vector());
            this.c.put(string, oracleKSIdentityEntry);
        }
        pKCS12.setAuthSafes((List)arrayList);
        n = pKCS12.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        pKCS12.output((OutputStream)object);
        OraclePKIDebug.a("OracleKeyStoreSpi::internalAddPrivateKeyAndCertificateChain: Exit");
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, HashMap hashMap, boolean bl, byte by) throws IOException, KeyStoreException {
        int n;
        Object object;
        Object object2;
        Object object3;
        PKCS12 pKCS12;
        ((ByteArrayInputStream)inputStream).mark(((ByteArrayInputStream)inputStream).available());
        byte[] byArray = this.a(inputStream, cArray, oraclePKIX509CertImpl, hashMap);
        ((ByteArrayInputStream)inputStream).reset();
        if (byArray == null && this.getP11Lib() != null) {
            byArray = this.a(inputStream, cArray, oraclePKIX509CertImpl);
        }
        ((ByteArrayInputStream)inputStream).reset();
        PKCS12 pKCS122 = new PKCS12();
        pKCS122.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12 = new PKCS12(new String(cArray), inputStream);
            pKCS122.setAuthSafes((List)pKCS12.getAuthSafesAsList());
        }
        pKCS12 = null;
        if (pKCS122.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12 = new PKCS12Safe(pKCS122);
            if ((by & 4) != 0) {
                pKCS12.setMode(3);
            } else {
                pKCS12.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12 = (PKCS12Safe)pKCS122.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            object3 = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object3) || !OracleLocalKeyId.c(object3.getLocalKeyID())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
            ++n2;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)pKCS12, oraclePKIX509CertImpl.getX509());
        if (bl) {
            OracleLocalKeyId.a(byArray, TrustFlags.d.c());
        }
        pKCS12CertBag.setLocalKeyID(byArray);
        object3 = oraclePKIX509CertImpl.getPublicKey().getAlgorithm();
        RSA rSA = null;
        BigInteger bigInteger = null;
        byte[] byArray2 = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = BigInteger.TEN;
        KeyPair keyPair = null;
        byte[] byArray3 = null;
        if (((String)object3).equals("RSA")) {
            if (TransitionMode.isJCEUseEnabled()) {
                try {
                    object2 = JCEUtil.getCipherInstance((String)"RSA/ECB/PKCS1Padding");
                    ((Cipher)object2).init(1, oraclePKIX509CertImpl.getPublicKey());
                    byArray2 = ((Cipher)object2).doFinal(bigInteger3.toByteArray());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (OraclePKIDebug.getDebugFlag()) {
                        generalSecurityException.printStackTrace();
                    }
                }
            } else {
                rSA = new RSA();
                object2 = new RSAPublicKey(oraclePKIX509CertImpl.getPublicKey().getEncoded());
                rSA.setKey((RSAKey)object2);
                bigInteger = rSA.performOp(bigInteger3);
            }
        } else if (((String)object3).equals("EC")) {
            try {
                object2 = JCEUtil.getKeyPairGeneratorInstance((String)"EC");
                ((KeyPairGenerator)object2).initialize(((ECPublicKey)oraclePKIX509CertImpl.getPublicKey()).getParams());
                keyPair = ((KeyPairGenerator)object2).generateKeyPair();
                object = JCEUtil.getKeyAgreementInstance((String)"ECDH");
                ((KeyAgreement)object).init(keyPair.getPrivate());
                ((KeyAgreement)object).doPhase((ECPublicKey)oraclePKIX509CertImpl.getPublicKey(), true);
                byArray3 = ((KeyAgreement)object).generateSecret();
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        if (string != null) {
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object4;
                PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
                if (pKCS12Bag.getFriendlyName() == null || !pKCS12Bag.getFriendlyName().equals(string)) continue;
                oracle.security.crypto.core.PrivateKey privateKey = null;
                if (pKCS12Bag instanceof PKCS12KeyBag) {
                    privateKey = ((PKCS12KeyBag)pKCS12Bag).getPrivateKey();
                } else {
                    if (!(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) continue;
                    privateKey = ((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
                }
                String string2 = privateKey.getAlgorithm();
                if (!string2.equals(object3)) continue;
                if (string2.equals("RSA")) {
                    if (TransitionMode.isJCEUseEnabled()) {
                        try {
                            object4 = JCEUtil.getCipherInstance((String)"RSA/ECB/PKCS1Padding");
                            ((Cipher)object4).init(2, (Key)privateKey);
                            bigInteger2 = new BigInteger(((Cipher)object4).doFinal(byArray2));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            if (OraclePKIDebug.getDebugFlag()) {
                                generalSecurityException.printStackTrace();
                            }
                            bigInteger2 = BigInteger.ZERO;
                        }
                    } else {
                        rSA.setKey((RSAKey)((RSAPrivateKey)privateKey));
                        bigInteger2 = rSA.performOp(bigInteger);
                    }
                    if (!bigInteger2.equals(bigInteger3)) continue;
                    n = 1;
                    break;
                }
                if (!string2.equals("EC")) continue;
                try {
                    object4 = JCEUtil.getKeyAgreementInstance((String)"ECDH");
                    ((KeyAgreement)object4).init((ECPrivateKey)privateKey);
                    if (keyPair != null) {
                        ((KeyAgreement)object4).doPhase(keyPair.getPublic(), true);
                    }
                    if (!Arrays.equals(byArray3, ((KeyAgreement)object4).generateSecret())) continue;
                    n = 1;
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
            if (n == 0) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                Object object5;
                object = (PKCS12Bag)arrayList.get(n);
                oracle.security.crypto.core.PrivateKey privateKey = null;
                if (object instanceof PKCS12KeyBag) {
                    privateKey = ((PKCS12KeyBag)object).getPrivateKey();
                } else {
                    if (!(object instanceof PKCS12ShroudedKeyBag)) continue;
                    privateKey = ((PKCS12ShroudedKeyBag)object).getPrivateKey();
                }
                String string3 = privateKey.getAlgorithm();
                if (!string3.equals(object3)) continue;
                if (string3.equals("RSA")) {
                    if (TransitionMode.isJCEUseEnabled()) {
                        try {
                            object5 = JCEUtil.getCipherInstance((String)"RSA/ECB/PKCS1Padding");
                            ((Cipher)object5).init(2, (Key)privateKey);
                            bigInteger2 = new BigInteger(((Cipher)object5).doFinal(byArray2));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            if (OraclePKIDebug.getDebugFlag()) {
                                generalSecurityException.printStackTrace();
                            }
                            bigInteger2 = BigInteger.ZERO;
                        }
                    } else {
                        rSA.setKey((RSAKey)((RSAPrivateKey)privateKey));
                        bigInteger2 = rSA.performOp(bigInteger);
                    }
                    if (!bigInteger2.equals(bigInteger3)) continue;
                    string = object.getFriendlyName();
                    break;
                }
                if (!string3.equals("EC")) continue;
                try {
                    object5 = JCEUtil.getKeyAgreementInstance((String)"ECDH");
                    ((KeyAgreement)object5).init((ECPrivateKey)privateKey);
                    if (keyPair != null) {
                        ((KeyAgreement)object5).doPhase(keyPair.getPublic(), true);
                    }
                    if (!Arrays.equals(byArray3, ((KeyAgreement)object5).generateSecret())) continue;
                    string = object.getFriendlyName();
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
        }
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string.toLowerCase());
        }
        arrayList.add(pKCS12CertBag);
        OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        pKCS12.setBags((List)arrayList);
        if (arrayList.size() > 0 && pKCS122.getAuthSafesAsList().isEmpty()) {
            pKCS122.addAuthSafe((PKCS12Safe)pKCS12);
        }
        n = pKCS122.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS122.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        pKCS122.output((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object;
        int n;
        PKCS12Safe pKCS12Safe;
        String string3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string3) || (oraclePKIX509CertImpl2 = (OraclePKIX509CertImpl)this.engineGetCertificate(string3)) == null || !string.equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalReplaceTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        string3 = new PKCS12();
        string3.setPasswd(cArray);
        if (inputStream != null) {
            pKCS12Safe = new PKCS12(new String(cArray), inputStream);
            string3.setAuthSafes((List)pKCS12Safe.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        pKCS12Safe = (PKCS12Safe)string3.getAuthSafesAsList().get(0);
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
        Vector<Object> vector2 = new Vector<Object>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        int n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            object = (PKCS12Bag)arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(object.getLocalKeyID())) {
                byte[] byArray;
                PKCS12CertBag pKCS12CertBag;
                X509 x509 = ((PKCS12CertBag)object).getCert();
                X509 x5092 = null;
                if (oraclePKIX509CertImpl2 != null) {
                    x5092 = new X509(oraclePKIX509CertImpl2.getEncoded());
                }
                if (x509.equals((Object)oraclePKIX509CertImpl.getX509()) && (x5092 == null || !x5092.equals((Object)oraclePKIX509CertImpl.getX509()))) {
                    OraclePKIDebug.a("Certificate is already present in wallet.");
                    throw new IOException(a.getString("PKI-04003") + " " + oraclePKIX509CertImpl.getSubjectDN().toString());
                }
                if (x5092 == null || !x5092.equals((Object)x509)) {
                    String string4;
                    if (object.getFriendlyName() != null && object.getFriendlyName().equalsIgnoreCase(string)) {
                        throw new IOException(a.getString("PKI-04008") + string);
                    }
                    pKCS12CertBag = new PKCS12CertBag(pKCS12Safe, x509);
                    pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n2));
                    String string5 = null;
                    byArray = object.getLocalKeyID();
                    string5 = OracleLocalKeyId.a(byArray);
                    if (string5 != null && !"".equals(string5)) {
                        byArray = pKCS12CertBag.getLocalKeyID();
                        OracleLocalKeyId.a(byArray, string5);
                        pKCS12CertBag.setLocalKeyID(byArray);
                    }
                    if ((string4 = object.getFriendlyName()) != null) {
                        pKCS12CertBag.setFriendlyName(string4);
                    }
                    arrayList2.add(pKCS12CertBag);
                    vector2.addElement(pKCS12CertBag);
                    OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                    ++n2;
                    continue;
                }
                pKCS12CertBag = new PKCS12CertBag(pKCS12Safe, oraclePKIX509CertImpl.getX509());
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n2));
                if (string2 == null) {
                    byArray = object.getLocalKeyID();
                    string2 = OracleLocalKeyId.a(byArray);
                }
                if (string2 != null) {
                    byArray = pKCS12CertBag.getLocalKeyID();
                    OracleLocalKeyId.a(byArray, string2);
                    pKCS12CertBag.setLocalKeyID(byArray);
                }
                pKCS12CertBag.setFriendlyName(string.toLowerCase());
                arrayList2.add(pKCS12CertBag);
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                continue;
            }
            arrayList2.add(object);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object)) continue;
            vector2.addElement(object);
            if (!OracleLocalKeyId.d(object.getLocalKeyID())) continue;
            vector.addElement((PKCS12Bag)object);
        }
        pKCS12Safe.setBags(arrayList2);
        if (arrayList2.size() > 0 && string3.getAuthSafesAsList().isEmpty()) {
            string3.addAuthSafe(pKCS12Safe);
        }
        n = string3.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string3.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string3.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, String string3, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        Object object3;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2;
        String string4;
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        X500Name x500Name = null;
        BigInteger bigInteger = null;
        X500Name x500Name2 = new X500Name(oraclePKIX509CertImpl.getSubjectDN().toString());
        if (string != null) {
            x500Name = new X500Name(string);
        }
        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string2);
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            oraclePKIX509CertImpl2 = null;
            if (!this.engineIsCertificateEntry(string4) || (oraclePKIX509CertImpl2 = (OraclePKIX509CertImpl)this.engineGetCertificate(string4)) == null) continue;
            object3 = oraclePKIX509CertImpl2.getSubjectDN().toString();
            object2 = oraclePKIX509CertImpl2.getIssuerDN().toString();
            serializable = oraclePKIX509CertImpl2.getSerialNumber();
            bl = false;
            bl2 = false;
            bl3 = false;
            if (!x500Name2.equals((Object)new X500Name((String)object3))) continue;
            if (string == null || x500Name != null && x500Name.equals((Object)new X500Name((String)object2))) {
                bl = true;
            }
            if (bigInteger == null || bigInteger != null && bigInteger.equals(serializable)) {
                bl2 = true;
            }
            if (this.IsPubKeyMatching(oraclePKIX509CertImpl, oraclePKIX509CertImpl2)) {
                bl3 = true;
            }
            if (!bl || !bl2 || !bl3) continue;
            if (!bl4) {
                bl4 = true;
                oraclePKIX509CertImpl3 = oraclePKIX509CertImpl2;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025") + " " + oraclePKIX509CertImpl2.getSubjectDN().toString());
        }
        if (!bl4) {
            OraclePKIDebug.a("internalReplaceTrustedCert: No trusted cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        string4 = new PKCS12();
        string4.setPasswd(cArray);
        if (inputStream != null) {
            oraclePKIX509CertImpl2 = new PKCS12(new String(cArray), inputStream);
            string4.setAuthSafes((List)oraclePKIX509CertImpl2.getAuthSafesAsList());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        oraclePKIX509CertImpl2 = (PKCS12Safe)string4.getAuthSafesAsList().get(0);
        object3 = oraclePKIX509CertImpl2.getBagsAsList();
        object2 = new ArrayList(((ArrayList)object3).size());
        serializable = new Vector();
        Vector<Object> vector = new Vector<Object>(((ArrayList)object3).size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + " bags");
        int n2 = 0;
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(object.getLocalKeyID())) {
                byte[] byArray;
                PKCS12CertBag pKCS12CertBag;
                X509 x509 = ((PKCS12CertBag)object).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl3.getEncoded());
                if (x509.equals((Object)oraclePKIX509CertImpl.getX509()) && (x5092 == null || !x5092.equals((Object)oraclePKIX509CertImpl.getX509()))) {
                    OraclePKIDebug.a("Certificate is already present in wallet.");
                    throw new IOException(a.getString("PKI-04003") + " " + oraclePKIX509CertImpl.getSubjectDN().toString());
                }
                if (x5092 == null || !x5092.equals((Object)x509)) {
                    String string5;
                    pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)oraclePKIX509CertImpl2, x509);
                    pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n2));
                    String string6 = null;
                    byArray = object.getLocalKeyID();
                    string6 = OracleLocalKeyId.a(byArray);
                    if (string6 != null && !"".equals(string6)) {
                        byArray = pKCS12CertBag.getLocalKeyID();
                        OracleLocalKeyId.a(byArray, string6);
                        pKCS12CertBag.setLocalKeyID(byArray);
                    }
                    if ((string5 = object.getFriendlyName()) != null) {
                        pKCS12CertBag.setFriendlyName(string5);
                    }
                    ((ArrayList)object2).add(pKCS12CertBag);
                    vector.addElement(pKCS12CertBag);
                    OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                    ++n2;
                    continue;
                }
                pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)oraclePKIX509CertImpl2, oraclePKIX509CertImpl.getX509());
                pKCS12CertBag.setLocalKeyID(OracleLocalKeyId.b(0, n2));
                if (string3 == null) {
                    byArray = object.getLocalKeyID();
                    string3 = OracleLocalKeyId.a(byArray);
                }
                if (string3 != null) {
                    byArray = pKCS12CertBag.getLocalKeyID();
                    OracleLocalKeyId.a(byArray, string3);
                    pKCS12CertBag.setLocalKeyID(byArray);
                }
                ((ArrayList)object2).add(pKCS12CertBag);
                vector.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                continue;
            }
            ((ArrayList)object2).add(object);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object)) continue;
            vector.addElement(object);
            if (!OracleLocalKeyId.c(object.getLocalKeyID())) continue;
            ((Vector)serializable).addElement(object);
        }
        oraclePKIX509CertImpl2.setBags((List)object2);
        if (((ArrayList)object2).size() > 0 && string4.getAuthSafesAsList().isEmpty()) {
            string4.addAuthSafe((PKCS12Safe)oraclePKIX509CertImpl2);
        }
        n = string4.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + string4.getAuthSafesAsList().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        string4.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        byte[] byArray = null;
        int n = -1;
        try {
            int n2 = NZNative.Pkcs11HasMatchingPvtKey(this.getP11Lib(), this.getP11TokenLabel(), this.getP11TokenPassphrase(), oraclePKIX509CertImpl.getEncoded());
            if (n2 != 0) {
                OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in HSM");
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            IOException iOException = new IOException();
            iOException.initCause(certificateEncodingException);
            throw iOException;
        }
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            if (!((OracleKSEntry)entry.getValue() instanceof OracleKSIdentityEntry)) continue;
            OracleKSIdentityEntry oracleKSIdentityEntry = (OracleKSIdentityEntry)entry.getValue();
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)oracleKSIdentityEntry.a();
            CertificateRequest certificateRequest = oraclePKIRSAPrivateKey.getCertificateRequest();
            OraclePKIRSAPublicKey oraclePKIRSAPublicKey = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl.getPublicKey();
            if (oraclePKIRSAPrivateKey.isPvtKeyPresent() || certificateRequest == null || !this.a(oraclePKIRSAPublicKey, certificateRequest)) continue;
            n = ((OracleKSIdentityEntry)entry.getValue()).i();
            if (((OracleKSIdentityEntry)entry.getValue()).b() == null) break;
            throw new IOException(a.getString("PKI-04004"));
        }
        if (n == -1) {
            OraclePKIDebug.a("OracleKeyStoreSpi: Could not generate localkeyID");
            throw new IOException("OracleKeyStoreSpi: Could not generate localkeyID");
        }
        byArray = OracleLocalKeyId.e(0, n);
        return byArray;
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, HashMap hashMap) throws IOException {
        byte[] byArray = null;
        boolean bl = false;
        boolean bl2 = false;
        if (hashMap != null && hashMap.size() > 0) {
            bl = true;
        }
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            if (!((OracleKSEntry)entry.getValue() instanceof OracleKSIdentityEntry)) continue;
            PrivateKey privateKey = null;
            PublicKey publicKey = null;
            if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("RSA")) {
                if (((OracleKSEntry)entry.getValue()).a() instanceof OraclePKIECPrivateKey) continue;
                privateKey = (OraclePKIRSAPrivateKey)((OracleKSEntry)entry.getValue()).a();
                publicKey = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl.getPublicKey();
                if (!((OraclePKIRSAPrivateKey)privateKey).isPvtKeyPresent() || !this.a((OraclePKIRSAPublicKey)publicKey, (OraclePKIRSAPrivateKey)privateKey)) continue;
                if (((OraclePKIRSAPrivateKey)privateKey).getCertificateRequest() == null) {
                    throw new IOException(a.getString("PKI-04005"));
                }
            } else if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("EC")) {
                if (((OracleKSEntry)entry.getValue()).a() instanceof OraclePKIRSAPrivateKey) continue;
                privateKey = (OraclePKIECPrivateKey)((OracleKSEntry)entry.getValue()).a();
                publicKey = (OraclePKIECPublicKey)oraclePKIX509CertImpl.getPublicKey();
                if (!((OraclePKIECPrivateKey)privateKey).isPvtKeyPresent() || !this.a((OraclePKIECPublicKey)publicKey, (OraclePKIECPrivateKey)privateKey)) continue;
                if (((OraclePKIECPrivateKey)privateKey).getCertificateRequest() == null) {
                    throw new IOException(a.getString("PKI-04005"));
                }
            }
            byArray = ((OracleKSIdentityEntry)entry.getValue()).h();
            if (((OracleKSIdentityEntry)entry.getValue()).b() == null) break;
            throw new IOException(a.getString("PKI-04004"));
        }
        if (byArray == null) {
            OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in wallet");
            if (this.getP11Lib() == null) {
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        return byArray;
    }

    boolean a(OraclePKIRSAPublicKey oraclePKIRSAPublicKey, CertificateRequest certificateRequest) {
        boolean bl = false;
        BigInteger bigInteger = oraclePKIRSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = oraclePKIRSAPublicKey.getModulus();
        BigInteger bigInteger3 = ((RSAPublicKey)certificateRequest.getPublicKey()).getExponent();
        BigInteger bigInteger4 = ((RSAPublicKey)certificateRequest.getPublicKey()).getModulus();
        if (bigInteger.equals(bigInteger3) && bigInteger2.equals(bigInteger4)) {
            bl = true;
        }
        return bl;
    }

    boolean a(OraclePKIRSAPublicKey oraclePKIRSAPublicKey, OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey) {
        boolean bl = false;
        BigInteger bigInteger = oraclePKIRSAPrivateKey.getPublicExponent();
        BigInteger bigInteger2 = oraclePKIRSAPrivateKey.getModulus();
        if (bigInteger.equals(oraclePKIRSAPublicKey.getPublicExponent()) && bigInteger2.equals(oraclePKIRSAPublicKey.getModulus())) {
            bl = true;
        }
        return bl;
    }

    boolean a(OraclePKIECPublicKey oraclePKIECPublicKey, OraclePKIECPrivateKey oraclePKIECPrivateKey) {
        try {
            byte[] byArray = "abcxyz".getBytes();
            Signature signature = JCEUtil.getSignatureInstance((String)"SHA256withECDSA");
            signature.initSign(oraclePKIECPrivateKey);
            signature.update(byArray, 0, byArray.length);
            byte[] byArray2 = signature.sign();
            Signature signature2 = JCEUtil.getSignatureInstance((String)"SHA256withECDSA");
            signature2.initVerify(oraclePKIECPublicKey);
            signature2.update(byArray, 0, byArray.length);
            return signature2.verify(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl, HashMap hashMap) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        if (hashMap != null && hashMap.size() > 0) {
            bl2 = true;
        }
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext() && !bl) {
            String string;
            String string2;
            Certificate[] certificateArray;
            Map.Entry entry = iterator.next();
            if (!((OracleKSEntry)entry.getValue() instanceof OracleKSIdentityEntry) || (certificateArray = ((OracleKSIdentityEntry)entry.getValue()).c()) == null) continue;
            for (int i = 0; !(i >= certificateArray.length || i > 0 && bl2 && (string2 = (String)hashMap.get(string = CertType.a.b() + ((X509Certificate)certificateArray[i]).getSubjectDN().getName() + ((X509Certificate)certificateArray[i]).getIssuerDN().getName() + ((X509Certificate)certificateArray[i]).getSerialNumber().toString())) != null && string2.indexOf(TrustFlags.a.c()) != -1); ++i) {
                if (!oraclePKIX509CertImpl.equals(certificateArray[i])) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            Certificate certificate;
            if (!((OracleKSEntry)entry.getValue() instanceof OracleKSTrustedCertEntry) || !(certificate = ((OracleKSEntry)entry.getValue()).b()).equals(oraclePKIX509CertImpl)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean a(PKCS12 pKCS12, int n, byte by) throws IOException {
        boolean bl = false;
        PKCS12Safe pKCS12Safe = null;
        if (pKCS12.getAuthSafesAsList().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12Safe = new PKCS12Safe(pKCS12);
            if ((by & 4) != 0) {
                pKCS12Safe.setMode(3);
            } else {
                pKCS12Safe.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA256, AlgID.aes256_CBC);
            }
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12Safe = (PKCS12Safe)pKCS12.getAuthSafesAsList().get(0);
        }
        ArrayList arrayList = pKCS12Safe.getBagsAsList();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray;
            int n2;
            PKCS12Bag pKCS12Bag = (PKCS12Bag)arrayList.get(i);
            if (!OracleKeyStoreSpi.c(pKCS12Bag) || (n2 = OracleLocalKeyId.l(byArray = pKCS12Bag.getLocalKeyID())) != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap, boolean bl) throws Exception {
        String string;
        Object object;
        Object object2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        String string2;
        String string3 = null;
        byte[] byArray = null;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string4;
            string2 = (String)enumeration.nextElement();
            if (null == string2 || string2.isEmpty() || null == (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2))) continue;
            object2 = oraclePKIX509CertImpl.getSubjectDN();
            String string5 = string4 = object2 != null ? object2.getName() : null;
            if (bl) {
                string3 = TrustFlags.e.c();
            } else if (null != string2) {
                object = oraclePKIX509CertImpl.getIssuerDN();
                string = object != null ? object.getName() : null;
                String string6 = this.engineIsCertificateEntry(string2) ? CertType.a.name() : CertType.b.name();
                string3 = OracleTrustFlagHelper.evaluateTrustFlagForCert(string4, string, oraclePKIX509CertImpl.getBasicConstraints(), string6);
            }
            hashMap2.put(string4, string3);
        }
        string2 = new PKCS12();
        string2.setPasswd(cArray);
        if (inputStream != null) {
            oraclePKIX509CertImpl = new PKCS12(new String(cArray), inputStream);
            string2.setAuthSafes((List)oraclePKIX509CertImpl.getAuthSafesAsList());
        }
        oraclePKIX509CertImpl = (PKCS12Safe)string2.getAuthSafesAsList().get(0);
        object2 = oraclePKIX509CertImpl.getBagsAsList();
        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            object = (PKCS12Bag)((ArrayList)object2).get(i);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object)) continue;
            byArray = object.getLocalKeyID();
            string = ((PKCS12CertBag)object).getCert();
            string3 = (String)hashMap2.get(string.getSubjectDN().getName());
            OracleLocalKeyId.a(byArray, string3);
            object.setLocalKeyID(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
        string2.output((OutputStream)byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagsto Cert: Exit");
        return byteArrayOutputStream.toByteArray();
    }
}

