/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.RevokedCertificate;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.ext.AuthorityKeyIDExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.cert.ext.SubjectAltNameExtension;
import oracle.security.crypto.cert.ext.SubjectKeyIDExtension;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.ECPrivateKey;
import oracle.security.crypto.core.ECPublicKey;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Utils;
import oracle.security.pki.C041;
import oracle.security.pki.NZNative;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OracleFileSSOWalletImpl;
import oracle.security.pki.OracleFileWalletImpl;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OracleNewWalletImpl;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletImpl;
import oracle.security.pki.OracleWalletJks;
import oracle.security.pki.OracleWalletPersona;
import oracle.security.pki.internal.OraclePKIRSAKeyHelper;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.EccCurveParameters;
import oracle.security.pki.util.SignatureAlgorithms;

public class OracleWallet {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private static final String j = "file:";
    private static final String k = "reg:";
    private static final char l = ':';
    protected static final String b = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    protected static final String c = "-----END NEW CERTIFICATE REQUEST-----";
    protected static final String d = "-----BEGIN CERTIFICATE-----";
    protected static final String e = "-----END CERTIFICATE-----";
    protected static final String f = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    protected static final String g = "-----END ENCRYPTED PRIVATE KEY-----";
    protected static final String h = "-----BEGIN PRIVATE KEY-----";
    protected static final String i = "-----END PRIVATE KEY-----";
    private String m = null;
    private byte[] n = null;
    private char[] o = null;
    private char[] p = null;
    private boolean q = false;
    private HashMap r;
    private OracleWalletImpl s = null;
    private int t = 0;
    private OracleSecretStore u = null;
    private AlgorithmIdentifier v = null;
    private AlgorithmIdentifier w = null;
    public static final byte WLTCONF_NONE = 0;
    public static final byte WLTCONF_V12Compat = 1;
    public static final byte WLTCONF_TFCompat = 2;
    public static final int MIGRATE_ALL = 0;
    public static final int MIGRATE_KEY_ENTIRES_ONLY = 1;
    public static final int MIGRATE_TRUSTED_ENTRIES_ONLY = 2;
    public static final boolean SUPPORTS_MULTIPLE_CERTS_FOR_A_PRIVATE_KEY = false;
    private static String x = "MIICNDCCAaECEAKtZn5ORf5eV288mBle3cAwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk0MTEwOTAwMDAwMFoXDTEwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGbMA0GCSqGSIb3DQEBAQUAA4GJADCBhQJ+AJLOesGugz5aqomDV6wlAXYMra6OLDfO6zV4ZFQD5YRAUcm/jwjiioII0haGN1XpsSECrXZogZoFokvJSyVmIlZsiAeP94FZbYQHZXATcXY+m3dM41CJVphIuR2nKRoTLkoRWZweFdVJVCxzOmmCsZc5nG1wZ0jl3S3WyB57AgMBAAEwDQYJKoZIhvcNAQECBQADfgBl3X7hsuyw4jrg7HFGmhkRuNPHoLQDQCYCPgmc4RKz0Vr2N6W3YQO2WxZpO8ZECAyIUwxrl0nHPjXcbLm7qt9cuzovk2C2qUtN8iD3zV9/ZHuO3ABc1/p3yjkWWW8O6tO1g39NTUJWdrTJXwT4OPjr0l91X817/OWOgHz8UA==";
    public static final String ENTRUST_PREMIUM_CERT = "MIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEyMjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGAvtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEAWUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMooPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQh7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfNB/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVyvUxFnmG6v4SBkgPR0ml8xQ==";
    public static final String ENTRUST_GLOBAL_CERT = "MIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChMLRW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBaFw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UECxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaBbL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoTC0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAwIEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1UdDgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsiad0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraFJnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1UyrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==";
    public static final String ENTRUST_MAIN_CERT = "MIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5uZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OCAdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHboIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8BdiE1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAaMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=";

    public OracleWallet() {
        this.b();
    }

    public static OracleWallet getInstance(String string) {
        OracleWallet oracleWallet = null;
        oracleWallet = string != null && string.equals("jks") ? new OracleWalletJks() : new OracleWallet();
        return oracleWallet;
    }

    public String getLocation() {
        return this.m;
    }

    public HashMap getMapTrustFlagsValue() {
        if (this.q && this.r != null && this.r.size() > 0) {
            return new HashMap(this.r);
        }
        return null;
    }

    public void setLocation(String string) {
        this.m = string;
    }

    public void setWalletRioType(int n) {
        this.t = n;
    }

    public void setCertSignAlgorithm(String string) {
        if (string == null) {
            return;
        }
        this.v = SignatureAlgorithms.b(string);
        if (this.v == null) {
            System.out.println(a.getString("INVALID_SIGNATURE_ALGORITHM") + string);
        }
    }

    public String getCertSignAlgorithm() {
        if (this.v != null) {
            return this.v.toString();
        }
        return "(default)";
    }

    public AlgorithmIdentifier getCertSignAlgorithmId() {
        if (this.v != null) {
            return this.v;
        }
        return null;
    }

    public void setCRLSignAlgorithm(String string) {
        if (string == null) {
            return;
        }
        this.v = SignatureAlgorithms.b(string);
        if (this.v == null) {
            System.out.println(a.getString("INVALID_SIGNATURE_ALGORITHM") + string);
        }
    }

    public String getCRLSignAlgorithm() {
        if (this.w != null) {
            return this.w.toString();
        }
        return "(default)";
    }

    public static String getDefaultLocation() {
        return null;
    }

    public static boolean isValidPassword(char[] cArray) {
        int n = 8;
        boolean bl = false;
        boolean bl2 = false;
        if (cArray == null) {
            return false;
        }
        if (cArray.length < 8) {
            return false;
        }
        for (char c : cArray) {
            if (Character.isLetter(c)) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return bl && bl2;
    }

    public static int[] getKeysizes() {
        int[] nArray = new int[OraclePKIRSAKeyHelper.getKeySizes().size()];
        int n = 0;
        for (Integer n2 : OraclePKIRSAKeyHelper.getKeySizes()) {
            nArray[n++] = n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2) throws IOException {
        BigInteger bigInteger = new BigInteger(128, JCEUtil.getSecureRandom());
        this.a(x500Principal, n, n2, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n) throws IOException {
        BigInteger bigInteger = new BigInteger(128, JCEUtil.getSecureRandom());
        this.a(x500Principal, string, n, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger, String string) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, null, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger, String string2) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, null, string2);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, oracleCertExtension, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string2) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, oracleCertExtension, string2);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2) throws IOException {
        this.a(x500Principal, n, 0, date, date2, BigInteger.ZERO, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2) throws IOException {
        this.a(x500Principal, string, 0, date, date2, BigInteger.ZERO, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger, String string) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, null, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger, String string2) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, null, string2);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, oracleCertExtension, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string2) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, oracleCertExtension, string2);
    }

    private void a(X500Principal x500Principal, int n, int n2, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        OraclePKIRSAKeyHelper.validateKeysize(n);
        try {
            KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance((String)"RSA");
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            java.security.PublicKey publicKey = keyPair.getPublic();
            this.a(x500Principal, privateKey, publicKey, n2, date, date2, bigInteger, oracleCertExtension, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(a.getString("PKI-02013"));
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
    }

    private void a(X500Principal x500Principal, String string, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string2) throws IOException {
        if (string == null) {
            throw new IOException(a.getString("PKI-07011"));
        }
        try {
            KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance((String)"EC");
            ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(EccCurveParameters.b(string).c());
            try {
                keyPairGenerator.initialize(eCGenParameterSpec);
                KeyPair keyPair = keyPairGenerator.genKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                java.security.PublicKey publicKey = keyPair.getPublic();
                this.a(x500Principal, privateKey, publicKey, n, date, date2, bigInteger, oracleCertExtension, string2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IOException(a.getString("PKI-07009"));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(a.getString("PKI-02014"));
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
    }

    private void a(X500Principal x500Principal, PrivateKey privateKey, java.security.PublicKey publicKey, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        Object object;
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, publicKey, privateKey);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        SubjectKeyIDExtension subjectKeyIDExtension = null;
        X509 x509 = null;
        try {
            x509 = n == 0 ? new X509(x500Name, publicKey, x500Name, privateKey, bigInteger, date, date2, this.v) : new X509(x500Name, publicKey, x500Name, privateKey, bigInteger, n, this.v);
            if (oracleCertExtension != null) {
                if (oracleCertExtension.getSubjectKeyId()) {
                    subjectKeyIDExtension = new SubjectKeyIDExtension(CryptoUtils.generateKeyID((java.security.PublicKey)publicKey), false);
                    x509.addExtension((X509Extension)subjectKeyIDExtension);
                    x509.addExtension((X509Extension)new AuthorityKeyIDExtension(subjectKeyIDExtension.getSubjectKeyID(), false));
                }
                if (oracleCertExtension.getKeyUsage() != null) {
                    x509.addExtension((X509Extension)new KeyUsageExtension(oracleCertExtension.getKeyUsage(), true));
                }
                if (oracleCertExtension.getBasicConstraints() != null) {
                    x509.addExtension((X509Extension)oracleCertExtension.getBasicConstraints());
                }
                if ((object = oracleCertExtension.getSubjectAlternativeNamesList()) != null) {
                    x509.addExtension((X509Extension)new SubjectAltNameExtension(object));
                }
            }
            oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw (IOException)iOException.initCause(exception);
        }
        try {
            if (oraclePKIX509CertImpl != null) {
                if (this.o == null) {
                    this.p = this.c();
                }
                this.internalAddCertReq(certificateRequest, CryptoUtils.fromJCEPrivateKey((PrivateKey)privateKey), string);
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
                object = null;
                if (string != null) {
                    int n2 = 1;
                    object = string + ' ' + Integer.toString(n2);
                }
                this.internalAddTrustedCert(oraclePKIX509CertImpl, (String)object, null);
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
                this.internalAddUserCert(oraclePKIX509CertImpl, string);
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw (IOException)iOException.initCause(exception);
        }
    }

    public void create(char[] cArray) throws IOException {
        this.create(cArray, (byte)0);
    }

    public void create(char[] cArray, byte by) throws IOException {
        this.b();
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(a.getString("PKI-01002"));
        }
        if (cArray != null) {
            this.o = new char[cArray.length];
            System.arraycopy(cArray, 0, this.o, 0, cArray.length);
        }
        this.n = null;
        this.s = new OracleNewWalletImpl();
        KeyStore keyStore = this.getKeyStore();
        this.a(keyStore);
        try {
            this.setKeyStore(keyStore, by);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
    }

    protected void a(KeyStore keyStore) throws IOException {
    }

    public InputStream getWalletArray(boolean bl) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.o != null && !bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        } else if (this.o != null && bl) {
            C041 c041 = new C041();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(this.n);
            byteArrayInputStream = c041.b(byteArrayInputStream2) == 0 ? (ByteArrayInputStream)this.a(1) : new ByteArrayInputStream(this.n);
        } else if (this.o == null && bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        } else {
            throw new IOException("Cannot create p12 without password.");
        }
        return byteArrayInputStream;
    }

    public void convertToV12() throws IOException {
        Object object2;
        char[] cArray = this.c();
        PKCS12 pKCS12 = new PKCS12(new String(cArray), this.getWalletArray(this.isAutoLoginOnly()));
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        AlgorithmIdentifier algorithmIdentifier = TransitionMode.isFIPS140ModeEnabled() ? AlgID.hmacWithSHA256 : AlgID.hmacWithSHA1;
        for (Object object2 : arrayList) {
            object2.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, algorithmIdentifier, AlgID.aes128_CBC);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        object2 = byteArrayOutputStream.toByteArray();
        this.setWalletArray(new ByteArrayInputStream((byte[])object2), cArray);
    }

    public byte[] getWalletArrayB(boolean bl) throws IOException {
        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.getWalletArray(bl);
        int n = byteArrayInputStream.available();
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, n);
        return byArray;
    }

    public void setWalletArray(InputStream inputStream, char[] cArray) throws IOException {
        this.b();
        if (cArray != null) {
            this.o = new char[cArray.length];
            System.arraycopy(cArray, 0, this.o, 0, cArray.length);
        }
        try {
            int n = inputStream.available();
            this.s = this.a(cArray);
            this.n = new byte[n];
            inputStream.read(this.n);
            OraclePKIDebug.a("Oracle Wallet: wallet size " + this.n.length);
            this.getSecretStore();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("OracleWallet.setWalletArray: " + throwable.toString());
            this.b();
            IOException iOException = new IOException(throwable.getLocalizedMessage());
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    public void setWalletArray(byte[] byArray, char[] cArray) throws IOException {
        this.setWalletArray(new ByteArrayInputStream(byArray), cArray);
    }

    public synchronized void open(String string, char[] cArray) throws IOException {
        this.b();
        if (cArray != null) {
            this.o = new char[cArray.length];
            System.arraycopy(cArray, 0, this.o, 0, cArray.length);
        }
        try {
            this.s = this.a(string, cArray);
            this.n = this.s.a();
            OraclePKIDebug.a("Oracle Wallet: wallet size " + this.n.length);
            if (this.o == null) {
                C041 c041 = new C041();
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.n);
                    c041.b(byteArrayInputStream);
                    this.p = c041.a(byteArrayInputStream);
                }
                catch (IOException iOException) {
                    this.b();
                    throw new IOException(iOException.getMessage());
                }
            }
            this.getSecretStore();
            if (this.checkTrustFlagsEnabled()) {
                this.q = true;
                OraclePKIDebug.a("Oracle Wallet: Trust Flags are enabled, loading info");
                this.r = new HashMap();
                this.getTrustFlagsValue(this.r);
                if (this.r.size() == 0) {
                    this.r = null;
                }
            }
            OraclePKIDebug.a("Oracle Wallet: Trust Flags Enabled :" + this.q);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.b();
            IOException iOException = new IOException(fileNotFoundException.getLocalizedMessage());
            iOException.initCause(fileNotFoundException);
            throw iOException;
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("OracleWallet.open: " + throwable.toString());
            this.b();
            IOException iOException = new IOException(throwable.getLocalizedMessage());
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    public void openDefault(char[] cArray) throws IOException {
        String string = "";
        this.open(string, cArray);
        throw new IOException("not implemented");
    }

    public void createSSO() throws IOException {
        if (this.o == null && this.s == null) {
            this.o = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.a(keyStore);
            try {
                this.setKeyStore(keyStore);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                throw (IOException)iOException.initCause(exception);
            }
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.a(2);
            this.b();
            this.n = new byte[((InputStream)byteArrayInputStream).available()];
            byteArrayInputStream.read(this.n);
            OraclePKIDebug.a("OracleWallet: created ALO " + this.n.length + " bytes.");
        }
    }

    public void createSSO_OLD() throws IOException {
        if (this.o == null && this.s == null) {
            this.o = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.a(keyStore);
            try {
                this.setKeyStore(keyStore);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                throw (IOException)iOException.initCause(exception);
            }
            this.s = this.a(this.m, this.o);
            OraclePKIDebug.a("OracleWallet: saving sso (ALO) " + this.n.length + " bytes.");
            this.s.b(this.n, this.o, 2);
        } else {
            OraclePKIDebug.a("OracleWallet: saving sso (AL) " + this.n.length + " bytes.");
            this.s.b(this.n, this.o, 1);
        }
    }

    public void deleteSSOWallet() throws IOException {
        this.s.d();
    }

    public void deleteWallet() throws IOException {
        this.s.c();
    }

    public void save() throws IOException {
        OraclePKIDebug.a("OracleWallet: saving " + this.n.length + " bytes.");
        String string = this.m;
        if (string == null) {
            string = this.s.e();
        }
        this.saveAs(string);
    }

    public synchronized void saveAs(String string) throws IOException {
        this.saveAs(string, (byte)0);
    }

    public synchronized void saveAs(String string, byte by) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        C041 c041 = new C041();
        OracleWalletImpl oracleWalletImpl = this.a(string, new char[16]);
        if (this.o == null) {
            Object object;
            Object object2;
            OraclePKIDebug.a("OracleWallet: saving sso (ALO) " + this.n.length + " bytes.");
            char[] cArray = null;
            try {
                object2 = new ByteArrayInputStream(this.n);
                if (c041.b((InputStream)object2) == 2) {
                    cArray = c041.a((InputStream)object2);
                    if (this.p == null) {
                        this.p = cArray;
                    }
                    object = new PKCS12(new String(cArray), (InputStream)object2);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(object.length());
                    object.output((OutputStream)byteArrayOutputStream);
                    this.n = byteArrayOutputStream.toByteArray();
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            oracleWalletImpl.b(this.n, this.p, 2, by);
            this.o = null;
            object2 = null;
            try {
                object2 = c041.a(this.p, 2);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            object = new ByteArrayOutputStream(((Object)object2).length + this.n.length);
            ((OutputStream)object).write((byte[])object2);
            ((OutputStream)object).write(this.n);
            this.n = ((ByteArrayOutputStream)object).toByteArray();
        } else {
            String string2 = null;
            string2 = string.endsWith("ewallet.p12") ? string.replaceAll("ewallet.p12", "cwallet.sso") : string.concat("/cwallet.sso");
            OracleWalletImpl oracleWalletImpl2 = this.a(string2, null);
            if (!oracleWalletImpl2.b()) {
                OraclePKIDebug.a("OracleWallet: saving p12 " + this.n.length + " bytes.");
                oracleWalletImpl.a(this.n, this.o, by);
            } else {
                OraclePKIDebug.a("OracleWallet: saving p12 (& sso or lsso) " + this.n.length + " bytes.");
                byte[] byArray = oracleWalletImpl2.a();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                int n = c041.b(byteArrayInputStream);
                if (n == 1 || n == 3) {
                    oracleWalletImpl.a(this.n, this.o, n, by);
                }
            }
        }
        this.s = oracleWalletImpl;
    }

    public synchronized void saveSSO() throws IOException {
        OraclePKIDebug.a("OracleWallet: saving sso " + this.n.length + " bytes.");
        this.s.b(this.n, this.o, 1);
    }

    public void saveLSSO() throws IOException {
        OraclePKIDebug.a("OracleWallet: saving lsso " + this.n.length + " bytes.");
        this.s.b(this.n, this.o, 3);
    }

    public boolean exists(String string) throws IOException {
        OracleWalletImpl oracleWalletImpl = this.a(string, this.o);
        return oracleWalletImpl.b();
    }

    public boolean exists(String string, boolean bl) throws IOException {
        OracleWalletImpl oracleWalletImpl = null;
        oracleWalletImpl = bl ? this.a(string, this.o) : this.a(string, this.o == null ? "".toCharArray() : this.o);
        return oracleWalletImpl.b();
    }

    public synchronized OracleSecretStore getSecretStore() throws IOException, OracleSecretStoreException {
        ByteArrayInputStream byteArrayInputStream = null;
        OraclePKIDebug.a("OracleWallet: getSecretStore");
        if (this.u == null) {
            this.u = new OracleSecretStore();
            if (this.n != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.n);
            }
            this.u.load(byteArrayInputStream, this.o);
        }
        return this.u;
    }

    public KeyStore getKeyStore() throws IOException {
        KeyStore keyStore = null;
        try {
            if (null == Security.getProvider("OraclePKI")) {
                Security.insertProviderAt(new OraclePKIProvider(), 1);
            }
            keyStore = this.o != null ? KeyStore.getInstance("PKCS12", "OraclePKI") : KeyStore.getInstance("SSO", "OraclePKI");
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.n != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.n);
            }
            keyStore.load(byteArrayInputStream, this.o);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
        return keyStore;
    }

    public synchronized void setSecretStore(OracleSecretStore oracleSecretStore) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.a("OracleWallet: setSecretStore");
        ByteArrayInputStream byteArrayInputStream = null;
        if (oracleSecretStore != this.u) {
            throw new OracleSecretStoreException("Secretstore mismatch.");
        }
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        this.n = oracleSecretStore.setStoreInWallet(byteArrayInputStream, this.o);
    }

    public void setKeyStore(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.setKeyStore(keyStore, (byte)0);
    }

    public void setKeyStore(KeyStore keyStore, byte by) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: setKeyStore");
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, keyStore, this.o, by);
    }

    public KeyStore createPKCS11KeyStore(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, InvocationTargetException, NoSuchMethodException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        if (string3 == null) {
            String string4 = string == null ? "/opt/bar/cfg/pkcs11.cfg" : string;
            Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Provider provider = (Provider)constructor.newInstance(string4);
            Security.addProvider(provider);
            keyStore = KeyStore.getInstance("PKCS11");
            keyStore.load(null, string2.toCharArray());
        } else if (string3.contains("Luna")) {
            Class<?> clazz = Class.forName("com.chrysalisits.crypto.LunaJCAProvider");
            Provider provider = (Provider)clazz.newInstance();
            Security.removeProvider(provider.getName());
            Security.insertProviderAt(provider, 1);
            keyStore = KeyStore.getInstance("Luna");
            keyStore.load(null, null);
        }
        return keyStore;
    }

    public OracleWallet migratePKCS12toJKS(char[] cArray, int n) throws IOException {
        String string;
        Enumeration<String> enumeration;
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(a.getString("PKI-01002"));
        }
        OracleWallet oracleWallet = OracleWallet.getInstance("jks");
        oracleWallet.create(cArray);
        KeyStore keyStore = oracleWallet.getKeyStore();
        KeyStore keyStore2 = this.getKeyStore();
        try {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                keyStore.deleteEntry(string);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        try {
            enumeration = keyStore2.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                string = enumeration.nextElement();
                if ((n == 0 || n == 2) && keyStore2.isCertificateEntry(string)) {
                    certificateArray = (Certificate[])keyStore2.getCertificate(string);
                    keyStore.setCertificateEntry(string, (Certificate)certificateArray);
                    continue;
                }
                if (n != 0 && n != 1 || !keyStore2.isKeyEntry(string)) continue;
                certificateArray = keyStore2.getCertificateChain(string);
                Key key = keyStore2.getKey(string, this.o);
                if (certificateArray == null) {
                    X509 x509 = null;
                    BigInteger bigInteger = new BigInteger("7");
                    int n2 = 3650;
                    CertificateRequest certificateRequest = null;
                    RSAPrivateKey rSAPrivateKey = null;
                    if (key.getAlgorithm().equals("RSA")) {
                        certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                        rSAPrivateKey = new RSAPrivateKey(key.getEncoded());
                    } else {
                        if (!key.getAlgorithm().equals("EC")) continue;
                        certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                        rSAPrivateKey = new ECPrivateKey(key.getEncoded());
                    }
                    x509 = new X509(certificateRequest.getSubject(), (java.security.PublicKey)certificateRequest.getPublicKey(), certificateRequest.getSubject(), (PrivateKey)rSAPrivateKey, bigInteger, n2, null);
                    CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509.getEncoded()));
                    Certificate[] certificateArray2 = new Certificate[]{x509Certificate};
                    keyStore.setKeyEntry(string, key, cArray, certificateArray2);
                    continue;
                }
                keyStore.setKeyEntry(string, key, cArray, certificateArray);
            }
            oracleWallet.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return oracleWallet;
    }

    public void migrateJKStoPKCS12(KeyStore keyStore, char[] cArray, String[] stringArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        OraclePKIDebug.a("OracleWallet: migrateJKStoPKCS12");
        if (cArray == null) {
            throw new IOException("keystore password cannot be null");
        }
        try {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) {
                        this.a(keyStore, cArray, string);
                        continue;
                    }
                    if (keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) {
                        this.a(keyStore, string);
                        continue;
                    }
                    if (keyStore.containsAlias(string)) continue;
                    throw new IOException("Invalid alias : " + string);
                }
            } else {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) {
                        this.a(keyStore, cArray, string);
                        continue;
                    }
                    if (keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) {
                        this.a(keyStore, string);
                        continue;
                    }
                    if (keyStore.containsAlias(string)) continue;
                    throw new IOException("Invalid alias : " + string);
                }
            }
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            throw new UnrecoverableEntryException("passwords of the keystore and key entries should be the same");
        }
    }

    void a(KeyStore keyStore, char[] cArray, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, passwordProtection);
        PrivateKey privateKey = privateKeyEntry.getPrivateKey();
        X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
        X509Certificate[] x509CertificateArray = (X509Certificate[])privateKeyEntry.getCertificateChain();
        java.security.PublicKey publicKey = x509Certificate.getPublicKey();
        RSAPrivateKey rSAPrivateKey = null;
        oracle.security.crypto.core.RSAPublicKey rSAPublicKey = null;
        if (publicKey.getAlgorithm().equals("RSA")) {
            rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
            rSAPublicKey = new oracle.security.crypto.core.RSAPublicKey(publicKey.getEncoded());
        } else if (publicKey.getAlgorithm().equals("EC")) {
            rSAPrivateKey = new ECPrivateKey(privateKey.getEncoded());
            rSAPublicKey = new ECPublicKey(publicKey.getEncoded());
        }
        oracle.security.crypto.core.KeyPair keyPair = new oracle.security.crypto.core.KeyPair(rSAPublicKey, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey);
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            oraclePKIX509CertImplArray[i] = new OraclePKIX509CertImpl(new X509(x509CertificateArray[i].getEncoded()));
        }
        if (oraclePKIX509CertImplArray.length > 1) {
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
            if (oraclePKIX509CertImplArray2.length > 1) {
                for (int i = 0; i < oraclePKIX509CertImplArray2.length - 1; ++i) {
                    try {
                        String string2 = keyStore.getCertificateAlias(oraclePKIX509CertImplArray2[i]);
                        this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i], string2, null);
                        if (this.o != null) continue;
                        this.p = this.b(this.p);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                this.a(x500Principal, keyPair, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, string);
                this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], string);
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
            }
        } else {
            Principal principal;
            try {
                principal = (OraclePKIPrincipalImpl)oraclePKIX509CertImplArray[0].getIssuerDN();
                OraclePKIPrincipalImpl oraclePKIPrincipalImpl = (OraclePKIPrincipalImpl)oraclePKIX509CertImplArray[0].getSubjectDN();
                if (((OraclePKIPrincipalImpl)principal).equals(oraclePKIPrincipalImpl)) {
                    this.internalAddTrustedCert(oraclePKIX509CertImplArray[0], string, null);
                    if (this.o == null) {
                        this.p = this.b(this.p);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            principal = x509Certificate.getSubjectX500Principal();
            int n = 1;
            string = string + ' ' + Integer.toString(n);
            this.a((X500Principal)principal, keyPair, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, string);
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
            if (this.o == null) {
                this.p = this.b(this.p);
            }
        }
    }

    void a(KeyStore keyStore, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(x509Certificate.getEncoded()));
        try {
            this.internalAddTrustedCert(oraclePKIX509CertImpl, string, null);
            if (this.o == null) {
                this.p = this.b(this.p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void a(X500Principal x500Principal, oracle.security.crypto.core.KeyPair keyPair, oracle.security.crypto.core.PrivateKey privateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.getName());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, (java.security.PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalAddCertReq(certificateRequest, privateKey, string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public Enumeration listAliases() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: listAliases");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.engineAliases();
    }

    public CRL createCRL(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.createCRL(null, null, null, n);
    }

    public CRL createCRL(String string, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.createCRL(string, null, null, n);
    }

    public CRL createCRL(String string, String string2, String string3, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        String string4;
        KeyStore keyStore = this.getKeyStore();
        RSAPrivateKey rSAPrivateKey = null;
        X509 x509 = null;
        X509 x5092 = null;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Enumeration<String> enumeration = keyStore.aliases();
        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string3);
        while (enumeration.hasMoreElements()) {
            string4 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string4)) continue;
            x5092 = ((OraclePKIX509CertImpl)keyStore.getCertificate(string4)).getX509();
            x500Name = x5092.getSubject();
            bl = false;
            bl2 = false;
            bl3 = false;
            if (string != null && (string == null || !x500Name.equals((Object)new X500Name(string)))) continue;
            bl = true;
            x500Name2 = x5092.getIssuer();
            if (string2 != null && (string2 == null || !x500Name2.equals((Object)new X500Name(string2)))) continue;
            bl2 = true;
            bigInteger2 = x5092.getSerialNo();
            if (bigInteger == null || bigInteger != null && bigInteger.equals(bigInteger2)) {
                bl3 = true;
            }
            if (!bl || !bl2 || !bl3) continue;
            if (!bl4) {
                bl4 = true;
                x509 = x5092;
                object = keyStore.getKey(string4, null);
                if (object.getAlgorithm().equals("RSA")) {
                    rSAPrivateKey = new RSAPrivateKey(object.getEncoded());
                    continue;
                }
                if (!object.getAlgorithm().equals("EC")) continue;
                rSAPrivateKey = new ECPrivateKey(object.getEncoded());
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025"));
        }
        if (rSAPrivateKey == null || x509 == null) {
            throw new IOException(a.getString("PKI-04002"));
        }
        try {
            oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
            oraclePKIX509CertImpl.checkValidity();
        }
        catch (Exception exception) {
            throw new IOException(a.getString("PKI-04026"));
        }
        try {
            string4 = null;
            string4 = new CRL();
            string4.setIssuer(x509.getSubject());
            string4.setDates(n);
            string4.setPrivateKey(rSAPrivateKey, this.w);
            object = null;
            object = (SubjectKeyIDExtension)x509.getExtension(PKIX.id_ce_subjectKeyIdentifier);
            if (object != null) {
                string4.addExtension((X509Extension)new AuthorityKeyIDExtension(object.getSubjectKeyID()));
            } else {
                OraclePKIDebug.a("Issuer's cert does not have Subject Key Identifier set,so can not set Authority Key Identifier in CRL generated.");
            }
            return string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CRL revokeCertificate(InputStream inputStream, CRL cRL) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        RevokedCertificate revokedCertificate = new RevokedCertificate(oraclePKIX509CertImplArray[0].getSerialNumber(), new Date());
        KeyStore keyStore = this.getKeyStore();
        RSAPrivateKey rSAPrivateKey = null;
        Enumeration<String> enumeration = keyStore.aliases();
        OraclePKIPrincipalImpl oraclePKIPrincipalImpl = new OraclePKIPrincipalImpl(cRL.getIssuer());
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string);
            if (oraclePKIPrincipalImpl == null || !oraclePKIPrincipalImpl.equals(((X509Certificate)oraclePKIX509CertImpl).getSubjectDN())) continue;
            try {
                bl = OracleWallet.verifyCRLSignature(oraclePKIX509CertImpl, cRL);
            }
            catch (Exception exception) {
                System.out.println("Could not verify CRL signature : " + exception.getLocalizedMessage());
            }
            if (!bl) continue;
            Key key = keyStore.getKey(string, null);
            if (key.getAlgorithm().equals("RSA")) {
                rSAPrivateKey = new RSAPrivateKey(key.getEncoded());
                break;
            }
            if (!key.getAlgorithm().equals("EC")) break;
            rSAPrivateKey = new ECPrivateKey(key.getEncoded());
            break;
        }
        if (rSAPrivateKey == null || oraclePKIX509CertImpl == null) {
            throw new IOException(a.getString("PKI-04002"));
        }
        try {
            oraclePKIX509CertImpl.checkValidity();
        }
        catch (Exception exception) {
            throw new IOException(a.getString("PKI-04026"));
        }
        cRL.addCertificate(revokedCertificate);
        if (this.w == null) {
            cRL.setPrivateKey(rSAPrivateKey, null);
        } else {
            cRL.setPrivateKey(rSAPrivateKey, this.w);
        }
        return cRL;
    }

    public static boolean getRevocationStatus(InputStream inputStream, CRL cRL) throws IOException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        return cRL.isRevoked(oraclePKIX509CertImplArray[0].getSerialNumber());
    }

    public static boolean verifyCRLSignature(InputStream inputStream, CRL cRL) throws IOException, AuthenticationException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        return OracleWallet.verifyCRLSignature(oraclePKIX509CertImplArray[0], cRL);
    }

    public static boolean verifyCRLSignature(OraclePKIX509CertImpl oraclePKIX509CertImpl, CRL cRL) throws IOException, AuthenticationException {
        oracle.security.crypto.core.RSAPublicKey rSAPublicKey = null;
        java.security.PublicKey publicKey = oraclePKIX509CertImpl.getPublicKey();
        if (publicKey.getAlgorithm().equals("RSA")) {
            rSAPublicKey = new oracle.security.crypto.core.RSAPublicKey(publicKey.getEncoded());
        } else if (publicKey.getAlgorithm().equals("EC")) {
            rSAPublicKey = new ECPublicKey(publicKey.getEncoded());
        }
        cRL.setPublicKey((java.security.PublicKey)rSAPublicKey);
        return cRL.verify();
    }

    public void addCertRequest(X500Principal x500Principal, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, n, null, null);
    }

    public void addCertRequest(X500Principal x500Principal, int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, n, null, string);
    }

    public void addCertRequest(X500Principal x500Principal, int n, OracleCertExtension oracleCertExtension) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, n, oracleCertExtension, null);
    }

    public void addCertRequest(X500Principal x500Principal, int n, OracleCertExtension oracleCertExtension, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIRSAKeyHelper.validateKeysize(n);
        try {
            KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance((String)"RSA");
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            java.security.PublicKey publicKey = keyPair.getPublic();
            this.a(x500Principal, privateKey, publicKey, oracleCertExtension, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(a.getString("PKI-02013"));
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
    }

    public void addCertRequest(X500Principal x500Principal, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, string, null, null);
    }

    public void addCertRequest(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, string, null, string2);
    }

    public void addCertRequest(X500Principal x500Principal, String string, OracleCertExtension oracleCertExtension) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, string, oracleCertExtension, null);
    }

    public void addCertRequest(X500Principal x500Principal, String string, OracleCertExtension oracleCertExtension, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (string == null) {
            throw new IOException(a.getString("PKI-07011"));
        }
        try {
            KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance((String)"EC");
            ECGenParameterSpec eCGenParameterSpec = null;
            if (EccCurveParameters.b(string) != null) {
                eCGenParameterSpec = new ECGenParameterSpec(EccCurveParameters.b(string).c());
            } else if (EccCurveParameters.c(string) != null) {
                eCGenParameterSpec = new ECGenParameterSpec(string);
            } else {
                IOException iOException = new IOException(a.getString("PKI-02014"));
                throw iOException;
            }
            try {
                keyPairGenerator.initialize(eCGenParameterSpec);
                KeyPair keyPair = keyPairGenerator.genKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                java.security.PublicKey publicKey = keyPair.getPublic();
                this.a(x500Principal, privateKey, publicKey, oracleCertExtension, string2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IOException(a.getString("PKI-07009"));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(a.getString("PKI-02014"));
        }
    }

    private void a(X500Principal x500Principal, PrivateKey privateKey, java.security.PublicKey publicKey, OracleCertExtension oracleCertExtension, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object;
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, publicKey, privateKey);
        if (oracleCertExtension != null) {
            if (oracleCertExtension.getSubjectKeyId()) {
                certificateRequest.addExtension((X509Extension)new SubjectKeyIDExtension(CryptoUtils.generateKeyID((java.security.PublicKey)publicKey), false));
            }
            if (oracleCertExtension.getKeyUsage() != null) {
                certificateRequest.addExtension((X509Extension)new KeyUsageExtension(oracleCertExtension.getKeyUsage(), true));
            }
            if (oracleCertExtension.getBasicConstraints() != null) {
                certificateRequest.addExtension((X509Extension)oracleCertExtension.getBasicConstraints());
            }
            if ((object = oracleCertExtension.getSubjectAlternativeNamesList()) != null) {
                certificateRequest.addExtension((X509Extension)new SubjectAltNameExtension((List)object));
            }
        }
        if (null != (object = this.getCertSignAlgorithmId())) {
            certificateRequest.setSigAlgID(object);
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalAddCertReq(certificateRequest, CryptoUtils.fromJCEPrivateKey((PrivateKey)privateKey), string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void addCertRequest(CertificateRequest certificateRequest) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalAddCertReq(certificateRequest, (RSAPrivateKey)null, (String)null);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public String exportCertReqB64(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string3)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string3, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            }
            if (!x500Name.equals((Object)new X500Name(string2 = certificateRequest.getSubject().toString()))) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            string = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + Utils.toBase64((byte[])byteArrayOutputStream.toByteArray()) + c;
            break;
        }
        return string;
    }

    public InputStream exportCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = this.exportCertReqB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertReqB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string3)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string3, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            }
            if (certificateRequest == null || !string.equals(string3)) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            string2 = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + Utils.toBase64((byte[])byteArrayOutputStream.toByteArray()) + c;
            break;
        }
        return string2;
    }

    public InputStream exportCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = this.exportCertReqB64(x500Principal);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public InputStream createCert(InputStream inputStream, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, (Date)null, (Date)null, BigInteger.ZERO);
    }

    public InputStream createCert(InputStream inputStream, int n, String string, String string2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, null, null, BigInteger.ZERO, string, string2, bigInteger);
    }

    public InputStream createCert(InputStream inputStream, int n, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, (Date)null, (Date)null, bigInteger);
    }

    public InputStream createCert(InputStream inputStream, int n, BigInteger bigInteger, String string, String string2, BigInteger bigInteger2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, null, null, bigInteger, string, string2, bigInteger2);
    }

    public InputStream createCert(InputStream inputStream, Date date, Date date2, String string, String string2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, 0, date, date2, BigInteger.ZERO, string, string2, bigInteger);
    }

    public InputStream createCert(InputStream inputStream, Date date, Date date2, BigInteger bigInteger, String string, String string2, BigInteger bigInteger2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, 0, date, date2, bigInteger, string, string2, bigInteger2);
    }

    private InputStream a(InputStream inputStream, int n, Date date, Date date2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, date, date2, bigInteger, null, null, null);
    }

    private InputStream a(InputStream inputStream, int n, Date date, Date date2, BigInteger bigInteger, String string, String string2, BigInteger bigInteger2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        Object object2;
        Object object3;
        CertificateRequest certificateRequest = new CertificateRequest(inputStream);
        KeyStore keyStore = this.getKeyStore();
        String string3 = this.a(string, string2, bigInteger2);
        Key key = keyStore.getKey(string3, null);
        RSAPrivateKey rSAPrivateKey = null;
        if (key.getAlgorithm().equals("RSA")) {
            rSAPrivateKey = new RSAPrivateKey(key.getEncoded());
        } else if (key.getAlgorithm().equals("EC")) {
            rSAPrivateKey = new ECPrivateKey(key.getEncoded());
        }
        Certificate certificate = keyStore.getCertificate(string3);
        X509 x509 = ((OraclePKIX509CertImpl)certificate).getX509();
        if (rSAPrivateKey == null || x509 == null) {
            OraclePKIDebug.a("OracleWallet.createCert: " + a.getString("PKI-04002"));
            throw new IOException(a.getString("PKI-04002"));
        }
        X509 x5092 = null;
        try {
            x5092 = n == 0 ? new X509(certificateRequest.getSubject(), (java.security.PublicKey)certificateRequest.getPublicKey(), x509.getSubject(), (PrivateKey)rSAPrivateKey, bigInteger, date, date2, this.v) : new X509(certificateRequest.getSubject(), (java.security.PublicKey)certificateRequest.getPublicKey(), x509.getSubject(), (PrivateKey)rSAPrivateKey, bigInteger, n, this.v);
            object3 = null;
            object2 = certificateRequest.getExtensions();
            if (object2 != null) {
                object3 = object2.getExtensionsAsList();
                for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                    x5092.addExtension((X509Extension)((ArrayList)object3).get(i));
                }
            }
            object = null;
            object = (SubjectKeyIDExtension)x509.getExtension(PKIX.id_ce_subjectKeyIdentifier);
            if (object != null) {
                x5092.addExtension((X509Extension)new AuthorityKeyIDExtension(object.getSubjectKeyID(), false));
            } else {
                OraclePKIDebug.a("Issuer's cert does not have Subject Key Identifier set,so can not set Authority Key Identifier in certificate generated.");
            }
        }
        catch (SignatureException signatureException) {
            if (OraclePKIDebug.getDebugFlag()) {
                signatureException.printStackTrace();
            }
            throw new IOException(signatureException.getLocalizedMessage());
        }
        object3 = null;
        object2 = new ByteArrayOutputStream();
        x5092.output((OutputStream)object2);
        object = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])((ByteArrayOutputStream)object2).toByteArray()) + e;
        byte[] byArray = ((String)object).getBytes();
        object3 = new ByteArrayInputStream(byArray);
        return object3;
    }

    private String a(String string, String string2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        String string3 = null;
        if (string == null && string2 == null && bigInteger == null) {
            while (enumeration.hasMoreElements()) {
                Certificate certificate;
                string3 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string3) || (certificate = keyStore.getCertificate(string3)) == null) continue;
                return string3;
            }
        } else {
            while (enumeration.hasMoreElements()) {
                Certificate certificate;
                string3 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string3) || (certificate = keyStore.getCertificate(string3)) == null) continue;
                X509 x509 = ((OraclePKIX509CertImpl)certificate).getX509();
                if (string != null && !x509.getSubject().toString().equals(string) || string2 != null && !x509.getIssuer().toString().equals(string2) || bigInteger != null && !x509.getSerialNo().equals(bigInteger)) continue;
                return string3;
            }
        }
        OraclePKIDebug.a("OracleWallet.internalGetSignerAlias: " + a.getString("PKI-04007"));
        throw new IOException(a.getString("PKI-04007"));
    }

    public String exportCertB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.exportCertB64(x500Principal, null, null);
    }

    public String exportCertB64(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        String string3 = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string4;
            String string5 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string5);
            if (oraclePKIX509CertImpl == null || !x500Name.equals((Object)new X500Name(string4 = oraclePKIX509CertImpl.getSubjectDN().toString())) || string != null && !((String)(object = oraclePKIX509CertImpl.getIssuerDN().toString())).equals(string)) continue;
            if (string2 != null) {
                object = oraclePKIX509CertImpl.getSerialNumber();
                if (object == null) continue;
                String string6 = ((BigInteger)object).toString();
                String string7 = ((BigInteger)object).toString(16);
                String string8 = "0x" + ((BigInteger)object).toString(16);
                if (!string6.equals(string2) && !string7.equalsIgnoreCase(string2) && !string8.equalsIgnoreCase(string2)) continue;
            }
            object = oraclePKIX509CertImpl.getEncoded();
            string3 = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])object) + e;
            break;
        }
        return string3;
    }

    public InputStream exportCert(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = this.exportCertB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string3);
            if (oraclePKIX509CertImpl == null || !string.equals(string3)) continue;
            byte[] byArray = oraclePKIX509CertImpl.getEncoded();
            string2 = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])byArray) + e;
            break;
        }
        return string2;
    }

    public InputStream exportCert(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.exportCert(x500Principal, null, null);
    }

    public InputStream exportCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        String string3 = this.exportCertB64(x500Principal, string, string2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
        return byteArrayInputStream;
    }

    public String exportPrivateKeyB64(String string, char[] cArray, byte[] byArray, int n) throws IOException {
        String string2 = null;
        KeyStore keyStore = null;
        if (!this.canModify()) {
            throw new IOException("Cannot export private key from SSO wallet.");
        }
        try {
            keyStore = this.getKeyStore();
            Key key = keyStore.getKey(string, this.o);
            if (key instanceof PrivateKey) {
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n);
                PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                SecretKeyFactory secretKeyFactory = JCEUtil.getSecretKeyFactoryInstance((String)"PBEWithMD5AndDES");
                SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                Cipher cipher = JCEUtil.getCipherInstance((String)"PBEWithMD5AndDES");
                cipher.init(1, (Key)secretKey, pBEParameterSpec);
                byte[] byArray2 = cipher.doFinal(key.getEncoded());
                String string3 = Utils.toBase64((byte[])byArray2, (boolean)true, (boolean)false);
                string2 = "-----BEGIN PRIVATE KEY-----\n" + string3 + "\n-----END PRIVATE KEY-----";
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        return string2;
    }

    public String exportPrivateKeyB64(String string, char[] cArray) throws IOException {
        String string2 = null;
        KeyStore keyStore = null;
        if (!this.canModify()) {
            throw new IOException("Cannot export private key from SSO wallet.");
        }
        try {
            keyStore = this.getKeyStore();
            Key key = keyStore.getKey(string, this.o);
            if (key instanceof PrivateKey) {
                PrivateKeyPKCS8 privateKeyPKCS8 = new PrivateKeyPKCS8((oracle.security.crypto.core.PrivateKey)new RSAPrivateKey(key.getEncoded()), new String(cArray));
                byte[] byArray = privateKeyPKCS8.getEncoded();
                String string3 = Utils.toBase64((byte[])byArray, (boolean)true, (boolean)false);
                string2 = "-----BEGIN ENCRYPTED PRIVATE KEY-----\n" + string3 + "\n" + g;
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        return string2;
    }

    public void importPrivateKeyB64(String string, String string2, char[] cArray, byte[] byArray, int n, String string3, String string4) throws IOException {
        RSAPrivateKey rSAPrivateKey = null;
        ECPrivateKey eCPrivateKey = null;
        java.security.PublicKey publicKey = null;
        oracle.security.crypto.core.RSAPublicKey rSAPublicKey = null;
        ECPublicKey eCPublicKey = null;
        oracle.security.crypto.core.KeyPair keyPair = null;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = null;
        Cipher cipher = null;
        PBEKeySpec pBEKeySpec = null;
        PBEParameterSpec pBEParameterSpec = null;
        SecretKeyFactory secretKeyFactory = null;
        X500Name x500Name = null;
        CertificateRequest certificateRequest = null;
        SecretKey secretKey = null;
        String string5 = null;
        String string6 = null;
        if (!this.canModify()) {
            throw new IOException("Cannot import private key to SSO wallet.");
        }
        try {
            if (null != string3) {
                oraclePKIX509CertImplArray2 = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string3.getBytes()));
                publicKey = oraclePKIX509CertImplArray2[0].getPublicKey();
                string6 = oraclePKIX509CertImplArray2[0].getPublicKeyType();
                pBEParameterSpec = new PBEParameterSpec(byArray, n);
                pBEKeySpec = new PBEKeySpec(cArray);
                secretKeyFactory = JCEUtil.getSecretKeyFactoryInstance((String)"PBEWithMD5AndDES");
                secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                cipher = JCEUtil.getCipherInstance((String)"PBEWithMD5AndDES");
                cipher.init(2, (Key)secretKey, pBEParameterSpec);
                if (string2.indexOf(h) == -1) {
                    throw new IOException("Header not present in private key");
                }
                if (string2.indexOf(i) == -1) {
                    throw new IOException("Footer not present in private key");
                }
                string5 = string2.substring(h.length(), string2.indexOf(i) - 1);
                byte[] byArray2 = cipher.doFinal(Utils.fromBase64((String)string5));
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    rSAPrivateKey = new RSAPrivateKey(byArray2);
                    rSAPublicKey = new oracle.security.crypto.core.RSAPublicKey(publicKey.getEncoded());
                    keyPair = new oracle.security.crypto.core.KeyPair((PublicKey)rSAPublicKey, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey);
                } else if (null != string6 && string6.equalsIgnoreCase("EC")) {
                    eCPrivateKey = new ECPrivateKey(byArray2);
                    eCPublicKey = new ECPublicKey(publicKey.getEncoded());
                    keyPair = new oracle.security.crypto.core.KeyPair((PublicKey)eCPublicKey, (oracle.security.crypto.core.PrivateKey)eCPrivateKey);
                }
                x500Name = new X500Name(oraclePKIX509CertImplArray2[0].getSubjectDN().toString());
                certificateRequest = new CertificateRequest(x500Name, (java.security.PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    this.internalAddCertReq(certificateRequest, rSAPrivateKey, string);
                } else if (null != string6 && string6.equalsIgnoreCase("EC")) {
                    this.internalAddCertReq(certificateRequest, (oracle.security.crypto.core.PrivateKey)eCPrivateKey, string);
                }
                if (this.o == null) {
                    this.p = this.c();
                }
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
                if (string4 != null) {
                    oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string4.getBytes()));
                    for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                        this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], null, null);
                        if (this.o != null) continue;
                        this.p = this.b(this.p);
                    }
                }
                this.internalAddUserCert(oraclePKIX509CertImplArray2[0], string);
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
    }

    public void importPrivateKeyB64(String string, String string2, char[] cArray, String string3, String string4) throws IOException {
        RSAPrivateKey rSAPrivateKey = null;
        ECPrivateKey eCPrivateKey = null;
        java.security.PublicKey publicKey = null;
        oracle.security.crypto.core.RSAPublicKey rSAPublicKey = null;
        ECPublicKey eCPublicKey = null;
        oracle.security.crypto.core.KeyPair keyPair = null;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = null;
        PrivateKeyPKCS8 privateKeyPKCS8 = null;
        X500Name x500Name = null;
        CertificateRequest certificateRequest = null;
        String string5 = null;
        String string6 = null;
        KeyStore keyStore = null;
        Enumeration<String> enumeration = null;
        if (!this.canModify()) {
            throw new IOException("Cannot import private key to SSO wallet.");
        }
        try {
            if (null != string3) {
                oraclePKIX509CertImplArray2 = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string3.getBytes()));
                publicKey = oraclePKIX509CertImplArray2[0].getPublicKey();
                string6 = oraclePKIX509CertImplArray2[0].getPublicKeyType();
                if (string2.indexOf(new String(f)) == -1) {
                    throw new IOException("Header not present in private key");
                }
                if (string2.indexOf(new String(g)) == -1) {
                    throw new IOException("Footer not present in private key");
                }
                string5 = string2.substring(new String(f).length(), string2.indexOf(new String(g)) - 1);
                byte[] byArray = Utils.fromBase64((String)string5);
                privateKeyPKCS8 = new PrivateKeyPKCS8((InputStream)new ByteArrayInputStream(byArray));
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    rSAPrivateKey = (RSAPrivateKey)privateKeyPKCS8.getKey(new String(cArray));
                    rSAPublicKey = new oracle.security.crypto.core.RSAPublicKey(publicKey.getEncoded());
                    keyPair = new oracle.security.crypto.core.KeyPair((PublicKey)rSAPublicKey, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey);
                } else if (null != string6 && string6.equalsIgnoreCase("EC")) {
                    eCPrivateKey = (ECPrivateKey)privateKeyPKCS8.getKey(new String(cArray));
                    eCPublicKey = new ECPublicKey(publicKey.getEncoded());
                    keyPair = new oracle.security.crypto.core.KeyPair((PublicKey)eCPublicKey, (oracle.security.crypto.core.PrivateKey)eCPrivateKey);
                }
                keyStore = this.getKeyStore();
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    Key key;
                    String string7 = enumeration.nextElement();
                    if (!keyStore.isKeyEntry(string7) || !((key = keyStore.getKey(string7, this.o)) instanceof PrivateKey)) continue;
                    byte[] byArray2 = key.getEncoded();
                    if (!(null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA")) ? Arrays.equals(byArray2, rSAPrivateKey.getEncoded()) : null != string6 && string6.equalsIgnoreCase("EC") && Arrays.equals(byArray2, eCPrivateKey.getEncoded()))) continue;
                    throw new IOException("Private key already present in wallet.");
                }
                x500Name = new X500Name(oraclePKIX509CertImplArray2[0].getSubjectDN().toString());
                certificateRequest = new CertificateRequest(x500Name, (java.security.PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate());
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    this.internalAddCertReq(certificateRequest, rSAPrivateKey, string);
                } else if (null != string6 && string6.equalsIgnoreCase("EC")) {
                    this.internalAddCertReq(certificateRequest, (oracle.security.crypto.core.PrivateKey)eCPrivateKey, string);
                }
                if (this.o == null) {
                    this.p = this.c();
                }
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
                if (string4 != null) {
                    oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string4.getBytes()));
                    for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                        this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], null, null);
                        if (this.o != null) continue;
                        this.p = this.b(this.p);
                    }
                }
                this.internalAddUserCert(oraclePKIX509CertImplArray2[0], string);
                if (this.o == null) {
                    this.p = this.b(this.p);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
    }

    public void importCertB64(String string, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.importCert(byteArrayInputStream, bl, null, null);
    }

    public void importCertB64(String string, boolean bl, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.importCert(byteArrayInputStream, bl, string2, null);
    }

    public boolean canModify() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        C041 c041;
        int n;
        boolean bl = true;
        if (this.o == null && ((n = (c041 = new C041()).b(byteArrayInputStream = new ByteArrayInputStream(this.n))) == 1 || n == 3)) {
            bl = false;
        }
        return bl;
    }

    public void importCert(InputStream inputStream, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.importCert(inputStream, bl, null, null);
    }

    public void importCert(InputStream inputStream, boolean bl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray;
        if (!this.canModify()) {
            throw new IOException(a.getString("PKI-02008"));
        }
        if (this.o == null) {
            this.p = this.c();
        }
        if ((oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream)).length > 1 && string2 != null) {
            throw new IOException(a.getString("PKI-04024"));
        }
        if (bl) {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                if (i == 0) {
                    this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], string, string2);
                    continue;
                }
                this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], null, string2);
            }
        } else if (oraclePKIX509CertImplArray.length > 1) {
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
            for (int i = 0; i < oraclePKIX509CertImplArray2.length - 1; ++i) {
                this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i], null, string2);
            }
            this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], string);
        } else {
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
        }
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void deleteCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemoveCertReq(x500Principal);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void deleteCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemoveCertReq(string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void removePrivateKey(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemovePrivateKey(string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void deleteCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.deleteCert(x500Principal, null, null);
    }

    public void deleteCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemoveUserCert(x500Principal, string, string2);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void deleteCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemoveUserCert(string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public boolean isTrustedCertUsedInChain(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: isTrustedCertUsedInChain");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.a(x500Principal, this.r);
    }

    public boolean isTrustedCertUsedInChain(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: isTrustedCertUsedInChain");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.a(string, this.r);
    }

    public void replaceTrustpoint(InputStream inputStream, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalReplaceTrustedCert(oraclePKIX509CertImplArray[0], string, string2);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void replaceTrustpoint(InputStream inputStream, String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalReplaceTrustedCert(oraclePKIX509CertImplArray[0], string, string2, string3);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void replaceUserCert(InputStream inputStream, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalRemoveUserCert(string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
        this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void replaceUserCert(InputStream inputStream, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalRemoveMatchingUserCert(oraclePKIX509CertImplArray[0], string, string2);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
        this.internalAddUserCert(oraclePKIX509CertImplArray[0], null);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void removeTrustpoint(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.removeTrustpoint(x500Principal, null, null);
    }

    public void removeTrustpoint(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemoveTrustedCert(x500Principal, string, string2);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void removeTrustpoint(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemoveTrustedCert(string);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void removeTrustpoints() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalRemoveAllTrusted();
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public boolean areTrustFlagsEnabled() {
        return this.q;
    }

    public boolean checkTrustFlagsEnabled() throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        if (this.o == null) {
            this.p = this.c();
        }
        return this.a();
    }

    protected boolean a() throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalCheckTrustFlagsEnabled");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.b(byteArrayInputStream, this.o);
    }

    public void getTrustFlagsValue(HashMap hashMap) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalGetTrustFlagsValue(hashMap);
    }

    public void internalGetTrustFlagsValue(HashMap hashMap) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalGetTrustFlagsValue");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, hashMap);
    }

    public void assignTrustFlagstoCertificate(String string, String string2, String string3, String string4) throws Exception {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.internalAssignTrustFlagstoCertificate(string, string2, string3, string4);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    public void internalAssignTrustFlagstoCertificate(String string, String string2, String string3, String string4) throws IOException, NoSuchAlgorithmException, SignatureException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAssignTrustFlagstoCertificate");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, string, string2, string3, string4, this.r);
    }

    public int getPersonaCount() {
        return 1;
    }

    public X500Principal[] getCertReqDNs(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
            vector.add(new X500Principal(certificateRequest.getSubject().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertReqDNalias(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            CertificateRequest certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest();
            if (certificateRequest == null) continue;
            arrayList2.add(certificateRequest.getSubject().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getCertReqAliases(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray)) continue;
            CertificateRequest certificateRequest = null;
            object = keyStore.getKey((String)stringArray, null);
            if (object.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            } else if (object.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            stringArray[n2] = (String)object.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getPPvtAliases(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray)) continue;
            CertificateRequest certificateRequest = null;
            object = keyStore.getKey((String)stringArray, null);
            if (object.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            } else if (object.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            stringArray[n2] = (String)object.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getPPvtInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        String[] stringArray = new String[2];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        int n2 = this.internalGetCRCompNum(string);
        stringArray[0] = Integer.toString(n2);
        stringArray[1] = Integer.toString(-1);
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string2, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            }
            if (certificateRequest == null || !string.equals(string2)) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                stringArray[1] = Integer.toString(2);
                break;
            }
            stringArray[1] = Integer.toString(1);
            break;
        }
        return stringArray;
    }

    public byte[] getPPvtBytes(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        byte[] byArray = null;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)) == null || !string.equals(string2)) continue;
            byArray = oraclePKIRSAPrivateKey.getEncoded();
            break;
        }
        return new String("").getBytes();
    }

    public byte[] getPPvtBytesUnEnc(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        byte[] byArray = null;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)) == null || !string.equals(string2)) continue;
            byArray = oraclePKIRSAPrivateKey.getEncoded();
            break;
        }
        return byArray;
    }

    public int getCertReqCount(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            ++n2;
        }
        return n2;
    }

    public X500Principal[] getCertReqDNs(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            x500PrincipalArray = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry((String)x500PrincipalArray) || keyStore.getCertificate((String)x500PrincipalArray) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
                vector.add(new X500Principal(certificateRequest.getSubject().toString()));
                continue;
            }
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
            vector.add(new X500Principal(certificateRequest.getSubject().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertReqDNalias(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (bl) {
                if (!keyStore.isKeyEntry(string) || keyStore.getCertificate(string) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
                arrayList2.add(certificateRequest.getSubject().toString());
                arrayList2.add(string);
                arrayList.add(arrayList2);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            arrayList2.add(certificateRequest.getSubject().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public int getCertReqCount(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry(string) || keyStore.getCertificate(string) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
                ++n2;
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            ++n2;
        }
        return n2;
    }

    public String[] getCertReqInfo(int n, int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                stringArray[1] = new Integer(((oracle.security.crypto.core.RSAPublicKey)certificateRequest.getPublicKey()).modulusLength() * 8).toString();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                stringArray[1] = new Integer(((ECPublicKey)certificateRequest.getPublicKey()).getParams().getCurve().getField().getFieldSize()).toString();
            }
            if (certificateRequest != null && n2 == n3) {
                stringArray[0] = certificateRequest.getSubject().toString();
                stringArray[2] = new String(certificateRequest.getPublicKey().getAlgorithm());
                stringArray[3] = new String(string);
                break;
            }
            ++n3;
        }
        return stringArray;
    }

    public String[] getCertReqInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string2, null);
            stringArray[3] = key.getAlgorithm();
            if (stringArray[3].equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                stringArray[1] = new Integer(((oracle.security.crypto.core.RSAPublicKey)certificateRequest.getPublicKey()).modulusLength() * 8).toString();
            } else if (stringArray[3].equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                stringArray[1] = new Integer(((ECPublicKey)certificateRequest.getPublicKey()).getParams().getCurve().getField().getFieldSize()).toString();
            }
            if (certificateRequest == null || !string.equals(string2)) continue;
            stringArray[0] = certificateRequest.getSubject().toString();
            stringArray[2] = new String(certificateRequest.getPublicKey().getAlgorithm());
            break;
        }
        return stringArray;
    }

    public X500Principal[] getCertDNs(int n) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(x509Certificate.getSubjectDN().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertDNalias(int n) throws IOException, KeyStoreException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) continue;
            arrayList2.add(x509Certificate.getSubjectDN().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getCertAliases(int n) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getCertInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[13];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = oraclePKIX509CertImpl.getSubjectDN().toString();
            stringArray[1] = oraclePKIX509CertImpl.getIssuerDN().toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
            stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
            stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
            stringArray[7] = oraclePKIX509CertImpl.getPublicKey().getAlgorithm();
            if (stringArray[7].equals("RSA")) {
                stringArray[6] = new Integer(((RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
            } else if (stringArray[7].equals("EC")) {
                stringArray[6] = new Integer(((java.security.interfaces.ECPublicKey)oraclePKIX509CertImpl.getPublicKey()).getParams().getCurve().getField().getFieldSize()).toString();
            }
            stringArray[8] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[9] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[10] = TransitionMode.isFIPS140ModeEnabled() ? oraclePKIX509CertImpl.getSHA256Digest() : oraclePKIX509CertImpl.getMD5Digest();
            stringArray[11] = oraclePKIX509CertImpl.getSHADigest();
            stringArray[12] = Integer.toString(this.internalGetCertCompNum(string));
            break;
        }
        return stringArray;
    }

    protected String a(boolean[] blArray) {
        return "SSL";
    }

    public int getCertCount(int n) throws IOException, KeyStoreException, CertificateException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null) continue;
            ++n2;
        }
        return n2;
    }

    public X509Certificate getCert(int n, int n2) throws IOException, KeyStoreException, CertificateException {
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate2 != null && n2 == n3) {
                CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509Certificate2.getEncoded()));
                break;
            }
            if (x509Certificate2 == null) continue;
            ++n3;
        }
        return x509Certificate;
    }

    public X509Certificate getSSLCert(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X509Certificate x509Certificate = null;
        String string = null;
        KeyStore keyStore = null;
        keyStore = this.getKeyStore();
        String string2 = "OracleX509";
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        keyManagerFactory.init(keyStore, this.o);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        String[] stringArray = new String[]{"RSA"};
        Principal[] principalArray = this.getTrustpointDNs(0);
        string = bl ? ((X509KeyManager)keyManagerArray[0]).chooseServerAlias(stringArray[0], principalArray, null) : ((X509KeyManager)keyManagerArray[0]).chooseClientAlias(stringArray, principalArray, null);
        if (string == null) {
            throw new IOException(a.getString("PKI-04016"));
        }
        x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        return x509Certificate;
    }

    public String getSSLCertAlias(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = null;
        KeyStore keyStore = null;
        keyStore = this.getKeyStore();
        String string2 = "OracleX509";
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        keyManagerFactory.init(keyStore, this.o);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        String[] stringArray = new String[]{"RSA"};
        Principal[] principalArray = this.getTrustpointDNs(0);
        string = bl ? ((X509KeyManager)keyManagerArray[0]).chooseServerAlias(stringArray[0], principalArray, null) : ((X509KeyManager)keyManagerArray[0]).chooseClientAlias(stringArray, principalArray, null);
        if (string == null) {
            throw new IOException(a.getString("PKI-04016"));
        }
        return string;
    }

    public X500Principal[] getTrustpointDNs(int n) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)x500PrincipalArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(x509Certificate.getSubjectDN().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getTrustpointDNalias(int n) throws IOException, KeyStoreException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) continue;
            arrayList2.add(x509Certificate.getSubjectDN().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getTrustpointAliases(int n) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)stringArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getTrustpointInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[13];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = oraclePKIX509CertImpl.getSubjectDN().toString();
            stringArray[1] = oraclePKIX509CertImpl.getIssuerDN().toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
            stringArray[4] = Long.toString(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L);
            stringArray[5] = Long.toString(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L);
            stringArray[7] = oraclePKIX509CertImpl.getPublicKey().getAlgorithm();
            if (stringArray[7].equals("RSA")) {
                stringArray[6] = new Integer(((RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
            } else if (stringArray[7].equals("EC")) {
                stringArray[6] = new Integer(((java.security.interfaces.ECPublicKey)oraclePKIX509CertImpl.getPublicKey()).getParams().getCurve().getField().getFieldSize()).toString();
            }
            stringArray[8] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[9] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[10] = TransitionMode.isFIPS140ModeEnabled() ? oraclePKIX509CertImpl.getSHA256Digest() : oraclePKIX509CertImpl.getMD5Digest();
            stringArray[11] = oraclePKIX509CertImpl.getSHADigest();
            stringArray[12] = Integer.toString(this.internalGetTCertCompNum(string));
            break;
        }
        return stringArray;
    }

    public int getTrustpointCount(int n) throws IOException, KeyStoreException, CertificateException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null) continue;
            ++n2;
        }
        return n2;
    }

    public X509Certificate getTrustpoint(int n, int n2) throws IOException, KeyStoreException, CertificateException {
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate2 != null && n2 == n3) {
                CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509Certificate2.getEncoded()));
                break;
            }
            ++n3;
        }
        return x509Certificate;
    }

    public void changePassword(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new IOException("Password cannot be null string.");
        }
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(a.getString("PKI-01002"));
        }
        if (this.o == null) {
            throw new IOException("Cannot modify SSO wallet password.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.n);
        PKCS12 pKCS12 = new PKCS12(new String(this.o), (InputStream)byteArrayInputStream);
        pKCS12.setPasswd(cArray);
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PKCS12Safe)arrayList.get(i)).setPasswd(cArray);
        }
        try {
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException(a.getString("PKI-02004"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        this.n = byteArrayOutputStream.toByteArray();
        this.o = cArray;
    }

    public InputStream exportCertChain(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        return this.exportCertChain(x500Principal, null, null);
    }

    public InputStream exportCertChain(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateException {
        String string3 = this.exportCertChainB64(x500Principal, string, string2);
        return new ByteArrayInputStream(string3.getBytes());
    }

    public String exportCertChainB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        return this.exportCertChainB64(x500Principal, null, null);
    }

    public String exportCertChainB64(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateException {
        Object object;
        Enumeration<String> enumeration;
        Certificate[] certificateArray;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        KeyStore keyStore = this.getKeyStore();
        if (x500Principal != null) {
            certificateArray = new X500Name(x500Principal.toString());
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Object object2;
                String string5;
                string4 = enumeration.nextElement();
                object = (OraclePKIX509CertImpl)keyStore.getCertificate(string4);
                if (object == null || !keyStore.isKeyEntry(string4) || !certificateArray.equals((Object)new X500Name(string5 = ((OraclePKIX509CertImpl)object).getSubjectDN().toString())) || string != null && !((String)(object2 = ((OraclePKIX509CertImpl)object).getIssuerDN().toString())).equals(string)) continue;
                if (string2 != null) {
                    object2 = ((OraclePKIX509CertImpl)object).getSerialNumber();
                    if (object2 == null) continue;
                    String string6 = ((BigInteger)object2).toString();
                    String string7 = ((BigInteger)object2).toString(16);
                    String string8 = "0x" + ((BigInteger)object2).toString(16);
                    if (!string6.equals(string2) && !string7.equalsIgnoreCase(string2) && !string8.equalsIgnoreCase(string2)) continue;
                }
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.a("No certificate with matching DN found in wallet.");
                return string3;
            }
        } else {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string4 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.a("No user certificate found in wallet.");
                return string3;
            }
        }
        certificateArray = keyStore.getCertificateChain(string4);
        object = new PKCS7();
        OraclePKIDebug.a("Found cert chain of length = " + certificateArray.length);
        if (certificateArray.length > 1) {
            for (int i = 1; i < certificateArray.length; ++i) {
                object.addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[i]).getEncoded()));
            }
        } else if (certificateArray.length == 1) {
            object.addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[0]).getEncoded()));
        } else {
            OraclePKIDebug.a("Certificate chain length is zero");
            return string3;
        }
        byte[] byArray = object.getEncoded();
        string3 = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])byArray) + e;
        return string3;
    }

    public InputStream exportCertChain(String string) throws IOException, KeyStoreException, CertificateException {
        String string2 = this.exportCertChainB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertChainB64(String string) throws IOException, KeyStoreException, CertificateException {
        String string2 = null;
        boolean bl = false;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string3 = enumeration.nextElement();
            if (!string.equals(string3) || !keyStore.isKeyEntry(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("No certificate with matching alias found in wallet.");
            return string2;
        }
        Certificate[] certificateArray = keyStore.getCertificateChain(string3);
        PKCS7 pKCS7 = new PKCS7();
        OraclePKIDebug.a("Found cert chain of length = " + certificateArray.length);
        if (certificateArray.length > 1) {
            for (int i = 1; i < certificateArray.length; ++i) {
                pKCS7.addCertificate(new X509(certificateArray[i].getEncoded()));
            }
        } else if (certificateArray.length == 1) {
            pKCS7.addCertificate(new X509(certificateArray[0].getEncoded()));
        } else {
            OraclePKIDebug.a("Certificate chain length is zero");
            return string2;
        }
        byte[] byArray = pKCS7.getEncoded();
        string2 = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])byArray) + e;
        return string2;
    }

    public String exportUserCertChainB64() throws IOException, KeyStoreException, CertificateException {
        String string = null;
        try {
            X509Certificate x509Certificate = this.getSSLCert(true);
            String string2 = x509Certificate.getSubjectDN().toString();
            string = this.exportCertChainB64(new X500Principal(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return string;
    }

    public String trustpointNeededB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        return this.trustpointNeededB64(string, null, true);
    }

    public String trustpointNeededB64(String string, String string2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object;
        boolean bl2 = false;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(byteArrayInputStream);
        for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
            object = oraclePKIX509CertImplArray[i].getSubjectDN().toString();
            bl2 = this.isTrustedCertUsedInChain(new X500Principal((String)object));
            if (bl2) {
                return null;
            }
            if (string2 == null || !string2.equals(object)) continue;
            oraclePKIX509CertImpl = oraclePKIX509CertImplArray[i];
        }
        if (string2 != null) {
            if (oraclePKIX509CertImpl != null) {
                byte[] byArray = oraclePKIX509CertImpl.getEncoded();
                object = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])byArray) + e;
                return object;
            }
            throw new IOException("No trustpoint with matching DN in chain");
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
        oraclePKIX509CertImpl = bl ? oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1] : oraclePKIX509CertImplArray2[0];
        object = oraclePKIX509CertImpl.getEncoded();
        String string3 = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])object) + e;
        return string3;
    }

    public String exportTrustedB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string3 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string3) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string3)) == null || !string.equals(string3)) continue;
            byte[] byArray = x509Certificate.getEncoded();
            string2 = "-----BEGIN CERTIFICATE-----\n" + Utils.toBase64((byte[])byArray) + e;
            break;
        }
        return string2;
    }

    public boolean isAutoLoginOnly() throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            this.getSecretStore();
        }
        catch (Exception exception) {
            this.b();
            IOException iOException = new IOException(a.getString("PKI-03004"));
            iOException.initCause(exception);
            throw iOException;
        }
        if (this.n == null) {
            throw new IOException("Wallet array is null.");
        }
        byteArrayInputStream = new ByteArrayInputStream(this.n);
        if (this.o != null) {
            return false;
        }
        C041 c041 = new C041();
        return c041.b(byteArrayInputStream) == 2;
    }

    public void internalAddCertReq(CertificateRequest certificateRequest, RSAPrivateKey rSAPrivateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAddCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, certificateRequest, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, string);
    }

    public void internalAddCertReq(CertificateRequest certificateRequest, oracle.security.crypto.core.PrivateKey privateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAddCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, certificateRequest, privateKey, string);
    }

    public void internalRemoveCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, x500Principal);
    }

    public void internalRemoveCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.e(byteArrayInputStream, this.o, string);
    }

    public void internalRemovePrivateKey(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.f(byteArrayInputStream, this.o, string);
    }

    public int internalGetCRCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalGetCRCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.g(byteArrayInputStream, this.o, string);
    }

    public int internalGetTCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalGetTCertCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.j(byteArrayInputStream, this.o, string);
    }

    public int internalGetCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalGetCertCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.i(byteArrayInputStream, this.o, string);
    }

    public void internalAddTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAddTrustedCert");
        if (!oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm().equals("RSA") && !oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm().equals("EC")) {
            throw new IOException(a.getString("PKI-04019") + oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm());
        }
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, oraclePKIX509CertImpl, string, string2, this.areTrustFlagsEnabled());
    }

    public void internalReplaceTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalReplaceTrustedCert");
        if (!oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm().equals("RSA") && !oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm().equals("EC")) {
            throw new IOException(a.getString("PKI-04019") + oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm());
        }
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, oraclePKIX509CertImpl, string, string2, this.r);
    }

    public void internalReplaceTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalReplaceTrustedCert");
        if (!oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm().equals("RSA") && !oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm().equals("EC")) {
            throw new IOException(a.getString("PKI-04019") + oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm());
        }
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, oraclePKIX509CertImpl, string, string2, string3, this.r);
    }

    public void internalRemoveTrustedCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, x500Principal, string, string2, this.r);
    }

    public void internalRemoveTrustedCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, string, this.r);
    }

    public void internalRemoveAllTrusted() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveAllTrusted");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.b((InputStream)byteArrayInputStream, this.o, this.r);
    }

    public void internalAddUserCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAddUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, oraclePKIX509CertImpl, string, this.r, this.areTrustFlagsEnabled());
    }

    public void internalRemoveUserCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, x500Principal, string, string2);
    }

    public void internalRemoveUserCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.h(byteArrayInputStream, this.o, string);
    }

    public void internalRemoveMatchingUserCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveMatchingUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, oraclePKIX509CertImpl, string, string2);
    }

    public Enumeration getWalletPersonas() {
        Hashtable<String, OracleWalletPersona> hashtable = new Hashtable<String, OracleWalletPersona>();
        OracleWalletPersona oracleWalletPersona = new OracleWalletPersona(this);
        hashtable.put("one", oracleWalletPersona);
        return hashtable.elements();
    }

    public void Pkcs11AddCertReq(String string, String string2, String string3, String string4, int n, String string5) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, Exception {
        byte[] byArray = NZNative.Pkcs11AddCertReq(string, string2, string3, string4, n, string5);
        if (byArray == null) {
            throw new IOException("creq is null");
        }
        CertificateRequest certificateRequest = new CertificateRequest(byArray);
        this.addCertRequest(certificateRequest);
    }

    public boolean containsPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = this.getPkcs11Info();
        return stringArray[0] != null;
    }

    public String[] getPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet:getP11Info ");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        String[] stringArray = new String[]{oracleKeyStoreSpi.getP11Lib(), oracleKeyStoreSpi.getP11TokenLabel(), oracleKeyStoreSpi.getP11TokenPassphrase(), oracleKeyStoreSpi.getP11CertLabel()};
        return stringArray;
    }

    public void addP11Lib(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, string);
    }

    public void addP11TokenLabel(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.b((InputStream)byteArrayInputStream, this.o, string);
    }

    public void addP11TokenPwd(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.c(byteArrayInputStream, this.o, string);
    }

    public void addP11CertLbl(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.d(byteArrayInputStream, this.o, string);
    }

    private void b() {
        this.o = null;
        this.m = null;
        this.n = null;
        this.s = null;
        this.u = null;
        this.q = false;
        this.r = null;
    }

    private OracleWalletImpl a(String string, char[] cArray) throws IOException {
        if (string.indexOf(58) < 2) {
            string = j + string;
        }
        if (string.toLowerCase().startsWith(j)) {
            if (cArray == null) {
                return new OracleFileSSOWalletImpl(string.substring(j.length()));
            }
            return new OracleFileWalletImpl(string.substring(j.length()));
        }
        throw new IOException("Unsupported WRL type" + string);
    }

    private OracleWalletImpl a(char[] cArray) throws IOException {
        if (cArray == null) {
            return new OracleFileSSOWalletImpl(null);
        }
        return new OracleFileWalletImpl(null);
    }

    private InputStream a(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.n);
        char[] cArray = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C041 c041 = new C041();
        try {
            cArray = c041.a(byArray);
            byArray2 = c041.a(cArray, n);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(new String(this.o), (InputStream)byteArrayInputStream);
        pKCS12.setPasswd(cArray);
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PKCS12Safe)arrayList.get(i)).setPasswd(cArray);
        }
        try {
            pKCS12.output((OutputStream)byteArrayOutputStream);
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not create SSO wallet from p12" + (Object)((Object)authenticationException));
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byArray3);
    }

    private char[] c() throws IOException {
        char[] cArray = null;
        if (this.o == null) {
            C041 c041 = new C041();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.n);
                c041.b(byteArrayInputStream);
                cArray = c041.a(byteArrayInputStream);
            }
            catch (IOException iOException) {
                this.b();
                throw new IOException(iOException.getMessage());
            }
        }
        return cArray;
    }

    private char[] b(char[] cArray) throws IOException {
        if (this.o != null) {
            throw new IOException("");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.n);
        char[] cArray2 = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C041 c041 = new C041();
        try {
            cArray2 = c041.a(byArray);
            byArray2 = c041.a(cArray2, 2);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(new String(cArray), (InputStream)byteArrayInputStream);
        pKCS12.setPasswd(cArray2);
        ArrayList arrayList = pKCS12.getAuthSafesAsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ((PKCS12Safe)arrayList.get(i)).setPasswd(cArray2);
        }
        try {
            pKCS12.output((OutputStream)byteArrayOutputStream);
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not create SSO wallet from p12" + (Object)((Object)authenticationException));
        }
        this.n = byteArrayOutputStream.toByteArray();
        return cArray2;
    }

    OraclePKIX509CertImpl[] a(OraclePKIX509CertImpl[] oraclePKIX509CertImplArray) throws IOException {
        int n;
        int n2;
        int n3;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = new OraclePKIX509CertImpl[oraclePKIX509CertImplArray.length];
        Vector<OraclePKIX509CertImpl> vector = new Vector<OraclePKIX509CertImpl>(oraclePKIX509CertImplArray.length);
        Vector vector2 = new Vector(oraclePKIX509CertImplArray.length);
        for (n3 = 0; n3 < oraclePKIX509CertImplArray.length; ++n3) {
            vector.addElement(oraclePKIX509CertImplArray[n3]);
        }
        n3 = 0;
        for (n2 = 0; n2 < oraclePKIX509CertImplArray.length; ++n2) {
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl;
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl2 = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getIssuerDN();
            if (!oraclePKIPrincipalImpl2.equals(oraclePKIPrincipalImpl = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getSubjectDN())) continue;
            n3 = 1;
            vector2.addElement(vector.get(n2));
            vector.remove(n2);
            break;
        }
        if (n3 == 0) {
            throw new IOException("No self-signed cert in chain.");
        }
        n2 = 0;
        block2: do {
            n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                if (!((OraclePKIX509CertImpl)vector.get(n)).getIssuerDN().equals(((OraclePKIX509CertImpl)vector2.lastElement()).getSubjectDN())) continue;
                n2 = 1;
                vector2.addElement(vector.get(n));
                vector.remove(n);
                continue block2;
            }
        } while (n2 != 0);
        if (vector.size() != 0 || vector2.size() != oraclePKIX509CertImplArray.length) {
            throw new IOException("Could not form complete chain.");
        }
        for (n = 0; n < oraclePKIX509CertImplArray.length; ++n) {
            oraclePKIX509CertImplArray2[n] = (OraclePKIX509CertImpl)vector2.get(n);
        }
        return oraclePKIX509CertImplArray2;
    }

    private void a(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException(a.getString("PKI-02018"));
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException(a.getString("PKI-02018"));
        }
    }

    public int importPKCS12File(String string, char[] cArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        int n = 0;
        if (!this.canModify()) {
            throw new IOException(a.getString("PKI-02008"));
        }
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("OracleWallet.importPKCS12File: parsing PKCS#12 file at location " + string);
        }
        this.a(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        oracleKeyStoreSpi.load(fileInputStream, cArray, true);
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("During the import of PKCS#12 file into Oracle Wallet only most recently issued and currently valid certificate (validity is ensured for entire certificate chain) for a unique private key inside PKCS#12 file will be imported. Moreover, if same private key is already present in wallet then import will skip that entire priavte key and certificate chain pair.");
        }
        n = oracleKeyStoreSpi.retainOnlyLatestAndValidCertificateForUniquePrivateKey();
        Enumeration enumeration = oracleKeyStoreSpi.engineAliases();
        if (this.o == null) {
            this.p = this.c();
        }
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("OracleWallet.importPKCS12File: iterating through private key - certificate chain pairs inside PKCS#12 file and adding them into wallet one by one.");
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!oracleKeyStoreSpi.engineIsKeyEntry(string2)) continue;
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.n != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.n);
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.reset();
            }
            OracleKeyStoreSpi oracleKeyStoreSpi2 = null;
            oracleKeyStoreSpi2 = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
            if (OraclePKIDebug.getDebugFlag()) {
                OraclePKIDebug.a("OracleWallet.importPKCS12File: parsing wallet.");
            }
            oracleKeyStoreSpi2.engineLoad(byteArrayInputStream, this.o);
            if (byteArrayInputStream != null) {
                byteArrayInputStream.reset();
            }
            this.n = oracleKeyStoreSpi2.internalAddPrivateKeyAndCertificateChain(byteArrayInputStream, this.o, string2, oracleKeyStoreSpi.engineGetKey(string2, cArray), oracleKeyStoreSpi.engineGetCertificateChain(string2));
            if (this.o != null) continue;
            this.p = this.b(this.p);
        }
        fileInputStream.close();
        return n;
    }

    public void addTrustFlagsToCertificates(boolean bl) throws Exception {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.o == null) {
            this.p = this.c();
        }
        this.a(bl);
        if (this.o == null) {
            this.p = this.b(this.p);
        }
    }

    private void a(boolean bl) throws Exception {
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.n != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.n);
        }
        oracleKeyStoreSpi = this.o != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.o);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.n = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.o, this.r, bl);
    }
}

