/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyStore;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class OracleCertTextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static String b = "cert:\ndisplay [-cert [url|filename]] <-summary> <-complete>\ncreate [-wallet [wallet]] [-request [url|filename]] [-cert [filename]]\n       [-serial_file <file_loc> | -serial_num <serial_num>]\n       [-validity [days]] | [-valid_from [mm/dd/yyyy] -valid_until [mm/dd/yyyy]]\n       <-summary> [-pwd <pwd>]\n       [-sign_alg <md5|sha1|sha256|sha384|sha512>]\nhelp\n";

    public static void command(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(b);
            return;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleCertTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            OracleCertTextUI.create(stringArray3);
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(b);
            return;
        }
    }

    public static void create(String[] stringArray) {
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl2 = false;
        String string8 = null;
        String string9 = null;
        BigInteger bigInteger = null;
        boolean bl3 = false;
        int n2 = 0;
        String string10 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-cert")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-request")) {
                    string2 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-wallet")) {
                    string3 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-validity")) {
                    string4 = stringArray[++i2];
                    try {
                        n2 = Integer.parseInt(string4);
                        if (n2 <= 0) {
                            throw new NumberFormatException("");
                        }
                        if (n2 <= 182500) continue;
                        System.out.println("Validity should not be more than 182500 days.");
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Validity must be a positive integer");
                        return;
                    }
                }
                if (stringArray[i2].equals("-valid_from")) {
                    string5 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-valid_until")) {
                    string6 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i2].equals("-pwd")) {
                    string7 = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-serial_file")) {
                    string8 = stringArray[++i2];
                    bigInteger = OraclePKIGenFunc.getSerialNum(string8);
                    bigInteger = bigInteger.add(BigInteger.ONE);
                    bl3 = true;
                    continue;
                }
                if (stringArray[i2].equals("-serial_num")) {
                    string9 = stringArray[++i2];
                    bigInteger = new BigInteger(string9);
                    bl3 = true;
                    continue;
                }
                if (stringArray[i2].equals("-sign_alg")) {
                    if (!(stringArray[++i2].equalsIgnoreCase("md5") || stringArray[i2].equalsIgnoreCase("sha1") || stringArray[i2].equalsIgnoreCase("sha256") || stringArray[i2].equalsIgnoreCase("sha384") || stringArray[i2].equalsIgnoreCase("sha512"))) {
                        System.out.println("Unsupported Signature Algorithm - " + stringArray[i2]);
                    }
                    string10 = stringArray[i2];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        if (bl3 && bigInteger == null) {
            System.out.println("Serial number should not be null....");
            return;
        }
        if (string5 == null && string6 != null || string5 != null && string6 == null || string5 == null && string6 == null && string4 == null || string5 != null && string6 != null && string4 != null) {
            System.out.println("Please specify [-validity] alone OR both [-valid_from] and [-valid_until]");
            return;
        }
        OracleWallet oracleWallet = null;
        KeyStore keyStore = null;
        CertificateRequest certificateRequest = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string3, string7, bl2);
            keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string3, null);
                keyStore = oracleWallet.getKeyStore();
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(exception2.getLocalizedMessage());
                if (OraclePKIDebug.getDebugFlag()) {
                    exception2.printStackTrace();
                }
                return;
            }
        }
        try {
            certificateRequest = OraclePKIGenFunc.readCertRequestAt(string2);
        }
        catch (Exception exception) {
            System.out.println("Unable to read certificate request at " + string2);
            return;
        }
        try {
            Object object;
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = null;
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            if (string10 != null) {
                oracleWallet.setCertSignAlgorithm(string10);
            }
            if (n2 == 0) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                object2 = simpleDateFormat.parse(string5, new ParsePosition(0));
                object = simpleDateFormat.parse(string6, new ParsePosition(0));
                if (object2 == null || object == null) {
                    System.out.println("Please follow the format [mm/dd/yyyy] for valid_from and valid_until");
                    return;
                }
                byteArrayInputStream = !bl3 ? (ByteArrayInputStream)oracleWallet.createCert((InputStream)byteArrayInputStream2, (Date)object2, (Date)object) : (ByteArrayInputStream)oracleWallet.createCert(byteArrayInputStream2, (Date)object2, (Date)object, bigInteger);
            } else {
                byteArrayInputStream = !bl3 ? (ByteArrayInputStream)oracleWallet.createCert(byteArrayInputStream2, n2) : (ByteArrayInputStream)oracleWallet.createCert((InputStream)byteArrayInputStream2, n2, bigInteger);
            }
            int n3 = byteArrayInputStream.available();
            object2 = new byte[n3];
            byteArrayInputStream.read((byte[])object2);
            object = new FileWriter(string);
            ((Writer)object).write(new String((byte[])object2));
            ((OutputStreamWriter)object).flush();
            if (string8 != null) {
                OraclePKIGenFunc.updateSerialNum(string8, bigInteger);
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to save certificate at " + string);
            System.out.println(iOException.toString());
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static void display(String[] stringArray) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length == 0) {
            System.out.println(b);
            return;
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals("-cert")) {
                    string = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equals("-summary")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i2].equals("-complete")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i2]);
                System.out.println(b);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            return;
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        try {
            oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found at " + string);
            if (OraclePKIDebug.getDebugFlag()) {
                fileNotFoundException.printStackTrace();
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("Found invalid certificate at " + string);
            if (OraclePKIDebug.getDebugFlag()) {
                iOException.printStackTrace();
            }
            return;
        }
        if (bl) {
            for (int i3 = 0; i3 < oraclePKIX509CertImplArray.length; ++i3) {
                System.out.println(oraclePKIX509CertImplArray[i3]);
            }
        } else {
            for (int i4 = 0; i4 < oraclePKIX509CertImplArray.length; ++i4) {
                System.out.println("Subject:        " + oraclePKIX509CertImplArray[i4].getSubjectDN());
                System.out.println(a.getString("GEN_ISSUER_OUT") + oraclePKIX509CertImplArray[i4].getIssuerDN());
                System.out.println("Valid Until:    " + oraclePKIX509CertImplArray[i4].getNotAfter());
            }
        }
    }
}

