/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertUsage;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.ldap.ConnectionUtil;

public class OracleLDAP {
    public static boolean uploadWallet(String string, String string2, String string3, char[] cArray, String string4, char[] cArray2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, NamingException {
        Object object;
        Object object2;
        OraclePKIDebug.a("OracleLDAP: uploadWallet");
        OracleWallet oracleWallet = new OracleWallet();
        oracleWallet.open(string4, cArray2);
        byte[] byArray = null;
        boolean bl = false;
        InputStream inputStream = oracleWallet.getWalletArray(false);
        byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        InitialLdapContext initialLdapContext = null;
        try {
            object2 = oracleWallet.getSSLCert(false);
            if (OraclePKIX509CertUsage.isCertValidFor((Certificate)object2, 1)) {
                bl = true;
                string3 = ((X509Certificate)object2).getSubjectX500Principal().toString();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            OraclePKIDebug.a("Trying with SSL");
            object2 = null;
            object2 = string4.startsWith("file:") ? string4.substring(5) : string4;
            OraclePKIDebug.a("WRL: " + (String)object2);
            object = System.getProperty("file.separator");
            System.setProperty("oracle.ldap.wltloc", (String)object2 + (String)object + "ewallet.p12");
            System.setProperty("oracle.ldap.wltpass", new String(cArray2));
            initialLdapContext = ConnectionUtil.getSSLDirCtx(string, string2, string3, new String(cArray));
        } else {
            OraclePKIDebug.a("Trying with non-SSL");
            try {
                initialLdapContext = ConnectionUtil.getDefaultDirCtx(string, string2, string3, new String(cArray));
            }
            catch (Exception exception) {
                throw new IOException("No user certificate found in wallet for ssl, please use non-ssl port.");
            }
        }
        object2 = OracleLDAP.a(string3);
        object = new BasicAttribute("userpkcs12", byArray);
        ((BasicAttributes)object2).put((Attribute)object);
        initialLdapContext.modifyAttributes(string3, 2, (Attributes)object2);
        inputStream.close();
        OraclePKIDebug.a("Wallet Uploaded");
        return true;
    }

    public static byte[] downloadWallet(String string, String string2, String string3, char[] cArray) throws NamingException {
        OraclePKIDebug.a("OracleLDAP: downloadWallet");
        InitialLdapContext initialLdapContext = ConnectionUtil.getDefaultDirCtx(string, string2, string3, new String(cArray));
        Attributes attributes = initialLdapContext.getAttributes(string3, new String[]{"userpkcs12"});
        byte[] byArray = (byte[])attributes.get("userpkcs12").get();
        OraclePKIDebug.a("Wallet downloaded");
        return byArray;
    }

    private static BasicAttributes a(String string) {
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("inetOrgPerson");
        basicAttribute.add("organizationalPerson");
        basicAttribute.add("person");
        basicAttribute.add("top");
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(basicAttribute);
        basicAttributes.put(new BasicAttribute("sn", string));
        return basicAttributes;
    }
}

