/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Clob;
import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.OutParametersMetadata;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.ReadableMetadata;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Type;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStruct;
import oracle.r2dbc.OracleR2dbcObject;
import oracle.r2dbc.OracleR2dbcObjectMetadata;
import oracle.r2dbc.OracleR2dbcTypes;
import oracle.r2dbc.impl.DependentCounter;
import oracle.r2dbc.impl.OracleConnectionImpl;
import oracle.r2dbc.impl.OracleLargeObjects;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleResultImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.r2dbc.impl.ReadablesMetadata;
import oracle.r2dbc.impl.SqlTypeMap;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.reactivestreams.Publisher;

class OracleReadableImpl
implements Readable {
    private final OracleConnectionImpl r2dbcConnection;
    private final Connection jdbcConnection;
    private final ReactiveJdbcAdapter.JdbcReadable jdbcReadable;
    private final ReadablesMetadata<?> readablesMetadata;
    private final ReactiveJdbcAdapter adapter;
    private final DependentCounter dependentCounter;

    private OracleReadableImpl(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata<?> readablesMetadata) {
        this.r2dbcConnection = r2dbcConnection;
        this.jdbcConnection = r2dbcConnection.jdbcConnection();
        this.dependentCounter = dependentCounter;
        this.jdbcReadable = jdbcReadable;
        this.readablesMetadata = readablesMetadata;
        this.adapter = r2dbcConnection.adapter();
    }

    static Row createRow(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.RowMetadataImpl metadata) {
        return new RowImpl(r2dbcConnection, dependentCounter, jdbcReadable, metadata);
    }

    static OutParameters createOutParameters(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.OutParametersMetadataImpl metadata) {
        return new OutParametersImpl(r2dbcConnection, dependentCounter, jdbcReadable, metadata);
    }

    public <T> T get(int index, Class<T> type) {
        OracleR2dbcExceptions.requireNonNull(type, "type must not be null");
        this.requireValidIndex(index);
        return this.convert(index, type);
    }

    public <T> T get(String name, Class<T> type) {
        OracleR2dbcExceptions.requireNonNull(name, "name must not be null");
        OracleR2dbcExceptions.requireNonNull(type, "type must not be null");
        return this.convert(this.indexOf(name), type);
    }

    private int indexOf(String name) {
        int columnIndex = this.readablesMetadata.getColumnIndex(name);
        if (columnIndex != -1) {
            return columnIndex;
        }
        throw new NoSuchElementException("Unrecognized name: " + name);
    }

    private <T> T convert(int index, Class<T> type) {
        Type sqlType;
        Class defaultType;
        Object value = ByteBuffer.class.equals(type) ? this.getByteBuffer(index) : (io.r2dbc.spi.Blob.class.equals(type) ? this.getBlob(index) : (Clob.class.equals(type) ? this.getClob(index) : (LocalDateTime.class.equals(type) ? this.getLocalDateTime(index) : (Result.class.equals(type) ? this.getResult(index) : (Object.class.equals(type) ? (Object.class.equals((Object)(defaultType = this.readablesMetadata.get(index).getJavaType())) ? this.jdbcReadable.getObject(index, Object.class) : this.convert(index, defaultType)) : ((sqlType = this.readablesMetadata.get(index).getType()) instanceof OracleR2dbcTypes.ArrayType ? this.getOracleArray(index, type) : (sqlType instanceof OracleR2dbcTypes.ObjectType ? this.getOracleObject(index, type) : this.jdbcReadable.getObject(index, type))))))));
        return type.cast(value);
    }

    private ByteBuffer getByteBuffer(int index) {
        byte[] columnValue = this.jdbcReadable.getObject(index, byte[].class);
        return columnValue == null ? null : ByteBuffer.wrap(columnValue);
    }

    private io.r2dbc.spi.Blob getBlob(int index) {
        Blob jdbcBlob = this.jdbcReadable.getObject(index, Blob.class);
        if (jdbcBlob == null) {
            return null;
        }
        Publisher<Void> freePublisher = this.r2dbcConnection.addCloseTask(this.adapter.publishBlobFree(jdbcBlob));
        return OracleLargeObjects.createBlob(this.adapter.publishBlobRead(jdbcBlob), freePublisher);
    }

    private Clob getClob(int index) {
        Type type = this.readablesMetadata.get(index).getType();
        java.sql.Clob jdbcClob = R2dbcType.NCLOB.equals((Object)type) || R2dbcType.NVARCHAR.equals((Object)type) || R2dbcType.NCHAR.equals((Object)type) ? (java.sql.Clob)this.jdbcReadable.getObject(index, NClob.class) : this.jdbcReadable.getObject(index, java.sql.Clob.class);
        if (jdbcClob == null) {
            return null;
        }
        Publisher<Void> freePublisher = this.r2dbcConnection.addCloseTask(this.adapter.publishClobFree(jdbcClob));
        return OracleLargeObjects.createClob(this.adapter.publishClobRead(jdbcClob), freePublisher);
    }

    private LocalDateTime getLocalDateTime(int index) {
        return this.jdbcReadable.getObject(index, LocalDateTime.class);
    }

    private <T> T getOracleArray(int index, Class<T> type) {
        if (type.isArray()) {
            return type.cast(this.getJavaArray(index, type.getComponentType()));
        }
        return this.jdbcReadable.getObject(index, type);
    }

    private Object getJavaArray(int index, Class<?> javaType) {
        OracleArray oracleArray = this.jdbcReadable.getObject(index, OracleArray.class);
        return oracleArray == null ? null : this.convertOracleArray(oracleArray, javaType);
    }

    private Object convertOracleArray(OracleArray oracleArray, Class<?> javaType) {
        try {
            if (javaType.isPrimitive()) {
                Object object = this.convertPrimitiveArray(oracleArray, javaType);
                return object;
            }
            Class<?> convertedType = this.getArrayTypeMapping(oracleArray, javaType);
            Object[] javaArray = (Object[])oracleArray.getArray(Map.of(oracleArray.getBaseTypeName(), convertedType));
            ?[] objArray = this.convertArray(javaArray, convertedType);
            return objArray;
        }
        catch (SQLException sqlException) {
            throw OracleR2dbcExceptions.toR2dbcException(sqlException);
        }
        finally {
            OracleR2dbcExceptions.runJdbc(() -> oracleArray.free());
        }
    }

    private Class<?> getArrayTypeMapping(OracleArray oracleArray, Class<?> javaType) {
        if (!Object.class.equals(javaType)) {
            return javaType;
        }
        int jdbcType = OracleR2dbcExceptions.fromJdbc(() -> oracleArray.getBaseType());
        if (jdbcType == 2003) {
            Object[] oracleArrays = (Object[])OracleR2dbcExceptions.fromJdbc(() -> oracleArray.getArray());
            OracleArray oracleArrayElement = oracleArrays.length > 0 ? (OracleArray)oracleArrays[0] : (OracleArray)OracleR2dbcExceptions.fromJdbc(() -> this.jdbcConnection.unwrap(OracleConnection.class).createOracleArray(oracleArray.getBaseTypeName(), (Object)new Object[0]));
            return Array.newInstance(this.getArrayTypeMapping(oracleArrayElement, Object.class), 0).getClass();
        }
        Type r2dbcType = SqlTypeMap.toR2dbcType(jdbcType == 91 ? 93 : jdbcType);
        return r2dbcType != null ? r2dbcType.getJavaType() : javaType;
    }

    private Object convertPrimitiveArray(OracleArray oracleArray, Class<?> primitiveType) {
        try {
            if (Boolean.TYPE.equals(primitiveType)) {
                short[] shorts = oracleArray.getShortArray();
                boolean[] booleans = new boolean[shorts.length];
                for (int i = 0; i < shorts.length; ++i) {
                    booleans[i] = shorts[i] != 0;
                }
                return booleans;
            }
            if (Byte.TYPE.equals(primitiveType)) {
                short[] shorts = oracleArray.getShortArray();
                byte[] bytes = new byte[shorts.length];
                for (int i = 0; i < shorts.length; ++i) {
                    bytes[i] = (byte)shorts[i];
                }
                return bytes;
            }
            if (Short.TYPE.equals(primitiveType)) {
                return oracleArray.getShortArray();
            }
            if (Integer.TYPE.equals(primitiveType)) {
                return oracleArray.getIntArray();
            }
            if (Long.TYPE.equals(primitiveType)) {
                return oracleArray.getLongArray();
            }
            if (Float.TYPE.equals(primitiveType)) {
                return oracleArray.getFloatArray();
            }
            if (Double.TYPE.equals(primitiveType)) {
                return oracleArray.getDoubleArray();
            }
            Object javaArray = oracleArray.getArray(Map.of(oracleArray.getSQLTypeName(), primitiveType));
            Class<?> javaArrayType = javaArray.getClass().getComponentType();
            if (primitiveType.equals(javaArrayType)) {
                return javaArray;
            }
            throw OracleReadableImpl.unsupportedConversion(javaArrayType, primitiveType);
        }
        catch (SQLException sqlException) {
            throw OracleR2dbcExceptions.toR2dbcException(sqlException);
        }
    }

    private <T> T[] convertArray(Object[] array, Class<T> desiredType) {
        if (desiredType.isAssignableFrom(array.getClass().getComponentType())) {
            return array;
        }
        if (array.length == 0) {
            return (Object[])Array.newInstance(desiredType, 0);
        }
        Class<?> elementType = null;
        for (Object element : array) {
            if (element == null) continue;
            elementType = array[0].getClass();
            break;
        }
        if (elementType == null) {
            return (Object[])Array.newInstance(desiredType, array.length);
        }
        return OracleReadableImpl.mapArray(array, length -> (Object[])Array.newInstance(desiredType, length), this.getMappingFunction(elementType, desiredType));
    }

    private <T> T getOracleObject(int index, Class<T> type) {
        if (type.isAssignableFrom(OracleR2dbcObject.class)) {
            return type.cast(this.getOracleR2dbcObject(index));
        }
        if (type.isAssignableFrom(Object[].class)) {
            return type.cast(OracleReadableImpl.toArray(this.getOracleR2dbcObject(index)));
        }
        if (type.isAssignableFrom(Map.class)) {
            return type.cast(OracleReadableImpl.toMap(this.getOracleR2dbcObject(index)));
        }
        return this.jdbcReadable.getObject(index, type);
    }

    private OracleR2dbcObjectImpl getOracleR2dbcObject(int index) {
        OracleStruct oracleStruct = this.jdbcReadable.getObject(index, OracleStruct.class);
        if (oracleStruct == null) {
            return null;
        }
        return new OracleR2dbcObjectImpl(this.r2dbcConnection, this.dependentCounter, new StructJdbcReadable((Struct)oracleStruct), ReadablesMetadata.createAttributeMetadata(oracleStruct));
    }

    private static Object[] toArray(OracleReadableImpl readable) {
        if (readable == null) {
            return null;
        }
        Object[] array = new Object[readable.readablesMetadata.getList().size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = readable.get(i);
        }
        return array;
    }

    private static Map<String, Object> toMap(OracleReadableImpl readable) {
        if (readable == null) {
            return null;
        }
        List<?> metadataList = readable.readablesMetadata.getList();
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < metadataList.size(); ++i) {
            map.put(((ReadableMetadata)metadataList.get(i)).getName(), readable.get(i));
        }
        return map;
    }

    private <T, U> Function<T, U> getMappingFunction(Class<T> fromType, Class<U> toType) {
        Function<Object, Object> mappingFunction = null;
        if (toType.isAssignableFrom(fromType)) {
            return toType::cast;
        }
        if (fromType.equals(BigDecimal.class)) {
            if (toType.equals(Boolean.class)) {
                mappingFunction = bigDecimal -> bigDecimal.shortValue() != 0;
            } else if (toType.equals(Byte.class)) {
                mappingFunction = bigDecimal -> bigDecimal.byteValue();
            } else if (toType.equals(Short.class)) {
                mappingFunction = bigDecimal -> bigDecimal.shortValue();
            } else if (toType.equals(Integer.class)) {
                mappingFunction = bigDecimal -> bigDecimal.intValue();
            } else if (toType.equals(Long.class)) {
                mappingFunction = bigDecimal -> bigDecimal.longValue();
            } else if (toType.equals(Float.class)) {
                mappingFunction = bigDecimal -> Float.valueOf(bigDecimal.floatValue());
            } else if (toType.equals(Double.class)) {
                mappingFunction = bigDecimal -> bigDecimal.doubleValue();
            }
        } else if (byte[].class.equals(fromType) && toType.isAssignableFrom(ByteBuffer.class)) {
            mappingFunction = byteArray -> ByteBuffer.wrap(byteArray);
        } else if (Timestamp.class.isAssignableFrom(fromType)) {
            if (toType.isAssignableFrom(LocalDateTime.class)) {
                mappingFunction = timeStamp -> timeStamp.toLocalDateTime();
            } else if (toType.isAssignableFrom(LocalDate.class)) {
                mappingFunction = timeStamp -> timeStamp.toLocalDateTime().toLocalDate();
            } else if (toType.isAssignableFrom(LocalTime.class)) {
                mappingFunction = timeStamp -> timeStamp.toLocalDateTime().toLocalTime();
            }
        } else if (OffsetDateTime.class.isAssignableFrom(fromType)) {
            if (toType.isAssignableFrom(OffsetTime.class)) {
                mappingFunction = offsetDateTime -> offsetDateTime.toOffsetTime();
            } else if (toType.isAssignableFrom(LocalDateTime.class)) {
                mappingFunction = offsetDateTime -> offsetDateTime.toLocalDateTime();
            } else if (toType.isAssignableFrom(LocalDate.class)) {
                mappingFunction = offsetDateTime -> offsetDateTime.toLocalDate();
            } else if (toType.isAssignableFrom(LocalTime.class)) {
                mappingFunction = offsetDateTime -> offsetDateTime.toLocalTime();
            }
        } else if (TIMESTAMPTZ.class.isAssignableFrom(fromType)) {
            if (toType.isAssignableFrom(OffsetDateTime.class)) {
                mappingFunction = timestampWithTimeZone -> OracleR2dbcExceptions.fromJdbc(() -> timestampWithTimeZone.toOffsetDateTime());
            } else if (toType.isAssignableFrom(OffsetTime.class)) {
                mappingFunction = timestampWithTimeZone -> OracleR2dbcExceptions.fromJdbc(() -> timestampWithTimeZone.toOffsetTime());
            } else if (toType.isAssignableFrom(LocalDateTime.class)) {
                mappingFunction = timestampWithTimeZone -> OracleR2dbcExceptions.fromJdbc(() -> timestampWithTimeZone.toLocalDateTime());
            }
        } else if (TIMESTAMPLTZ.class.isAssignableFrom(fromType)) {
            if (toType.isAssignableFrom(OffsetDateTime.class)) {
                mappingFunction = timestampWithLocalTimeZone -> OracleR2dbcExceptions.fromJdbc(() -> timestampWithLocalTimeZone.offsetDateTimeValue(this.jdbcConnection));
            } else if (toType.isAssignableFrom(OffsetTime.class)) {
                mappingFunction = timestampWithLocalTimeZone -> OracleR2dbcExceptions.fromJdbc(() -> timestampWithLocalTimeZone.offsetTimeValue(this.jdbcConnection));
            } else if (toType.isAssignableFrom(LocalDateTime.class)) {
                mappingFunction = timestampWithLocalTimeZone -> OracleR2dbcExceptions.fromJdbc(() -> timestampWithLocalTimeZone.localDateTimeValue(this.jdbcConnection));
            }
        } else if (INTERVALYM.class.isAssignableFrom(fromType) && toType.isAssignableFrom(Period.class)) {
            mappingFunction = intervalym -> {
                ByteBuffer byteBuffer = ByteBuffer.wrap(intervalym.shareBytes());
                return Period.of(byteBuffer.getInt() - Integer.MIN_VALUE, (byte)(byteBuffer.get() - 60), 0);
            };
        } else if (INTERVALDS.class.isAssignableFrom(fromType) && toType.isAssignableFrom(Duration.class)) {
            mappingFunction = intervalds -> intervalds.getDuration();
        } else if (Blob.class.isAssignableFrom(fromType) && byte[].class.equals(toType)) {
            mappingFunction = blob -> OracleR2dbcExceptions.fromJdbc(() -> blob.getBytes(1L, Math.toIntExact(blob.length())));
        } else if (java.sql.Clob.class.isAssignableFrom(fromType) && String.class.isAssignableFrom(toType)) {
            mappingFunction = clob -> OracleR2dbcExceptions.fromJdbc(() -> clob.getSubString(1L, Math.toIntExact(clob.length())));
        } else if (OracleArray.class.isAssignableFrom(fromType) && toType.isArray()) {
            mappingFunction = oracleArray -> this.convertOracleArray((OracleArray)oracleArray, toType.getComponentType());
        }
        if (mappingFunction == null) {
            throw OracleReadableImpl.unsupportedConversion(fromType, toType);
        }
        Function<BigDecimal, Object> typedMappingFunction = mappingFunction;
        return typedMappingFunction;
    }

    private static IllegalArgumentException unsupportedConversion(Class<?> fromType, Class<?> toType) {
        return new IllegalArgumentException(String.format("Conversion from %s to %s is not supported", fromType.getName(), toType.getName()));
    }

    private static <T, U> U[] mapArray(T[] array, IntFunction<U[]> arrayAllocator, Function<T, U> mappingFunction) {
        U[] result = arrayAllocator.apply(array.length);
        for (int i = 0; i < array.length; ++i) {
            T arrayValue = array[i];
            result[i] = arrayValue == null ? null : mappingFunction.apply(array[i]);
        }
        return result;
    }

    private Result getResult(int index) {
        ResultSet resultSet = this.jdbcReadable.getObject(index, ResultSet.class);
        if (resultSet == null) {
            return null;
        }
        this.dependentCounter.increment();
        return OracleResultImpl.createQueryResult(this.r2dbcConnection, this.dependentCounter, resultSet);
    }

    private void requireValidIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index is less than zero: " + index);
        }
        if (index >= this.readablesMetadata.getList().size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is greater than or equal to column count: " + this.readablesMetadata.getList().size());
        }
    }

    private final class StructJdbcReadable
    implements ReactiveJdbcAdapter.JdbcReadable {
        private final Object[] attributes = OracleR2dbcExceptions.fromJdbc(struct::getAttributes);

        private StructJdbcReadable(Struct struct) {
        }

        @Override
        public <T> T getObject(int index, Class<T> type) {
            Object attribute = this.attributes[index];
            if (attribute == null) {
                return null;
            }
            if (type.isInstance(attribute)) {
                return type.cast(attribute);
            }
            Function<?, Object> mappingFunction = OracleReadableImpl.this.getMappingFunction(attribute.getClass(), type);
            return mappingFunction.apply(attribute);
        }
    }

    private final class OracleR2dbcObjectImpl
    extends OracleReadableImpl
    implements OracleR2dbcObject {
        private final OracleR2dbcObjectMetadata metadata;

        private OracleR2dbcObjectImpl(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, StructJdbcReadable structJdbcReadable, ReadablesMetadata.OracleR2dbcObjectMetadataImpl metadata) {
            super(r2dbcConnection, dependentCounter, structJdbcReadable, metadata);
            this.metadata = metadata;
        }

        @Override
        public OracleR2dbcObjectMetadata getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return String.format("%s = %s", this.metadata.getObjectType().getName(), OracleReadableImpl.toMap(this));
        }
    }

    private static final class OutParametersImpl
    extends OracleReadableImpl
    implements OutParameters {
        private final OutParametersMetadata metadata;

        private OutParametersImpl(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.OutParametersMetadataImpl metadata) {
            super(r2dbcConnection, dependentCounter, jdbcReadable, metadata);
            this.metadata = metadata;
        }

        public OutParametersMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static final class RowImpl
    extends OracleReadableImpl
    implements Row {
        private final RowMetadata metadata;

        private RowImpl(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, ReactiveJdbcAdapter.JdbcReadable jdbcReadable, ReadablesMetadata.RowMetadataImpl metadata) {
            super(r2dbcConnection, dependentCounter, jdbcReadable, metadata);
            this.metadata = metadata;
        }

        public RowMetadata getMetadata() {
            return this.metadata;
        }
    }
}

