/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

class NIOControlPacket
extends NIOPacket {
    short nsControlCommand;
    static final short NSPCTL_SERR = 8;
    static final short NSPCTL_CLRATTN = 9;
    static final int ORA_ERROR_EMFI_NUMBER = 22;
    static final int NSECMANSHUT = 12572;
    static final int NSESENDMESG = 12573;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    NIOControlPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 10;
    }

    @Override
    void readPayloadBuffer() throws IOException {
        this.nsControlCommand = this.session.payloadBufferForRead.getShort();
        if (this.nsControlCommand == 8) {
            this.processNSError();
        } else if (this.nsControlCommand == 9) {
            this.disableAttentionProcessing();
        }
    }

    private void processNSError() throws IOException {
        int n2 = this.session.payloadBufferForRead.getInt();
        int n3 = this.session.payloadBufferForRead.getInt();
        int n4 = this.session.payloadBufferForRead.getInt();
        if (n3 == 12572 || n3 == 12573) {
            this.session.needsToBeClosed = true;
            return;
        }
        if (n2 == 22) {
            throw new NetException(n3, "ORA-" + n3, true);
        }
        throw new NetException(n3, "TNS-" + n3, true);
    }

    private void disableAttentionProcessing() {
        this.session.negotiatedOptions &= 0xFFFFFDFF;
        this.session.negotiatedOptions &= 0xFFFFFBFF;
    }

    static {
        try {
            $$$methodRef$$$3 = NIOControlPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NIOControlPacket.class.getDeclaredMethod("disableAttentionProcessing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NIOControlPacket.class.getDeclaredMethod("processNSError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NIOControlPacket.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

