/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.AggregateByteArray;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CCharByteArray
extends AggregateByteArray {
    char[] charArray;
    DBConversion conversion;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    T2CCharByteArray(char[] cArray, ByteArray byteArray) {
        super(PhysicalConnection.EMPTY_BYTE_ARRAY, byteArray);
        this.charArray = cArray;
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    long length() {
        return (long)this.charArray.length + this.extension.length();
    }

    void setChars(char[] cArray) {
        this.charArray = cArray;
    }

    void setDBConversion(DBConversion dBConversion) {
        this.conversion = dBConversion;
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    char[] getChars(long l2, int n2, CharacterSet characterSet, int[] nArray) throws SQLException {
        if (l2 < (long)this.charArray.length) {
            char[] cArray = new char[n2];
            System.arraycopy(this.charArray, (int)l2, cArray, 0, n2);
            nArray[0] = n2;
            return cArray;
        }
        return this.extension.getChars(l2 - (long)this.charArray.length, n2, characterSet, nArray);
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    void get(long l2, byte[] byArray, int n2, int n3) {
        if (l2 < (long)this.charArray.length) {
            try {
                int n4 = this.conversion.javaCharsToCHARBytes(this.charArray, (int)l2, byArray, n2, n3);
            }
            catch (SQLException sQLException) {
            }
        } else {
            this.extension.get(l2 - (long)this.charArray.length, byArray, n2, n3);
        }
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    byte get(long l2) {
        if (l2 < (long)this.charArray.length) {
            return (byte)(this.charArray[(int)l2] & 0xFF);
        }
        return this.extension.get(l2 - (long)this.charArray.length);
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$6 = T2CCharByteArray.class.getDeclaredConstructor(char[].class, ByteArray.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T2CCharByteArray.class.getDeclaredMethod("get", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T2CCharByteArray.class.getDeclaredMethod("get", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T2CCharByteArray.class.getDeclaredMethod("getChars", Long.TYPE, Integer.TYPE, CharacterSet.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CCharByteArray.class.getDeclaredMethod("setDBConversion", DBConversion.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CCharByteArray.class.getDeclaredMethod("setChars", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CCharByteArray.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

