/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLException;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jndi.LDAPSSLSocketFactory;
import oracle.net.ns.NetException;
import oracle.security.pki.OracleSSOKeyStoreSpi;

public class JndiAttrs {
    private static final String WALLET_ENTRY_DN = "oracle.ldap.client.dn";
    private static final String WALLET_ENTRY_PASSWORD = "oracle.ldap.client.password";
    private static final String LDAP_AUTH_TYPE_NONE = "none";
    private static final String LDAP_AUTH_TYPE_SIMPLE = "simple";
    private Properties env;
    private static final String nFactory = "java.naming.factory.initial";
    private static final String nProvider = "java.naming.provider.url";
    private static final String nProfile = "ora-net-profile";
    private static final String default_nFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String ldap_read_timeout = "com.sun.jndi.ldap.read.timeout";
    private static final String ldap_connect_timeout = "com.sun.jndi.ldap.connect.timeout";
    DirContext ctx;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JndiAttrs(@Blind(value=PropertiesBlinder.class) Properties properties) throws NetException {
        String string = null;
        this.env = new Properties();
        if (properties.containsKey(nFactory)) {
            this.env.put(nFactory, properties.getProperty(nFactory));
        } else {
            this.env.put(nFactory, default_nFactory);
        }
        if (properties.containsKey(nProvider)) {
            string = properties.getProperty(nProvider);
            if (string.startsWith("ldaps")) {
                this.env.put("java.naming.ldap.factory.socket", "oracle.net.jndi.LDAPSSLSocketFactory");
                this.env.put("java.naming.security.protocol", "ssl");
                string = "ldap:" + string.substring(6);
            }
            this.env.put(nProvider, string);
        }
        if (properties.containsKey("oracle.net.profile")) {
            this.env.put(nProfile, properties.getProperty("oracle.net.profile"));
        }
        try {
            Class<?> clazz = Class.forName("javax.naming.directory.InitialDirContext");
            if (this.env.get(nFactory) == null) {
                this.env.put(nFactory, default_nFactory);
            }
            if (this.env.get(nProvider) == null) {
                this.env.put(nProvider, string);
            }
        }
        catch (Exception exception) {
            throw new NetException(110, exception.toString());
        }
        if (properties.containsKey(ldap_connect_timeout)) {
            this.env.put(ldap_connect_timeout, properties.getProperty(ldap_connect_timeout));
        }
        if (properties.containsKey(ldap_read_timeout)) {
            this.env.put(ldap_read_timeout, properties.getProperty(ldap_read_timeout));
        }
        this.addAuthenticationDetails(properties);
        LDAPSSLSocketFactory.connectionProperties.set(properties);
        try {
            this.initializeLDAPContext(this.env);
        }
        finally {
            LDAPSSLSocketFactory.connectionProperties.remove();
        }
    }

    private void addAuthenticationDetails(Properties properties) {
        OpaqueString opaqueString;
        String string;
        String string2 = properties.getProperty("oracle.net.ldap.security.authentication");
        if (string2 == null || string2.equalsIgnoreCase(LDAP_AUTH_TYPE_NONE)) {
            return;
        }
        if (string2.equalsIgnoreCase(LDAP_AUTH_TYPE_SIMPLE)) {
            Object[] objectArray;
            this.env.put("java.naming.security.authentication", LDAP_AUTH_TYPE_SIMPLE);
            string = properties.getProperty("oracle.net.ldap.security.principal");
            opaqueString = (OpaqueString)properties.get("oracle.net.ldap.security.credentials");
            if ((string == null || opaqueString == null) && (objectArray = this.getAuthDetailsFromWallet(properties)) != null) {
                string = (String)objectArray[0];
                opaqueString = (OpaqueString)objectArray[1];
            }
            if (string == null || opaqueString == null) {
                throw new RuntimeException("Unable to get LDAP Authentication details.");
            }
        } else {
            throw new RuntimeException("Invalid LDAP Authentication type : " + string2);
        }
        this.env.put("java.naming.security.principal", string);
        this.env.put("java.naming.security.credentials", opaqueString.get());
    }

    private Object[] getAuthDetailsFromWallet(Properties properties) {
        Object[] objectArray;
        block12: {
            char[] cArray = null;
            try {
                String string = properties.getProperty("oracle.net.ldap.ssl.walletLocation");
                if (string == null) {
                    Object[] objectArray2 = null;
                    return objectArray2;
                }
                if (properties.containsKey("oracle.net.ldap.ssl.walletPassword")) {
                    cArray = ((OpaqueString)properties.get("oracle.net.ldap.ssl.walletPassword")).getChars();
                }
                OracleSSOKeyStoreSpi oracleSSOKeyStoreSpi = new OracleSSOKeyStoreSpi();
                oracleSSOKeyStoreSpi.engineLoad((InputStream)new FileInputStream(string), cArray);
                Object[] objectArray3 = new Object[2];
                if (oracleSSOKeyStoreSpi.secretStoreContainsAlias(WALLET_ENTRY_DN)) {
                    objectArray3[0] = new String(oracleSSOKeyStoreSpi.secretStoreGetSecret(WALLET_ENTRY_DN));
                }
                if (oracleSSOKeyStoreSpi.secretStoreContainsAlias(WALLET_ENTRY_PASSWORD)) {
                    objectArray3[1] = OpaqueString.newOpaqueString(oracleSSOKeyStoreSpi.secretStoreGetSecret(WALLET_ENTRY_PASSWORD));
                }
                objectArray = objectArray3;
                if (cArray == null) break block12;
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to get LDAP Authentication details : " + exception.getMessage(), exception);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new RuntimeException("Add OraPKI libs to the class path to read the credentials from wallet.", noClassDefFoundError);
            }
            finally {
                if (cArray != null) {
                    Arrays.fill(cArray, '\u0000');
                }
            }
            Arrays.fill(cArray, '\u0000');
        }
        return objectArray;
    }

    private void initializeLDAPContext(@Blind(value=PropertiesBlinder.class) Properties properties) throws NetException {
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                this.ctx = new InitialDirContext(properties);
                break;
            }
            catch (NamingException namingException) {
                if (namingException.getRootCause() instanceof SSLException && i2 < 3) continue;
                NetException netException = new NetException(108, namingException.toString());
                netException.initCause(namingException);
                throw netException;
            }
        }
    }

    public Vector getProfileAttrs(String string) throws NetException {
        String string2 = "cn=";
        Attributes attributes = null;
        try {
            string2 = string2.concat(string);
            attributes = this.ctx.getAttributes(string2);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return this.setAttrs(attributes);
    }

    public Vector getAttrs(String string, String[] stringArray) throws NetException {
        String string2 = "cn=";
        Attributes attributes = null;
        try {
            string2 = !string.startsWith(string2) ? string2.concat(string) : string;
            attributes = this.ctx.getAttributes(string2, stringArray);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return this.setAttrs(attributes);
    }

    private Vector setAttrs(Attributes attributes) throws NetException {
        Vector vector = new Vector(1, 1);
        if (attributes != null) {
            try {
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                    Attribute attribute = namingEnumeration.next();
                    NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                    while (namingEnumeration2.hasMoreElements()) {
                        vector.addElement(namingEnumeration2.nextElement());
                    }
                }
            }
            catch (NamingException namingException) {
                throw new NetException(108, namingException.toString());
            }
        }
        return vector;
    }

    public void setEnv(String string, String string2) {
        this.env.put(string, string2);
    }

    public void close() throws NetException {
        try {
            if (null != this.ctx) {
                this.ctx.close();
            }
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
    }

    public final String getLdapUrlUsed() throws NetException {
        String string = null;
        try {
            string = (String)this.ctx.getEnvironment().get(nProvider);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return string;
    }

    static {
        try {
            $$$methodRef$$$9 = JndiAttrs.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JndiAttrs.class.getDeclaredMethod("getLdapUrlUsed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JndiAttrs.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JndiAttrs.class.getDeclaredMethod("setEnv", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JndiAttrs.class.getDeclaredMethod("setAttrs", Attributes.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JndiAttrs.class.getDeclaredMethod("getAttrs", String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JndiAttrs.class.getDeclaredMethod("getProfileAttrs", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JndiAttrs.class.getDeclaredMethod("initializeLDAPContext", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JndiAttrs.class.getDeclaredMethod("getAuthDetailsFromWallet", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JndiAttrs.class.getDeclaredMethod("addAuthenticationDetails", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

