/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.logging.Logger;
import oracle.jdbc.driver.Chain;

final class LRUCache<T> {
    private Chain.Link<T>[] vacant = new Chain.Link[]{null};
    private int[] ivacant = new int[]{0};
    private final boolean implicit;
    private static final int NSTMTS = 3;
    private static final int MRSETS = 6;
    private final Map<String, Chain<T>>[] cache;
    private final Chain<T> history = new Chain<T>(this.vacant, this.ivacant);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    LRUCache(boolean bl) {
        this.implicit = bl;
        this.cache = new Map[bl ? 18 : 1];
        for (int i2 = 0; i2 < this.cache.length; ++i2) {
            this.cache[i2] = new HashMap<String, Chain<T>>();
        }
    }

    void vacancy(int n2) {
        if (n2 > 1) {
            this.vacant = new Chain.Link[Math.min(n2, 1000)];
            this.ivacant[0] = 0;
        }
    }

    T removeMostRecent(int n2, int n3, String string) {
        int n4 = this.implicit ? n2 * 3 + n3 : 0;
        Chain<T> chain = this.cache[n4].get(string);
        return null == chain ? null : (T)chain.removeHead();
    }

    T removeLeastRecent() {
        return this.history.removeTail();
    }

    void add(T t2, int n3, int n4, String string2) {
        assert (Objects.nonNull(t2));
        assert (Objects.nonNull(string2));
        int n5 = this.implicit ? n3 * 3 + n4 : 0;
        Map map = Objects.isNull(this.cache[n5]) ? new HashMap<String, Chain<T>>() : this.cache[n5];
        IntConsumer intConsumer = n2 -> {
            if (0 == n2) {
                map.remove(string2);
            }
        };
        Function<String, Chain> function = string -> new Chain<T>(this.vacant, this.ivacant, intConsumer);
        Chain chain = map.computeIfAbsent(string2, function);
        Chain.addHead(t2, chain, this.history);
    }

    int size() {
        return this.history.size();
    }

    void forEach(Consumer<? super T> consumer) {
        this.history.forEach(consumer);
    }

    public String toString() {
        return "cache=" + Arrays.deepToString(this.cache) + ", history=" + this.history.toString();
    }

    static {
        try {
            $$$methodRef$$$9 = LRUCache.class.getDeclaredConstructor(Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LRUCache.class.getDeclaredMethod("lambda$add$0", Map.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LRUCache.class.getDeclaredMethod("lambda$add$1", IntConsumer.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LRUCache.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LRUCache.class.getDeclaredMethod("forEach", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LRUCache.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LRUCache.class.getDeclaredMethod("add", Object.class, Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LRUCache.class.getDeclaredMethod("removeLeastRecent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LRUCache.class.getDeclaredMethod("removeMostRecent", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LRUCache.class.getDeclaredMethod("vacancy", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

