/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ano.Ano;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.AddrResolution;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public abstract class NSProtocol
implements Communication,
SQLnetDef {
    protected AddrResolution addrRes;
    protected SessionAtts sAtts;
    DMSFactory.DMSNoun dmsParent = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;

    @Override
    public SessionAtts getSessionAttributes() {
        return this.sAtts;
    }

    @Override
    public void connect(String string, @Blind(value=PropertiesBlinder.class) Properties properties, DMSFactory.DMSNoun dMSNoun) throws IOException, NetException, InterruptedIOException {
        this.connect(string, properties, null, null, null, dMSNoun);
    }

    @Override
    public void connect(String string, @Blind(value=PropertiesBlinder.class) Properties properties, GSSCredential gSSCredential, DMSFactory.DMSNoun dMSNoun) throws IOException, NetException, InterruptedIOException {
        this.connect(string, properties, gSSCredential, null, null, dMSNoun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String string, @Blind(value=PropertiesBlinder.class) Properties properties, GSSCredential gSSCredential, SSLContext sSLContext, OracleHostnameResolver oracleHostnameResolver, DMSFactory.DMSNoun dMSNoun) throws IOException, NetException, InterruptedIOException {
        if (this.sAtts.connected) {
            throw new NetException(201);
        }
        if (string == null) {
            throw new NetException(208);
        }
        this.dmsParent = dMSNoun;
        this.addrRes = new AddrResolution(string, properties, sSLContext, oracleHostnameResolver, this.sAtts.getSecuredLogger());
        boolean bl = this.getDisableOOBProperty(properties);
        boolean bl2 = this.getZeroCopyIOProperty(properties);
        this.sAtts.traceId = (String)properties.get("T4CConnection.hashCode");
        if (this.addrRes.connection_revised) {
            string = this.addrRes.getTNSAddressInUpperCase();
            properties = this.addrRes.getUp();
        }
        this.configureSessionAttsCompression(properties);
        try {
            this.establishConnection(string, true, this.dmsParent);
            this.configureSessionAttsAno(properties);
            this.negotiateConnection(new NVFactory(), new NVNavigator(), bl, bl2, this.dmsParent);
            this.configureSessionAttsAfterNegotiation(properties);
            this.verifyServerCertificateMatch();
            this.initializeAno(gSSCredential);
        }
        finally {
            this.cancelOutboundTimeoutInterrupt();
        }
        this.addrRes.connection_redirected = false;
        this.sAtts.initializeNetProperties(properties);
    }

    @Override
    public CompletionStage<Void> connectAsync(String string, Properties properties, GSSCredential gSSCredential, SSLContext sSLContext, OracleHostnameResolver oracleHostnameResolver, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        if (this.sAtts.connected) {
            return CompletionStageUtil.failedStage(new NetException(201));
        }
        if (string == null) {
            return CompletionStageUtil.failedStage(new NetException(208));
        }
        this.dmsParent = dMSNoun;
        try {
            this.addrRes = new AddrResolution(string, properties, sSLContext, oracleHostnameResolver, this.sAtts.getSecuredLogger());
        }
        catch (NetException netException) {
            return CompletionStageUtil.failedStage(netException);
        }
        boolean bl = this.getDisableOOBProperty(properties);
        boolean bl2 = this.getZeroCopyIOProperty(properties);
        this.sAtts.traceId = (String)properties.get("T4CConnection.hashCode");
        if (this.addrRes.connection_revised) {
            string = this.addrRes.getTNSAddressInUpperCase();
            properties = this.addrRes.getUp();
        }
        this.configureSessionAttsCompression(properties);
        AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler2 = AsyncOutboundTimeoutHandler.newInstance(asyncOutboundTimeoutHandler, new NetException(503));
        Properties properties2 = properties;
        return this.establishConnectionAsync(string, true, this.dmsParent, asyncOutboundTimeoutHandler2, executor).thenCompose(CompletionStageUtil.normalCompletionHandler(sessionAtts -> {
            this.configureSessionAttsAno(properties2);
            return this.negotiateConnectionAsync(new NVFactory(), new NVNavigator(), bl, bl2, this.dmsParent, asyncOutboundTimeoutHandler2, executor);
        })).thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
            this.configureSessionAttsAfterNegotiation(properties2);
            this.verifyServerCertificateMatch();
            this.initializeAno(gSSCredential);
            return void_;
        })).whenComplete((void_, throwable) -> {
            asyncOutboundTimeoutHandler2.cancelTimeout();
            if (throwable == null) {
                this.addrRes.connection_redirected = false;
                try {
                    this.sAtts.initializeNetProperties(properties2);
                }
                catch (IOException iOException) {
                    throw new CompletionException(iOException);
                }
            }
        });
    }

    private final boolean getDisableOOBProperty(Properties properties) {
        String string = (String)properties.get("DISABLE_OOB");
        return "true".equals(string);
    }

    private final boolean getZeroCopyIOProperty(Properties properties) {
        if (this.sAtts.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            return false;
        }
        String string = (String)properties.get("USE_ZERO_COPY_IO");
        return string == null || !"false".equals(string);
    }

    private final void configureSessionAttsCompression(Properties properties) {
        this.sAtts.networkCompression = properties.getProperty("oracle.net.networkCompression", "off").toLowerCase();
        this.sAtts.networkCompressionThreshold = Integer.parseInt(properties.getProperty("oracle.net.networkCompressionThreshold", "1024"));
        String string = properties.getProperty("oracle.net.networkCompressionLevels", "(high)");
        this.sAtts.networkCompressionLevelsArray = new ArrayList();
        if (string.equals("(high)")) {
            this.sAtts.networkCompressionLevelsArray.add("high");
        } else {
            String[] stringArray;
            string = string.trim();
            string = string.substring(1, string.length() - 1);
            for (String string2 : stringArray = string.split("\\s+|,")) {
                if (string2.equals("")) continue;
                this.sAtts.networkCompressionLevelsArray.add(string2.toLowerCase());
            }
        }
    }

    private final void configureSessionAttsAno(Properties properties) throws NetException {
        this.sAtts.profile = new ClientProfile(properties);
        boolean bl = Boolean.valueOf(properties.getProperty("oracle.net.useJCEAPI", "false"));
        this.sAtts.ano = new Ano();
        this.sAtts.ano.init(this.sAtts, this.sAtts.isJavaNetNIO, bl);
        this.sAtts.anoEnabled = true;
    }

    private final void configureSessionAttsAfterNegotiation(Properties properties) throws IOException {
        this.sAtts.connected = true;
        this.sAtts.nt.setReadTimeoutIfRequired(properties);
    }

    private final void verifyServerCertificateMatch() throws IOException, NetException {
        String string = (String)this.sAtts.nt.getOption(106);
        if (string != null && string.equalsIgnoreCase("false")) {
            throw new NetException(405);
        }
    }

    private final void initializeAno(GSSCredential gSSCredential) throws IOException, NetException {
        if (this.sAtts.noAnoServices) {
            if (this.sAtts.profile.getEncryptionLevelNum() == 3 || this.sAtts.profile.getDataIntegrityLevelNum() == 3) {
                throw new NetException(320, "(encryption / checksumming required by client but disabled by server)");
            }
        } else {
            this.sAtts.ano.negotiation(this.addrRes.connection_redirected, this.sAtts.isJavaNetNIO, gSSCredential);
        }
    }

    private final void cancelOutboundTimeoutInterrupt() throws NetException {
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        if (interruptTask != null && interruptTask.isInterrupted()) {
            Thread.interrupted();
            throw new NetException(503);
        }
    }

    abstract void negotiateConnection(NVFactory var1, NVNavigator var2, boolean var3, boolean var4, DMSFactory.DMSNoun var5) throws IOException, NetException;

    abstract CompletionStage<Void> negotiateConnectionAsync(NVFactory var1, NVNavigator var2, boolean var3, boolean var4, DMSFactory.DMSNoun var5, AsyncOutboundTimeoutHandler var6, Executor var7);

    @Override
    public void sendBreak() throws IOException, NetException {
        if (this.sAtts.isExpediatedAttentionEnabled()) {
            this.sAtts.nt.sendUrgentByte(33);
            if (this.sAtts.isAttentionProcessingEnabled()) {
                this.sendMarker(2, (byte)1);
            }
        } else {
            this.sendMarker(1, (byte)1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if (this.sAtts.isExpediatedAttentionEnabled()) {
            this.sAtts.nt.sendUrgentByte(33);
            if (this.sAtts.isAttentionProcessingEnabled()) {
                this.sendMarker(2, (byte)3);
            }
        } else {
            this.sendMarker(1, (byte)3);
        }
    }

    protected abstract void sendMarker(int var1, byte var2) throws IOException, NetException;

    @Override
    public void setOption(int n2, Object object) throws NetException, IOException {
        if (n2 > 100 && n2 < 110) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            nTAdapter.setOption(n2, object);
        }
    }

    @Override
    public Object getOption(int n2) throws NetException, IOException {
        if (n2 > 100 && n2 < 110) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            return nTAdapter.getOption(n2);
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        if (nTAdapter != null) {
            nTAdapter.abort();
        }
    }

    @Override
    public String getEncryptionName() {
        String string = null;
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        try {
            string = (String)nTAdapter.getOption(105);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null && this.sAtts.ano != null) {
            string = this.sAtts.ano.getEncryptionName();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getAccessBanner() {
        return this.sAtts.getConnectData();
    }

    @Override
    public String getDataIntegrityName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getDataIntegrityName();
        }
        return string;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return string;
    }

    @Override
    public void cancelTimeout() {
    }

    public void reconnectIfRequired(boolean bl) throws IOException, InterruptedIOException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.sAtts.timestampLastIO;
        if (l3 > (long)this.sAtts.timeout) {
            this.reconnect(bl);
        }
    }

    @Override
    public void setAuthSessionKey(byte[] byArray) throws NetException {
        if (byArray != null && (this.sAtts.isEncryptionActive || this.sAtts.isChecksumActive)) {
            this.sAtts.ano.setAuthSessionKey(byArray);
        }
    }

    @Override
    public void doKeyFoldinForExternalAuth() {
        if ((this.sAtts.isEncryptionActive || this.sAtts.isChecksumActive) && !this.sAtts.profile.useWeakCrypto()) {
            this.sAtts.ano.setAuthSessionKey(this.sAtts.ano.getExternalAuthSessionKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean bl) throws IOException, InterruptedIOException {
        try {
            String string = new String(this.sAtts.reconnectAddress);
            this.sAtts.attemptingReconnect = true;
            ConnOption connOption = this.sAtts.cOption;
            this.addrRes.connection_redirected = true;
            this.sAtts.cOption.nt.disconnect();
            this.establishConnection(string, false, this.dmsParent);
            this.sAtts.cOption.restoreFromOrigCoption(connOption);
            if (bl) {
                this.sendProbePacket();
            }
        }
        finally {
            this.sAtts.attemptingReconnect = false;
        }
    }

    SessionAtts establishConnection(String string, DMSFactory.DMSNoun dMSNoun) throws NetException, IOException, InterruptedIOException {
        return this.establishConnection(string, false, dMSNoun);
    }

    SessionAtts establishConnection(String string, boolean bl, DMSFactory.DMSNoun dMSNoun) throws NetException, IOException, InterruptedIOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string, bl, dMSNoun);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.networkType = this.sAtts.nt.getNetworkAdapterType();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.sAtts.setNetConnectionIdPrefix(this.addrRes.getConnStrategy().getConnectionIdPrefix());
        this.initializeSessionAttributes();
        return this.sAtts;
    }

    final CompletionStage<SessionAtts> establishConnectionAsync(String string, boolean bl, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        return this.addrRes.resolveAndExecuteAsync(string, bl, dMSNoun, asyncOutboundTimeoutHandler, executor).thenApply(connOption -> {
            this.sAtts.cOption = connOption;
            if (this.sAtts.cOption == null) {
                return null;
            }
            this.sAtts.nt = this.sAtts.cOption.nt;
            this.sAtts.networkType = this.sAtts.nt.getNetworkAdapterType();
            this.sAtts.setTDU(this.sAtts.cOption.tdu);
            this.sAtts.setSDU(this.sAtts.cOption.sdu);
            try {
                this.initializeSessionAttributes();
            }
            catch (IOException iOException) {
                throw new CompletionException(iOException);
            }
            return this.sAtts;
        });
    }

    abstract void initializeSessionAttributes() throws NetException, IOException;

    abstract void sendProbePacket() throws IOException;

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.addrRes.isConnectionSocketKeepAlive();
    }

    @Override
    public int getSocketReadTimeout() throws NetException, IOException {
        String string = (String)this.getOption(101);
        int n2 = string == null || "".equals(string) ? 0 : Integer.parseInt(string);
        return n2;
    }

    @Override
    public void setSocketReadTimeout(int n2) throws NetException, IOException {
        String string = Integer.toString(n2);
        this.setOption(101, string);
    }

    @Override
    public String getConnectionString() {
        return this.addrRes.getTNSAddress();
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getSocketOptions() {
        return this.addrRes.getSocketOptions();
    }

    @Override
    public int getNegotiatedSDU() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.negotiatedSDU;
    }

    @Override
    public NetStat getNetworkStat() {
        return this.sAtts.nt.getNetStat();
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.sAtts.networkCompressionEnabled;
    }

    @Override
    public int getOutboundConnectTimeout() {
        int n2 = 0;
        if (this.addrRes != null) {
            n2 = this.addrRes.getConnStrategy().getOutboundConnectTimeout();
        }
        return n2;
    }

    @Override
    public boolean isUsingCustomHostnameResolver() {
        return this.addrRes.isUsingCustomHostnameResolver();
    }

    void tryUrgentByte() {
        try {
            this.sAtts.nt.sendUrgentByte(33);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$45 = NSProtocol.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$44 = NSProtocol.class.getDeclaredMethod("lambda$connectAsync$0", Properties.class, Boolean.TYPE, Boolean.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$43 = NSProtocol.class.getDeclaredMethod("lambda$connectAsync$1", Properties.class, GSSCredential.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$42 = NSProtocol.class.getDeclaredMethod("lambda$connectAsync$2", AsyncOutboundTimeoutHandler.class, Properties.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$41 = NSProtocol.class.getDeclaredMethod("lambda$establishConnectionAsync$3", ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$40 = NSProtocol.class.getDeclaredMethod("tryUrgentByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$39 = NSProtocol.class.getDeclaredMethod("isUsingCustomHostnameResolver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$38 = NSProtocol.class.getDeclaredMethod("getOutboundConnectTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$37 = NSProtocol.class.getDeclaredMethod("isNetworkCompressionEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$36 = NSProtocol.class.getDeclaredMethod("getNetworkStat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$35 = NSProtocol.class.getDeclaredMethod("getNegotiatedSDU", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$34 = NSProtocol.class.getDeclaredMethod("getSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$33 = NSProtocol.class.getDeclaredMethod("getConnectionString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$32 = NSProtocol.class.getDeclaredMethod("setSocketReadTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$31 = NSProtocol.class.getDeclaredMethod("getSocketReadTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$30 = NSProtocol.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$29 = NSProtocol.class.getDeclaredMethod("establishConnectionAsync", String.class, Boolean.TYPE, DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$28 = NSProtocol.class.getDeclaredMethod("establishConnection", String.class, Boolean.TYPE, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$27 = NSProtocol.class.getDeclaredMethod("establishConnection", String.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$26 = NSProtocol.class.getDeclaredMethod("reconnect", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$25 = NSProtocol.class.getDeclaredMethod("doKeyFoldinForExternalAuth", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$24 = NSProtocol.class.getDeclaredMethod("setAuthSessionKey", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$23 = NSProtocol.class.getDeclaredMethod("reconnectIfRequired", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$22 = NSProtocol.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$21 = NSProtocol.class.getDeclaredMethod("getAuthenticationAdaptorName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$20 = NSProtocol.class.getDeclaredMethod("getDataIntegrityName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$19 = NSProtocol.class.getDeclaredMethod("getAccessBanner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$18 = NSProtocol.class.getDeclaredMethod("getEncryptionName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$17 = NSProtocol.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$16 = NSProtocol.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = NSProtocol.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = NSProtocol.class.getDeclaredMethod("sendInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = NSProtocol.class.getDeclaredMethod("sendBreak", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = NSProtocol.class.getDeclaredMethod("cancelOutboundTimeoutInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = NSProtocol.class.getDeclaredMethod("initializeAno", GSSCredential.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = NSProtocol.class.getDeclaredMethod("verifyServerCertificateMatch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = NSProtocol.class.getDeclaredMethod("configureSessionAttsAfterNegotiation", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = NSProtocol.class.getDeclaredMethod("configureSessionAttsAno", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = NSProtocol.class.getDeclaredMethod("configureSessionAttsCompression", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = NSProtocol.class.getDeclaredMethod("getZeroCopyIOProperty", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = NSProtocol.class.getDeclaredMethod("getDisableOOBProperty", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NSProtocol.class.getDeclaredMethod("connectAsync", String.class, Properties.class, GSSCredential.class, SSLContext.class, OracleHostnameResolver.class, DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NSProtocol.class.getDeclaredMethod("connect", String.class, Properties.class, GSSCredential.class, SSLContext.class, OracleHostnameResolver.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NSProtocol.class.getDeclaredMethod("connect", String.class, Properties.class, GSSCredential.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NSProtocol.class.getDeclaredMethod("connect", String.class, Properties.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NSProtocol.class.getDeclaredMethod("getSessionAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

