/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonGenerationException;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonValue;

public class JakartaGeneratorWrapper
implements Wrapper,
JsonGenerator {
    OracleJsonGenerator wrapped;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    public JakartaGeneratorWrapper(OracleJsonGenerator oracleJsonGenerator) {
        this.wrapped = oracleJsonGenerator;
    }

    public void close() {
        try {
            this.wrapped.close();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
    }

    public void flush() {
        try {
            this.wrapped.flush();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
    }

    public JsonGenerator writeKey(String string) {
        try {
            this.wrapped.writeKey(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    private JsonException translate(OracleJsonException oracleJsonException) {
        if (oracleJsonException instanceof OracleJsonGenerationException) {
            return new JsonGenerationException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
        }
        return new JsonException(oracleJsonException.getMessage(), (Throwable)oracleJsonException);
    }

    public JsonGenerator write(String string, JsonValue jsonValue) {
        try {
            this.wrapped.writeKey(string);
            this.write(jsonValue);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(JsonValue jsonValue) {
        if (jsonValue instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)jsonValue;
            try {
                if (wrapper.isWrapperFor(OracleJsonValue.class)) {
                    this.wrapped.write(wrapper.unwrap(OracleJsonValue.class));
                    return this;
                }
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException(sQLException);
            }
        }
        this.writeJsonValue(jsonValue);
        return this;
    }

    private void writeJsonValue(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case OBJECT: {
                JsonObject jsonObject = (JsonObject)jsonValue;
                this.writeStartObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    this.writeKey((String)entry.getKey());
                    this.writeJsonValue((JsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case ARRAY: {
                JsonArray jsonArray = (JsonArray)jsonValue;
                this.writeStartArray();
                for (JsonValue jsonValue2 : jsonArray) {
                    this.writeJsonValue(jsonValue2);
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString jsonString = (JsonString)jsonValue;
                this.write(jsonString.getString());
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                this.writeOraNum(jsonNumber.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
    }

    public void writeJsonParser(Object object) {
        JsonParser jsonParser = (JsonParser)object;
        int n2 = 0;
        while (jsonParser.hasNext()) {
            switch (jsonParser.next()) {
                case END_ARRAY: {
                    this.writeEnd();
                    --n2;
                    break;
                }
                case END_OBJECT: {
                    this.writeEnd();
                    --n2;
                    break;
                }
                case KEY_NAME: {
                    this.writeKey(jsonParser.getString());
                    break;
                }
                case START_ARRAY: {
                    this.writeStartArray();
                    ++n2;
                    break;
                }
                case START_OBJECT: {
                    this.writeStartObject();
                    ++n2;
                    break;
                }
                case VALUE_FALSE: {
                    this.write(false);
                    break;
                }
                case VALUE_NULL: {
                    this.writeNull();
                    break;
                }
                case VALUE_NUMBER: {
                    this.writeOraNum(jsonParser.getBigDecimal());
                    break;
                }
                case VALUE_STRING: {
                    this.write(jsonParser.getString());
                    break;
                }
                case VALUE_TRUE: {
                    this.write(true);
                }
            }
            if (n2 > 0) continue;
            break;
        }
    }

    public JsonGenerator write(String string) {
        try {
            this.wrapped.write(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(BigDecimal bigDecimal) {
        try {
            this.wrapped.write(bigDecimal);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(BigInteger bigInteger) {
        this.wrapped.write(bigInteger);
        return this;
    }

    public JsonGenerator write(int n2) {
        try {
            this.wrapped.write(n2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(long l2) {
        try {
            this.wrapped.write(l2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(double d2) {
        try {
            this.wrapped.write(d2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(boolean bl) {
        try {
            this.wrapped.write(bl);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, String string2) {
        try {
            this.wrapped.write(string, string2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, BigInteger bigInteger) {
        try {
            this.wrapped.write(string, bigInteger);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, BigDecimal bigDecimal) {
        try {
            this.wrapped.write(string, bigDecimal);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, int n2) {
        try {
            this.wrapped.write(string, n2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, long l2) {
        try {
            this.wrapped.write(string, l2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, double d2) {
        try {
            this.wrapped.write(string, d2);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator write(String string, boolean bl) {
        try {
            this.wrapped.write(string, bl);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeEnd() {
        try {
            this.wrapped.writeEnd();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        try {
            this.wrapped.writeNull();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeNull(String string) {
        try {
            this.wrapped.writeNull(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartArray() {
        try {
            this.wrapped.writeStartArray();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartArray(String string) {
        try {
            this.wrapped.writeStartArray(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartObject() {
        try {
            this.wrapped.writeStartObject();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    public JsonGenerator writeStartObject(String string) {
        try {
            this.wrapped.writeStartObject(string);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance(this.wrapped)) {
            return (T)this.wrapped;
        }
        throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, clazz.getName()).getMessage());
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this.wrapped);
    }

    private void writeOraNum(BigDecimal bigDecimal) {
        try {
            this.wrapped.write(new OracleJsonDecimalImpl(bigDecimal));
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.translate(oracleJsonException);
        }
    }

    static {
        try {
            $$$methodRef$$$32 = JakartaGeneratorWrapper.class.getDeclaredConstructor(OracleJsonGenerator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeOraNum", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = JakartaGeneratorWrapper.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = JakartaGeneratorWrapper.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeStartObject", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeStartObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeStartArray", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeStartArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeNull", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeEnd", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeJsonParser", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeJsonValue", JsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", JsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JakartaGeneratorWrapper.class.getDeclaredMethod("write", String.class, JsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JakartaGeneratorWrapper.class.getDeclaredMethod("translate", OracleJsonException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JakartaGeneratorWrapper.class.getDeclaredMethod("writeKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JakartaGeneratorWrapper.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JakartaGeneratorWrapper.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

