/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.BLOB;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class BlobAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    BlobAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.BLOB, oracleStatement, 4000, bl);
        this.init(oracleStatement, 113, 113, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    BlobAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(Representation.BLOB, oracleStatement, 4000, false);
        this.init(oracleStatement, 113, 113, s2, false);
        this.initForDescribe(113, n2, bl, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        return this.getBLOB(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    @Override
    BLOB getBLOB(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        BLOB bLOB = new BLOB(this.statement.connection, this.getBytesInternal(n2));
        if (this.isPrefetched()) {
            bLOB.setActivePrefetch(true);
            bLOB.setLength(this.getPrefetchedLength(n2));
            bLOB.setChunkSize(this.getPrefetchedChunkSize(n2));
            bLOB.setPrefetchedData(this.getPrefetchedData(n2));
        }
        if (bLOB.isTemporary()) {
            this.statement.connection.addTemporaryLob(bLOB);
        }
        return bLOB;
    }

    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        if (bLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(bLOB);
        }
        return bLOB.asciiStreamValue();
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        if (bLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(bLOB);
        }
        return bLOB.characterStreamValue(true);
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        if (bLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(bLOB);
        }
        return bLOB.getBinaryStream(true);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        if (this.isPrefetched() && this.getPrefetchedLength(n2) > Integer.MAX_VALUE) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        if (this.isPrefetched() && (long)this.getPrefetchedDataLength(n2) == this.getPrefetchedLength(n2)) {
            return this.getPrefetchedData(n2);
        }
        BLOB bLOB = this.getBLOB(n2);
        if (bLOB == null) {
            return null;
        }
        if (bLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(bLOB);
        }
        return bLOB.getBytes(1L, (int)bLOB.length());
    }

    @Override
    String getString(int n2) throws SQLException {
        this.unimpl("getString/getNString");
        return null;
    }

    @Override
    String getNString(int n2) throws SQLException {
        this.unimpl("getNString");
        return null;
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        this.unimpl("updateChecksum");
        return -1L;
    }

    static {
        try {
            $$$methodRef$$$12 = BlobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = BlobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = BlobAccessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = BlobAccessor.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = BlobAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = BlobAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = BlobAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = BlobAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = BlobAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BlobAccessor.class.getDeclaredMethod("getBLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BlobAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BlobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BlobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

