/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.lang.reflect.Executable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.DATE;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonDateImpl
implements OracleJsonDate {
    byte[] raw;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleJsonDateImpl(byte[] byArray) {
        this.raw = byArray;
    }

    public OracleJsonDateImpl(LocalDateTime localDateTime) {
        this.raw = OsonPrimitiveConversions.toOracleDate(this.getExceptionFactory(), localDateTime);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.DATE;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonDate)) {
            return false;
        }
        if (!(object instanceof OracleJsonDateImpl)) {
            throw new UnsupportedOperationException();
        }
        OracleJsonDateImpl oracleJsonDateImpl = (OracleJsonDateImpl)object;
        return Arrays.equals(oracleJsonDateImpl.raw, this.raw);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        byte[] byArray = this.raw();
        return OsonPrimitiveConversions.dateToLocalDateTime(this.getExceptionFactory(), byArray);
    }

    @Override
    public String getString() {
        return OsonPrimitiveConversions.dateToString(this.getExceptionFactory(), this.raw);
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public DATE getDATE() {
        return new DATE(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        if (Jsonp.isJakartaJson(clazz)) {
            return clazz.cast(new JakartaPrimitive.JakartaDateImpl(this.raw));
        }
        return clazz.cast(new JsonpPrimitive.JsonpDateImpl(this.raw));
    }

    public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    static {
        try {
            $$$methodRef$$$11 = OracleJsonDateImpl.class.getDeclaredConstructor(LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleJsonDateImpl.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleJsonDateImpl.class.getDeclaredMethod("getExceptionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleJsonDateImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJsonDateImpl.class.getDeclaredMethod("getDATE", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJsonDateImpl.class.getDeclaredMethod("raw", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJsonDateImpl.class.getDeclaredMethod("getString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJsonDateImpl.class.getDeclaredMethod("getLocalDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJsonDateImpl.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJsonDateImpl.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJsonDateImpl.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJsonDateImpl.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

