/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class JsonAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    private final OracleJsonFactory factory;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;

    JsonAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.JSON, oracleStatement, 4000, bl);
        this.init(oracleStatement, 119, 119, s2, bl);
        this.initForDataAccess(n3, n2, null);
        this.factory = oracleStatement.connection.getOracleJsonFactory();
    }

    JsonAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(Representation.JSON, oracleStatement, 4000, false);
        this.init(oracleStatement, 119, 119, s2, false);
        this.initForDescribe(119, n2, bl, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
        this.factory = oracleStatement.connection.getOracleJsonFactory();
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        try {
            OracleJsonParser oracleJsonParser = this.factory.createJsonBinaryParser(this.getBufferInternal(n2));
            this.out.reset();
            OracleJsonGenerator oracleJsonGenerator = this.factory.createJsonTextGenerator(this.out);
            oracleJsonGenerator.writeParser(oracleJsonParser);
            oracleJsonGenerator.close();
            return this.out.toByteArray();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    JsonValue getJsonValue(int n2) throws SQLException {
        byte[] byArray = this.getBytesInternal(n2);
        try {
            return this.factory.createJsonBinaryValue(ByteBuffer.wrap(byArray)).wrap(JsonValue.class);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    JsonParser getJsonParser(int n2) throws SQLException {
        byte[] byArray = this.getBytesInternal(n2);
        try {
            return this.factory.createJsonBinaryParser(ByteBuffer.wrap(byArray)).wrap(JsonParser.class);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    JsonStructure getJsonStructure(int n2) throws SQLException {
        JsonValue jsonValue = this.getJsonValue(n2);
        if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY || jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            return (JsonStructure)jsonValue;
        }
        throw this.invalidColumnType();
    }

    @Override
    JsonObject getJsonObject(int n2) throws SQLException {
        return (JsonObject)this.getJsonValue(n2, JsonValue.ValueType.OBJECT);
    }

    @Override
    JsonArray getJsonArray(int n2) throws SQLException {
        return (JsonArray)this.getJsonValue(n2, JsonValue.ValueType.ARRAY);
    }

    @Override
    JsonString getJsonString(int n2) throws SQLException {
        return (JsonString)this.getJsonValue(n2, JsonValue.ValueType.STRING);
    }

    @Override
    JsonNumber getJsonNumber(int n2) throws SQLException {
        return (JsonNumber)this.getJsonValue(n2, JsonValue.ValueType.NUMBER);
    }

    private JsonValue getJsonValue(int n2, JsonValue.ValueType valueType) throws SQLException {
        JsonValue jsonValue = this.getJsonValue(n2);
        if (jsonValue.getValueType() == valueType) {
            return jsonValue;
        }
        throw this.invalidColumnType();
    }

    @Override
    jakarta.json.JsonValue getJakartaJsonValue(int n2) throws SQLException {
        byte[] byArray = this.getBytesInternal(n2);
        try {
            return this.factory.createJsonBinaryValue(ByteBuffer.wrap(byArray)).wrap(jakarta.json.JsonValue.class);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    jakarta.json.stream.JsonParser getJakartaJsonParser(int n2) throws SQLException {
        byte[] byArray = this.getBytesInternal(n2);
        try {
            return this.factory.createJsonBinaryParser(ByteBuffer.wrap(byArray)).wrap(jakarta.json.stream.JsonParser.class);
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    jakarta.json.JsonStructure getJakartaJsonStructure(int n2) throws SQLException {
        jakarta.json.JsonValue jsonValue = this.getJakartaJsonValue(n2);
        if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY || jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            return (jakarta.json.JsonStructure)jsonValue;
        }
        throw this.invalidColumnType();
    }

    @Override
    jakarta.json.JsonObject getJakartaJsonObject(int n2) throws SQLException {
        return (jakarta.json.JsonObject)this.getJakartaJsonValue(n2, JsonValue.ValueType.OBJECT);
    }

    @Override
    jakarta.json.JsonArray getJakartaJsonArray(int n2) throws SQLException {
        return (jakarta.json.JsonArray)this.getJakartaJsonValue(n2, JsonValue.ValueType.ARRAY);
    }

    @Override
    jakarta.json.JsonString getJakartaJsonString(int n2) throws SQLException {
        return (jakarta.json.JsonString)this.getJakartaJsonValue(n2, JsonValue.ValueType.STRING);
    }

    @Override
    jakarta.json.JsonNumber getJakartaJsonNumber(int n2) throws SQLException {
        return (jakarta.json.JsonNumber)this.getJakartaJsonValue(n2, JsonValue.ValueType.NUMBER);
    }

    private jakarta.json.JsonValue getJakartaJsonValue(int n2, JsonValue.ValueType valueType) throws SQLException {
        jakarta.json.JsonValue jsonValue = this.getJakartaJsonValue(n2);
        if (jsonValue.getValueType() == valueType) {
            return jsonValue;
        }
        throw this.invalidColumnType();
    }

    @Override
    OracleJsonParser getOracleJsonParser(int n2) throws SQLException {
        try {
            return this.factory.createJsonBinaryParser(this.getBufferInternal(n2));
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    OracleJsonDatum getOracleJsonDatum(int n2) throws SQLException {
        try {
            return new OracleJsonDatum(this.getBytesInternal(n2));
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    Datum getDatum(int n2) throws SQLException {
        return this.getOracleJsonDatum(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getOracleJsonDatum(n2);
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return super.getOracleObject(n2);
    }

    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        return super.getOracleObject(n2);
    }

    @Override
    ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        if (oRADataFactory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
        }
        Datum datum = this.getOracleObject(n2);
        return oRADataFactory.create(datum, 2016);
    }

    @Override
    OracleJsonValue getOracleJsonValue(int n2) throws SQLException {
        try {
            return this.factory.createJsonBinaryValue(this.getBufferInternal(n2));
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    @Override
    OracleJsonStructure getOracleJsonStructure(int n2) throws SQLException {
        return (OracleJsonStructure)this.getOracleJsonValueAbstract(n2, OracleJsonValue.OracleJsonType.OBJECT, OracleJsonValue.OracleJsonType.ARRAY);
    }

    @Override
    OracleJsonNumber getOracleJsonNumber(int n2) throws SQLException {
        return (OracleJsonNumber)this.getOracleJsonValueAbstract(n2, OracleJsonValue.OracleJsonType.DECIMAL, OracleJsonValue.OracleJsonType.DOUBLE, OracleJsonValue.OracleJsonType.FLOAT);
    }

    @Override
    OracleJsonObject getOracleJsonObject(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.OBJECT).asJsonObject();
    }

    @Override
    OracleJsonArray getOracleJsonArray(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.ARRAY).asJsonArray();
    }

    @Override
    OracleJsonDecimal getOracleJsonDecimal(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.DECIMAL).asJsonDecimal();
    }

    @Override
    OracleJsonDouble getOracleJsonDouble(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.DOUBLE).asJsonDouble();
    }

    @Override
    OracleJsonFloat getOracleJsonFloat(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.FLOAT).asJsonFloat();
    }

    @Override
    OracleJsonString getOracleJsonString(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.STRING).asJsonString();
    }

    @Override
    OracleJsonBinary getOracleJsonBinary(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.BINARY).asJsonBinary();
    }

    @Override
    OracleJsonTimestamp getOracleJsonTimestamp(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.TIMESTAMP).asJsonTimestamp();
    }

    @Override
    OracleJsonDate getOracleJsonDate(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.DATE).asJsonDate();
    }

    @Override
    OracleJsonIntervalDS getOracleJsonIntervalDS(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.INTERVALDS).asJsonIntervalDS();
    }

    @Override
    OracleJsonIntervalYM getOracleJsonIntervalYM(int n2) throws SQLException {
        return this.getOracleJsonValue(n2, OracleJsonValue.OracleJsonType.INTERVALYM).asJsonIntervalYM();
    }

    private OracleJsonValue getOracleJsonValue(int n2, OracleJsonValue.OracleJsonType oracleJsonType) throws SQLException {
        OracleJsonValue oracleJsonValue = this.getOracleJsonValue(n2);
        if (oracleJsonValue.getOracleJsonType() == oracleJsonType) {
            return oracleJsonValue;
        }
        throw this.invalidColumnType();
    }

    private OracleJsonValue getOracleJsonValueAbstract(int n2, OracleJsonValue.OracleJsonType ... oracleJsonTypeArray) throws SQLException {
        OracleJsonValue oracleJsonValue = this.getOracleJsonValue(n2);
        for (OracleJsonValue.OracleJsonType oracleJsonType : oracleJsonTypeArray) {
            if (oracleJsonType != oracleJsonValue.getOracleJsonType()) continue;
            return oracleJsonValue;
        }
        throw this.invalidColumnType();
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        String string = this.getString(n2);
        return string == null ? null : new StringReader(string);
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        return byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        try {
            OracleJsonParser oracleJsonParser = this.factory.createJsonBinaryParser(this.getBufferInternal(n2));
            StringWriter stringWriter = new StringWriter();
            OracleJsonGenerator oracleJsonGenerator = this.factory.createJsonTextGenerator(stringWriter);
            oracleJsonGenerator.writeParser(oracleJsonParser);
            oracleJsonGenerator.close();
            return stringWriter.toString();
        }
        catch (OracleJsonException oracleJsonException) {
            throw this.toSQLException(oracleJsonException);
        }
    }

    private ByteBuffer getBufferInternal(int n2) throws SQLException {
        return ByteBuffer.wrap(this.getBytesInternal(n2));
    }

    private SQLException toSQLException(RuntimeException runtimeException) {
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), runtimeException).fillInStackTrace();
    }

    private SQLException invalidColumnType() {
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        this.unimpl("updateChecksum");
        return -1L;
    }

    static {
        try {
            $$$methodRef$$$48 = JsonAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = JsonAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = JsonAccessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = JsonAccessor.class.getDeclaredMethod("invalidColumnType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = JsonAccessor.class.getDeclaredMethod("toSQLException", RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = JsonAccessor.class.getDeclaredMethod("getBufferInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = JsonAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = JsonAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = JsonAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = JsonAccessor.class.getDeclaredMethod("getOracleJsonValueAbstract", Integer.TYPE, OracleJsonValue.OracleJsonType[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = JsonAccessor.class.getDeclaredMethod("getOracleJsonValue", Integer.TYPE, OracleJsonValue.OracleJsonType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = JsonAccessor.class.getDeclaredMethod("getOracleJsonIntervalYM", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = JsonAccessor.class.getDeclaredMethod("getOracleJsonIntervalDS", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = JsonAccessor.class.getDeclaredMethod("getOracleJsonDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = JsonAccessor.class.getDeclaredMethod("getOracleJsonTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = JsonAccessor.class.getDeclaredMethod("getOracleJsonBinary", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = JsonAccessor.class.getDeclaredMethod("getOracleJsonString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = JsonAccessor.class.getDeclaredMethod("getOracleJsonFloat", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = JsonAccessor.class.getDeclaredMethod("getOracleJsonDouble", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = JsonAccessor.class.getDeclaredMethod("getOracleJsonDecimal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = JsonAccessor.class.getDeclaredMethod("getOracleJsonArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = JsonAccessor.class.getDeclaredMethod("getOracleJsonObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JsonAccessor.class.getDeclaredMethod("getOracleJsonNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JsonAccessor.class.getDeclaredMethod("getOracleJsonStructure", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JsonAccessor.class.getDeclaredMethod("getOracleJsonValue", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonAccessor.class.getDeclaredMethod("getORAData", Integer.TYPE, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonAccessor.class.getDeclaredMethod("getDatum", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonAccessor.class.getDeclaredMethod("getOracleJsonDatum", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonAccessor.class.getDeclaredMethod("getOracleJsonParser", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonValue", Integer.TYPE, JsonValue.ValueType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonStructure", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonParser", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonAccessor.class.getDeclaredMethod("getJakartaJsonValue", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonAccessor.class.getDeclaredMethod("getJsonValue", Integer.TYPE, JsonValue.ValueType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonAccessor.class.getDeclaredMethod("getJsonNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonAccessor.class.getDeclaredMethod("getJsonString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonAccessor.class.getDeclaredMethod("getJsonArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonAccessor.class.getDeclaredMethod("getJsonObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonAccessor.class.getDeclaredMethod("getJsonStructure", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonAccessor.class.getDeclaredMethod("getJsonParser", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonAccessor.class.getDeclaredMethod("getJsonValue", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

