/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class GeneratedScrollableResultSet
extends OracleResultSet {
    protected OracleStatement statement;
    protected long currentRow;
    protected long fetchedRowCount;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;

    GeneratedScrollableResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection);
        this.statement = oracleStatement;
        this.currentRow = -1L;
        this.fetchedRowCount = 0L;
        if (oracleStatement.sqlKind == OracleStatement.SqlKind.SELECT_FOR_UPDATE && physicalConnection.autocommit && physicalConnection.protocolId == 0) {
            this.needCommitAtClose = true;
        }
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBigDecimal").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBigDecimal").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            BigDecimal bigDecimal = this.statement.getBigDecimal(this.currentRow, n2);
            return bigDecimal;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBigDecimal").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBigDecimal").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            BigDecimal bigDecimal = this.statement.getBigDecimal(this.currentRow, n2, n3);
            return bigDecimal;
        }
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBoolean").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBoolean").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            boolean bl = this.statement.getBoolean(this.currentRow, n2);
            return bl;
        }
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getByte").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getByte").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            byte by = this.statement.getByte(this.currentRow, n2);
            return by;
        }
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBytes").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBytes").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            byte[] byArray = this.statement.getBytes(this.currentRow, n2);
            return byArray;
        }
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDate").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDate").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Date date = this.statement.getDate(this.currentRow, n2);
            return date;
        }
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDate").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDate").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Date date = this.statement.getDate(this.currentRow, n2, calendar);
            return date;
        }
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDouble").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDouble").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            double d2 = this.statement.getDouble(this.currentRow, n2);
            return d2;
        }
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getFloat").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getFloat").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            float f2 = this.statement.getFloat(this.currentRow, n2);
            return f2;
        }
    }

    @Override
    public int getInt(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getInt").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getInt").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            int n3 = this.statement.getInt(this.currentRow, n2);
            return n3;
        }
    }

    @Override
    public long getLong(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getLong").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getLong").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            long l2 = this.statement.getLong(this.currentRow, n2);
            return l2;
        }
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNClob").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNClob").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            NClob nClob = this.statement.getNClob(this.currentRow, n2);
            return nClob;
        }
    }

    @Override
    public String getNString(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNString").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNString").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            String string = this.statement.getNString(this.currentRow, n2);
            return string;
        }
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getObject").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getObject").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Object object = this.statement.getObject(this.currentRow, n2);
            return object;
        }
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getObject").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getObject").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Object object = this.statement.getObject(this.currentRow, n2, map);
            return object;
        }
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    @Override
    public short getShort(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getShort").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getShort").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            short s2 = this.statement.getShort(this.currentRow, n2);
            return s2;
        }
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getSQLXML").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getSQLXML").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            SQLXML sQLXML = this.statement.getSQLXML(this.currentRow, n2);
            return sQLXML;
        }
    }

    @Override
    public String getString(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getString").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getString").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            String string = this.statement.getString(this.currentRow, n2);
            return string;
        }
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTime").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTime").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Time time = this.statement.getTime(this.currentRow, n2);
            return time;
        }
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTime").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTime").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Time time = this.statement.getTime(this.currentRow, n2, calendar);
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTimestamp").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTimestamp").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Timestamp timestamp = this.statement.getTimestamp(this.currentRow, n2);
            return timestamp;
        }
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTimestamp").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTimestamp").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Timestamp timestamp = this.statement.getTimestamp(this.currentRow, n2, calendar);
            return timestamp;
        }
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getURL").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getURL").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            URL uRL = this.statement.getURL(this.currentRow, n2);
            return uRL;
        }
    }

    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getARRAY").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getARRAY").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            ARRAY aRRAY = this.statement.getARRAY(this.currentRow, n2);
            return aRRAY;
        }
    }

    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBFILE").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBFILE").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            BFILE bFILE = this.statement.getBFILE(this.currentRow, n2);
            return bFILE;
        }
    }

    @Override
    public BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBLOB").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBLOB").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            BLOB bLOB = this.statement.getBLOB(this.currentRow, n2);
            return bLOB;
        }
    }

    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCHAR").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCHAR").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            CHAR cHAR = this.statement.getCHAR(this.currentRow, n2);
            return cHAR;
        }
    }

    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCLOB").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCLOB").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            CLOB cLOB = this.statement.getCLOB(this.currentRow, n2);
            return cLOB;
        }
    }

    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCursor").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCursor").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            ResultSet resultSet = this.statement.getCursor(this.currentRow, n2);
            return resultSet;
        }
    }

    @Override
    public DATE getDATE(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getDATE").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getDATE").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            DATE dATE = this.statement.getDATE(this.currentRow, n2);
            return dATE;
        }
    }

    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getINTERVALDS").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getINTERVALDS").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            INTERVALDS iNTERVALDS = this.statement.getINTERVALDS(this.currentRow, n2);
            return iNTERVALDS;
        }
    }

    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getINTERVALYM").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getINTERVALYM").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            INTERVALYM iNTERVALYM = this.statement.getINTERVALYM(this.currentRow, n2);
            return iNTERVALYM;
        }
    }

    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNUMBER").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNUMBER").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            NUMBER nUMBER = this.statement.getNUMBER(this.currentRow, n2);
            return nUMBER;
        }
    }

    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getOPAQUE").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getOPAQUE").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            OPAQUE oPAQUE = this.statement.getOPAQUE(this.currentRow, n2);
            return oPAQUE;
        }
    }

    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getOracleObject").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getOracleObject").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Datum datum = this.statement.getOracleObject(this.currentRow, n2);
            return datum;
        }
    }

    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getORAData").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getORAData").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            ORAData oRAData = this.statement.getORAData(this.currentRow, n2, oRADataFactory);
            return oRAData;
        }
    }

    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getObject").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getObject").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Object object = this.statement.getObject(this.currentRow, n2, oracleDataFactory);
            return object;
        }
    }

    @Override
    public RAW getRAW(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getRAW").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getRAW").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            RAW rAW = this.statement.getRAW(this.currentRow, n2);
            return rAW;
        }
    }

    @Override
    public REF getREF(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getREF").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getREF").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            REF rEF = this.statement.getREF(this.currentRow, n2);
            return rEF;
        }
    }

    @Override
    public ROWID getROWID(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getROWID").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getROWID").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            ROWID rOWID = this.statement.getROWID(this.currentRow, n2);
            return rOWID;
        }
    }

    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getSTRUCT").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getSTRUCT").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            STRUCT sTRUCT = this.statement.getSTRUCT(this.currentRow, n2);
            return sTRUCT;
        }
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTIMESTAMPLTZ").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTIMESTAMPLTZ").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = this.statement.getTIMESTAMPLTZ(this.currentRow, n2);
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTIMESTAMPTZ").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTIMESTAMPTZ").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            TIMESTAMPTZ tIMESTAMPTZ = this.statement.getTIMESTAMPTZ(this.currentRow, n2);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getTIMESTAMP").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getTIMESTAMP").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            TIMESTAMP tIMESTAMP = this.statement.getTIMESTAMP(this.currentRow, n2);
            return tIMESTAMP;
        }
    }

    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCustomDatum").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCustomDatum").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            CustomDatum customDatum = this.statement.getCustomDatum(this.currentRow, n2, customDatumFactory);
            return customDatum;
        }
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getAsciiStream").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getAsciiStream").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            InputStream inputStream = this.statement.getAsciiStream(this.currentRow, n2);
            return inputStream;
        }
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getBinaryStream").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getBinaryStream").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            InputStream inputStream = this.statement.getBinaryStream(this.currentRow, n2);
            return inputStream;
        }
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getCharacterStream").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getCharacterStream").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Reader reader = this.statement.getCharacterStream(this.currentRow, n2);
            return reader;
        }
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getNCharacterStream").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getNCharacterStream").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            Reader reader = this.statement.getNCharacterStream(this.currentRow, n2);
            return reader;
        }
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, "getUnicodeStream").fillInStackTrace();
            }
            if (this.connection.isClosedInternal()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, "getUnicodeStream").fillInStackTrace();
            }
            if (n2 < 1 || n2 > this.statement.getNumberOfUserColumns()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            if (this.currentRow < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.currentRow == this.fetchedRowCount) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            InputStream inputStream = this.statement.getUnicodeStream(this.currentRow, n2);
            return inputStream;
        }
    }

    static {
        try {
            $$$methodRef$$$56 = GeneratedScrollableResultSet.class.getDeclaredConstructor(PhysicalConnection.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = GeneratedScrollableResultSet.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = GeneratedScrollableResultSet.class.getDeclaredMethod("getNCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = GeneratedScrollableResultSet.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = GeneratedScrollableResultSet.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = GeneratedScrollableResultSet.class.getDeclaredMethod("getCustomDatum", Integer.TYPE, CustomDatumFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = GeneratedScrollableResultSet.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = GeneratedScrollableResultSet.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = GeneratedScrollableResultSet.class.getDeclaredMethod("getTIMESTAMPLTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = GeneratedScrollableResultSet.class.getDeclaredMethod("getSTRUCT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = GeneratedScrollableResultSet.class.getDeclaredMethod("getROWID", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = GeneratedScrollableResultSet.class.getDeclaredMethod("getREF", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = GeneratedScrollableResultSet.class.getDeclaredMethod("getRAW", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = GeneratedScrollableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = GeneratedScrollableResultSet.class.getDeclaredMethod("getORAData", Integer.TYPE, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = GeneratedScrollableResultSet.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = GeneratedScrollableResultSet.class.getDeclaredMethod("getOPAQUE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = GeneratedScrollableResultSet.class.getDeclaredMethod("getNUMBER", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = GeneratedScrollableResultSet.class.getDeclaredMethod("getINTERVALYM", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = GeneratedScrollableResultSet.class.getDeclaredMethod("getINTERVALDS", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = GeneratedScrollableResultSet.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = GeneratedScrollableResultSet.class.getDeclaredMethod("getCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = GeneratedScrollableResultSet.class.getDeclaredMethod("getCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = GeneratedScrollableResultSet.class.getDeclaredMethod("getCHAR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBfile", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBFILE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = GeneratedScrollableResultSet.class.getDeclaredMethod("getARRAY", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = GeneratedScrollableResultSet.class.getDeclaredMethod("getURL", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = GeneratedScrollableResultSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = GeneratedScrollableResultSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = GeneratedScrollableResultSet.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = GeneratedScrollableResultSet.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = GeneratedScrollableResultSet.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = GeneratedScrollableResultSet.class.getDeclaredMethod("getSQLXML", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = GeneratedScrollableResultSet.class.getDeclaredMethod("getShort", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = GeneratedScrollableResultSet.class.getDeclaredMethod("getRowId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = GeneratedScrollableResultSet.class.getDeclaredMethod("getRef", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = GeneratedScrollableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = GeneratedScrollableResultSet.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = GeneratedScrollableResultSet.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = GeneratedScrollableResultSet.class.getDeclaredMethod("getNClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = GeneratedScrollableResultSet.class.getDeclaredMethod("getLong", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = GeneratedScrollableResultSet.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = GeneratedScrollableResultSet.class.getDeclaredMethod("getFloat", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = GeneratedScrollableResultSet.class.getDeclaredMethod("getDouble", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = GeneratedScrollableResultSet.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = GeneratedScrollableResultSet.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = GeneratedScrollableResultSet.class.getDeclaredMethod("getClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = GeneratedScrollableResultSet.class.getDeclaredMethod("getByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBoolean", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBlob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = GeneratedScrollableResultSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = GeneratedScrollableResultSet.class.getDeclaredMethod("getArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

