/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public interface Monitor {
    public CloseableLock getMonitorLock();

    default public CloseableLock newDefaultLock() {
        return CloseableLock.wrap(new ReentrantLock());
    }

    default public CloseableLock acquireCloseableLock() {
        this.acquireLock();
        return this.getMonitorLock();
    }

    default public void acquireLock() {
        this.getMonitorLock().lock.lock();
    }

    default public void releaseLock() {
        this.getMonitorLock().lock.unlock();
    }

    public static Monitor newInstance() {
        class MonitorImpl
        implements Monitor,
        Serializable {
            private static final long serialVersionUID = -2318644678533776943L;
            private final CloseableLock monitorLock = this.newDefaultLock();
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            MonitorImpl() {
            }

            @Override
            public CloseableLock getMonitorLock() {
                return this.monitorLock;
            }

            static {
                try {
                    $$$methodRef$$$1 = MonitorImpl.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = MonitorImpl.class.getDeclaredMethod("getMonitorLock", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        }
        return new MonitorImpl();
    }

    public static final class CloseableLock
    implements AutoCloseable,
    Serializable {
        private static final long serialVersionUID = -285233395800863549L;
        private final Lock lock;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private CloseableLock(Lock lock) {
            this.lock = lock;
        }

        public static CloseableLock wrap(Lock lock) {
            return new CloseableLock(lock);
        }

        @Override
        public void close() {
            this.lock.unlock();
        }

        static {
            try {
                $$$methodRef$$$3 = CloseableLock.class.getDeclaredConstructor(Lock.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = CloseableLock.class.getDeclaredMethod("access$000", CloseableLock.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = CloseableLock.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = CloseableLock.class.getDeclaredMethod("wrap", Lock.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static interface WaitableMonitor
    extends Monitor {
        public Condition getMonitorCondition();

        default public Condition newMonitorCondition() {
            return this.getMonitorLock().lock.newCondition();
        }

        default public void monitorWait() throws InterruptedException {
            this.getMonitorCondition().await();
        }

        default public void monitorWait(long l2) throws InterruptedException {
            this.monitorWait(l2, 0);
        }

        default public void monitorWait(long l2, int n2) throws InterruptedException {
            if (!1.$assertionsDisabled && l2 < 0L) {
                throw new AssertionError((Object)"Negative millisecond timeout");
            }
            if (!1.$assertionsDisabled && n2 < 0) {
                throw new AssertionError((Object)"Negative nanosecond timeout");
            }
            this.getMonitorCondition().awaitNanos(TimeUnit.MILLISECONDS.toNanos(l2) + (long)n2);
        }

        default public void monitorNotify() {
            this.getMonitorCondition().signal();
        }

        default public void monitorNotifyAll() {
            this.getMonitorCondition().signalAll();
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

