/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import oracle.jdbc.driver.ConsumerExceptionEvent;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.internal.JMSConsumerExceptionListener;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFJMSRegistration
extends NTFRegistration
implements JMSNotificationRegistration {
    private final String name;
    private final String jmsConnectionId;
    private long jmsRegistrationId;
    private int qosFlag;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    NTFJMSRegistration(long l2, boolean bl, String string, String string2, Properties properties, String string3, short s2, String string4) {
        super((int)l2, 1, bl, string, null, 0, properties, string2, s2, null);
        this.name = string3;
        this.jmsConnectionId = string4;
    }

    @Override
    public void addListener(JMSNotificationListener jMSNotificationListener, Executor executor) throws SQLException {
        NTFEventListener nTFEventListener = new NTFEventListener(jMSNotificationListener);
        nTFEventListener.setExecutor(executor);
        this.addListener(nTFEventListener);
    }

    @Override
    public void addListener(JMSNotificationListener jMSNotificationListener) throws SQLException {
        NTFEventListener nTFEventListener = new NTFEventListener(jMSNotificationListener);
        this.addListener(nTFEventListener);
    }

    @Override
    public void setConsumerExceptionListener(JMSConsumerExceptionListener jMSConsumerExceptionListener) throws SQLException {
        NTFEventListener nTFEventListener = new NTFEventListener(jMSConsumerExceptionListener);
        this.setNotificationExceptionListener(nTFEventListener);
    }

    @Override
    public void setConsumerExceptionListener(JMSConsumerExceptionListener jMSConsumerExceptionListener, Executor executor) throws SQLException {
        NTFEventListener nTFEventListener = new NTFEventListener(jMSConsumerExceptionListener);
        nTFEventListener.setExecutor(executor);
        this.setNotificationExceptionListener(nTFEventListener);
    }

    @Override
    public JMSConsumerExceptionListener getConsumerExceptionListener() throws SQLException {
        NTFEventListener nTFEventListener = this.getNotificationExceptionListener();
        JMSConsumerExceptionListener jMSConsumerExceptionListener = nTFEventListener.getNtfExceptionListener();
        return jMSConsumerExceptionListener;
    }

    void raiseException(int n2) throws SQLException {
        String string;
        NTFEventListener nTFEventListener = this.getNotificationExceptionListener();
        JMSConsumerExceptionListener jMSConsumerExceptionListener = nTFEventListener.getNtfExceptionListener();
        if (jMSConsumerExceptionListener == null) {
            return;
        }
        switch (n2) {
            case 1: {
                string = "Server Not Reachable";
                break;
            }
            case 2: {
                string = "Consumer Closed by Administrator";
                break;
            }
            case 3: {
                string = "Destination Queue/Topic closed by Administrator";
                break;
            }
            default: {
                return;
            }
        }
        ConsumerExceptionEvent consumerExceptionEvent = new ConsumerExceptionEvent(n2, string);
        jMSConsumerExceptionListener.onConsumerException(consumerExceptionEvent);
    }

    @Override
    public void removeListener(JMSNotificationListener jMSNotificationListener) throws SQLException {
        super.removeListener(jMSNotificationListener);
    }

    @Override
    public String getQueueName() {
        return this.name;
    }

    public String getJMSConnectionId() {
        return this.jmsConnectionId;
    }

    long getJMSRegistrationId() {
        return this.jmsRegistrationId;
    }

    void setJMSRegistrationId(long l2) {
        this.jmsRegistrationId = l2;
    }

    public int getQOSFlag() {
        return this.qosFlag;
    }

    public void setQOSFlag(int n2) {
        this.qosFlag = n2;
    }

    static {
        try {
            $$$methodRef$$$13 = NTFJMSRegistration.class.getDeclaredConstructor(Long.TYPE, Boolean.TYPE, String.class, String.class, Properties.class, String.class, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFJMSRegistration.class.getDeclaredMethod("setQOSFlag", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFJMSRegistration.class.getDeclaredMethod("getQOSFlag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFJMSRegistration.class.getDeclaredMethod("setJMSRegistrationId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFJMSRegistration.class.getDeclaredMethod("getJMSRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFJMSRegistration.class.getDeclaredMethod("getJMSConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFJMSRegistration.class.getDeclaredMethod("getQueueName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFJMSRegistration.class.getDeclaredMethod("removeListener", JMSNotificationListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFJMSRegistration.class.getDeclaredMethod("raiseException", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFJMSRegistration.class.getDeclaredMethod("getConsumerExceptionListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFJMSRegistration.class.getDeclaredMethod("setConsumerExceptionListener", JMSConsumerExceptionListener.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFJMSRegistration.class.getDeclaredMethod("setConsumerExceptionListener", JMSConsumerExceptionListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFJMSRegistration.class.getDeclaredMethod("addListener", JMSNotificationListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFJMSRegistration.class.getDeclaredMethod("addListener", JMSNotificationListener.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

