/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementCacheEntry;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.STATEMENT_CACHE})
class LRUStatementCache {
    private int cacheSize;
    private int numElements;
    private OracleStatementCacheEntry applicationCacheStart;
    private OracleStatementCacheEntry applicationCacheEnd;
    private OracleStatementCacheEntry implicitCacheStart;
    private OracleStatementCacheEntry explicitCacheStart;
    boolean implicitCacheEnabled;
    boolean explicitCacheEnabled;
    private boolean debug = false;
    static final String DMS_HIT_COUNT_NAME = "StatementCacheHit";
    static final String DMS_HIT_COUNT_DESCRIPTION = "Statement found in cache";
    static final String DMS_MISS_COUNT_NAME = "StatementCacheMiss";
    static final String DMS_MISS_COUNT_DESCRIPTION = "Statement not found in cache";
    EventIntf dmsStatementCacheHitCount = null;
    EventIntf dmsStatementCacheMissCount = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    protected LRUStatementCache(int n2) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
        }
        this.cacheSize = n2;
        this.numElements = 0;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.implicitCacheEnabled = false;
        this.explicitCacheEnabled = false;
    }

    protected void createDMSSensors(NounIntf nounIntf) {
        this.dmsStatementCacheHitCount = DMSFactory.createEvent(nounIntf, DMS_HIT_COUNT_NAME, DMS_HIT_COUNT_DESCRIPTION);
        this.dmsStatementCacheMissCount = DMSFactory.createEvent(nounIntf, DMS_MISS_COUNT_NAME, DMS_MISS_COUNT_DESCRIPTION);
    }

    protected void resize(int n2) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
        }
        if (n2 >= this.cacheSize || n2 >= this.numElements) {
            this.cacheSize = n2;
        } else {
            OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheEnd;
            while (this.numElements > n2) {
                this.purgeCacheEntry(oracleStatementCacheEntry);
                oracleStatementCacheEntry = oracleStatementCacheEntry.applicationPrev;
            }
            this.cacheSize = n2;
        }
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (!bl) {
            this.purgeImplicitCache();
        }
        this.implicitCacheEnabled = bl;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
        return bl;
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (!bl) {
            this.purgeExplicitCache();
        }
        this.explicitCacheEnabled = bl;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
        return bl;
    }

    protected void addToImplicitCache(OraclePreparedStatement oraclePreparedStatement, String string, int n2, int n3) throws SQLException {
        block8: {
            block7: {
                if (!this.implicitCacheEnabled || this.cacheSize == 0) break block7;
                if (oraclePreparedStatement.cacheState != 2) break block8;
            }
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        oraclePreparedStatement.enterImplicitCache();
        OracleStatementCacheEntry oracleStatementCacheEntry = new OracleStatementCacheEntry();
        oracleStatementCacheEntry.statement = oraclePreparedStatement;
        oracleStatementCacheEntry.onImplicit = true;
        oracleStatementCacheEntry.sql = string;
        oracleStatementCacheEntry.statementType = n2;
        oracleStatementCacheEntry.scrollType = n3;
        oracleStatementCacheEntry.applicationNext = this.applicationCacheStart;
        oracleStatementCacheEntry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = oracleStatementCacheEntry;
        }
        this.applicationCacheStart = oracleStatementCacheEntry;
        oracleStatementCacheEntry.implicitNext = this.implicitCacheStart;
        oracleStatementCacheEntry.implicitPrev = null;
        if (this.implicitCacheStart != null) {
            this.implicitCacheStart.implicitPrev = oracleStatementCacheEntry;
        }
        this.implicitCacheStart = oracleStatementCacheEntry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = oracleStatementCacheEntry;
        }
        ++this.numElements;
    }

    protected void addToExplicitCache(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        if (!this.explicitCacheEnabled || this.cacheSize == 0 || oraclePreparedStatement.cacheState == 2) {
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        oraclePreparedStatement.enterExplicitCache();
        OracleStatementCacheEntry oracleStatementCacheEntry = new OracleStatementCacheEntry();
        oracleStatementCacheEntry.statement = oraclePreparedStatement;
        oracleStatementCacheEntry.sql = string;
        oracleStatementCacheEntry.onImplicit = false;
        oracleStatementCacheEntry.applicationNext = this.applicationCacheStart;
        oracleStatementCacheEntry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = oracleStatementCacheEntry;
        }
        this.applicationCacheStart = oracleStatementCacheEntry;
        oracleStatementCacheEntry.explicitNext = this.explicitCacheStart;
        oracleStatementCacheEntry.explicitPrev = null;
        if (this.explicitCacheStart != null) {
            this.explicitCacheStart.explicitPrev = oracleStatementCacheEntry;
        }
        this.explicitCacheStart = oracleStatementCacheEntry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = oracleStatementCacheEntry;
        }
        ++this.numElements;
    }

    protected OracleStatement searchImplicitCache(String string, int n2, int n3, PhysicalConnection physicalConnection) throws SQLException {
        if (!this.implicitCacheEnabled) {
            return null;
        }
        OracleStatementCacheEntry oracleStatementCacheEntry = null;
        oracleStatementCacheEntry = this.implicitCacheStart;
        while (!(oracleStatementCacheEntry == null || oracleStatementCacheEntry.statementType == n2 && oracleStatementCacheEntry.scrollType == n3 && oracleStatementCacheEntry.sql.equals(string))) {
            oracleStatementCacheEntry = oracleStatementCacheEntry.implicitNext;
        }
        if (oracleStatementCacheEntry != null) {
            this.dmsStatementCacheHitCount.occurred();
            if (oracleStatementCacheEntry.applicationPrev != null) {
                oracleStatementCacheEntry.applicationPrev.applicationNext = oracleStatementCacheEntry.applicationNext;
            }
            if (oracleStatementCacheEntry.applicationNext != null) {
                oracleStatementCacheEntry.applicationNext.applicationPrev = oracleStatementCacheEntry.applicationPrev;
            }
            if (this.applicationCacheStart == oracleStatementCacheEntry) {
                this.applicationCacheStart = oracleStatementCacheEntry.applicationNext;
            }
            if (this.applicationCacheEnd == oracleStatementCacheEntry) {
                this.applicationCacheEnd = oracleStatementCacheEntry.applicationPrev;
            }
            if (oracleStatementCacheEntry.implicitPrev != null) {
                oracleStatementCacheEntry.implicitPrev.implicitNext = oracleStatementCacheEntry.implicitNext;
            }
            if (oracleStatementCacheEntry.implicitNext != null) {
                oracleStatementCacheEntry.implicitNext.implicitPrev = oracleStatementCacheEntry.implicitPrev;
            }
            if (this.implicitCacheStart == oracleStatementCacheEntry) {
                this.implicitCacheStart = oracleStatementCacheEntry.implicitNext;
            }
            --this.numElements;
            oracleStatementCacheEntry.statement.exitImplicitCacheToActive();
            return oracleStatementCacheEntry.statement;
        }
        OracleStatement oracleStatement = null;
        this.dmsStatementCacheMissCount.occurred();
        return oracleStatement;
    }

    protected OracleStatement searchExplicitCache(String string) throws SQLException {
        if (!this.explicitCacheEnabled) {
            return null;
        }
        OracleStatementCacheEntry oracleStatementCacheEntry = null;
        oracleStatementCacheEntry = this.explicitCacheStart;
        while (oracleStatementCacheEntry != null && !oracleStatementCacheEntry.sql.equals(string)) {
            oracleStatementCacheEntry = oracleStatementCacheEntry.explicitNext;
        }
        if (oracleStatementCacheEntry != null) {
            this.dmsStatementCacheHitCount.occurred();
            if (oracleStatementCacheEntry.applicationPrev != null) {
                oracleStatementCacheEntry.applicationPrev.applicationNext = oracleStatementCacheEntry.applicationNext;
            }
            if (oracleStatementCacheEntry.applicationNext != null) {
                oracleStatementCacheEntry.applicationNext.applicationPrev = oracleStatementCacheEntry.applicationPrev;
            }
            if (this.applicationCacheStart == oracleStatementCacheEntry) {
                this.applicationCacheStart = oracleStatementCacheEntry.applicationNext;
            }
            if (this.applicationCacheEnd == oracleStatementCacheEntry) {
                this.applicationCacheEnd = oracleStatementCacheEntry.applicationPrev;
            }
            if (oracleStatementCacheEntry.explicitPrev != null) {
                oracleStatementCacheEntry.explicitPrev.explicitNext = oracleStatementCacheEntry.explicitNext;
            }
            if (oracleStatementCacheEntry.explicitNext != null) {
                oracleStatementCacheEntry.explicitNext.explicitPrev = oracleStatementCacheEntry.explicitPrev;
            }
            if (this.explicitCacheStart == oracleStatementCacheEntry) {
                this.explicitCacheStart = oracleStatementCacheEntry.explicitNext;
            }
            --this.numElements;
            oracleStatementCacheEntry.statement.exitExplicitCacheToActive();
            return oracleStatementCacheEntry.statement;
        }
        this.dmsStatementCacheMissCount.occurred();
        return null;
    }

    protected void purgeImplicitCache() throws SQLException {
        OracleStatementCacheEntry oracleStatementCacheEntry = this.implicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            this.purgeCacheEntry(oracleStatementCacheEntry);
            oracleStatementCacheEntry = oracleStatementCacheEntry.implicitNext;
        }
        this.implicitCacheStart = null;
    }

    protected void purgeExplicitCache() throws SQLException {
        OracleStatementCacheEntry oracleStatementCacheEntry = this.explicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            this.purgeCacheEntry(oracleStatementCacheEntry);
            oracleStatementCacheEntry = oracleStatementCacheEntry.explicitNext;
        }
        this.explicitCacheStart = null;
    }

    private void purgeCacheEntry(OracleStatementCacheEntry oracleStatementCacheEntry) throws SQLException {
        if (oracleStatementCacheEntry.applicationNext != null) {
            oracleStatementCacheEntry.applicationNext.applicationPrev = oracleStatementCacheEntry.applicationPrev;
        }
        if (oracleStatementCacheEntry.applicationPrev != null) {
            oracleStatementCacheEntry.applicationPrev.applicationNext = oracleStatementCacheEntry.applicationNext;
        }
        if (this.applicationCacheStart == oracleStatementCacheEntry) {
            this.applicationCacheStart = oracleStatementCacheEntry.applicationNext;
        }
        if (this.applicationCacheEnd == oracleStatementCacheEntry) {
            this.applicationCacheEnd = oracleStatementCacheEntry.applicationPrev;
        }
        OraclePreparedStatement oraclePreparedStatement = oracleStatementCacheEntry.statement;
        if (oracleStatementCacheEntry.onImplicit) {
            if (oracleStatementCacheEntry.implicitNext != null) {
                oracleStatementCacheEntry.implicitNext.implicitPrev = oracleStatementCacheEntry.implicitPrev;
            }
            if (oracleStatementCacheEntry.implicitPrev != null) {
                oracleStatementCacheEntry.implicitPrev.implicitNext = oracleStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheStart == oracleStatementCacheEntry) {
                this.implicitCacheStart = oracleStatementCacheEntry.implicitNext;
            }
        } else {
            if (oracleStatementCacheEntry.explicitNext != null) {
                oracleStatementCacheEntry.explicitNext.explicitPrev = oracleStatementCacheEntry.explicitPrev;
            }
            if (oracleStatementCacheEntry.explicitPrev != null) {
                oracleStatementCacheEntry.explicitPrev.explicitNext = oracleStatementCacheEntry.explicitNext;
            }
            if (this.explicitCacheStart == oracleStatementCacheEntry) {
                this.explicitCacheStart = oracleStatementCacheEntry.explicitNext;
            }
        }
        --this.numElements;
        oracleStatementCacheEntry.statement.exitExplicitCacheToClose();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void printCache(String string) throws SQLException {
        System.out.println("*** Start of Statement Cache Dump (" + string + ") ***");
        System.out.println("cache size: " + this.cacheSize + " num elements: " + this.numElements + " implicit enabled: " + this.implicitCacheEnabled + " explicit enabled: " + this.explicitCacheEnabled);
        System.out.println("applicationStart: " + this.applicationCacheStart + "  applicationEnd: " + this.applicationCacheEnd);
        OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheStart;
        while (oracleStatementCacheEntry != null) {
            oracleStatementCacheEntry.print();
            oracleStatementCacheEntry = oracleStatementCacheEntry.applicationNext;
        }
        System.out.println("implicitStart: " + this.implicitCacheStart);
        oracleStatementCacheEntry = this.implicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            oracleStatementCacheEntry.print();
            oracleStatementCacheEntry = oracleStatementCacheEntry.implicitNext;
        }
        System.out.println("explicitStart: " + this.explicitCacheStart);
        oracleStatementCacheEntry = this.explicitCacheStart;
        while (oracleStatementCacheEntry != null) {
            oracleStatementCacheEntry.print();
            oracleStatementCacheEntry = oracleStatementCacheEntry.explicitNext;
        }
        System.out.println("*** End of Statement Cache Dump (" + string + ") ***");
    }

    public void close() throws SQLException {
        OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheStart;
        while (oracleStatementCacheEntry != null) {
            if (oracleStatementCacheEntry.onImplicit) {
                oracleStatementCacheEntry.statement.exitImplicitCacheToClose();
            } else {
                oracleStatementCacheEntry.statement.exitExplicitCacheToClose();
            }
            oracleStatementCacheEntry = oracleStatementCacheEntry.applicationNext;
        }
        this.applicationCacheStart = null;
        this.applicationCacheEnd = null;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.numElements = 0;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    int getNumberOfStatementsInCache() {
        return this.numElements;
    }

    String[] getCachedStrings() {
        int n2 = this.numElements;
        String[] stringArray = new String[n2];
        OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheEnd;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = oracleStatementCacheEntry.statement.sqlObject.getOriginalSql();
            oracleStatementCacheEntry = oracleStatementCacheEntry.applicationPrev;
        }
        return stringArray;
    }

    protected void clearCursorIds() {
        OracleStatementCacheEntry oracleStatementCacheEntry = this.applicationCacheStart;
        while (oracleStatementCacheEntry != null) {
            oracleStatementCacheEntry.statement.clearCursorId();
            oracleStatementCacheEntry = oracleStatementCacheEntry.applicationNext;
        }
    }

    static {
        try {
            $$$methodRef$$$20 = LRUStatementCache.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = LRUStatementCache.class.getDeclaredMethod("clearCursorIds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = LRUStatementCache.class.getDeclaredMethod("getCachedStrings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = LRUStatementCache.class.getDeclaredMethod("getNumberOfStatementsInCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LRUStatementCache.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LRUStatementCache.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LRUStatementCache.class.getDeclaredMethod("printCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LRUStatementCache.class.getDeclaredMethod("getCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LRUStatementCache.class.getDeclaredMethod("purgeCacheEntry", OracleStatementCacheEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LRUStatementCache.class.getDeclaredMethod("purgeExplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LRUStatementCache.class.getDeclaredMethod("purgeImplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LRUStatementCache.class.getDeclaredMethod("searchExplicitCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LRUStatementCache.class.getDeclaredMethod("searchImplicitCache", String.class, Integer.TYPE, Integer.TYPE, PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LRUStatementCache.class.getDeclaredMethod("addToExplicitCache", OraclePreparedStatement.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LRUStatementCache.class.getDeclaredMethod("addToImplicitCache", OraclePreparedStatement.class, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LRUStatementCache.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LRUStatementCache.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LRUStatementCache.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LRUStatementCache.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LRUStatementCache.class.getDeclaredMethod("resize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LRUStatementCache.class.getDeclaredMethod("createDMSSensors", NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

